/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;

public class ExceptionsAttribute
extends AttributeInfo {
    public static final String tag = "Exceptions";

    ExceptionsAttribute(ConstPool constPool, int n2, DataInputStream dataInputStream) throws IOException {
        super(constPool, n2, dataInputStream);
    }

    private ExceptionsAttribute(ConstPool constPool, ExceptionsAttribute exceptionsAttribute, Map map) {
        super(constPool, tag);
        this.copyFrom(exceptionsAttribute, map);
    }

    public ExceptionsAttribute(ConstPool constPool) {
        super(constPool, tag);
        byte[] byArray = new byte[2];
        byArray[1] = 0;
        byArray[0] = 0;
        this.info = byArray;
    }

    public AttributeInfo copy(ConstPool constPool, Map map) {
        return new ExceptionsAttribute(constPool, this, map);
    }

    private void copyFrom(ExceptionsAttribute exceptionsAttribute, Map map) {
        ConstPool constPool = exceptionsAttribute.constPool;
        ConstPool constPool2 = this.constPool;
        byte[] byArray = exceptionsAttribute.info;
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        byArray2[0] = byArray[0];
        byArray2[1] = byArray[1];
        for (int i2 = 2; i2 < n2; i2 += 2) {
            int n3 = ByteArray.readU16bit(byArray, i2);
            ByteArray.write16bit(constPool.copy(n3, constPool2, map), byArray2, i2);
        }
        this.info = byArray2;
    }

    public int[] getExceptionIndexes() {
        byte[] byArray = this.info;
        int n2 = byArray.length;
        if (n2 <= 2) {
            return null;
        }
        int[] nArray = new int[n2 / 2 - 1];
        int n3 = 0;
        for (int i2 = 2; i2 < n2; i2 += 2) {
            nArray[n3++] = (byArray[i2] & 0xFF) << 8 | byArray[i2 + 1] & 0xFF;
        }
        return nArray;
    }

    public String[] getExceptions() {
        byte[] byArray = this.info;
        int n2 = byArray.length;
        if (n2 <= 2) {
            return null;
        }
        String[] stringArray = new String[n2 / 2 - 1];
        int n3 = 0;
        for (int i2 = 2; i2 < n2; i2 += 2) {
            int n4 = (byArray[i2] & 0xFF) << 8 | byArray[i2 + 1] & 0xFF;
            stringArray[n3++] = this.constPool.getClassInfo(n4);
        }
        return stringArray;
    }

    public void setExceptionIndexes(int[] nArray) {
        int n2 = nArray.length;
        byte[] byArray = new byte[n2 * 2 + 2];
        ByteArray.write16bit(n2, byArray, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteArray.write16bit(nArray[i2], byArray, i2 * 2 + 2);
        }
        this.info = byArray;
    }

    public void setExceptions(String[] stringArray) {
        int n2 = stringArray.length;
        byte[] byArray = new byte[n2 * 2 + 2];
        ByteArray.write16bit(n2, byArray, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteArray.write16bit(this.constPool.addClassInfo(stringArray[i2]), byArray, i2 * 2 + 2);
        }
        this.info = byArray;
    }

    public int tableLength() {
        return this.info.length / 2 - 1;
    }

    public int getException(int n2) {
        int n3 = n2 * 2 + 2;
        return (this.info[n3] & 0xFF) << 8 | this.info[n3 + 1] & 0xFF;
    }
}

