/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.util.Map;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtPrimitiveType;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor$PrettyPrinter;

public class Descriptor {
    public static String toJvmName(String string) {
        return string.replace('.', '/');
    }

    public static String toJavaName(String string) {
        return string.replace('/', '.');
    }

    public static String toJvmName(CtClass ctClass) {
        if (ctClass.isArray()) {
            return Descriptor.of(ctClass);
        }
        return Descriptor.toJvmName(ctClass.getName());
    }

    public static String toClassName(String string) {
        String string2;
        int n2 = 0;
        int n3 = 0;
        char c2 = string.charAt(0);
        while (c2 == '[') {
            ++n2;
            c2 = string.charAt(++n3);
        }
        if (c2 == 'L') {
            int n4 = string.indexOf(59, n3++);
            string2 = string.substring(n3, n4).replace('/', '.');
            n3 = n4;
        } else if (c2 == 'V') {
            string2 = "void";
        } else if (c2 == 'I') {
            string2 = "int";
        } else if (c2 == 'B') {
            string2 = "byte";
        } else if (c2 == 'J') {
            string2 = "long";
        } else if (c2 == 'D') {
            string2 = "double";
        } else if (c2 == 'F') {
            string2 = "float";
        } else if (c2 == 'C') {
            string2 = "char";
        } else if (c2 == 'S') {
            string2 = "short";
        } else if (c2 == 'Z') {
            string2 = "boolean";
        } else {
            throw new RuntimeException("bad descriptor: " + string);
        }
        if (n3 + 1 != string.length()) {
            throw new RuntimeException("multiple descriptors?: " + string);
        }
        if (n2 == 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        do {
            stringBuffer.append("[]");
        } while (--n2 > 0);
        return stringBuffer.toString();
    }

    public static String of(String string) {
        if (string.equals("void")) {
            return "V";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("double")) {
            return "D";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("boolean")) {
            return "Z";
        }
        return "L" + Descriptor.toJvmName(string) + ";";
    }

    public static String rename(String string, String string2, String string3) {
        int n2;
        if (string.indexOf(string2) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while ((n2 = string.indexOf(76, n4)) >= 0) {
            if (string.startsWith(string2, n2 + 1) && string.charAt(n2 + string2.length() + 1) == ';') {
                stringBuffer.append(string.substring(n3, n2));
                stringBuffer.append('L');
                stringBuffer.append(string3);
                stringBuffer.append(';');
                n3 = n4 = n2 + string2.length() + 2;
                continue;
            }
            n4 = string.indexOf(59, n2) + 1;
            if (n4 >= 1) continue;
            break;
        }
        if (n3 == 0) {
            return string;
        }
        n2 = string.length();
        if (n3 < n2) {
            stringBuffer.append(string.substring(n3, n2));
        }
        return stringBuffer.toString();
    }

    public static String rename(String string, Map map) {
        int n2;
        int n3;
        if (map == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        int n5 = 0;
        while ((n3 = string.indexOf(76, n5)) >= 0 && (n2 = string.indexOf(59, n3)) >= 0) {
            n5 = n2 + 1;
            String string2 = string.substring(n3 + 1, n2);
            String string3 = (String)map.get(string2);
            if (string3 == null) continue;
            stringBuffer.append(string.substring(n4, n3));
            stringBuffer.append('L');
            stringBuffer.append(string3);
            stringBuffer.append(';');
            n4 = n5;
        }
        if (n4 == 0) {
            return string;
        }
        n3 = string.length();
        if (n4 < n3) {
            stringBuffer.append(string.substring(n4, n3));
        }
        return stringBuffer.toString();
    }

    public static String of(CtClass ctClass) {
        StringBuffer stringBuffer = new StringBuffer();
        Descriptor.toDescriptor(stringBuffer, ctClass);
        return stringBuffer.toString();
    }

    private static void toDescriptor(StringBuffer stringBuffer, CtClass ctClass) {
        if (ctClass.isArray()) {
            stringBuffer.append('[');
            try {
                Descriptor.toDescriptor(stringBuffer, ctClass.getComponentType());
            }
            catch (NotFoundException notFoundException) {
                stringBuffer.append('L');
                String string = ctClass.getName();
                stringBuffer.append(Descriptor.toJvmName(string.substring(0, string.length() - 2)));
                stringBuffer.append(';');
            }
        } else if (ctClass.isPrimitive()) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)ctClass;
            stringBuffer.append(ctPrimitiveType.getDescriptor());
        } else {
            stringBuffer.append('L');
            stringBuffer.append(ctClass.getName().replace('.', '/'));
            stringBuffer.append(';');
        }
    }

    public static String ofConstructor(CtClass[] ctClassArray) {
        return Descriptor.ofMethod(CtClass.voidType, ctClassArray);
    }

    public static String ofMethod(CtClass ctClass, CtClass[] ctClassArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (ctClassArray != null) {
            int n2 = ctClassArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Descriptor.toDescriptor(stringBuffer, ctClassArray[i2]);
            }
        }
        stringBuffer.append(')');
        if (ctClass != null) {
            Descriptor.toDescriptor(stringBuffer, ctClass);
        }
        return stringBuffer.toString();
    }

    public static String ofParameters(CtClass[] ctClassArray) {
        return Descriptor.ofMethod(null, ctClassArray);
    }

    public static String appendParameter(String string, String string2) {
        int n2 = string2.indexOf(41);
        if (n2 < 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2.substring(0, n2));
        stringBuffer.append('L');
        stringBuffer.append(string.replace('.', '/'));
        stringBuffer.append(';');
        stringBuffer.append(string2.substring(n2));
        return stringBuffer.toString();
    }

    public static String insertParameter(String string, String string2) {
        if (string2.charAt(0) != '(') {
            return string2;
        }
        return "(L" + string.replace('.', '/') + ';' + string2.substring(1);
    }

    public static String appendParameter(CtClass ctClass, String string) {
        int n2 = string.indexOf(41);
        if (n2 < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n2));
        Descriptor.toDescriptor(stringBuffer, ctClass);
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String insertParameter(CtClass ctClass, String string) {
        if (string.charAt(0) != '(') {
            return string;
        }
        return "(" + Descriptor.of(ctClass) + string.substring(1);
    }

    public static String changeReturnType(String string, String string2) {
        int n2 = string2.indexOf(41);
        if (n2 < 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2.substring(0, n2 + 1));
        stringBuffer.append('L');
        stringBuffer.append(string.replace('.', '/'));
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public static CtClass[] getParameterTypes(String string, ClassPool classPool) throws NotFoundException {
        if (string.charAt(0) != '(') {
            return null;
        }
        int n2 = Descriptor.numOfParameters(string);
        CtClass[] ctClassArray = new CtClass[n2];
        int n3 = 0;
        int n4 = 1;
        while ((n4 = Descriptor.toCtClass(classPool, string, n4, ctClassArray, n3++)) > 0) {
        }
        return ctClassArray;
    }

    public static boolean eqParamTypes(String string, String string2) {
        if (string.charAt(0) != '(') {
            return false;
        }
        int n2 = 0;
        char c2;
        while ((c2 = string.charAt(n2)) == string2.charAt(n2)) {
            if (c2 == ')') {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getParamDescriptor(String string) {
        return string.substring(0, string.indexOf(41) + 1);
    }

    public static CtClass getReturnType(String string, ClassPool classPool) throws NotFoundException {
        int n2 = string.indexOf(41);
        if (n2 < 0) {
            return null;
        }
        CtClass[] ctClassArray = new CtClass[1];
        Descriptor.toCtClass(classPool, string, n2 + 1, ctClassArray, 0);
        return ctClassArray[0];
    }

    public static int numOfParameters(String string) {
        char c2;
        int n2 = 0;
        int n3 = 1;
        while ((c2 = string.charAt(n3)) != ')') {
            while (c2 == '[') {
                c2 = string.charAt(++n3);
            }
            if (c2 == 'L') {
                if ((n3 = string.indexOf(59, n3) + 1) <= 0) {
                    throw new IndexOutOfBoundsException("bad descriptor");
                }
            } else {
                ++n3;
            }
            ++n2;
        }
        return n2;
    }

    public static CtClass toCtClass(String string, ClassPool classPool) throws NotFoundException {
        CtClass[] ctClassArray = new CtClass[1];
        int n2 = Descriptor.toCtClass(classPool, string, 0, ctClassArray, 0);
        if (n2 >= 0) {
            return ctClassArray[0];
        }
        return classPool.get(string.replace('/', '.'));
    }

    private static int toCtClass(ClassPool classPool, String string, int n2, CtClass[] ctClassArray, int n3) throws NotFoundException {
        Object object;
        String string2;
        int n4;
        int n5 = 0;
        char c2 = string.charAt(n2);
        while (c2 == '[') {
            ++n5;
            c2 = string.charAt(++n2);
        }
        if (c2 == 'L') {
            n4 = string.indexOf(59, ++n2);
            string2 = string.substring(n2, n4++).replace('/', '.');
        } else {
            object = Descriptor.toPrimitiveClass(c2);
            if (object == null) {
                return -1;
            }
            n4 = n2 + 1;
            if (n5 == 0) {
                ctClassArray[n3] = object;
                return n4;
            }
            string2 = ((CtClass)object).getName();
        }
        if (n5 > 0) {
            object = new StringBuffer(string2);
            while (n5-- > 0) {
                ((StringBuffer)object).append("[]");
            }
            string2 = ((StringBuffer)object).toString();
        }
        ctClassArray[n3] = classPool.get(string2);
        return n4;
    }

    static CtClass toPrimitiveClass(char c2) {
        CtClass ctClass = null;
        switch (c2) {
            case 'Z': {
                ctClass = CtClass.booleanType;
                break;
            }
            case 'C': {
                ctClass = CtClass.charType;
                break;
            }
            case 'B': {
                ctClass = CtClass.byteType;
                break;
            }
            case 'S': {
                ctClass = CtClass.shortType;
                break;
            }
            case 'I': {
                ctClass = CtClass.intType;
                break;
            }
            case 'J': {
                ctClass = CtClass.longType;
                break;
            }
            case 'F': {
                ctClass = CtClass.floatType;
                break;
            }
            case 'D': {
                ctClass = CtClass.doubleType;
                break;
            }
            case 'V': {
                ctClass = CtClass.voidType;
            }
        }
        return ctClass;
    }

    public static int arrayDimension(String string) {
        int n2 = 0;
        while (string.charAt(n2) == '[') {
            ++n2;
        }
        return n2;
    }

    public static String toArrayComponent(String string, int n2) {
        return string.substring(n2);
    }

    public static int dataSize(String string) {
        return Descriptor.dataSize(string, true);
    }

    public static int paramSize(String string) {
        return -Descriptor.dataSize(string, false);
    }

    private static int dataSize(String string, boolean bl2) {
        int n2 = 0;
        char c2 = string.charAt(0);
        if (c2 == '(') {
            int n3 = 1;
            while (true) {
                if ((c2 = string.charAt(n3)) == ')') {
                    c2 = string.charAt(n3 + 1);
                    break;
                }
                boolean bl3 = false;
                while (c2 == '[') {
                    bl3 = true;
                    c2 = string.charAt(++n3);
                }
                if (c2 == 'L') {
                    if ((n3 = string.indexOf(59, n3) + 1) <= 0) {
                        throw new IndexOutOfBoundsException("bad descriptor");
                    }
                } else {
                    ++n3;
                }
                if (!(bl3 || c2 != 'J' && c2 != 'D')) {
                    n2 -= 2;
                    continue;
                }
                --n2;
            }
        }
        if (bl2) {
            if (c2 == 'J' || c2 == 'D') {
                n2 += 2;
            } else if (c2 != 'V') {
                ++n2;
            }
        }
        return n2;
    }

    public static String toString(String string) {
        return Descriptor$PrettyPrinter.toString(string);
    }
}

