/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.bytecode.ClassInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ConstInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ConstInfoPadding;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.DoubleInfo;
import org.zeroturnaround.bundled.javassist.bytecode.FieldrefInfo;
import org.zeroturnaround.bundled.javassist.bytecode.FloatInfo;
import org.zeroturnaround.bundled.javassist.bytecode.IntegerInfo;
import org.zeroturnaround.bundled.javassist.bytecode.InterfaceMethodrefInfo;
import org.zeroturnaround.bundled.javassist.bytecode.LongInfo;
import org.zeroturnaround.bundled.javassist.bytecode.LongVector;
import org.zeroturnaround.bundled.javassist.bytecode.MemberrefInfo;
import org.zeroturnaround.bundled.javassist.bytecode.MethodrefInfo;
import org.zeroturnaround.bundled.javassist.bytecode.NameAndTypeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.StringInfo;
import org.zeroturnaround.bundled.javassist.bytecode.Utf8Info;

public final class ConstPool {
    LongVector items;
    int numOfItems;
    HashMap classes;
    HashMap strings;
    int thisClassInfo;
    public static final int CONST_Class = 7;
    public static final int CONST_Fieldref = 9;
    public static final int CONST_Methodref = 10;
    public static final int CONST_InterfaceMethodref = 11;
    public static final int CONST_String = 8;
    public static final int CONST_Integer = 3;
    public static final int CONST_Float = 4;
    public static final int CONST_Long = 5;
    public static final int CONST_Double = 6;
    public static final int CONST_NameAndType = 12;
    public static final int CONST_Utf8 = 1;
    public static final CtClass THIS = null;

    public ConstPool(String string) {
        this.items = new LongVector();
        this.numOfItems = 0;
        this.addItem(null);
        this.classes = new HashMap();
        this.strings = new HashMap();
        this.thisClassInfo = this.addClassInfo(string);
    }

    public ConstPool(DataInputStream dataInputStream) throws IOException {
        this.classes = new HashMap();
        this.strings = new HashMap();
        this.thisClassInfo = 0;
        this.read(dataInputStream);
    }

    void prune() {
        this.classes = new HashMap();
        this.strings = new HashMap();
    }

    public int getSize() {
        return this.numOfItems;
    }

    public String getClassName() {
        return this.getClassInfo(this.thisClassInfo);
    }

    public int getThisClassInfo() {
        return this.thisClassInfo;
    }

    void setThisClassInfo(int n2) {
        this.thisClassInfo = n2;
    }

    ConstInfo getItem(int n2) {
        return (ConstInfo)this.items.elementAt(n2);
    }

    public int getTag(int n2) {
        return this.getItem(n2).getTag();
    }

    public String getClassInfo(int n2) {
        ClassInfo classInfo = (ClassInfo)this.getItem(n2);
        if (classInfo == null) {
            return null;
        }
        return Descriptor.toJavaName(this.getUtf8Info(classInfo.name));
    }

    public int getNameAndTypeName(int n2) {
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(n2);
        return nameAndTypeInfo.memberName;
    }

    public int getNameAndTypeDescriptor(int n2) {
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(n2);
        return nameAndTypeInfo.typeDescriptor;
    }

    public int getMemberClass(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(n2);
        return memberrefInfo.classIndex;
    }

    public int getMemberNameAndType(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(n2);
        return memberrefInfo.nameAndTypeIndex;
    }

    public int getFieldrefClass(int n2) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(n2);
        return fieldrefInfo.classIndex;
    }

    public String getFieldrefClassName(int n2) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(n2);
        if (fieldrefInfo == null) {
            return null;
        }
        return this.getClassInfo(fieldrefInfo.classIndex);
    }

    public int getFieldrefNameAndType(int n2) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(n2);
        return fieldrefInfo.nameAndTypeIndex;
    }

    public String getFieldrefName(int n2) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(n2);
        if (fieldrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(fieldrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.memberName);
    }

    public String getFieldrefType(int n2) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(n2);
        if (fieldrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(fieldrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.typeDescriptor);
    }

    public int getMethodrefClass(int n2) {
        MethodrefInfo methodrefInfo = (MethodrefInfo)this.getItem(n2);
        return methodrefInfo.classIndex;
    }

    public String getMethodrefClassName(int n2) {
        MethodrefInfo methodrefInfo = (MethodrefInfo)this.getItem(n2);
        if (methodrefInfo == null) {
            return null;
        }
        return this.getClassInfo(methodrefInfo.classIndex);
    }

    public int getMethodrefNameAndType(int n2) {
        MethodrefInfo methodrefInfo = (MethodrefInfo)this.getItem(n2);
        return methodrefInfo.nameAndTypeIndex;
    }

    public String getMethodrefName(int n2) {
        MethodrefInfo methodrefInfo = (MethodrefInfo)this.getItem(n2);
        if (methodrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(methodrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.memberName);
    }

    public String getMethodrefType(int n2) {
        MethodrefInfo methodrefInfo = (MethodrefInfo)this.getItem(n2);
        if (methodrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(methodrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.typeDescriptor);
    }

    public int getInterfaceMethodrefClass(int n2) {
        InterfaceMethodrefInfo interfaceMethodrefInfo = (InterfaceMethodrefInfo)this.getItem(n2);
        return interfaceMethodrefInfo.classIndex;
    }

    public String getInterfaceMethodrefClassName(int n2) {
        InterfaceMethodrefInfo interfaceMethodrefInfo = (InterfaceMethodrefInfo)this.getItem(n2);
        return this.getClassInfo(interfaceMethodrefInfo.classIndex);
    }

    public int getInterfaceMethodrefNameAndType(int n2) {
        InterfaceMethodrefInfo interfaceMethodrefInfo = (InterfaceMethodrefInfo)this.getItem(n2);
        return interfaceMethodrefInfo.nameAndTypeIndex;
    }

    public String getInterfaceMethodrefName(int n2) {
        InterfaceMethodrefInfo interfaceMethodrefInfo = (InterfaceMethodrefInfo)this.getItem(n2);
        if (interfaceMethodrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(interfaceMethodrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.memberName);
    }

    public String getInterfaceMethodrefType(int n2) {
        InterfaceMethodrefInfo interfaceMethodrefInfo = (InterfaceMethodrefInfo)this.getItem(n2);
        if (interfaceMethodrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(interfaceMethodrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.typeDescriptor);
    }

    public Object getLdcValue(int n2) {
        ConstInfo constInfo = this.getItem(n2);
        Object object = null;
        object = constInfo instanceof StringInfo ? this.getStringInfo(n2) : (constInfo instanceof FloatInfo ? (Number)new Float(this.getFloatInfo(n2)) : (Number)(constInfo instanceof IntegerInfo ? (Number)new Integer(this.getIntegerInfo(n2)) : (Number)(constInfo instanceof LongInfo ? (Number)new Long(this.getLongInfo(n2)) : (Number)(constInfo instanceof DoubleInfo ? new Double(this.getDoubleInfo(n2)) : null))));
        return object;
    }

    public int getIntegerInfo(int n2) {
        IntegerInfo integerInfo = (IntegerInfo)this.getItem(n2);
        return integerInfo.value;
    }

    public float getFloatInfo(int n2) {
        FloatInfo floatInfo = (FloatInfo)this.getItem(n2);
        return floatInfo.value;
    }

    public long getLongInfo(int n2) {
        LongInfo longInfo = (LongInfo)this.getItem(n2);
        return longInfo.value;
    }

    public double getDoubleInfo(int n2) {
        DoubleInfo doubleInfo = (DoubleInfo)this.getItem(n2);
        return doubleInfo.value;
    }

    public String getStringInfo(int n2) {
        StringInfo stringInfo = (StringInfo)this.getItem(n2);
        return this.getUtf8Info(stringInfo.string);
    }

    public String getUtf8Info(int n2) {
        Utf8Info utf8Info = (Utf8Info)this.getItem(n2);
        return utf8Info.string;
    }

    public int isConstructor(String string, int n2) {
        return this.isMember(string, "<init>", n2);
    }

    public int isMember(String string, String string2, int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(n2);
        if (this.getClassInfo(memberrefInfo.classIndex).equals(string)) {
            NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(memberrefInfo.nameAndTypeIndex);
            if (this.getUtf8Info(nameAndTypeInfo.memberName).equals(string2)) {
                return nameAndTypeInfo.typeDescriptor;
            }
        }
        return 0;
    }

    public String eqMember(String string, String string2, int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(n2);
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(memberrefInfo.nameAndTypeIndex);
        if (this.getUtf8Info(nameAndTypeInfo.memberName).equals(string) && this.getUtf8Info(nameAndTypeInfo.typeDescriptor).equals(string2)) {
            return this.getClassInfo(memberrefInfo.classIndex);
        }
        return null;
    }

    private int addItem(ConstInfo constInfo) {
        this.items.addElement(constInfo);
        return this.numOfItems++;
    }

    public int copy(int n2, ConstPool constPool, Map map) {
        if (n2 == 0) {
            return 0;
        }
        ConstInfo constInfo = this.getItem(n2);
        return constInfo.copy(this, constPool, map);
    }

    int addConstInfoPadding() {
        return this.addItem(new ConstInfoPadding());
    }

    public int addClassInfo(CtClass ctClass) {
        if (ctClass == THIS) {
            return this.thisClassInfo;
        }
        if (!ctClass.isArray()) {
            return this.addClassInfo(ctClass.getName());
        }
        return this.addClassInfo(Descriptor.toJvmName(ctClass));
    }

    public int addClassInfo(String string) {
        ClassInfo classInfo = (ClassInfo)this.classes.get(string);
        if (classInfo != null) {
            return classInfo.index;
        }
        int n2 = this.addUtf8Info(Descriptor.toJvmName(string));
        classInfo = new ClassInfo(n2, this.numOfItems);
        this.classes.put(string, classInfo);
        return this.addItem(classInfo);
    }

    public int addNameAndTypeInfo(String string, String string2) {
        return this.addNameAndTypeInfo(this.addUtf8Info(string), this.addUtf8Info(string2));
    }

    public int addNameAndTypeInfo(int n2, int n3) {
        return this.addItem(new NameAndTypeInfo(n2, n3));
    }

    public int addFieldrefInfo(int n2, String string, String string2) {
        int n3 = this.addNameAndTypeInfo(string, string2);
        return this.addFieldrefInfo(n2, n3);
    }

    public int addFieldrefInfo(int n2, int n3) {
        return this.addItem(new FieldrefInfo(n2, n3));
    }

    public int addMethodrefInfo(int n2, String string, String string2) {
        int n3 = this.addNameAndTypeInfo(string, string2);
        return this.addMethodrefInfo(n2, n3);
    }

    public int addMethodrefInfo(int n2, int n3) {
        return this.addItem(new MethodrefInfo(n2, n3));
    }

    public int addInterfaceMethodrefInfo(int n2, String string, String string2) {
        int n3 = this.addNameAndTypeInfo(string, string2);
        return this.addInterfaceMethodrefInfo(n2, n3);
    }

    public int addInterfaceMethodrefInfo(int n2, int n3) {
        return this.addItem(new InterfaceMethodrefInfo(n2, n3));
    }

    public int addStringInfo(String string) {
        return this.addItem(new StringInfo(this.addUtf8Info(string)));
    }

    public int addIntegerInfo(int n2) {
        return this.addItem(new IntegerInfo(n2));
    }

    public int addFloatInfo(float f2) {
        return this.addItem(new FloatInfo(f2));
    }

    public int addLongInfo(long l2) {
        int n2 = this.addItem(new LongInfo(l2));
        this.addItem(new ConstInfoPadding());
        return n2;
    }

    public int addDoubleInfo(double d2) {
        int n2 = this.addItem(new DoubleInfo(d2));
        this.addItem(new ConstInfoPadding());
        return n2;
    }

    public int addUtf8Info(String string) {
        Utf8Info utf8Info = (Utf8Info)this.strings.get(string);
        if (utf8Info != null) {
            return utf8Info.index;
        }
        utf8Info = new Utf8Info(string, this.numOfItems);
        this.strings.put(string, utf8Info);
        return this.addItem(utf8Info);
    }

    public Set getClassNames() {
        HashSet<String> hashSet = new HashSet<String>();
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        for (int i2 = 1; i2 < n2; ++i2) {
            String string = ((ConstInfo)longVector.elementAt(i2)).getClassName(this);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void renameClass(String string, String string2) {
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        this.classes = new HashMap(this.classes.size() * 2);
        for (int i2 = 1; i2 < n2; ++i2) {
            ConstInfo constInfo = (ConstInfo)longVector.elementAt(i2);
            constInfo.renameClass(this, string, string2);
            constInfo.makeHashtable(this);
        }
    }

    public void renameClass(Map map) {
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        this.classes = new HashMap(this.classes.size() * 2);
        for (int i2 = 1; i2 < n2; ++i2) {
            ConstInfo constInfo = (ConstInfo)longVector.elementAt(i2);
            constInfo.renameClass(this, map);
            constInfo.makeHashtable(this);
        }
    }

    private void read(DataInputStream dataInputStream) throws IOException {
        ConstInfo constInfo;
        int n2;
        int n3 = dataInputStream.readUnsignedShort();
        this.items = new LongVector(n3);
        this.numOfItems = 0;
        this.addItem(null);
        while (--n3 > 0) {
            n2 = this.readOne(dataInputStream);
            if (n2 != 5 && n2 != 6) continue;
            this.addItem(new ConstInfoPadding());
            --n3;
        }
        n2 = 1;
        while ((constInfo = (ConstInfo)this.items.elementAt(n2++)) != null) {
            constInfo.makeHashtable(this);
        }
    }

    private int readOne(DataInputStream dataInputStream) throws IOException {
        ConstInfo constInfo;
        int n2 = dataInputStream.readUnsignedByte();
        switch (n2) {
            case 1: {
                constInfo = new Utf8Info(dataInputStream, this.numOfItems);
                this.strings.put(((Utf8Info)constInfo).string, constInfo);
                break;
            }
            case 3: {
                constInfo = new IntegerInfo(dataInputStream);
                break;
            }
            case 4: {
                constInfo = new FloatInfo(dataInputStream);
                break;
            }
            case 5: {
                constInfo = new LongInfo(dataInputStream);
                break;
            }
            case 6: {
                constInfo = new DoubleInfo(dataInputStream);
                break;
            }
            case 7: {
                constInfo = new ClassInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 8: {
                constInfo = new StringInfo(dataInputStream);
                break;
            }
            case 9: {
                constInfo = new FieldrefInfo(dataInputStream);
                break;
            }
            case 10: {
                constInfo = new MethodrefInfo(dataInputStream);
                break;
            }
            case 11: {
                constInfo = new InterfaceMethodrefInfo(dataInputStream);
                break;
            }
            case 12: {
                constInfo = new NameAndTypeInfo(dataInputStream);
                break;
            }
            default: {
                throw new IOException("invalid constant type: " + n2);
            }
        }
        this.addItem(constInfo);
        return n2;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.numOfItems);
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        for (int i2 = 1; i2 < n2; ++i2) {
            ((ConstInfo)longVector.elementAt(i2)).write(dataOutputStream);
        }
    }

    public void print() {
        this.print(new PrintWriter(System.out, true));
    }

    public void print(PrintWriter printWriter) {
        int n2 = this.numOfItems;
        for (int i2 = 1; i2 < n2; ++i2) {
            printWriter.print(i2);
            printWriter.print(" ");
            ((ConstInfo)this.items.elementAt(i2)).print(printWriter);
        }
    }
}

