/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import org.zeroturnaround.bundled.javassist.bytecode.AlignmentException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTable;
import org.zeroturnaround.bundled.javassist.bytecode.LineNumberAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LocalVariableAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;

public class CodeIterator
implements Opcode {
    protected CodeAttribute codeAttr;
    protected byte[] bytecode;
    protected int endPos;
    protected int currentPos;
    private static final int[] opcodeLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 0, 0, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 0, 3, 2, 3, 1, 1, 3, 3, 1, 1, 0, 4, 3, 3, 5, 5};

    protected CodeIterator(CodeAttribute codeAttribute) {
        this.codeAttr = codeAttribute;
        this.bytecode = codeAttribute.getCode();
        this.begin();
    }

    public void begin() {
        this.currentPos = 0;
        this.endPos = this.getCodeLength();
    }

    public void move(int n2) {
        this.currentPos = n2;
    }

    public CodeAttribute get() {
        return this.codeAttr;
    }

    public int getCodeLength() {
        return this.bytecode.length;
    }

    public int byteAt(int n2) {
        return this.bytecode[n2] & 0xFF;
    }

    public void writeByte(int n2, int n3) {
        this.bytecode[n3] = (byte)n2;
    }

    public int u16bitAt(int n2) {
        return ByteArray.readU16bit(this.bytecode, n2);
    }

    public int s16bitAt(int n2) {
        return ByteArray.readS16bit(this.bytecode, n2);
    }

    public void write16bit(int n2, int n3) {
        ByteArray.write16bit(n2, this.bytecode, n3);
    }

    public int s32bitAt(int n2) {
        return ByteArray.read32bit(this.bytecode, n2);
    }

    public void write32bit(int n2, int n3) {
        ByteArray.write32bit(n2, this.bytecode, n3);
    }

    public void write(byte[] byArray, int n2) {
        int n3 = byArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.bytecode[n2++] = byArray[i2];
        }
    }

    public boolean hasNext() {
        return this.currentPos < this.endPos;
    }

    public int next() throws BadBytecode {
        int n2 = this.currentPos;
        this.currentPos = CodeIterator.nextOpcode(this.bytecode, n2);
        return n2;
    }

    public int lookAhead() {
        return this.currentPos;
    }

    public int skipConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(-1);
    }

    public int skipSuperConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(0);
    }

    public int skipThisConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(1);
    }

    private int skipSuperConstructor0(int n2) throws BadBytecode {
        this.begin();
        ConstPool constPool = this.codeAttr.getConstPool();
        String string = this.codeAttr.getDeclaringClass();
        int n3 = 0;
        while (this.hasNext()) {
            int n4;
            int n5 = this.next();
            int n6 = this.byteAt(n5);
            if (n6 == 187) {
                ++n3;
                continue;
            }
            if (n6 != 183 || !constPool.getMethodrefName(n4 = ByteArray.readU16bit(this.bytecode, n5 + 1)).equals("<init>") || --n3 >= 0) continue;
            if (n2 < 0) {
                return n5;
            }
            String string2 = constPool.getMethodrefClassName(n4);
            if (string2.equals(string) != n2 > 0) break;
            return n5;
        }
        this.begin();
        return -1;
    }

    public int insert(byte[] byArray) throws BadBytecode {
        int n2 = this.currentPos;
        this.insert0(this.currentPos, byArray, false);
        return n2;
    }

    public void insert(int n2, byte[] byArray) throws BadBytecode {
        this.insert0(n2, byArray, false);
    }

    public int insertEx(byte[] byArray) throws BadBytecode {
        int n2 = this.currentPos;
        this.insert0(this.currentPos, byArray, true);
        return n2;
    }

    public void insertEx(int n2, byte[] byArray) throws BadBytecode {
        this.insert0(n2, byArray, true);
    }

    private void insert0(int n2, byte[] byArray, boolean bl2) throws BadBytecode {
        int n3 = byArray.length;
        if (n3 <= 0) {
            return;
        }
        this.insertGapCore(n2, n3, bl2);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.bytecode[n2++] = byArray[i2];
        }
    }

    public int insertGap(int n2) throws BadBytecode {
        int n3 = this.currentPos;
        this.insertGapCore(this.currentPos, n2, false);
        return n3;
    }

    public int insertGap(int n2, int n3) throws BadBytecode {
        return this.insertGapCore(n2, n3, false);
    }

    public int insertExGap(int n2) throws BadBytecode {
        int n3 = this.currentPos;
        this.insertGapCore(this.currentPos, n2, true);
        return n3;
    }

    public int insertExGap(int n2, int n3) throws BadBytecode {
        return this.insertGapCore(n2, n3, true);
    }

    private int insertGapCore(int n2, int n3, boolean bl2) throws BadBytecode {
        if (n3 <= 0) {
            return 0;
        }
        int n4 = this.currentPos;
        byte[] byArray = CodeIterator.insertGap(this.bytecode, n2, n3, bl2, this.get().getExceptionTable(), this.codeAttr);
        int n5 = byArray.length - this.bytecode.length;
        if (n4 >= n2) {
            this.currentPos = n4 + n5;
        }
        this.codeAttr.setCode(byArray);
        this.bytecode = byArray;
        this.endPos = this.getCodeLength();
        this.updateCursors(n2, n5);
        return n5;
    }

    protected void updateCursors(int n2, int n3) {
    }

    public void insert(ExceptionTable exceptionTable, int n2) {
        this.codeAttr.getExceptionTable().add(0, exceptionTable, n2);
    }

    public int append(byte[] byArray) {
        int n2 = this.getCodeLength();
        int n3 = byArray.length;
        if (n3 <= 0) {
            return n2;
        }
        this.appendGap(n3);
        byte[] byArray2 = this.bytecode;
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray2[i2 + n2] = byArray[i2];
        }
        return n2;
    }

    public void appendGap(int n2) {
        int n3;
        byte[] byArray = this.bytecode;
        int n4 = byArray.length;
        byte[] byArray2 = new byte[n4 + n2];
        for (n3 = 0; n3 < n4; ++n3) {
            byArray2[n3] = byArray[n3];
        }
        for (n3 = n4; n3 < n4 + n2; ++n3) {
            byArray2[n3] = 0;
        }
        this.codeAttr.setCode(byArray2);
        this.bytecode = byArray2;
        this.endPos = this.getCodeLength();
    }

    public void append(ExceptionTable exceptionTable, int n2) {
        ExceptionTable exceptionTable2 = this.codeAttr.getExceptionTable();
        exceptionTable2.add(exceptionTable2.size(), exceptionTable, n2);
    }

    static int nextOpcode(byte[] byArray, int n2) throws BadBytecode {
        int n3;
        try {
            n3 = byArray[n2] & 0xFF;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new BadBytecode("invalid opcode address");
        }
        try {
            int n4 = opcodeLength[n3];
            if (n4 > 0) {
                return n2 + n4;
            }
            if (n3 == 196) {
                if (byArray[n2 + 1] == -124) {
                    return n2 + 6;
                }
                return n2 + 4;
            }
            int n5 = (n2 & 0xFFFFFFFC) + 8;
            if (n3 == 171) {
                int n6 = ByteArray.read32bit(byArray, n5);
                return n5 + n6 * 8 + 4;
            }
            if (n3 == 170) {
                int n7 = ByteArray.read32bit(byArray, n5);
                int n8 = ByteArray.read32bit(byArray, n5 + 4);
                return n5 + (n8 - n7 + 1) * 4 + 8;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new BadBytecode(n3);
    }

    static byte[] insertGap(byte[] byArray, int n2, int n3, boolean bl2, ExceptionTable exceptionTable, CodeAttribute codeAttribute) throws BadBytecode {
        if (n3 <= 0) {
            return byArray;
        }
        try {
            return CodeIterator.insertGap0(byArray, n2, n3, bl2, exceptionTable, codeAttribute);
        }
        catch (AlignmentException alignmentException) {
            try {
                return CodeIterator.insertGap0(byArray, n2, n3 + 3 & 0xFFFFFFFC, bl2, exceptionTable, codeAttribute);
            }
            catch (AlignmentException alignmentException2) {
                throw new RuntimeException("fatal error?");
            }
        }
    }

    private static byte[] insertGap0(byte[] byArray, int n2, int n3, boolean bl2, ExceptionTable exceptionTable, CodeAttribute codeAttribute) throws BadBytecode, AlignmentException {
        StackMapTable stackMapTable;
        LocalVariableAttribute localVariableAttribute;
        LocalVariableAttribute localVariableAttribute2;
        int n4 = byArray.length;
        byte[] byArray2 = new byte[n4 + n3];
        CodeIterator.insertGap2(byArray, n2, n3, n4, byArray2, bl2);
        exceptionTable.shiftPc(n2, n3, bl2);
        LineNumberAttribute lineNumberAttribute = (LineNumberAttribute)codeAttribute.getAttribute("LineNumberTable");
        if (lineNumberAttribute != null) {
            lineNumberAttribute.shiftPc(n2, n3, bl2);
        }
        if ((localVariableAttribute2 = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable")) != null) {
            localVariableAttribute2.shiftPc(n2, n3, bl2);
        }
        if ((localVariableAttribute = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTypeTable")) != null) {
            localVariableAttribute.shiftPc(n2, n3, bl2);
        }
        if ((stackMapTable = (StackMapTable)codeAttribute.getAttribute("StackMapTable")) != null) {
            stackMapTable.shiftPc(n2, n3, bl2);
        }
        return byArray2;
    }

    private static void insertGap2(byte[] byArray, int n2, int n3, int n4, byte[] byArray2, boolean bl2) throws BadBytecode, AlignmentException {
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            if (n5 == n2) {
                n12 = n6 + n3;
                while (n6 < n12) {
                    byArray2[n6++] = 0;
                }
            }
            int n13 = CodeIterator.nextOpcode(byArray, n5);
            n12 = byArray[n5] & 0xFF;
            if (153 <= n12 && n12 <= 168 || n12 == 198 || n12 == 199) {
                n11 = byArray[n5 + 1] << 8 | byArray[n5 + 2] & 0xFF;
                n11 = CodeIterator.newOffset(n5, n11, n2, n3, bl2);
                byArray2[n6] = byArray[n5];
                ByteArray.write16bit(n11, byArray2, n6 + 1);
                n6 += 3;
            } else if (n12 == 200 || n12 == 201) {
                n11 = ByteArray.read32bit(byArray, n5 + 1);
                n11 = CodeIterator.newOffset(n5, n11, n2, n3, bl2);
                byArray2[n6++] = byArray[n5];
                ByteArray.write32bit(n11, byArray2, n6);
                n6 += 4;
            } else if (n12 == 170) {
                if (n5 != n6 && (n3 & 3) != 0) {
                    throw new AlignmentException();
                }
                n11 = n5;
                n10 = (n5 & 0xFFFFFFFC) + 4;
                while (n11 < n10) {
                    byArray2[n6++] = byArray[n11++];
                }
                n9 = CodeIterator.newOffset(n5, ByteArray.read32bit(byArray, n10), n2, n3, bl2);
                ByteArray.write32bit(n9, byArray2, n6);
                n8 = ByteArray.read32bit(byArray, n10 + 4);
                ByteArray.write32bit(n8, byArray2, n6 + 4);
                n7 = ByteArray.read32bit(byArray, n10 + 8);
                ByteArray.write32bit(n7, byArray2, n6 + 8);
                n6 += 12;
                n11 = n10 + 12;
                n10 = n11 + (n7 - n8 + 1) * 4;
                while (n11 < n10) {
                    int n14 = CodeIterator.newOffset(n5, ByteArray.read32bit(byArray, n11), n2, n3, bl2);
                    ByteArray.write32bit(n14, byArray2, n6);
                    n6 += 4;
                    n11 += 4;
                }
            } else if (n12 == 171) {
                if (n5 != n6 && (n3 & 3) != 0) {
                    throw new AlignmentException();
                }
                n11 = n5;
                n10 = (n5 & 0xFFFFFFFC) + 4;
                while (n11 < n10) {
                    byArray2[n6++] = byArray[n11++];
                }
                n9 = CodeIterator.newOffset(n5, ByteArray.read32bit(byArray, n10), n2, n3, bl2);
                ByteArray.write32bit(n9, byArray2, n6);
                n8 = ByteArray.read32bit(byArray, n10 + 4);
                ByteArray.write32bit(n8, byArray2, n6 + 4);
                n6 += 8;
                n11 = n10 + 8;
                n10 = n11 + n8 * 8;
                while (n11 < n10) {
                    ByteArray.copy32bit(byArray, n11, byArray2, n6);
                    n7 = CodeIterator.newOffset(n5, ByteArray.read32bit(byArray, n11 + 4), n2, n3, bl2);
                    ByteArray.write32bit(n7, byArray2, n6 + 4);
                    n6 += 8;
                    n11 += 8;
                }
            } else {
                while (n5 < n13) {
                    byArray2[n6++] = byArray[n5++];
                }
            }
            n5 = n13;
        }
    }

    private static int newOffset(int n2, int n3, int n4, int n5, boolean bl2) {
        int n6 = n2 + n3;
        if (n2 < n4) {
            if (n4 < n6 || bl2 && n4 == n6) {
                n3 += n5;
            }
        } else if (n6 < n4 || !bl2 && n4 == n6) {
            n3 -= n5;
        }
        return n3;
    }
}

