/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.ConstInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;

class ClassInfo
extends ConstInfo {
    static final int tag = 7;
    int name;
    int index;

    public ClassInfo(int n2, int n3) {
        this.name = n2;
        this.index = n3;
    }

    public ClassInfo(DataInputStream dataInputStream, int n2) throws IOException {
        this.name = dataInputStream.readUnsignedShort();
        this.index = n2;
    }

    public int getTag() {
        return 7;
    }

    public String getClassName(ConstPool constPool) {
        return constPool.getUtf8Info(this.name);
    }

    public void renameClass(ConstPool constPool, String string, String string2) {
        String string3;
        String string4 = constPool.getUtf8Info(this.name);
        if (string4.equals(string)) {
            this.name = constPool.addUtf8Info(string2);
        } else if (string4.charAt(0) == '[' && string4 != (string3 = Descriptor.rename(string4, string, string2))) {
            this.name = constPool.addUtf8Info(string3);
        }
    }

    public void renameClass(ConstPool constPool, Map map) {
        String string = constPool.getUtf8Info(this.name);
        if (string.charAt(0) == '[') {
            String string2 = Descriptor.rename(string, map);
            if (string != string2) {
                this.name = constPool.addUtf8Info(string2);
            }
        } else {
            String string3 = (String)map.get(string);
            if (string3 != null && !string3.equals(string)) {
                this.name = constPool.addUtf8Info(string3);
            }
        }
    }

    public int copy(ConstPool constPool, ConstPool constPool2, Map map) {
        String string;
        String string2 = constPool.getUtf8Info(this.name);
        if (map != null && (string = (String)map.get(string2)) != null) {
            string2 = string;
        }
        return constPool2.addClassInfo(string2);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(7);
        dataOutputStream.writeShort(this.name);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("Class #");
        printWriter.println(this.name);
    }

    void makeHashtable(ConstPool constPool) {
        String string = Descriptor.toJavaName(this.getClassName(constPool));
        constPool.classes.put(string, this);
    }
}

