/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.PrintWriter;
import java.util.List;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.bytecode.AccessFlag;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFile;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.FieldInfo;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$Printer;

public class ClassFileWriter {
    public static void print(ClassFile classFile) {
        ClassFileWriter.print(classFile, new PrintWriter(System.out, true));
    }

    public static void print(ClassFile classFile, PrintWriter printWriter) {
        int n2;
        Object object;
        int n3;
        int n4 = AccessFlag.toModifier(classFile.getAccessFlags() & 0xFFFFFFDF);
        printWriter.println("major: " + classFile.major + ", minor: " + classFile.minor + " modifiers: " + Integer.toHexString(classFile.getAccessFlags()));
        printWriter.println(Modifier.toString(n4) + " class " + classFile.getName() + " extends " + classFile.getSuperclass());
        String[] stringArray = classFile.getInterfaces();
        if (stringArray != null && stringArray.length > 0) {
            printWriter.print("    implements ");
            printWriter.print(stringArray[0]);
            for (n3 = 1; n3 < stringArray.length; ++n3) {
                printWriter.print(", " + stringArray[n3]);
            }
            printWriter.println();
        }
        printWriter.println();
        List list = classFile.getFields();
        int n5 = list.size();
        for (n3 = 0; n3 < n5; ++n3) {
            object = (FieldInfo)list.get(n3);
            n2 = ((FieldInfo)object).getAccessFlags();
            printWriter.println(Modifier.toString(AccessFlag.toModifier(n2)) + " " + ((FieldInfo)object).getName() + "\t" + ((FieldInfo)object).getDescriptor());
            ClassFileWriter.printAttributes(((FieldInfo)object).getAttributes(), printWriter, 'f');
        }
        printWriter.println();
        list = classFile.getMethods();
        n5 = list.size();
        for (n3 = 0; n3 < n5; ++n3) {
            object = (MethodInfo)list.get(n3);
            n2 = ((MethodInfo)object).getAccessFlags();
            printWriter.println(Modifier.toString(AccessFlag.toModifier(n2)) + " " + ((MethodInfo)object).getName() + "\t" + ((MethodInfo)object).getDescriptor());
            ClassFileWriter.printAttributes(((MethodInfo)object).getAttributes(), printWriter, 'm');
            printWriter.println();
        }
        printWriter.println();
        ClassFileWriter.printAttributes(classFile.getAttributes(), printWriter, 'c');
    }

    static void printAttributes(List list, PrintWriter printWriter, char c2) {
        if (list == null) {
            return;
        }
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AttributeInfo attributeInfo;
            AttributeInfo attributeInfo2 = (AttributeInfo)list.get(i2);
            if (attributeInfo2 instanceof CodeAttribute) {
                attributeInfo = (CodeAttribute)attributeInfo2;
                printWriter.println("attribute: " + attributeInfo2.getName() + ": " + attributeInfo2.getClass().getName());
                printWriter.println("max stack " + ((CodeAttribute)attributeInfo).getMaxStack() + ", max locals " + ((CodeAttribute)attributeInfo).getMaxLocals() + ", " + ((CodeAttribute)attributeInfo).getExceptionTable().size() + " catch blocks");
                printWriter.println("<code attribute begin>");
                ClassFileWriter.printAttributes(((CodeAttribute)attributeInfo).getAttributes(), printWriter, c2);
                printWriter.println("<code attribute end>");
                continue;
            }
            if (attributeInfo2 instanceof StackMapTable) {
                printWriter.println("<stack map table begin>");
                StackMapTable$Printer.print((StackMapTable)attributeInfo2, printWriter);
                printWriter.println("<stack map table end>");
                continue;
            }
            if (attributeInfo2 instanceof SignatureAttribute) {
                attributeInfo = (SignatureAttribute)attributeInfo2;
                String string = ((SignatureAttribute)attributeInfo).getSignature();
                printWriter.println("signature: " + string);
                try {
                    String string2 = c2 == 'c' ? SignatureAttribute.toClassSignature(string).toString() : (c2 == 'm' ? SignatureAttribute.toMethodSignature(string).toString() : SignatureAttribute.toFieldSignature(string).toString());
                    printWriter.println("           " + string2);
                }
                catch (BadBytecode badBytecode) {
                    printWriter.println("           syntax error");
                }
                continue;
            }
            printWriter.println("attribute: " + attributeInfo2.getName() + " (" + attributeInfo2.get().length + " byte): " + attributeInfo2.getClass().getName());
        }
    }
}

