/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtPrimitiveType;
import org.zeroturnaround.bundled.javassist.bytecode.ByteVector;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTable;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;

public class Bytecode
extends ByteVector
implements Cloneable,
Opcode {
    public static final CtClass THIS = ConstPool.THIS;
    ConstPool constPool;
    int maxStack;
    int maxLocals;
    ExceptionTable tryblocks;
    private int stackDepth;

    public Bytecode(ConstPool constPool, int n2, int n3) {
        this.constPool = constPool;
        this.maxStack = n2;
        this.maxLocals = n3;
        this.tryblocks = new ExceptionTable(constPool);
        this.stackDepth = 0;
    }

    public Bytecode(ConstPool constPool) {
        this(constPool, 0, 0);
    }

    public Object clone() {
        try {
            Bytecode bytecode = (Bytecode)super.clone();
            bytecode.tryblocks = (ExceptionTable)this.tryblocks.clone();
            return bytecode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public ExceptionTable getExceptionTable() {
        return this.tryblocks;
    }

    public CodeAttribute toCodeAttribute() {
        return new CodeAttribute(this.constPool, this.maxStack, this.maxLocals, this.get(), this.tryblocks);
    }

    public int length() {
        return this.getSize();
    }

    public byte[] get() {
        return this.copy();
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(int n2) {
        this.maxStack = n2;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxLocals(int n2) {
        this.maxLocals = n2;
    }

    public void setMaxLocals(boolean bl2, CtClass[] ctClassArray, int n2) {
        if (!bl2) {
            ++n2;
        }
        if (ctClassArray != null) {
            CtClass ctClass = CtClass.doubleType;
            CtClass ctClass2 = CtClass.longType;
            int n3 = ctClassArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                CtClass ctClass3 = ctClassArray[i2];
                if (ctClass3 == ctClass || ctClass3 == ctClass2) {
                    n2 += 2;
                    continue;
                }
                ++n2;
            }
        }
        this.maxLocals = n2;
    }

    public void incMaxLocals(int n2) {
        this.maxLocals += n2;
    }

    public void addExceptionHandler(int n2, int n3, int n4, CtClass ctClass) {
        this.addExceptionHandler(n2, n3, n4, this.constPool.addClassInfo(ctClass));
    }

    public void addExceptionHandler(int n2, int n3, int n4, String string) {
        this.addExceptionHandler(n2, n3, n4, this.constPool.addClassInfo(string));
    }

    public void addExceptionHandler(int n2, int n3, int n4, int n5) {
        this.tryblocks.add(n2, n3, n4, n5);
    }

    public int currentPc() {
        return this.getSize();
    }

    public int read(int n2) {
        return super.read(n2);
    }

    public int read16bit(int n2) {
        int n3 = this.read(n2);
        int n4 = this.read(n2 + 1);
        return (n3 << 8) + (n4 & 0xFF);
    }

    public int read32bit(int n2) {
        int n3 = this.read16bit(n2);
        int n4 = this.read16bit(n2 + 2);
        return (n3 << 16) + (n4 & 0xFFFF);
    }

    public void write(int n2, int n3) {
        super.write(n2, n3);
    }

    public void write16bit(int n2, int n3) {
        this.write(n2, n3 >> 8);
        this.write(n2 + 1, n3);
    }

    public void write32bit(int n2, int n3) {
        this.write16bit(n2, n3 >> 16);
        this.write16bit(n2 + 2, n3);
    }

    public void add(int n2) {
        super.add(n2);
    }

    public void add32bit(int n2) {
        this.add(n2 >> 24);
        this.add(n2 >> 16);
        this.add(n2 >> 8);
        this.add(n2);
    }

    public void addGap(int n2) {
        super.addGap(n2);
    }

    public void addOpcode(int n2) {
        this.add(n2);
        this.growStack(Opcode.STACK_GROW[n2]);
    }

    public void growStack(int n2) {
        this.setStackDepth(this.stackDepth + n2);
    }

    public int getStackDepth() {
        return this.stackDepth;
    }

    public void setStackDepth(int n2) {
        this.stackDepth = n2;
        if (this.stackDepth > this.maxStack) {
            this.maxStack = this.stackDepth;
        }
    }

    public void addIndex(int n2) {
        this.add(n2 >> 8);
        this.add(n2);
    }

    public void addAload(int n2) {
        if (n2 < 4) {
            this.addOpcode(42 + n2);
        } else if (n2 < 256) {
            this.addOpcode(25);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(25);
            this.addIndex(n2);
        }
    }

    public void addAstore(int n2) {
        if (n2 < 4) {
            this.addOpcode(75 + n2);
        } else if (n2 < 256) {
            this.addOpcode(58);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(58);
            this.addIndex(n2);
        }
    }

    public void addIconst(int n2) {
        if (n2 < 6 && -2 < n2) {
            this.addOpcode(3 + n2);
        } else if (n2 <= 127 && -128 <= n2) {
            this.addOpcode(16);
            this.add(n2);
        } else if (n2 <= Short.MAX_VALUE && Short.MIN_VALUE <= n2) {
            this.addOpcode(17);
            this.add(n2 >> 8);
            this.add(n2);
        } else {
            this.addLdc(this.constPool.addIntegerInfo(n2));
        }
    }

    public void addConstZero(CtClass ctClass) {
        if (ctClass.isPrimitive()) {
            if (ctClass == CtClass.longType) {
                this.addOpcode(9);
            } else if (ctClass == CtClass.floatType) {
                this.addOpcode(11);
            } else if (ctClass == CtClass.doubleType) {
                this.addOpcode(14);
            } else {
                if (ctClass == CtClass.voidType) {
                    throw new RuntimeException("void type?");
                }
                this.addOpcode(3);
            }
        } else {
            this.addOpcode(1);
        }
    }

    public void addIload(int n2) {
        if (n2 < 4) {
            this.addOpcode(26 + n2);
        } else if (n2 < 256) {
            this.addOpcode(21);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(21);
            this.addIndex(n2);
        }
    }

    public void addIstore(int n2) {
        if (n2 < 4) {
            this.addOpcode(59 + n2);
        } else if (n2 < 256) {
            this.addOpcode(54);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(54);
            this.addIndex(n2);
        }
    }

    public void addLconst(long l2) {
        if (l2 == 0L || l2 == 1L) {
            this.addOpcode(9 + (int)l2);
        } else {
            this.addLdc2w(l2);
        }
    }

    public void addLload(int n2) {
        if (n2 < 4) {
            this.addOpcode(30 + n2);
        } else if (n2 < 256) {
            this.addOpcode(22);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(22);
            this.addIndex(n2);
        }
    }

    public void addLstore(int n2) {
        if (n2 < 4) {
            this.addOpcode(63 + n2);
        } else if (n2 < 256) {
            this.addOpcode(55);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(55);
            this.addIndex(n2);
        }
    }

    public void addDconst(double d2) {
        if (d2 == 0.0 || d2 == 1.0) {
            this.addOpcode(14 + (int)d2);
        } else {
            this.addLdc2w(d2);
        }
    }

    public void addDload(int n2) {
        if (n2 < 4) {
            this.addOpcode(38 + n2);
        } else if (n2 < 256) {
            this.addOpcode(24);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(24);
            this.addIndex(n2);
        }
    }

    public void addDstore(int n2) {
        if (n2 < 4) {
            this.addOpcode(71 + n2);
        } else if (n2 < 256) {
            this.addOpcode(57);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(57);
            this.addIndex(n2);
        }
    }

    public void addFconst(float f2) {
        if (f2 == 0.0f || f2 == 1.0f || f2 == 2.0f) {
            this.addOpcode(11 + (int)f2);
        } else {
            this.addLdc(this.constPool.addFloatInfo(f2));
        }
    }

    public void addFload(int n2) {
        if (n2 < 4) {
            this.addOpcode(34 + n2);
        } else if (n2 < 256) {
            this.addOpcode(23);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(23);
            this.addIndex(n2);
        }
    }

    public void addFstore(int n2) {
        if (n2 < 4) {
            this.addOpcode(67 + n2);
        } else if (n2 < 256) {
            this.addOpcode(56);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(56);
            this.addIndex(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int addLoad(int n2, CtClass ctClass) {
        if (!ctClass.isPrimitive()) {
            this.addAload(n2);
            return 1;
        }
        if (ctClass == CtClass.booleanType || ctClass == CtClass.charType || ctClass == CtClass.byteType || ctClass == CtClass.shortType || ctClass == CtClass.intType) {
            this.addIload(n2);
            return 1;
        }
        if (ctClass == CtClass.longType) {
            this.addLload(n2);
            return 2;
        }
        if (ctClass == CtClass.floatType) {
            this.addFload(n2);
            return 1;
        }
        if (ctClass != CtClass.doubleType) throw new RuntimeException("void type?");
        this.addDload(n2);
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int addStore(int n2, CtClass ctClass) {
        if (!ctClass.isPrimitive()) {
            this.addAstore(n2);
            return 1;
        }
        if (ctClass == CtClass.booleanType || ctClass == CtClass.charType || ctClass == CtClass.byteType || ctClass == CtClass.shortType || ctClass == CtClass.intType) {
            this.addIstore(n2);
            return 1;
        }
        if (ctClass == CtClass.longType) {
            this.addLstore(n2);
            return 2;
        }
        if (ctClass == CtClass.floatType) {
            this.addFstore(n2);
            return 1;
        }
        if (ctClass != CtClass.doubleType) throw new RuntimeException("void type?");
        this.addDstore(n2);
        return 2;
    }

    public int addLoadParameters(CtClass[] ctClassArray, int n2) {
        int n3 = 0;
        if (ctClassArray != null) {
            int n4 = ctClassArray.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                n3 += this.addLoad(n3 + n2, ctClassArray[i2]);
            }
        }
        return n3;
    }

    public void addCheckcast(CtClass ctClass) {
        this.addOpcode(192);
        this.addIndex(this.constPool.addClassInfo(ctClass));
    }

    public void addCheckcast(String string) {
        this.addOpcode(192);
        this.addIndex(this.constPool.addClassInfo(string));
    }

    public void addInstanceof(String string) {
        this.addOpcode(193);
        this.addIndex(this.constPool.addClassInfo(string));
    }

    public void addGetfield(CtClass ctClass, String string, String string2) {
        this.add(180);
        int n2 = this.constPool.addClassInfo(ctClass);
        this.addIndex(this.constPool.addFieldrefInfo(n2, string, string2));
        this.growStack(Descriptor.dataSize(string2) - 1);
    }

    public void addGetfield(String string, String string2, String string3) {
        this.add(180);
        int n2 = this.constPool.addClassInfo(string);
        this.addIndex(this.constPool.addFieldrefInfo(n2, string2, string3));
        this.growStack(Descriptor.dataSize(string3) - 1);
    }

    public void addGetstatic(CtClass ctClass, String string, String string2) {
        this.add(178);
        int n2 = this.constPool.addClassInfo(ctClass);
        this.addIndex(this.constPool.addFieldrefInfo(n2, string, string2));
        this.growStack(Descriptor.dataSize(string2));
    }

    public void addGetstatic(String string, String string2, String string3) {
        this.add(178);
        int n2 = this.constPool.addClassInfo(string);
        this.addIndex(this.constPool.addFieldrefInfo(n2, string2, string3));
        this.growStack(Descriptor.dataSize(string3));
    }

    public void addInvokespecial(CtClass ctClass, String string, CtClass ctClass2, CtClass[] ctClassArray) {
        String string2 = Descriptor.ofMethod(ctClass2, ctClassArray);
        this.addInvokespecial(ctClass, string, string2);
    }

    public void addInvokespecial(CtClass ctClass, String string, String string2) {
        this.addInvokespecial(this.constPool.addClassInfo(ctClass), string, string2);
    }

    public void addInvokespecial(String string, String string2, String string3) {
        this.addInvokespecial(this.constPool.addClassInfo(string), string2, string3);
    }

    public void addInvokespecial(int n2, String string, String string2) {
        this.add(183);
        this.addIndex(this.constPool.addMethodrefInfo(n2, string, string2));
        this.growStack(Descriptor.dataSize(string2) - 1);
    }

    public void addInvokestatic(CtClass ctClass, String string, CtClass ctClass2, CtClass[] ctClassArray) {
        String string2 = Descriptor.ofMethod(ctClass2, ctClassArray);
        this.addInvokestatic(ctClass, string, string2);
    }

    public void addInvokestatic(CtClass ctClass, String string, String string2) {
        this.addInvokestatic(this.constPool.addClassInfo(ctClass), string, string2);
    }

    public void addInvokestatic(String string, String string2, String string3) {
        this.addInvokestatic(this.constPool.addClassInfo(string), string2, string3);
    }

    public void addInvokestatic(int n2, String string, String string2) {
        this.add(184);
        this.addIndex(this.constPool.addMethodrefInfo(n2, string, string2));
        this.growStack(Descriptor.dataSize(string2));
    }

    public void addInvokevirtual(CtClass ctClass, String string, CtClass ctClass2, CtClass[] ctClassArray) {
        String string2 = Descriptor.ofMethod(ctClass2, ctClassArray);
        this.addInvokevirtual(ctClass, string, string2);
    }

    public void addInvokevirtual(CtClass ctClass, String string, String string2) {
        this.addInvokevirtual(this.constPool.addClassInfo(ctClass), string, string2);
    }

    public void addInvokevirtual(String string, String string2, String string3) {
        this.addInvokevirtual(this.constPool.addClassInfo(string), string2, string3);
    }

    public void addInvokevirtual(int n2, String string, String string2) {
        this.add(182);
        this.addIndex(this.constPool.addMethodrefInfo(n2, string, string2));
        this.growStack(Descriptor.dataSize(string2) - 1);
    }

    public void addInvokeinterface(CtClass ctClass, String string, CtClass ctClass2, CtClass[] ctClassArray, int n2) {
        String string2 = Descriptor.ofMethod(ctClass2, ctClassArray);
        this.addInvokeinterface(ctClass, string, string2, n2);
    }

    public void addInvokeinterface(CtClass ctClass, String string, String string2, int n2) {
        this.addInvokeinterface(this.constPool.addClassInfo(ctClass), string, string2, n2);
    }

    public void addInvokeinterface(String string, String string2, String string3, int n2) {
        this.addInvokeinterface(this.constPool.addClassInfo(string), string2, string3, n2);
    }

    public void addInvokeinterface(int n2, String string, String string2, int n3) {
        this.add(185);
        this.addIndex(this.constPool.addInterfaceMethodrefInfo(n2, string, string2));
        this.add(n3);
        this.add(0);
        this.growStack(Descriptor.dataSize(string2) - 1);
    }

    public void addLdc(String string) {
        this.addLdc(this.constPool.addStringInfo(string));
    }

    public void addLdc(int n2) {
        if (n2 > 255) {
            this.addOpcode(19);
            this.addIndex(n2);
        } else {
            this.addOpcode(18);
            this.add(n2);
        }
    }

    public void addLdc2w(long l2) {
        this.addOpcode(20);
        this.addIndex(this.constPool.addLongInfo(l2));
    }

    public void addLdc2w(double d2) {
        this.addOpcode(20);
        this.addIndex(this.constPool.addDoubleInfo(d2));
    }

    public void addNew(CtClass ctClass) {
        this.addOpcode(187);
        this.addIndex(this.constPool.addClassInfo(ctClass));
    }

    public void addNew(String string) {
        this.addOpcode(187);
        this.addIndex(this.constPool.addClassInfo(string));
    }

    public void addAnewarray(String string) {
        this.addOpcode(189);
        this.addIndex(this.constPool.addClassInfo(string));
    }

    public void addAnewarray(CtClass ctClass, int n2) {
        this.addIconst(n2);
        this.addOpcode(189);
        this.addIndex(this.constPool.addClassInfo(ctClass));
    }

    public void addNewarray(int n2, int n3) {
        this.addIconst(n3);
        this.addOpcode(188);
        this.add(n2);
    }

    public int addMultiNewarray(CtClass ctClass, int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addIconst(nArray[i2]);
        }
        this.growStack(n2);
        return this.addMultiNewarray(ctClass, n2);
    }

    public int addMultiNewarray(CtClass ctClass, int n2) {
        this.add(197);
        this.addIndex(this.constPool.addClassInfo(ctClass));
        this.add(n2);
        this.growStack(1 - n2);
        return n2;
    }

    public int addMultiNewarray(String string, int n2) {
        this.add(197);
        this.addIndex(this.constPool.addClassInfo(string));
        this.add(n2);
        this.growStack(1 - n2);
        return n2;
    }

    public void addPutfield(CtClass ctClass, String string, String string2) {
        this.addPutfield0(ctClass, null, string, string2);
    }

    public void addPutfield(String string, String string2, String string3) {
        this.addPutfield0(null, string, string2, string3);
    }

    private void addPutfield0(CtClass ctClass, String string, String string2, String string3) {
        this.add(181);
        int n2 = string == null ? this.constPool.addClassInfo(ctClass) : this.constPool.addClassInfo(string);
        this.addIndex(this.constPool.addFieldrefInfo(n2, string2, string3));
        this.growStack(-1 - Descriptor.dataSize(string3));
    }

    public void addPutstatic(CtClass ctClass, String string, String string2) {
        this.addPutstatic0(ctClass, null, string, string2);
    }

    public void addPutstatic(String string, String string2, String string3) {
        this.addPutstatic0(null, string, string2, string3);
    }

    private void addPutstatic0(CtClass ctClass, String string, String string2, String string3) {
        this.add(179);
        int n2 = string == null ? this.constPool.addClassInfo(ctClass) : this.constPool.addClassInfo(string);
        this.addIndex(this.constPool.addFieldrefInfo(n2, string2, string3));
        this.growStack(-Descriptor.dataSize(string3));
    }

    public void addReturn(CtClass ctClass) {
        if (ctClass == null) {
            this.addOpcode(177);
        } else if (ctClass.isPrimitive()) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)ctClass;
            this.addOpcode(ctPrimitiveType.getReturnOp());
        } else {
            this.addOpcode(176);
        }
    }

    public void addRet(int n2) {
        if (n2 < 256) {
            this.addOpcode(169);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(169);
            this.addIndex(n2);
        }
    }

    public void addPrintln(String string) {
        this.addGetstatic("java.lang.System", "err", "Ljava/io/PrintStream;");
        this.addLdc(string);
        this.addInvokevirtual("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
    }
}

