/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.AnnotationDefaultAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.AnnotationsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstantAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.DeprecatedAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.EnclosingMethodAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.InnerClassesAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LineNumberAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LocalVariableAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ParameterAnnotationsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.SourceFileAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;
import org.zeroturnaround.bundled.javassist.bytecode.SyntheticAttribute;

public class AttributeInfo {
    protected ConstPool constPool;
    int name;
    byte[] info;

    protected AttributeInfo(ConstPool constPool, int n2, byte[] byArray) {
        this.constPool = constPool;
        this.name = n2;
        this.info = byArray;
    }

    protected AttributeInfo(ConstPool constPool, String string) {
        this(constPool, string, (byte[])null);
    }

    public AttributeInfo(ConstPool constPool, String string, byte[] byArray) {
        this(constPool, constPool.addUtf8Info(string), byArray);
    }

    protected AttributeInfo(ConstPool constPool, int n2, DataInputStream dataInputStream) throws IOException {
        this.constPool = constPool;
        this.name = n2;
        int n3 = dataInputStream.readInt();
        this.info = new byte[n3];
        if (n3 > 0) {
            dataInputStream.readFully(this.info);
        }
    }

    static AttributeInfo read(ConstPool constPool, DataInputStream dataInputStream) throws IOException {
        int n2 = dataInputStream.readUnsignedShort();
        String string = constPool.getUtf8Info(n2);
        if (string.charAt(0) < 'L') {
            if (string.equals("AnnotationDefault")) {
                return new AnnotationDefaultAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("Code")) {
                return new CodeAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("ConstantValue")) {
                return new ConstantAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("Deprecated")) {
                return new DeprecatedAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("EnclosingMethod")) {
                return new EnclosingMethodAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("Exceptions")) {
                return new ExceptionsAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("InnerClasses")) {
                return new InnerClassesAttribute(constPool, n2, dataInputStream);
            }
        } else {
            if (string.equals("LineNumberTable")) {
                return new LineNumberAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("LocalVariableTable") || string.equals("LocalVariableTypeTable")) {
                return new LocalVariableAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("RuntimeVisibleAnnotations") || string.equals("RuntimeInvisibleAnnotations")) {
                return new AnnotationsAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("RuntimeVisibleParameterAnnotations") || string.equals("RuntimeInvisibleParameterAnnotations")) {
                return new ParameterAnnotationsAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("Signature")) {
                return new SignatureAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("SourceFile")) {
                return new SourceFileAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("Synthetic")) {
                return new SyntheticAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("StackMapTable")) {
                return new StackMapTable(constPool, n2, dataInputStream);
            }
        }
        return new AttributeInfo(constPool, n2, dataInputStream);
    }

    public String getName() {
        return this.constPool.getUtf8Info(this.name);
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public int length() {
        return this.info.length + 6;
    }

    public byte[] get() {
        return this.info;
    }

    public void set(byte[] byArray) {
        this.info = byArray;
    }

    public AttributeInfo copy(ConstPool constPool, Map map) {
        int n2 = this.info.length;
        byte[] byArray = this.info;
        byte[] byArray2 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray2[i2] = byArray[i2];
        }
        return new AttributeInfo(constPool, this.getName(), byArray2);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name);
        dataOutputStream.writeInt(this.info.length);
        if (this.info.length > 0) {
            dataOutputStream.write(this.info);
        }
    }

    static int getLength(LinkedList linkedList) {
        int n2 = 0;
        int n3 = linkedList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            AttributeInfo attributeInfo = (AttributeInfo)linkedList.get(i2);
            n2 += attributeInfo.length();
        }
        return n2;
    }

    static AttributeInfo lookup(LinkedList linkedList, String string) {
        if (linkedList == null) {
            return null;
        }
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)listIterator.next();
            if (!attributeInfo.getName().equals(string)) continue;
            return attributeInfo;
        }
        return null;
    }

    static synchronized void remove(LinkedList linkedList, String string) {
        if (linkedList == null) {
            return;
        }
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)listIterator.next();
            if (!attributeInfo.getName().equals(string)) continue;
            listIterator.remove();
        }
    }

    static void writeAll(LinkedList linkedList, DataOutputStream dataOutputStream) throws IOException {
        if (linkedList == null) {
            return;
        }
        int n2 = linkedList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AttributeInfo attributeInfo = (AttributeInfo)linkedList.get(i2);
            attributeInfo.write(dataOutputStream);
        }
    }

    static LinkedList copyAll(LinkedList linkedList, ConstPool constPool) {
        if (linkedList == null) {
            return null;
        }
        LinkedList<AttributeInfo> linkedList2 = new LinkedList<AttributeInfo>();
        int n2 = linkedList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AttributeInfo attributeInfo = (AttributeInfo)linkedList.get(i2);
            linkedList2.add(attributeInfo.copy(constPool, null));
        }
        return linkedList2;
    }
}

