/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.SerialVersionUID$1;
import org.zeroturnaround.bundled.javassist.SerialVersionUID$2;
import org.zeroturnaround.bundled.javassist.SerialVersionUID$3;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFile;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;

public class SerialVersionUID {
    public static void setSerialVersionUID(CtClass ctClass) throws CannotCompileException, NotFoundException {
        try {
            ctClass.getDeclaredField("serialVersionUID");
            return;
        }
        catch (NotFoundException notFoundException) {
            if (!SerialVersionUID.isSerializable(ctClass)) {
                return;
            }
            CtField ctField = new CtField(CtClass.longType, "serialVersionUID", ctClass);
            ctField.setModifiers(26);
            ctClass.addField(ctField, SerialVersionUID.calculateDefault(ctClass) + "L");
            return;
        }
    }

    private static boolean isSerializable(CtClass ctClass) throws NotFoundException {
        ClassPool classPool = ctClass.getClassPool();
        return ctClass.subtypeOf(classPool.get("java.io.Serializable"));
    }

    static long calculateDefault(CtClass ctClass) throws CannotCompileException {
        try {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ClassFile classFile = ctClass.getClassFile();
            String string = SerialVersionUID.javaName(ctClass);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(ctClass.getModifiers() & 0x611);
            Object[] objectArray = classFile.getInterfaces();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                objectArray[n2] = SerialVersionUID.javaName((String)objectArray[n2]);
            }
            Arrays.sort(objectArray);
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                dataOutputStream.writeUTF((String)objectArray[n2]);
            }
            CtField[] ctFieldArray = ctClass.getDeclaredFields();
            Arrays.sort(ctFieldArray, new SerialVersionUID$1());
            for (int i2 = 0; i2 < ctFieldArray.length; ++i2) {
                CtField ctField = ctFieldArray[i2];
                int n3 = ctField.getModifiers();
                if ((n3 & 2) != 0 && (n3 & 0x88) != 0) continue;
                dataOutputStream.writeUTF(ctField.getName());
                dataOutputStream.writeInt(n3);
                dataOutputStream.writeUTF(ctField.getFieldInfo2().getDescriptor());
            }
            if (classFile.getStaticInitializer() != null) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            CtConstructor[] ctConstructorArray = ctClass.getDeclaredConstructors();
            Arrays.sort(ctConstructorArray, new SerialVersionUID$2());
            for (int i3 = 0; i3 < ctConstructorArray.length; ++i3) {
                CtConstructor ctConstructor = ctConstructorArray[i3];
                int n4 = ctConstructor.getModifiers();
                if ((n4 & 2) != 0) continue;
                dataOutputStream.writeUTF("<init>");
                dataOutputStream.writeInt(n4);
                dataOutputStream.writeUTF(ctConstructor.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            CtMethod[] ctMethodArray = ctClass.getDeclaredMethods();
            Arrays.sort(ctMethodArray, new SerialVersionUID$3());
            for (int i4 = 0; i4 < ctMethodArray.length; ++i4) {
                CtMethod ctMethod = ctMethodArray[i4];
                int n5 = ctMethod.getModifiers();
                if ((n5 & 2) != 0) continue;
                dataOutputStream.writeUTF(ctMethod.getName());
                dataOutputStream.writeInt(n5);
                dataOutputStream.writeUTF(ctMethod.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            dataOutputStream.flush();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = messageDigest.digest(byteArrayOutputStream.toByteArray());
            long l2 = 0L;
            for (int i5 = Math.min(byArray.length, 8) - 1; i5 >= 0; --i5) {
                l2 = l2 << 8 | (long)(byArray[i5] & 0xFF);
            }
            return l2;
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CannotCompileException(noSuchAlgorithmException);
        }
    }

    private static String javaName(CtClass ctClass) {
        return Descriptor.toJavaName(Descriptor.toJvmName(ctClass));
    }

    private static String javaName(String string) {
        return Descriptor.toJavaName(Descriptor.toJvmName(string));
    }
}

