/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import java.io.DataOutputStream;
import java.io.IOException;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtClassType;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtNewConstructor;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFile;

class CtNewClass
extends CtClassType {
    protected boolean hasConstructor;

    CtNewClass(String string, ClassPool classPool, boolean bl2, CtClass ctClass) {
        super(string, classPool);
        this.wasChanged = true;
        String string2 = bl2 || ctClass == null ? null : ctClass.getName();
        this.classfile = new ClassFile(bl2, string, string2);
        if (bl2 && ctClass != null) {
            this.classfile.setInterfaces(new String[]{ctClass.getName()});
        }
        this.setModifiers(Modifier.setPublic(this.getModifiers()));
        this.hasConstructor = bl2;
    }

    protected void extendToString(StringBuffer stringBuffer) {
        if (this.hasConstructor) {
            stringBuffer.append("hasConstructor ");
        }
        super.extendToString(stringBuffer);
    }

    public void addConstructor(CtConstructor ctConstructor) throws CannotCompileException {
        this.hasConstructor = true;
        super.addConstructor(ctConstructor);
    }

    public void toBytecode(DataOutputStream dataOutputStream) throws CannotCompileException, IOException {
        if (!this.hasConstructor) {
            try {
                this.inheritAllConstructors();
                this.hasConstructor = true;
            }
            catch (NotFoundException notFoundException) {
                throw new CannotCompileException(notFoundException);
            }
        }
        super.toBytecode(dataOutputStream);
    }

    public void inheritAllConstructors() throws CannotCompileException, NotFoundException {
        CtClass ctClass = this.getSuperclass();
        CtConstructor[] ctConstructorArray = ctClass.getDeclaredConstructors();
        int n2 = 0;
        for (int i2 = 0; i2 < ctConstructorArray.length; ++i2) {
            CtConstructor ctConstructor = ctConstructorArray[i2];
            if (!Modifier.isPublic(ctConstructor.getModifiers())) continue;
            CtConstructor ctConstructor2 = CtNewConstructor.make(ctConstructor.getParameterTypes(), ctConstructor.getExceptionTypes(), this);
            this.addConstructor(ctConstructor2);
            ++n2;
        }
        if (n2 < 1) {
            throw new CannotCompileException("no public constructor in " + ctClass.getName());
        }
    }
}

