/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassMap;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CodeConverter;
import org.zeroturnaround.bundled.javassist.CtBehavior;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtField$Initializer;
import org.zeroturnaround.bundled.javassist.CtMember;
import org.zeroturnaround.bundled.javassist.CtMember$Cache;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.FieldInitLink;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.AccessFlag;
import org.zeroturnaround.bundled.javassist.bytecode.AnnotationsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFile;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstantAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.EnclosingMethodAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.FieldInfo;
import org.zeroturnaround.bundled.javassist.bytecode.InnerClassesAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ParameterAnnotationsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.Annotation;
import org.zeroturnaround.bundled.javassist.compiler.AccessorMaker;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.Javac;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;

class CtClassType
extends CtClass {
    ClassPool classPool;
    boolean wasChanged;
    private boolean wasFrozen;
    boolean wasPruned;
    boolean memberRemoved;
    ClassFile classfile;
    byte[] rawClassfile;
    private WeakReference memberCache;
    private AccessorMaker accessors;
    private FieldInitLink fieldInitializers;
    private Hashtable hiddenMethods;
    private int uniqueNumberSeed;
    private boolean doPruning = ClassPool.doPruning;
    private int getCount;
    private static final int GET_THRESHOLD = 2;

    CtClassType(String string, ClassPool classPool) {
        super(string);
        this.classPool = classPool;
        this.memberRemoved = false;
        this.wasPruned = false;
        this.wasFrozen = false;
        this.wasChanged = false;
        this.classfile = null;
        this.rawClassfile = null;
        this.memberCache = null;
        this.accessors = null;
        this.fieldInitializers = null;
        this.hiddenMethods = null;
        this.uniqueNumberSeed = 0;
        this.getCount = 0;
    }

    CtClassType(InputStream inputStream, ClassPool classPool) throws IOException {
        this((String)null, classPool);
        this.classfile = new ClassFile(new DataInputStream(inputStream));
        this.qualifiedName = this.classfile.getName();
    }

    protected void extendToString(StringBuffer stringBuffer) {
        Object object;
        if (this.wasChanged) {
            stringBuffer.append("changed ");
        }
        if (this.wasFrozen) {
            stringBuffer.append("frozen ");
        }
        if (this.wasPruned) {
            stringBuffer.append("pruned ");
        }
        stringBuffer.append(Modifier.toString(this.getModifiers()));
        stringBuffer.append(" class ");
        stringBuffer.append(this.getName());
        try {
            String string;
            object = this.getSuperclass();
            if (object != null && !(string = ((CtClass)object).getName()).equals("java.lang.Object")) {
                stringBuffer.append(" extends " + ((CtClass)object).getName());
            }
        }
        catch (NotFoundException notFoundException) {
            stringBuffer.append(" extends ??");
        }
        try {
            object = this.getInterfaces();
            if (((CtClass[])object).length > 0) {
                stringBuffer.append(" implements ");
            }
            for (int i2 = 0; i2 < ((CtClass[])object).length; ++i2) {
                stringBuffer.append(((CtClass)object[i2]).getName());
                stringBuffer.append(", ");
            }
        }
        catch (NotFoundException notFoundException) {
            stringBuffer.append(" extends ??");
        }
        object = this.getMembers();
        this.exToString(stringBuffer, " fields=", ((CtMember$Cache)object).fieldHead(), ((CtMember$Cache)object).lastField());
        this.exToString(stringBuffer, " constructors=", ((CtMember$Cache)object).consHead(), ((CtMember$Cache)object).lastCons());
        this.exToString(stringBuffer, " methods=", ((CtMember$Cache)object).methodHead(), ((CtMember$Cache)object).lastMethod());
    }

    private void exToString(StringBuffer stringBuffer, String string, CtMember ctMember, CtMember ctMember2) {
        stringBuffer.append(string);
        while (ctMember != ctMember2) {
            ctMember = ctMember.next();
            stringBuffer.append(ctMember);
            stringBuffer.append(", ");
        }
    }

    public AccessorMaker getAccessorMaker() {
        if (this.accessors == null) {
            this.accessors = new AccessorMaker(this);
        }
        return this.accessors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassFile getClassFile2() {
        ClassFile classFile;
        ClassFile classFile2 = this.classfile;
        if (classFile2 != null) {
            return classFile2;
        }
        this.classPool.compress();
        if (this.rawClassfile != null) {
            try {
                this.classfile = new ClassFile(new DataInputStream(new ByteArrayInputStream(this.rawClassfile)));
                this.rawClassfile = null;
                this.getCount = 2;
                return this.classfile;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString(), iOException);
            }
        }
        InputStream inputStream = null;
        try {
            try {
                inputStream = this.classPool.openClassfile(this.getName());
                if (inputStream == null) {
                    throw new NotFoundException(this.getName());
                }
                ClassFile classFile3 = new ClassFile(new DataInputStream(inputStream = new BufferedInputStream(inputStream)));
                if (!classFile3.getName().equals(this.qualifiedName)) {
                    throw new RuntimeException("cannot find " + this.qualifiedName + ": " + classFile3.getName() + " found in " + this.qualifiedName.replace('.', '/') + ".class");
                }
                this.classfile = classFile3;
                classFile = classFile3;
                Object var6_8 = null;
                if (inputStream == null) return classFile;
            }
            catch (NotFoundException notFoundException) {
                throw new RuntimeException(notFoundException.toString(), notFoundException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString(), iOException);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return classFile;
        }
        inputStream.close();
        return classFile;
    }

    final void incGetCounter() {
        ++this.getCount;
    }

    void compress() {
        if (this.getCount < 2) {
            if (!this.isModified() && ClassPool.releaseUnmodifiedClassFile) {
                this.removeClassFile();
            } else if (this.isFrozen() && !this.wasPruned) {
                this.saveClassFile();
            }
        }
        this.getCount = 0;
    }

    private synchronized void saveClassFile() {
        if (this.classfile == null || this.hasMemberCache() != null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.classfile.write(dataOutputStream);
            byteArrayOutputStream.close();
            this.rawClassfile = byteArrayOutputStream.toByteArray();
            this.classfile = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void removeClassFile() {
        if (this.classfile != null && !this.isModified() && this.hasMemberCache() == null) {
            this.classfile = null;
        }
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    void setClassPool(ClassPool classPool) {
        this.classPool = classPool;
    }

    public URL getURL() throws NotFoundException {
        URL uRL = this.classPool.find(this.getName());
        if (uRL == null) {
            throw new NotFoundException(this.getName());
        }
        return uRL;
    }

    public boolean isModified() {
        return this.wasChanged;
    }

    public boolean isFrozen() {
        return this.wasFrozen;
    }

    public void freeze() {
        this.wasFrozen = true;
    }

    void checkModify() throws RuntimeException {
        if (this.isFrozen()) {
            String string = this.getName() + " class is frozen";
            if (this.wasPruned) {
                string = string + " and pruned";
            }
            throw new RuntimeException(string);
        }
        this.wasChanged = true;
    }

    public void defrost() {
        this.checkPruned("defrost");
        this.wasFrozen = false;
    }

    public boolean subtypeOf(CtClass ctClass) throws NotFoundException {
        int n2;
        String string = ctClass.getName();
        if (this == ctClass || this.getName().equals(string)) {
            return true;
        }
        ClassFile classFile = this.getClassFile2();
        String string2 = classFile.getSuperclass();
        if (string2 != null && string2.equals(string)) {
            return true;
        }
        String[] stringArray = classFile.getInterfaces();
        int n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!stringArray[n2].equals(string)) continue;
            return true;
        }
        if (string2 != null && this.classPool.get(string2).subtypeOf(ctClass)) {
            return true;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.classPool.get(stringArray[n2]).subtypeOf(ctClass)) continue;
            return true;
        }
        return false;
    }

    public void setName(String string) throws RuntimeException {
        String string2 = this.getName();
        if (string.equals(string2)) {
            return;
        }
        this.classPool.checkNotFrozen(string);
        ClassFile classFile = this.getClassFile2();
        super.setName(string);
        classFile.setName(string);
        this.nameReplaced();
        this.classPool.classNameChanged(string2, this);
    }

    public void replaceClassName(ClassMap classMap) throws RuntimeException {
        String string = this.getName();
        String string2 = (String)classMap.get(Descriptor.toJvmName(string));
        if (string2 != null) {
            string2 = Descriptor.toJavaName(string2);
            this.classPool.checkNotFrozen(string2);
        }
        super.replaceClassName(classMap);
        ClassFile classFile = this.getClassFile2();
        classFile.renameClass(classMap);
        this.nameReplaced();
        if (string2 != null) {
            super.setName(string2);
            this.classPool.classNameChanged(string, this);
        }
    }

    public void replaceClassName(String string, String string2) throws RuntimeException {
        String string3 = this.getName();
        if (string3.equals(string)) {
            this.setName(string2);
        } else {
            super.replaceClassName(string, string2);
            this.getClassFile2().renameClass(string, string2);
            this.nameReplaced();
        }
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isAnnotation() {
        return Modifier.isAnnotation(this.getModifiers());
    }

    public boolean isEnum() {
        return Modifier.isEnum(this.getModifiers());
    }

    public int getModifiers() {
        ClassFile classFile = this.getClassFile2();
        int n2 = classFile.getAccessFlags();
        n2 = AccessFlag.clear(n2, 32);
        int n3 = classFile.getInnerAccessFlags();
        if (n3 != -1 && (n3 & 8) != 0) {
            n2 |= 8;
        }
        return AccessFlag.toModifier(n2);
    }

    public CtClass[] getNestedClasses() throws NotFoundException {
        ClassFile classFile = this.getClassFile2();
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)classFile.getAttribute("InnerClasses");
        if (innerClassesAttribute == null) {
            return new CtClass[0];
        }
        String string = classFile.getName();
        int n2 = innerClassesAttribute.tableLength();
        ArrayList<CtClass> arrayList = new ArrayList<CtClass>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2;
            String string3 = innerClassesAttribute.outerClass(i2);
            if (string3 != null && !string3.equals(string) || (string2 = innerClassesAttribute.innerClass(i2)) == null) continue;
            arrayList.add(this.classPool.get(string2));
        }
        return arrayList.toArray(new CtClass[arrayList.size()]);
    }

    public void setModifiers(int n2) {
        ClassFile classFile = this.getClassFile2();
        if (Modifier.isStatic(n2)) {
            int n3 = classFile.getInnerAccessFlags();
            if (n3 != -1 && (n3 & 8) != 0) {
                n2 &= 0xFFFFFFF7;
            } else {
                throw new RuntimeException("cannot change " + this.getName() + " into a static class");
            }
        }
        this.checkModify();
        classFile.setAccessFlags(AccessFlag.of(n2));
    }

    public Object[] getAnnotations() throws ClassNotFoundException {
        return this.getAnnotations(false);
    }

    public Object[] getAvailableAnnotations() {
        try {
            return this.getAnnotations(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unexpected exception ", classNotFoundException);
        }
    }

    private Object[] getAnnotations(boolean bl2) throws ClassNotFoundException {
        ClassFile classFile = this.getClassFile2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.toAnnotationType(bl2, this.getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    static Object[] toAnnotationType(boolean bl2, ClassPool classPool, AnnotationsAttribute annotationsAttribute, AnnotationsAttribute annotationsAttribute2) throws ClassNotFoundException {
        int n2;
        int n3;
        Annotation[] annotationArray;
        int n4;
        Annotation[] annotationArray2;
        if (annotationsAttribute == null) {
            annotationArray2 = null;
            n4 = 0;
        } else {
            annotationArray2 = annotationsAttribute.getAnnotations();
            n4 = annotationArray2.length;
        }
        if (annotationsAttribute2 == null) {
            annotationArray = null;
            n3 = 0;
        } else {
            annotationArray = annotationsAttribute2.getAnnotations();
            n3 = annotationArray.length;
        }
        if (!bl2) {
            int n5;
            Object[] objectArray = new Object[n4 + n3];
            for (n5 = 0; n5 < n4; ++n5) {
                objectArray[n5] = CtClassType.toAnnoType(annotationArray2[n5], classPool);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                objectArray[n5 + n4] = CtClassType.toAnnoType(annotationArray[n5], classPool);
            }
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; n2 < n4; ++n2) {
            try {
                arrayList.add(CtClassType.toAnnoType(annotationArray2[n2], classPool));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                arrayList.add(CtClassType.toAnnoType(annotationArray[n2], classPool));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return arrayList.toArray();
    }

    static Object[][] toAnnotationType(boolean bl2, ClassPool classPool, ParameterAnnotationsAttribute parameterAnnotationsAttribute, ParameterAnnotationsAttribute parameterAnnotationsAttribute2, MethodInfo methodInfo) throws ClassNotFoundException {
        int n2 = 0;
        n2 = parameterAnnotationsAttribute != null ? parameterAnnotationsAttribute.numParameters() : (parameterAnnotationsAttribute2 != null ? parameterAnnotationsAttribute2.numParameters() : Descriptor.numOfParameters(methodInfo.getDescriptor()));
        Object[][] objectArray = new Object[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4;
            Annotation[] annotationArray;
            int n5;
            Annotation[] annotationArray2;
            if (parameterAnnotationsAttribute == null) {
                annotationArray2 = null;
                n5 = 0;
            } else {
                annotationArray2 = parameterAnnotationsAttribute.getAnnotations()[i2];
                n5 = annotationArray2.length;
            }
            if (parameterAnnotationsAttribute2 == null) {
                annotationArray = null;
                n4 = 0;
            } else {
                annotationArray = parameterAnnotationsAttribute2.getAnnotations()[i2];
                n4 = annotationArray.length;
            }
            if (!bl2) {
                int n6;
                objectArray[i2] = new Object[n5 + n4];
                for (n6 = 0; n6 < n5; ++n6) {
                    objectArray[i2][n6] = CtClassType.toAnnoType(annotationArray2[n6], classPool);
                }
                for (n6 = 0; n6 < n4; ++n6) {
                    objectArray[i2][n6 + n5] = CtClassType.toAnnoType(annotationArray[n6], classPool);
                }
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (n3 = 0; n3 < n5; ++n3) {
                try {
                    arrayList.add(CtClassType.toAnnoType(annotationArray2[n3], classPool));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                try {
                    arrayList.add(CtClassType.toAnnoType(annotationArray[n3], classPool));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            objectArray[i2] = arrayList.toArray();
        }
        return objectArray;
    }

    private static Object toAnnoType(Annotation annotation, ClassPool classPool) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = classPool.getClassLoader();
            return annotation.toAnnotationType(classLoader, classPool);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader = classPool.getClass().getClassLoader();
            return annotation.toAnnotationType(classLoader, classPool);
        }
    }

    public boolean subclassOf(CtClass ctClass) {
        if (ctClass == null) {
            return false;
        }
        String string = ctClass.getName();
        try {
            for (CtClass ctClass2 = this; ctClass2 != null; ctClass2 = ((CtClass)ctClass2).getSuperclass()) {
                if (!ctClass2.getName().equals(string)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public CtClass getSuperclass() throws NotFoundException {
        String string = this.getClassFile2().getSuperclass();
        if (string == null) {
            return null;
        }
        return this.classPool.get(string);
    }

    public void setSuperclass(CtClass ctClass) throws CannotCompileException {
        this.checkModify();
        if (this.isInterface()) {
            this.addInterface(ctClass);
        } else {
            this.getClassFile2().setSuperclass(ctClass.getName());
        }
    }

    public CtClass[] getInterfaces() throws NotFoundException {
        String[] stringArray = this.getClassFile2().getInterfaces();
        int n2 = stringArray.length;
        CtClass[] ctClassArray = new CtClass[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ctClassArray[i2] = this.classPool.get(stringArray[i2]);
        }
        return ctClassArray;
    }

    public void setInterfaces(CtClass[] ctClassArray) {
        String[] stringArray;
        this.checkModify();
        if (ctClassArray == null) {
            stringArray = new String[]{};
        } else {
            int n2 = ctClassArray.length;
            stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = ctClassArray[i2].getName();
            }
        }
        this.getClassFile2().setInterfaces(stringArray);
    }

    public void addInterface(CtClass ctClass) {
        this.checkModify();
        if (ctClass != null) {
            this.getClassFile2().addInterface(ctClass.getName());
        }
    }

    public CtClass getDeclaringClass() throws NotFoundException {
        ClassFile classFile = this.getClassFile2();
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)classFile.getAttribute("InnerClasses");
        if (innerClassesAttribute == null) {
            return null;
        }
        String string = this.getName();
        int n2 = innerClassesAttribute.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equals(innerClassesAttribute.innerClass(i2))) continue;
            String string2 = innerClassesAttribute.outerClass(i2);
            if (string2 != null) {
                return this.classPool.get(string2);
            }
            EnclosingMethodAttribute enclosingMethodAttribute = (EnclosingMethodAttribute)classFile.getAttribute("EnclosingMethod");
            if (enclosingMethodAttribute == null) continue;
            return this.classPool.get(enclosingMethodAttribute.className());
        }
        return null;
    }

    public CtMethod getEnclosingMethod() throws NotFoundException {
        ClassFile classFile = this.getClassFile2();
        EnclosingMethodAttribute enclosingMethodAttribute = (EnclosingMethodAttribute)classFile.getAttribute("EnclosingMethod");
        if (enclosingMethodAttribute != null) {
            CtClass ctClass = this.classPool.get(enclosingMethodAttribute.className());
            return ctClass.getMethod(enclosingMethodAttribute.methodName(), enclosingMethodAttribute.methodDescriptor());
        }
        return null;
    }

    public CtClass makeNestedClass(String string, boolean bl2) {
        if (!bl2) {
            throw new RuntimeException("sorry, only nested static class is supported");
        }
        this.checkModify();
        CtClass ctClass = this.classPool.makeNestedClass(this.getName() + "$" + string);
        ClassFile classFile = this.getClassFile2();
        ClassFile classFile2 = ctClass.getClassFile2();
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)classFile.getAttribute("InnerClasses");
        if (innerClassesAttribute == null) {
            innerClassesAttribute = new InnerClassesAttribute(classFile.getConstPool());
            classFile.addAttribute(innerClassesAttribute);
        }
        innerClassesAttribute.append(ctClass.getName(), this.getName(), string, classFile2.getAccessFlags() & 0xFFFFFFDF | 8);
        classFile2.addAttribute(innerClassesAttribute.copy(classFile2.getConstPool(), null));
        return ctClass;
    }

    private void nameReplaced() {
        CtMember$Cache ctMember$Cache = this.hasMemberCache();
        if (ctMember$Cache != null) {
            CtMember ctMember = ctMember$Cache.lastMethod();
            for (CtMember ctMember2 = ctMember$Cache.methodHead(); ctMember2 != ctMember; ctMember2 = ctMember2.next()) {
                ctMember2.nameReplaced();
            }
        }
    }

    protected CtMember$Cache hasMemberCache() {
        if (this.memberCache != null) {
            return (CtMember$Cache)this.memberCache.get();
        }
        return null;
    }

    protected synchronized CtMember$Cache getMembers() {
        CtMember$Cache ctMember$Cache = null;
        if (this.memberCache == null || (ctMember$Cache = (CtMember$Cache)this.memberCache.get()) == null) {
            ctMember$Cache = new CtMember$Cache(this);
            this.makeFieldCache(ctMember$Cache);
            this.makeBehaviorCache(ctMember$Cache);
            this.memberCache = new WeakReference<CtMember$Cache>(ctMember$Cache);
        }
        return ctMember$Cache;
    }

    private void makeFieldCache(CtMember$Cache ctMember$Cache) {
        List list = this.getClassFile2().getFields();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FieldInfo fieldInfo = (FieldInfo)list.get(i2);
            CtField ctField = new CtField(fieldInfo, (CtClass)this);
            ctMember$Cache.addField(ctField);
        }
    }

    private void makeBehaviorCache(CtMember$Cache ctMember$Cache) {
        List list = this.getClassFile2().getMethods();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CtBehavior ctBehavior;
            MethodInfo methodInfo = (MethodInfo)list.get(i2);
            if (methodInfo.isMethod()) {
                ctBehavior = new CtMethod(methodInfo, this);
                ctMember$Cache.addMethod(ctBehavior);
                continue;
            }
            ctBehavior = new CtConstructor(methodInfo, (CtClass)this);
            ctMember$Cache.addConstructor(ctBehavior);
        }
    }

    public CtField[] getFields() {
        ArrayList arrayList = new ArrayList();
        CtClassType.getFields(arrayList, this);
        return arrayList.toArray(new CtField[arrayList.size()]);
    }

    private static void getFields(ArrayList arrayList, CtClass ctClass) {
        Object object;
        if (ctClass == null) {
            return;
        }
        try {
            CtClassType.getFields(arrayList, ctClass.getSuperclass());
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            object = ctClass.getInterfaces();
            int n2 = ((CtClass[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtClassType.getFields(arrayList, (CtClass)object[i2]);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        object = ((CtClassType)ctClass).getMembers();
        CtMember ctMember = ((CtMember$Cache)object).fieldHead();
        CtMember ctMember2 = ((CtMember$Cache)object).lastField();
        while (ctMember != ctMember2) {
            if (Modifier.isPrivate((ctMember = ctMember.next()).getModifiers())) continue;
            arrayList.add(ctMember);
        }
    }

    public CtField getField(String string) throws NotFoundException {
        CtField ctField = this.getField2(string);
        if (ctField == null) {
            throw new NotFoundException("field: " + string + " in " + this.getName());
        }
        return ctField;
    }

    CtField getField2(String string) {
        CtField ctField = this.getDeclaredField2(string);
        if (ctField != null) {
            return ctField;
        }
        try {
            CtClass[] ctClassArray = this.getInterfaces();
            int n2 = ctClassArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtField ctField2 = ctClassArray[i2].getField2(string);
                if (ctField2 == null) continue;
                return ctField2;
            }
            CtClass ctClass = this.getSuperclass();
            if (ctClass != null) {
                return ctClass.getField2(string);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    public CtField[] getDeclaredFields() {
        CtMember ctMember;
        CtMember$Cache ctMember$Cache = this.getMembers();
        CtMember ctMember2 = ctMember$Cache.lastField();
        int n2 = CtMember$Cache.count(ctMember, ctMember2);
        CtField[] ctFieldArray = new CtField[n2];
        int n3 = 0;
        for (ctMember = ctMember$Cache.fieldHead(); ctMember != ctMember2; ctMember = ctMember.next()) {
            ctFieldArray[n3++] = (CtField)ctMember;
        }
        return ctFieldArray;
    }

    public CtField getDeclaredField(String string) throws NotFoundException {
        CtField ctField = this.getDeclaredField2(string);
        if (ctField == null) {
            throw new NotFoundException("field: " + string + " in " + this.getName());
        }
        return ctField;
    }

    private CtField getDeclaredField2(String string) {
        CtMember$Cache ctMember$Cache = this.getMembers();
        CtMember ctMember = ctMember$Cache.fieldHead();
        CtMember ctMember2 = ctMember$Cache.lastField();
        while (ctMember != ctMember2) {
            if (!(ctMember = ctMember.next()).getName().equals(string)) continue;
            return (CtField)ctMember;
        }
        return null;
    }

    public CtBehavior[] getDeclaredBehaviors() {
        CtMember ctMember;
        CtMember$Cache ctMember$Cache = this.getMembers();
        CtMember ctMember2 = ctMember$Cache.lastCons();
        int n2 = CtMember$Cache.count(ctMember, ctMember2);
        CtMember ctMember3 = ctMember$Cache.methodHead();
        CtMember ctMember4 = ctMember$Cache.lastMethod();
        int n3 = CtMember$Cache.count(ctMember3, ctMember4);
        CtBehavior[] ctBehaviorArray = new CtBehavior[n2 + n3];
        int n4 = 0;
        for (ctMember = ctMember$Cache.consHead(); ctMember != ctMember2; ctMember = ctMember.next()) {
            ctBehaviorArray[n4++] = (CtBehavior)ctMember;
        }
        while (ctMember3 != ctMember4) {
            ctMember3 = ctMember3.next();
            ctBehaviorArray[n4++] = (CtBehavior)ctMember3;
        }
        return ctBehaviorArray;
    }

    public CtConstructor[] getConstructors() {
        CtMember$Cache ctMember$Cache = this.getMembers();
        CtMember ctMember = ctMember$Cache.consHead();
        CtMember ctMember2 = ctMember$Cache.lastCons();
        int n2 = 0;
        CtMember ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            if (!CtClassType.isPubCons((CtConstructor)(ctMember3 = ctMember3.next()))) continue;
            ++n2;
        }
        CtConstructor[] ctConstructorArray = new CtConstructor[n2];
        int n3 = 0;
        ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember3 = ctMember3.next());
            if (!CtClassType.isPubCons(ctConstructor)) continue;
            ctConstructorArray[n3++] = ctConstructor;
        }
        return ctConstructorArray;
    }

    private static boolean isPubCons(CtConstructor ctConstructor) {
        return !Modifier.isPrivate(ctConstructor.getModifiers()) && ctConstructor.isConstructor();
    }

    public CtConstructor getConstructor(String string) throws NotFoundException {
        CtMember$Cache ctMember$Cache = this.getMembers();
        CtMember ctMember = ctMember$Cache.consHead();
        CtMember ctMember2 = ctMember$Cache.lastCons();
        while (ctMember != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember = ctMember.next());
            if (!ctConstructor.getMethodInfo2().getDescriptor().equals(string) || !ctConstructor.isConstructor()) continue;
            return ctConstructor;
        }
        return super.getConstructor(string);
    }

    public CtConstructor[] getDeclaredConstructors() {
        Object object;
        CtMember$Cache ctMember$Cache = this.getMembers();
        CtMember ctMember = ctMember$Cache.consHead();
        CtMember ctMember2 = ctMember$Cache.lastCons();
        int n2 = 0;
        CtMember ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            object = (CtConstructor)(ctMember3 = ctMember3.next());
            if (!((CtConstructor)object).isConstructor()) continue;
            ++n2;
        }
        object = new CtConstructor[n2];
        int n3 = 0;
        ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember3 = ctMember3.next());
            if (!ctConstructor.isConstructor()) continue;
            object[n3++] = ctConstructor;
        }
        return object;
    }

    public CtConstructor getClassInitializer() {
        CtMember$Cache ctMember$Cache = this.getMembers();
        CtMember ctMember = ctMember$Cache.consHead();
        CtMember ctMember2 = ctMember$Cache.lastCons();
        while (ctMember != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember = ctMember.next());
            if (!ctConstructor.isClassInitializer()) continue;
            return ctConstructor;
        }
        return null;
    }

    public CtMethod[] getMethods() {
        HashMap hashMap = new HashMap();
        CtClassType.getMethods0(hashMap, this);
        return hashMap.values().toArray(new CtMethod[hashMap.size()]);
    }

    private static void getMethods0(HashMap hashMap, CtClass ctClass) {
        Object object;
        try {
            object = ctClass.getInterfaces();
            int n2 = ((CtClass[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtClassType.getMethods0(hashMap, (CtClass)object[i2]);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            object = ctClass.getSuperclass();
            if (object != null) {
                CtClassType.getMethods0(hashMap, (CtClass)object);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (ctClass instanceof CtClassType) {
            object = ((CtClassType)ctClass).getMembers();
            CtMember ctMember = ((CtMember$Cache)object).methodHead();
            CtMember ctMember2 = ((CtMember$Cache)object).lastMethod();
            while (ctMember != ctMember2) {
                if (Modifier.isPrivate((ctMember = ctMember.next()).getModifiers())) continue;
                hashMap.put(((CtMethod)ctMember).getStringRep(), ctMember);
            }
        }
    }

    public CtMethod getMethod(String string, String string2) throws NotFoundException {
        CtMethod ctMethod = CtClassType.getMethod0(this, string, string2);
        if (ctMethod != null) {
            return ctMethod;
        }
        throw new NotFoundException(string + "(..) is not found in " + this.getName());
    }

    private static CtMethod getMethod0(CtClass ctClass, String string, String string2) {
        CtMember ctMember;
        CtClass[] ctClassArray;
        if (ctClass instanceof CtClassType) {
            ctClassArray = ((CtClassType)ctClass).getMembers();
            ctMember = ctClassArray.methodHead();
            CtMember ctMember2 = ctClassArray.lastMethod();
            while (ctMember != ctMember2) {
                if (!(ctMember = ctMember.next()).getName().equals(string) || !((CtMethod)ctMember).getMethodInfo2().getDescriptor().equals(string2)) continue;
                return (CtMethod)ctMember;
            }
        }
        try {
            ctClassArray = ctClass.getSuperclass();
            if (ctClassArray != null && (ctMember = CtClassType.getMethod0((CtClass)ctClassArray, string, string2)) != null) {
                return ctMember;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctClassArray = ctClass.getInterfaces();
            int n2 = ctClassArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtMethod ctMethod = CtClassType.getMethod0(ctClassArray[i2], string, string2);
                if (ctMethod == null) continue;
                return ctMethod;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    public CtMethod[] getDeclaredMethods() {
        CtMember ctMember;
        CtMember$Cache ctMember$Cache = this.getMembers();
        CtMember ctMember2 = ctMember$Cache.lastMethod();
        int n2 = CtMember$Cache.count(ctMember, ctMember2);
        CtMethod[] ctMethodArray = new CtMethod[n2];
        int n3 = 0;
        for (ctMember = ctMember$Cache.methodHead(); ctMember != ctMember2; ctMember = ctMember.next()) {
            ctMethodArray[n3++] = (CtMethod)ctMember;
        }
        return ctMethodArray;
    }

    public CtMethod getDeclaredMethod(String string) throws NotFoundException {
        CtMember$Cache ctMember$Cache = this.getMembers();
        CtMember ctMember = ctMember$Cache.methodHead();
        CtMember ctMember2 = ctMember$Cache.lastMethod();
        while (ctMember != ctMember2) {
            if (!(ctMember = ctMember.next()).getName().equals(string)) continue;
            return (CtMethod)ctMember;
        }
        throw new NotFoundException(string + "(..) is not found in " + this.getName());
    }

    public CtMethod getDeclaredMethod(String string, CtClass[] ctClassArray) throws NotFoundException {
        String string2 = Descriptor.ofParameters(ctClassArray);
        CtMember$Cache ctMember$Cache = this.getMembers();
        CtMember ctMember = ctMember$Cache.methodHead();
        CtMember ctMember2 = ctMember$Cache.lastMethod();
        while (ctMember != ctMember2) {
            if (!(ctMember = ctMember.next()).getName().equals(string) || !((CtMethod)ctMember).getMethodInfo2().getDescriptor().startsWith(string2)) continue;
            return (CtMethod)ctMember;
        }
        throw new NotFoundException(string + "(..) is not found in " + this.getName());
    }

    public void addField(CtField ctField, String string) throws CannotCompileException {
        this.addField(ctField, CtField$Initializer.byExpr(string));
    }

    public void addField(CtField ctField, CtField$Initializer ctField$Initializer) throws CannotCompileException {
        Object object;
        this.checkModify();
        if (ctField.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        if (ctField$Initializer == null) {
            ctField$Initializer = ctField.getInit();
        }
        if (ctField$Initializer != null) {
            ctField$Initializer.check(ctField.getSignature());
            int n2 = ctField.getModifiers();
            if (Modifier.isStatic(n2) && Modifier.isFinal(n2)) {
                try {
                    object = this.getClassFile2().getConstPool();
                    int n3 = ctField$Initializer.getConstantValue((ConstPool)object, ctField.getType());
                    if (n3 != 0) {
                        ctField.getFieldInfo2().addAttribute(new ConstantAttribute((ConstPool)object, n3));
                        ctField$Initializer = null;
                    }
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
        this.getMembers().addField(ctField);
        this.getClassFile2().addField(ctField.getFieldInfo2());
        if (ctField$Initializer != null) {
            FieldInitLink fieldInitLink = new FieldInitLink(ctField, ctField$Initializer);
            object = this.fieldInitializers;
            if (object == null) {
                this.fieldInitializers = fieldInitLink;
            } else {
                while (((FieldInitLink)object).next != null) {
                    object = ((FieldInitLink)object).next;
                }
                ((FieldInitLink)object).next = fieldInitLink;
            }
        }
    }

    public void removeField(CtField ctField) throws NotFoundException {
        this.checkModify();
        FieldInfo fieldInfo = ctField.getFieldInfo2();
        ClassFile classFile = this.getClassFile2();
        if (!classFile.getFields().remove(fieldInfo)) {
            throw new NotFoundException(ctField.toString());
        }
        this.getMembers().remove(ctField);
        this.memberRemoved = true;
    }

    public CtConstructor makeClassInitializer() throws CannotCompileException {
        CtConstructor ctConstructor = this.getClassInitializer();
        if (ctConstructor != null) {
            return ctConstructor;
        }
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        Bytecode bytecode = new Bytecode(classFile.getConstPool(), 0, 0);
        this.modifyClassConstructor(classFile, bytecode, 0, 0);
        return this.getClassInitializer();
    }

    public void addConstructor(CtConstructor ctConstructor) throws CannotCompileException {
        this.checkModify();
        if (ctConstructor.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        this.getMembers().addConstructor(ctConstructor);
        this.getClassFile2().addMethod(ctConstructor.getMethodInfo2());
    }

    public void removeConstructor(CtConstructor ctConstructor) throws NotFoundException {
        this.checkModify();
        MethodInfo methodInfo = ctConstructor.getMethodInfo2();
        ClassFile classFile = this.getClassFile2();
        if (!classFile.getMethods().remove(methodInfo)) {
            throw new NotFoundException(ctConstructor.toString());
        }
        this.getMembers().remove(ctConstructor);
        this.memberRemoved = true;
    }

    public void addMethod(CtMethod ctMethod) throws CannotCompileException {
        this.checkModify();
        if (ctMethod.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        this.getMembers().addMethod(ctMethod);
        this.getClassFile2().addMethod(ctMethod.getMethodInfo2());
        if ((ctMethod.getModifiers() & 0x400) != 0) {
            this.setModifiers(this.getModifiers() | 0x400);
        }
    }

    public void removeMethod(CtMethod ctMethod) throws NotFoundException {
        this.checkModify();
        MethodInfo methodInfo = ctMethod.getMethodInfo2();
        ClassFile classFile = this.getClassFile2();
        if (!classFile.getMethods().remove(methodInfo)) {
            throw new NotFoundException(ctMethod.toString());
        }
        this.getMembers().remove(ctMethod);
        this.memberRemoved = true;
    }

    public byte[] getAttribute(String string) {
        AttributeInfo attributeInfo = this.getClassFile2().getAttribute(string);
        if (attributeInfo == null) {
            return null;
        }
        return attributeInfo.get();
    }

    public void setAttribute(String string, byte[] byArray) {
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        classFile.addAttribute(new AttributeInfo(classFile.getConstPool(), string, byArray));
    }

    public void instrument(CodeConverter codeConverter) throws CannotCompileException {
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        ConstPool constPool = classFile.getConstPool();
        List list = classFile.getMethods();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            MethodInfo methodInfo = (MethodInfo)list.get(i2);
            codeConverter.doit(this, methodInfo, constPool);
        }
    }

    public void instrument(ExprEditor exprEditor) throws CannotCompileException {
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        List list = classFile.getMethods();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            MethodInfo methodInfo = (MethodInfo)list.get(i2);
            exprEditor.doit(this, methodInfo);
        }
    }

    public void prune() {
        if (this.wasPruned) {
            return;
        }
        this.wasFrozen = true;
        this.wasPruned = true;
        this.getClassFile2().prune();
    }

    public void toBytecode(DataOutputStream dataOutputStream) throws CannotCompileException, IOException {
        try {
            if (this.isModified()) {
                this.checkPruned("toBytecode");
                ClassFile classFile = this.getClassFile2();
                if (this.memberRemoved) {
                    classFile.compact();
                    this.memberRemoved = false;
                }
                this.modifyClassConstructor(classFile);
                this.modifyConstructors(classFile);
                classFile.write(dataOutputStream);
                dataOutputStream.flush();
                this.fieldInitializers = null;
                if (this.doPruning) {
                    classFile.prune();
                    this.wasPruned = true;
                }
            } else {
                this.classPool.writeClassfile(this.getName(), dataOutputStream);
            }
            this.getCount = 0;
            this.wasFrozen = true;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
    }

    private void checkPruned(String string) {
        if (this.wasPruned) {
            throw new RuntimeException(string + "(): " + this.getName() + " was pruned.");
        }
    }

    public boolean stopPruning(boolean bl2) {
        boolean bl3 = !this.doPruning;
        this.doPruning = !bl2;
        return bl3;
    }

    private void modifyClassConstructor(ClassFile classFile) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        Bytecode bytecode = new Bytecode(classFile.getConstPool(), 0, 0);
        Javac javac = new Javac(bytecode, this);
        int n2 = 0;
        boolean bl2 = false;
        FieldInitLink fieldInitLink = this.fieldInitializers;
        while (fieldInitLink != null) {
            CtField ctField = fieldInitLink.field;
            if (Modifier.isStatic(ctField.getModifiers())) {
                bl2 = true;
                int n3 = fieldInitLink.init.compileIfStatic(ctField.getType(), ctField.getName(), bytecode, javac);
                if (n2 < n3) {
                    n2 = n3;
                }
            }
            fieldInitLink = fieldInitLink.next;
        }
        if (bl2) {
            this.modifyClassConstructor(classFile, bytecode, n2, 0);
        }
    }

    private void modifyClassConstructor(ClassFile classFile, Bytecode bytecode, int n2, int n3) throws CannotCompileException {
        Object object;
        MethodInfo methodInfo = classFile.getStaticInitializer();
        if (methodInfo == null) {
            bytecode.add(177);
            bytecode.setMaxStack(n2);
            bytecode.setMaxLocals(n3);
            methodInfo = new MethodInfo(classFile.getConstPool(), "<clinit>", "()V");
            methodInfo.setAccessFlags(8);
            methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
            classFile.addMethod(methodInfo);
            object = this.hasMemberCache();
            if (object != null) {
                ((CtMember$Cache)object).addConstructor(new CtConstructor(methodInfo, (CtClass)this));
            }
        } else {
            object = methodInfo.getCodeAttribute();
            if (object == null) {
                throw new CannotCompileException("empty <clinit>");
            }
            try {
                int n4;
                CodeIterator codeIterator = ((CodeAttribute)object).iterator();
                int n5 = codeIterator.insertEx(bytecode.get());
                codeIterator.insert(bytecode.getExceptionTable(), n5);
                int n6 = ((CodeAttribute)object).getMaxStack();
                if (n6 < n2) {
                    ((CodeAttribute)object).setMaxStack(n2);
                }
                if ((n4 = ((CodeAttribute)object).getMaxLocals()) < n3) {
                    ((CodeAttribute)object).setMaxLocals(n3);
                }
            }
            catch (BadBytecode badBytecode) {
                throw new CannotCompileException(badBytecode);
            }
        }
        try {
            methodInfo.rebuildStackMapIf6(this.classPool, classFile);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }

    private void modifyConstructors(ClassFile classFile) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        ConstPool constPool = classFile.getConstPool();
        List list = classFile.getMethods();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CodeAttribute codeAttribute;
            MethodInfo methodInfo = (MethodInfo)list.get(i2);
            if (!methodInfo.isConstructor() || (codeAttribute = methodInfo.getCodeAttribute()) == null) continue;
            try {
                Bytecode bytecode = new Bytecode(constPool, 0, codeAttribute.getMaxLocals());
                CtClass[] ctClassArray = Descriptor.getParameterTypes(methodInfo.getDescriptor(), this.classPool);
                int n3 = this.makeFieldInitializer(bytecode, ctClassArray);
                CtClassType.insertAuxInitializer(codeAttribute, bytecode, n3);
                methodInfo.rebuildStackMapIf6(this.classPool, classFile);
                continue;
            }
            catch (BadBytecode badBytecode) {
                throw new CannotCompileException(badBytecode);
            }
        }
    }

    private static void insertAuxInitializer(CodeAttribute codeAttribute, Bytecode bytecode, int n2) throws BadBytecode {
        CodeIterator codeIterator = codeAttribute.iterator();
        int n3 = codeIterator.skipSuperConstructor();
        if (n3 < 0 && (n3 = codeIterator.skipThisConstructor()) >= 0) {
            return;
        }
        int n4 = codeIterator.insertEx(bytecode.get());
        codeIterator.insert(bytecode.getExceptionTable(), n4);
        int n5 = codeAttribute.getMaxStack();
        if (n5 < n2) {
            codeAttribute.setMaxStack(n2);
        }
    }

    private int makeFieldInitializer(Bytecode bytecode, CtClass[] ctClassArray) throws CannotCompileException, NotFoundException {
        int n2 = 0;
        Javac javac = new Javac(bytecode, this);
        try {
            javac.recordParams(ctClassArray, false);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        FieldInitLink fieldInitLink = this.fieldInitializers;
        while (fieldInitLink != null) {
            int n3;
            CtField ctField = fieldInitLink.field;
            if (!Modifier.isStatic(ctField.getModifiers()) && n2 < (n3 = fieldInitLink.init.compile(ctField.getType(), ctField.getName(), bytecode, ctClassArray, javac))) {
                n2 = n3;
            }
            fieldInitLink = fieldInitLink.next;
        }
        return n2;
    }

    Hashtable getHiddenMethods() {
        if (this.hiddenMethods == null) {
            this.hiddenMethods = new Hashtable();
        }
        return this.hiddenMethods;
    }

    int getUniqueNumber() {
        return this.uniqueNumberSeed++;
    }

    public String makeUniqueName(String string) {
        String string2;
        HashMap hashMap = new HashMap();
        this.makeMemberList(hashMap);
        Set set = hashMap.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        if (CtClassType.notFindInArray(string, stringArray)) {
            return string;
        }
        int n2 = 100;
        do {
            if (n2 <= 999) continue;
            throw new RuntimeException("too many unique name");
        } while (!CtClassType.notFindInArray(string2 = string + n2++, stringArray));
        return string2;
    }

    private static boolean notFindInArray(String string, String[] stringArray) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!stringArray[i2].startsWith(string)) continue;
            return false;
        }
        return true;
    }

    private void makeMemberList(HashMap hashMap) {
        Object object;
        int n2;
        int n3;
        Object object2;
        int n4 = this.getModifiers();
        if (Modifier.isAbstract(n4) || Modifier.isInterface(n4)) {
            try {
                object2 = this.getInterfaces();
                n3 = ((CtClass[])object2).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = object2[n2];
                    if (object == null || !(object instanceof CtClassType)) continue;
                    ((CtClassType)object).makeMemberList(hashMap);
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        try {
            object2 = this.getSuperclass();
            if (object2 != null && object2 instanceof CtClassType) {
                ((CtClassType)object2).makeMemberList(hashMap);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        object2 = this.getClassFile2().getMethods();
        n3 = object2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (MethodInfo)object2.get(n2);
            hashMap.put(((MethodInfo)object).getName(), this);
        }
        object2 = this.getClassFile2().getFields();
        n3 = object2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (FieldInfo)object2.get(n2);
            hashMap.put(((FieldInfo)object).getName(), this);
        }
    }
}

