/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collection;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassMap;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CodeConverter;
import org.zeroturnaround.bundled.javassist.CtBehavior;
import org.zeroturnaround.bundled.javassist.CtClass$1;
import org.zeroturnaround.bundled.javassist.CtClass$DelayedFileOutputStream;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtField$Initializer;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtPrimitiveType;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFile;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.compiler.AccessorMaker;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;

public abstract class CtClass {
    protected String qualifiedName;
    public static final String version = "3.8.0.GA";
    static final String javaLangObject = "java.lang.Object";
    public static CtClass booleanType;
    public static CtClass charType;
    public static CtClass byteType;
    public static CtClass shortType;
    public static CtClass intType;
    public static CtClass longType;
    public static CtClass floatType;
    public static CtClass doubleType;
    public static CtClass voidType;
    static CtClass[] primitiveTypes;

    public static void main(String[] stringArray) {
        System.out.println("Javassist version 3.8.0.GA");
        System.out.println("Copyright (C) 1999-2008 Shigeru Chiba. All Rights Reserved.");
    }

    protected CtClass(String string) {
        this.qualifiedName = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("[");
        this.extendToString(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void extendToString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
    }

    public ClassPool getClassPool() {
        return null;
    }

    public ClassFile getClassFile() {
        this.checkModify();
        return this.getClassFile2();
    }

    public ClassFile getClassFile2() {
        return null;
    }

    public AccessorMaker getAccessorMaker() {
        return null;
    }

    public URL getURL() throws NotFoundException {
        throw new NotFoundException(this.getName());
    }

    public boolean isModified() {
        return false;
    }

    public boolean isFrozen() {
        return true;
    }

    public void freeze() {
    }

    void checkModify() throws RuntimeException {
        if (this.isFrozen()) {
            throw new RuntimeException(this.getName() + " class is frozen");
        }
    }

    public void defrost() {
        throw new RuntimeException("cannot defrost " + this.getName());
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public CtClass getComponentType() throws NotFoundException {
        return null;
    }

    public boolean subtypeOf(CtClass ctClass) throws NotFoundException {
        return this == ctClass || this.getName().equals(ctClass.getName());
    }

    public String getName() {
        return this.qualifiedName;
    }

    public final String getSimpleName() {
        String string = this.qualifiedName;
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    public final String getPackageName() {
        String string = this.qualifiedName;
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return null;
        }
        return string.substring(0, n2);
    }

    public void setName(String string) {
        this.checkModify();
        if (string != null) {
            this.qualifiedName = string;
        }
    }

    public void replaceClassName(String string, String string2) {
        this.checkModify();
    }

    public void replaceClassName(ClassMap classMap) {
        this.checkModify();
    }

    public Collection getRefClasses() {
        ClassFile classFile = this.getClassFile2();
        if (classFile != null) {
            CtClass$1 ctClass$1 = new CtClass$1(this);
            classFile.renameClass(ctClass$1);
            return ctClass$1.values();
        }
        return null;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public int getModifiers() {
        return 0;
    }

    public Object[] getAnnotations() throws ClassNotFoundException {
        return new Object[0];
    }

    public Object[] getAvailableAnnotations() {
        return new Object[0];
    }

    public CtClass[] getNestedClasses() throws NotFoundException {
        return new CtClass[0];
    }

    public void setModifiers(int n2) {
        this.checkModify();
    }

    public boolean subclassOf(CtClass ctClass) {
        return false;
    }

    public CtClass getSuperclass() throws NotFoundException {
        return null;
    }

    public void setSuperclass(CtClass ctClass) throws CannotCompileException {
        this.checkModify();
    }

    public CtClass[] getInterfaces() throws NotFoundException {
        return new CtClass[0];
    }

    public void setInterfaces(CtClass[] ctClassArray) {
        this.checkModify();
    }

    public void addInterface(CtClass ctClass) {
        this.checkModify();
    }

    public CtClass getDeclaringClass() throws NotFoundException {
        return null;
    }

    public CtMethod getEnclosingMethod() throws NotFoundException {
        return null;
    }

    public CtClass makeNestedClass(String string, boolean bl2) {
        throw new RuntimeException(this.getName() + " is not a class");
    }

    public CtField[] getFields() {
        return new CtField[0];
    }

    public CtField getField(String string) throws NotFoundException {
        throw new NotFoundException(string);
    }

    CtField getField2(String string) {
        return null;
    }

    public CtField[] getDeclaredFields() {
        return new CtField[0];
    }

    public CtField getDeclaredField(String string) throws NotFoundException {
        throw new NotFoundException(string);
    }

    public CtBehavior[] getDeclaredBehaviors() {
        return new CtBehavior[0];
    }

    public CtConstructor[] getConstructors() {
        return new CtConstructor[0];
    }

    public CtConstructor getConstructor(String string) throws NotFoundException {
        throw new NotFoundException("no such a constructor");
    }

    public CtConstructor[] getDeclaredConstructors() {
        return new CtConstructor[0];
    }

    public CtConstructor getDeclaredConstructor(CtClass[] ctClassArray) throws NotFoundException {
        String string = Descriptor.ofConstructor(ctClassArray);
        return this.getConstructor(string);
    }

    public CtConstructor getClassInitializer() {
        return null;
    }

    public CtMethod[] getMethods() {
        return new CtMethod[0];
    }

    public CtMethod getMethod(String string, String string2) throws NotFoundException {
        throw new NotFoundException(string);
    }

    public CtMethod[] getDeclaredMethods() {
        return new CtMethod[0];
    }

    public CtMethod getDeclaredMethod(String string, CtClass[] ctClassArray) throws NotFoundException {
        throw new NotFoundException(string);
    }

    public CtMethod getDeclaredMethod(String string) throws NotFoundException {
        throw new NotFoundException(string);
    }

    public CtConstructor makeClassInitializer() throws CannotCompileException {
        throw new CannotCompileException("not a class");
    }

    public void addConstructor(CtConstructor ctConstructor) throws CannotCompileException {
        this.checkModify();
    }

    public void removeConstructor(CtConstructor ctConstructor) throws NotFoundException {
        this.checkModify();
    }

    public void addMethod(CtMethod ctMethod) throws CannotCompileException {
        this.checkModify();
    }

    public void removeMethod(CtMethod ctMethod) throws NotFoundException {
        this.checkModify();
    }

    public void addField(CtField ctField) throws CannotCompileException {
        this.addField(ctField, (CtField$Initializer)null);
    }

    public void addField(CtField ctField, String string) throws CannotCompileException {
        this.checkModify();
    }

    public void addField(CtField ctField, CtField$Initializer ctField$Initializer) throws CannotCompileException {
        this.checkModify();
    }

    public void removeField(CtField ctField) throws NotFoundException {
        this.checkModify();
    }

    public byte[] getAttribute(String string) {
        return null;
    }

    public void setAttribute(String string, byte[] byArray) {
        this.checkModify();
    }

    public void instrument(CodeConverter codeConverter) throws CannotCompileException {
        this.checkModify();
    }

    public void instrument(ExprEditor exprEditor) throws CannotCompileException {
        this.checkModify();
    }

    public Class toClass() throws CannotCompileException {
        return this.getClassPool().toClass(this);
    }

    public Class toClass(ClassLoader classLoader, ProtectionDomain protectionDomain) throws CannotCompileException {
        ClassPool classPool = this.getClassPool();
        if (classLoader == null) {
            classLoader = classPool.getClassLoader();
        }
        return classPool.toClass(this, classLoader, protectionDomain);
    }

    public final Class toClass(ClassLoader classLoader) throws CannotCompileException {
        return this.getClassPool().toClass(this, classLoader);
    }

    public void detach() {
        ClassPool classPool = this.getClassPool();
        CtClass ctClass = classPool.removeCached(this.getName());
        if (ctClass != this) {
            classPool.cacheCtClass(this.getName(), ctClass, false);
        }
    }

    public boolean stopPruning(boolean bl2) {
        return true;
    }

    public void prune() {
    }

    void incGetCounter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytecode() throws IOException, CannotCompileException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.toBytecode(dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void writeFile() throws NotFoundException, IOException, CannotCompileException {
        this.writeFile(".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String string) throws CannotCompileException, IOException {
        Object object;
        String string2 = this.getName();
        String string3 = string + File.separatorChar + string2.replace('.', File.separatorChar) + ".class";
        int n2 = string3.lastIndexOf(File.separatorChar);
        if (n2 > 0 && !((String)(object = string3.substring(0, n2))).equals(".")) {
            new File((String)object).mkdirs();
        }
        object = new DataOutputStream(new BufferedOutputStream(new CtClass$DelayedFileOutputStream(string3)));
        try {
            this.toBytecode((DataOutputStream)object);
        }
        finally {
            ((FilterOutputStream)object).close();
        }
    }

    public void debugWriteFile() {
        this.debugWriteFile(".");
    }

    public void debugWriteFile(String string) {
        try {
            boolean bl2 = this.stopPruning(true);
            this.writeFile(string);
            this.defrost();
            this.stopPruning(bl2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void toBytecode(DataOutputStream dataOutputStream) throws CannotCompileException, IOException {
        throw new CannotCompileException("not a class");
    }

    public String makeUniqueName(String string) {
        throw new RuntimeException("not available in " + this.getName());
    }

    void compress() {
    }

    static {
        primitiveTypes = new CtClass[9];
        CtClass.primitiveTypes[0] = booleanType = new CtPrimitiveType("boolean", 'Z', "java.lang.Boolean", "booleanValue", "()Z", 172, 4, 1);
        CtClass.primitiveTypes[1] = charType = new CtPrimitiveType("char", 'C', "java.lang.Character", "charValue", "()C", 172, 5, 1);
        CtClass.primitiveTypes[2] = byteType = new CtPrimitiveType("byte", 'B', "java.lang.Byte", "byteValue", "()B", 172, 8, 1);
        CtClass.primitiveTypes[3] = shortType = new CtPrimitiveType("short", 'S', "java.lang.Short", "shortValue", "()S", 172, 9, 1);
        CtClass.primitiveTypes[4] = intType = new CtPrimitiveType("int", 'I', "java.lang.Integer", "intValue", "()I", 172, 10, 1);
        CtClass.primitiveTypes[5] = longType = new CtPrimitiveType("long", 'J', "java.lang.Long", "longValue", "()J", 173, 11, 2);
        CtClass.primitiveTypes[6] = floatType = new CtPrimitiveType("float", 'F', "java.lang.Float", "floatValue", "()F", 174, 6, 1);
        CtClass.primitiveTypes[7] = doubleType = new CtPrimitiveType("double", 'D', "java.lang.Double", "doubleValue", "()D", 175, 7, 2);
        CtClass.primitiveTypes[8] = voidType = new CtPrimitiveType("void", 'V', "java.lang.Void", null, null, 177, 0, 0);
    }
}

