/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;

final class CtArray
extends CtClass {
    protected ClassPool pool;

    CtArray(String string, ClassPool classPool) {
        super(string);
        this.pool = classPool;
    }

    public ClassPool getClassPool() {
        return this.pool;
    }

    public boolean isArray() {
        return true;
    }

    public boolean subtypeOf(CtClass ctClass) throws NotFoundException {
        if (super.subtypeOf(ctClass)) {
            return true;
        }
        String string = ctClass.getName();
        if (string.equals("java.lang.Object") || string.equals("java.lang.Cloneable") || string.equals("java.io.Serializable")) {
            return true;
        }
        return ctClass.isArray() && this.getComponentType().subtypeOf(ctClass.getComponentType());
    }

    public CtClass getComponentType() throws NotFoundException {
        String string = this.getName();
        return this.pool.get(string.substring(0, string.length() - 2));
    }

    public CtClass getSuperclass() throws NotFoundException {
        return this.pool.get("java.lang.Object");
    }

    public CtMethod[] getMethods() {
        try {
            return this.getSuperclass().getMethods();
        }
        catch (NotFoundException notFoundException) {
            return super.getMethods();
        }
    }

    public CtMethod getMethod(String string, String string2) throws NotFoundException {
        return this.getSuperclass().getMethod(string, string2);
    }

    public CtConstructor[] getConstructors() {
        try {
            return this.getSuperclass().getConstructors();
        }
        catch (NotFoundException notFoundException) {
            return super.getConstructors();
        }
    }
}

