/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.CodeConverter$ArrayAccessReplacementMethodNames;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.convert.TransformAccessArrayField;
import org.zeroturnaround.bundled.javassist.convert.TransformAfter;
import org.zeroturnaround.bundled.javassist.convert.TransformBefore;
import org.zeroturnaround.bundled.javassist.convert.TransformCall;
import org.zeroturnaround.bundled.javassist.convert.TransformFieldAccess;
import org.zeroturnaround.bundled.javassist.convert.TransformNew;
import org.zeroturnaround.bundled.javassist.convert.TransformReadField;
import org.zeroturnaround.bundled.javassist.convert.TransformWriteField;
import org.zeroturnaround.bundled.javassist.convert.Transformer;

public class CodeConverter {
    protected Transformer transformers = null;

    public void replaceNew(CtClass ctClass, CtClass ctClass2, String string) {
        this.transformers = new TransformNew(this.transformers, ctClass.getName(), ctClass2.getName(), string);
    }

    public void redirectFieldAccess(CtField ctField, CtClass ctClass, String string) {
        this.transformers = new TransformFieldAccess(this.transformers, ctField, ctClass.getName(), string);
    }

    public void replaceFieldRead(CtField ctField, CtClass ctClass, String string) {
        this.transformers = new TransformReadField(this.transformers, ctField, ctClass.getName(), string);
    }

    public void replaceFieldWrite(CtField ctField, CtClass ctClass, String string) {
        this.transformers = new TransformWriteField(this.transformers, ctField, ctClass.getName(), string);
    }

    public void replaceArrayAccess(CtClass ctClass, CodeConverter$ArrayAccessReplacementMethodNames codeConverter$ArrayAccessReplacementMethodNames) throws NotFoundException {
        this.transformers = new TransformAccessArrayField(this.transformers, ctClass.getName(), codeConverter$ArrayAccessReplacementMethodNames);
    }

    public void redirectMethodCall(CtMethod ctMethod, CtMethod ctMethod2) throws CannotCompileException {
        String string;
        String string2 = ctMethod.getMethodInfo2().getDescriptor();
        if (!string2.equals(string = ctMethod2.getMethodInfo2().getDescriptor())) {
            throw new CannotCompileException("signature mismatch: " + ctMethod2.getLongName());
        }
        int n2 = ctMethod.getModifiers();
        int n3 = ctMethod2.getModifiers();
        if (Modifier.isStatic(n2) != Modifier.isStatic(n3) || Modifier.isPrivate(n2) && !Modifier.isPrivate(n3) || ctMethod.getDeclaringClass().isInterface() != ctMethod2.getDeclaringClass().isInterface()) {
            throw new CannotCompileException("invoke-type mismatch " + ctMethod2.getLongName());
        }
        this.transformers = new TransformCall(this.transformers, ctMethod, ctMethod2);
    }

    public void redirectMethodCall(String string, CtMethod ctMethod) throws CannotCompileException {
        this.transformers = new TransformCall(this.transformers, string, ctMethod);
    }

    public void insertBeforeMethod(CtMethod ctMethod, CtMethod ctMethod2) throws CannotCompileException {
        try {
            this.transformers = new TransformBefore(this.transformers, ctMethod, ctMethod2);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
    }

    public void insertAfterMethod(CtMethod ctMethod, CtMethod ctMethod2) throws CannotCompileException {
        try {
            this.transformers = new TransformAfter(this.transformers, ctMethod, ctMethod2);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
    }

    protected void doit(CtClass ctClass, MethodInfo methodInfo, ConstPool constPool) throws CannotCompileException {
        int n2;
        Transformer transformer;
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null || this.transformers == null) {
            return;
        }
        for (transformer = this.transformers; transformer != null; transformer = transformer.getNext()) {
            transformer.initialize(constPool, ctClass, methodInfo);
        }
        CodeIterator codeIterator = codeAttribute.iterator();
        while (codeIterator.hasNext()) {
            try {
                n2 = codeIterator.next();
                for (transformer = this.transformers; transformer != null; transformer = transformer.getNext()) {
                    n2 = transformer.transform(ctClass, n2, codeIterator, constPool);
                }
            }
            catch (BadBytecode badBytecode) {
                throw new CannotCompileException(badBytecode);
            }
        }
        n2 = 0;
        for (transformer = this.transformers; transformer != null; transformer = transformer.getNext()) {
            int n3 = transformer.extraLocals();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        for (transformer = this.transformers; transformer != null; transformer = transformer.getNext()) {
            transformer.clean();
        }
        codeAttribute.setMaxLocals(codeAttribute.getMaxLocals() + n2);
    }
}

