/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.bundled.javassist.ClassPool$1;
import org.zeroturnaround.bundled.javassist.ClassPoolTail;
import org.zeroturnaround.bundled.javassist.CtArray;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtClassType;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewClass;
import org.zeroturnaround.bundled.javassist.CtNewNestedClass;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;

public class ClassPool {
    private static Method defineClass1;
    private static Method defineClass2;
    public boolean childFirstLookup = false;
    public static boolean doPruning;
    private int compressCount;
    private static final int COMPRESS_THRESHOLD = 100;
    public static boolean releaseUnmodifiedClassFile;
    protected ClassPoolTail source;
    protected ClassPool parent;
    protected Hashtable classes = new Hashtable(191);
    private Hashtable cflow = null;
    private static final int INIT_HASH_SIZE = 191;
    private ArrayList importedPackages;
    private static ClassPool defaultPool;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$security$ProtectionDomain;

    public ClassPool() {
        this(null);
    }

    public ClassPool(boolean bl2) {
        this(null);
        if (bl2) {
            this.appendSystemPath();
        }
    }

    public ClassPool(ClassPool classPool) {
        this.source = new ClassPoolTail();
        this.parent = classPool;
        if (classPool == null) {
            CtClass[] ctClassArray = CtClass.primitiveTypes;
            for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
                this.classes.put(ctClassArray[i2].getName(), ctClassArray[i2]);
            }
        }
        this.cflow = null;
        this.compressCount = 0;
        this.clearImportedPackages();
    }

    public static synchronized ClassPool getDefault() {
        if (defaultPool == null) {
            defaultPool = new ClassPool(null);
            defaultPool.appendSystemPath();
        }
        return defaultPool;
    }

    protected CtClass getCached(String string) {
        return (CtClass)this.classes.get(string);
    }

    protected void cacheCtClass(String string, CtClass ctClass, boolean bl2) {
        this.classes.put(string, ctClass);
    }

    protected CtClass removeCached(String string) {
        return (CtClass)this.classes.remove(string);
    }

    public String toString() {
        return this.source.toString();
    }

    void compress() {
        if (this.compressCount++ > 100) {
            this.compressCount = 0;
            Enumeration enumeration = this.classes.elements();
            while (enumeration.hasMoreElements()) {
                ((CtClass)enumeration.nextElement()).compress();
            }
        }
    }

    public void importPackage(String string) {
        this.importedPackages.add(string);
    }

    public void clearImportedPackages() {
        this.importedPackages = new ArrayList();
        this.importedPackages.add("java.lang");
    }

    public Iterator getImportedPackages() {
        return this.importedPackages.iterator();
    }

    public void recordInvalidClassName(String string) {
        this.source.recordInvalidClassName(string);
    }

    void recordCflow(String string, String string2, String string3) {
        if (this.cflow == null) {
            this.cflow = new Hashtable();
        }
        this.cflow.put(string, new Object[]{string2, string3});
    }

    public Object[] lookupCflow(String string) {
        if (this.cflow == null) {
            this.cflow = new Hashtable();
        }
        return (Object[])this.cflow.get(string);
    }

    public CtClass getAndRename(String string, String string2) throws NotFoundException {
        CtClass ctClass = this.get0(string, false);
        if (ctClass == null) {
            throw new NotFoundException(string);
        }
        if (ctClass instanceof CtClassType) {
            ((CtClassType)ctClass).setClassPool(this);
        }
        ctClass.setName(string2);
        return ctClass;
    }

    synchronized void classNameChanged(String string, CtClass ctClass) {
        CtClass ctClass2 = this.getCached(string);
        if (ctClass2 == ctClass) {
            this.removeCached(string);
        }
        String string2 = ctClass.getName();
        this.checkNotFrozen(string2);
        this.cacheCtClass(string2, ctClass, false);
    }

    public CtClass get(String string) throws NotFoundException {
        CtClass ctClass = string == null ? null : this.get0(string, true);
        if (ctClass == null) {
            throw new NotFoundException(string);
        }
        ctClass.incGetCounter();
        return ctClass;
    }

    protected synchronized CtClass get0(String string, boolean bl2) throws NotFoundException {
        CtClass ctClass = null;
        if (bl2 && (ctClass = this.getCached(string)) != null) {
            return ctClass;
        }
        if (!this.childFirstLookup && this.parent != null && (ctClass = this.parent.get0(string, bl2)) != null) {
            return ctClass;
        }
        ctClass = this.createCtClass(string, bl2);
        if (ctClass != null) {
            if (bl2) {
                this.cacheCtClass(string, ctClass, false);
            }
            return ctClass;
        }
        if (this.childFirstLookup && this.parent != null) {
            ctClass = this.parent.get0(string, bl2);
        }
        return ctClass;
    }

    protected CtClass createCtClass(String string, boolean bl2) {
        if (string.charAt(0) == '[') {
            string = Descriptor.toClassName(string);
        }
        if (string.endsWith("[]")) {
            String string2 = string.substring(0, string.indexOf(91));
            if (!(bl2 && this.getCached(string2) != null || this.find(string2) != null)) {
                return null;
            }
            return new CtArray(string, this);
        }
        if (this.find(string) == null) {
            return null;
        }
        return new CtClassType(string, this);
    }

    public URL find(String string) {
        return this.source.find(string);
    }

    void checkNotFrozen(String string) throws RuntimeException {
        CtClass ctClass = this.getCached(string);
        if (ctClass == null) {
            if (!this.childFirstLookup && this.parent != null) {
                try {
                    ctClass = this.parent.get0(string, true);
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                if (ctClass != null) {
                    throw new RuntimeException(string + " is in a parent ClassPool.  Use the parent.");
                }
            }
        } else if (ctClass.isFrozen()) {
            throw new RuntimeException(string + ": frozen class (cannot edit)");
        }
    }

    InputStream openClassfile(String string) throws NotFoundException {
        return this.source.openClassfile(string);
    }

    void writeClassfile(String string, OutputStream outputStream) throws NotFoundException, IOException, CannotCompileException {
        this.source.writeClassfile(string, outputStream);
    }

    public CtClass[] get(String[] stringArray) throws NotFoundException {
        if (stringArray == null) {
            return new CtClass[0];
        }
        int n2 = stringArray.length;
        CtClass[] ctClassArray = new CtClass[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ctClassArray[i2] = this.get(stringArray[i2]);
        }
        return ctClassArray;
    }

    public CtMethod getMethod(String string, String string2) throws NotFoundException {
        CtClass ctClass = this.get(string);
        return ctClass.getDeclaredMethod(string2);
    }

    public CtClass makeClass(InputStream inputStream) throws IOException, RuntimeException {
        return this.makeClass(inputStream, true);
    }

    public CtClass makeClass(InputStream inputStream, boolean bl2) throws IOException, RuntimeException {
        this.compress();
        inputStream = new BufferedInputStream(inputStream);
        CtClassType ctClassType = new CtClassType(inputStream, this);
        ((CtClass)ctClassType).checkModify();
        String string = ctClassType.getName();
        if (bl2) {
            this.checkNotFrozen(string);
        }
        this.cacheCtClass(string, ctClassType, true);
        return ctClassType;
    }

    public CtClass makeClass(String string) throws RuntimeException {
        return this.makeClass(string, null);
    }

    public synchronized CtClass makeClass(String string, CtClass ctClass) throws RuntimeException {
        this.checkNotFrozen(string);
        CtNewClass ctNewClass = new CtNewClass(string, this, false, ctClass);
        this.cacheCtClass(string, ctNewClass, true);
        return ctNewClass;
    }

    synchronized CtClass makeNestedClass(String string) {
        this.checkNotFrozen(string);
        CtNewNestedClass ctNewNestedClass = new CtNewNestedClass(string, this, false, null);
        this.cacheCtClass(string, ctNewNestedClass, true);
        return ctNewNestedClass;
    }

    public CtClass makeInterface(String string) throws RuntimeException {
        return this.makeInterface(string, null);
    }

    public synchronized CtClass makeInterface(String string, CtClass ctClass) throws RuntimeException {
        this.checkNotFrozen(string);
        CtNewClass ctNewClass = new CtNewClass(string, this, true, ctClass);
        this.cacheCtClass(string, ctNewClass, true);
        return ctNewClass;
    }

    public ClassPath appendSystemPath() {
        return this.source.appendSystemPath();
    }

    public ClassPath insertClassPath(ClassPath classPath) {
        return this.source.insertClassPath(classPath);
    }

    public ClassPath appendClassPath(ClassPath classPath) {
        return this.source.appendClassPath(classPath);
    }

    public ClassPath insertClassPath(String string) throws NotFoundException {
        return this.source.insertClassPath(string);
    }

    public ClassPath appendClassPath(String string) throws NotFoundException {
        return this.source.appendClassPath(string);
    }

    public void removeClassPath(ClassPath classPath) {
        this.source.removeClassPath(classPath);
    }

    public void appendPathList(String string) throws NotFoundException {
        char c2 = File.pathSeparatorChar;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = string.indexOf(c2, n2)) < 0) break;
            this.appendClassPath(string.substring(n2, n3));
            n2 = n3 + 1;
        }
        this.appendClassPath(string.substring(n2));
    }

    public Class toClass(CtClass ctClass) throws CannotCompileException {
        return this.toClass(ctClass, this.getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return ClassPool.getContextClassLoader();
    }

    static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Class toClass(CtClass ctClass, ClassLoader classLoader) throws CannotCompileException {
        return this.toClass(ctClass, classLoader, null);
    }

    public Class toClass(CtClass ctClass, ClassLoader classLoader, ProtectionDomain protectionDomain) throws CannotCompileException {
        try {
            Object[] objectArray;
            Method method;
            byte[] byArray = ctClass.toBytecode();
            if (protectionDomain == null) {
                method = defineClass1;
                objectArray = new Object[]{ctClass.getName(), byArray, new Integer(0), new Integer(byArray.length)};
            } else {
                method = defineClass2;
                objectArray = new Object[]{ctClass.getName(), byArray, new Integer(0), new Integer(byArray.length), protectionDomain};
            }
            return ClassPool.toClass2(method, classLoader, objectArray);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CannotCompileException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new CannotCompileException(exception);
        }
    }

    private static synchronized Class toClass2(Method method, ClassLoader classLoader, Object[] objectArray) throws Exception {
        method.setAccessible(true);
        Class clazz = (Class)method.invoke((Object)classLoader, objectArray);
        method.setAccessible(false);
        return clazz;
    }

    static /* synthetic */ Method access$002(Method method) {
        defineClass1 = method;
        return defineClass1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Method access$102(Method method) {
        defineClass2 = method;
        return defineClass2;
    }

    static {
        try {
            AccessController.doPrivileged(new ClassPool$1());
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException("cannot initialize ClassPool", privilegedActionException.getException());
        }
        doPruning = false;
        releaseUnmodifiedClassFile = true;
        defaultPool = null;
    }
}

