/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia.borders;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.plaf.metal.MetalLookAndFeel;

class MetouiaDotsBuffer {
    private static Frame frame;
    private static Component component;
    private transient Image image;
    private static final int IMAGE_SIZE = 125;
    private static Dimension imageSize;
    private Color background;
    private Color highlight;
    private Color shadow;
    private Color darkshadow;
    private Color matteshadow;

    public MetouiaDotsBuffer() {
        if (frame == null) {
            frame = new Frame("bufferCreator");
        }
        if (component == null) {
            component = new Canvas();
            frame.add(component, "Center");
        }
        frame.addNotify();
        this.image = component.createImage(125, 125);
        this.background = MetalLookAndFeel.getControl();
        this.matteshadow = MetalLookAndFeel.getPrimaryControl();
        this.shadow = MetalLookAndFeel.getControlShadow();
        this.darkshadow = MetalLookAndFeel.getControlDarkShadow();
        this.highlight = MetalLookAndFeel.getPrimaryControlHighlight();
        this.fillBumpBuffer();
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = component.createImage(125, 125);
            this.fillBumpBuffer();
        }
        return this.image;
    }

    public Dimension getImageSize() {
        return imageSize;
    }

    protected void fillBumpBuffer() {
        Graphics g = this.image.getGraphics();
        g.setColor(this.background);
        g.fillRect(0, 0, 125, 125);
        g.setColor(this.matteshadow);
        int x = 0;
        while (x < 125) {
            int y = 0;
            while (y < 125) {
                g.drawLine(x, y, x, y);
                y += 5;
            }
            x += 5;
        }
        g.setColor(this.shadow);
        int x2 = 1;
        while (x2 < 125) {
            int y = 0;
            while (y < 125) {
                g.drawLine(x2, y, x2, y);
                g.drawLine(x2 - 1, y + 1, x2 - 1, y + 1);
                y += 5;
            }
            x2 += 5;
        }
        g.setColor(this.darkshadow);
        int x3 = 1;
        while (x3 < 125) {
            int y = 1;
            while (y < 125) {
                g.drawLine(x3, y, x3, y);
                y += 5;
            }
            x3 += 5;
        }
        g.setColor(this.highlight);
        int x4 = 2;
        while (x4 < 125) {
            int y = 1;
            while (y < 125) {
                g.drawLine(x4, y, x4, y + 1);
                g.drawLine(x4 + 1, y + 1, x4 + 1, y + 1);
                y += 5;
            }
            x4 += 5;
        }
        g.dispose();
    }

    static {
        imageSize = new Dimension(125, 125);
    }
}

