/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.HyperlinkHandler;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class HTMLInfoPanel
extends IzPanel {
    private static final long serialVersionUID = 3257008769514025270L;
    protected String panelResourcePrefixStr;
    protected String panelResourceNameStr;
    private JEditorPane textArea;

    public HTMLInfoPanel(InstallerFrame installerFrame, InstallData installData) {
        this(installerFrame, installData, "HTMLInfoPanel", true);
    }

    public HTMLInfoPanel(InstallerFrame installerFrame, InstallData installData, String string, boolean bl) {
        super(installerFrame, installData, new IzPanelLayout());
        this.panelResourcePrefixStr = string;
        this.panelResourceNameStr = string + ".info";
        if (bl) {
            this.add((Component)LabelFactory.create(installerFrame.langpack.getString("InfoPanel.info"), installerFrame.icons.getImageIcon("edit"), 10), "nextLine");
        }
        try {
            this.textArea = new JEditorPane(){

                protected InputStream getStream(URL uRL) throws IOException {
                    int n;
                    InputStream inputStream = super.getStream(uRL);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[2048];
                    while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    String string = HTMLInfoPanel.this.parseText(byteArrayOutputStream.toString());
                    return new ByteArrayInputStream(string.getBytes());
                }
            };
            this.textArea.setContentType("text/html; charset=utf-8");
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(new HyperlinkHandler());
            JScrollPane jScrollPane = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadHTMLInfoContent());
            this.textArea.setCaretPosition(0);
            this.add((Component)jScrollPane, "nextLine");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getLayoutHelper().completeLayout();
    }

    private URL loadHTMLInfoContent() {
        if (this.getMetadata() != null && this.getMetadata().getPanelid() != null) {
            try {
                String string = this.panelResourcePrefixStr + '.' + this.getMetadata().getPanelid();
                String string2 = ResourceManager.getInstance().getTextResource(string);
                if (string2 != null) {
                    this.panelResourceNameStr = string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return ResourceManager.getInstance().getURL(this.panelResourceNameStr);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        try {
            this.textArea.setPage(this.loadHTMLInfoContent());
            this.textArea.setCaretPosition(0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

