/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class GUIInstaller
extends InstallerBase {
    private InstallData installdata;
    protected String lnf;
    private static final String[] LANGUAGE_DISPLAY_TYPES = new String[]{"iso3", "native", "default"};
    private static final String[][] LANG_CODES = new String[][]{{"cat", "ca"}, {"chn", "zh"}, {"cze", "cs"}, {"dan", "da"}, {"deu", "de"}, {"eng", "en"}, {"fin", "fi"}, {"fra", "fr"}, {"hun", "hu"}, {"ita", "it"}, {"jpn", "ja"}, {"mys", "ms"}, {"ned", "nl"}, {"nor", "no"}, {"pol", "pl"}, {"por", "pt"}, {"rom", "or"}, {"rus", "ru"}, {"spa", "es"}, {"svk", "sk"}, {"swe", "sv"}, {"tur", "tr"}, {"ukr", "uk"}};
    private static HashMap isoTable;

    public GUIInstaller() throws Exception {
        try {
            this.init();
        }
        catch (Exception exception) {
            this.showFatalError(exception);
            throw exception;
        }
        catch (Error error) {
            this.showFatalError(error);
            throw error;
        }
    }

    private void showFatalError(Throwable throwable) {
        try {
            JOptionPane.showMessageDialog(null, "Error: " + throwable.toString(), "Error", 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.installdata = new InstallData();
        this.loadInstallData(this.installdata);
        this.loadGUIInstallData();
        this.loadLookAndFeel();
        this.checkJavaVersion();
        this.checkJDKAvailable();
        this.checkLockFile();
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                try {
                    GUIInstaller.this.loadLangPack();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        ResourceManager.create(this.installdata);
        this.loadConditions(this.installdata);
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log("not all installerconditions are fulfilled.");
            System.exit(-1);
            return;
        }
        this.addCustomLangpack(this.installdata);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    GUIInstaller.this.loadGUI();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public void showMissingRequirementMessage(String string) {
        JOptionPane.showMessageDialog(null, string);
    }

    public void loadGUIInstallData() throws Exception {
        InputStream inputStream = GUIInstaller.class.getResourceAsStream("/GUIPrefs");
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.installdata.guiPrefs = (GUIPrefs)objectInputStream.readObject();
        objectInputStream.close();
    }

    private void checkLockFile() throws Exception {
        String string = System.getProperty("java.io.tmpdir");
        String string2 = this.installdata.info.getAppName();
        String string3 = "iz-" + string2 + ".tmp";
        Debug.trace("Making temp file: " + string3);
        Debug.trace("In temp directory: " + string);
        File file = new File(string, string3);
        if (file.exists()) {
            Debug.trace("Lock File Exists, asking user for permission to proceed.");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append("The " + string2 + " installer you are attempting to run seems to have a copy already running.<br><br>");
            stringBuffer.append("This could be from a previous failed installation attempt or you may have accidentally launched <br>");
            stringBuffer.append("the installer twice. <b>The recommended action is to select 'Exit'</b> and wait for the other copy of <br>");
            stringBuffer.append("the installer to start. If you are sure there is no other copy of the installer running, click <br>");
            stringBuffer.append("the 'Continue' button to allow this installer to run. <br><br>");
            stringBuffer.append("Are you sure you want to continue with this installation?");
            stringBuffer.append("</html>");
            JLabel jLabel = new JLabel(stringBuffer.toString());
            jLabel.setFont(new Font("Sans Serif", 0, 12));
            Object[] objectArray = new Object[]{"Continue", "Exit"};
            int n = JOptionPane.showOptionDialog(null, jLabel, "Warning", 0, 2, null, objectArray, objectArray[1]);
            Debug.trace("Selected option: " + n);
            if (n == 0) {
                Debug.trace("Setting temp file to delete on exit");
                file.deleteOnExit();
            } else {
                Debug.trace("Leaving temp file alone and exiting");
                System.exit(1);
            }
        } else {
            try {
                if (file.createNewFile()) {
                    Debug.trace("Temp file created");
                    file.deleteOnExit();
                } else {
                    Debug.trace("Temp file could not be created");
                    Debug.trace("*** Multiple instances of installer will be allowed ***");
                }
            }
            catch (Exception exception) {
                Debug.trace("Temp file could not be created: " + exception);
                Debug.trace("*** Multiple instances of installer will be allowed ***");
            }
        }
    }

    private void checkJavaVersion() throws Exception {
        String string;
        String string2 = System.getProperty("java.version");
        if (string2.compareTo(string = this.installdata.info.getJavaVersion()) < 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The application that you are trying to install requires a ");
            stringBuffer.append(string);
            stringBuffer.append(" version or later of the Java platform.\n");
            stringBuffer.append("You are running a ");
            stringBuffer.append(string2);
            stringBuffer.append(" version of the Java platform.\n");
            stringBuffer.append("Please upgrade to a newer version.");
            System.out.println(stringBuffer.toString());
            JOptionPane.showMessageDialog(null, stringBuffer.toString(), "Error", 0);
            System.exit(1);
        }
    }

    private void checkJDKAvailable() {
        String[] stringArray;
        int n;
        if (!this.installdata.info.isJdkRequired()) {
            return;
        }
        FileExecutor fileExecutor = new FileExecutor();
        String[] stringArray2 = new String[]{"javac", "-help"};
        String[] stringArray3 = new String[2];
        if (fileExecutor.executeCommand(stringArray2, stringArray3) != 0 && (n = JOptionPane.showConfirmDialog(null, stringArray = new String[]{"It looks like your system does not have a Java Development Kit (JDK) available.", "The software that you plan to install requires a JDK for both its installation and execution.", "\n", "Do you still want to proceed with the installation process?"}, "Warning", 0, 2)) == 1) {
            System.exit(1);
        }
    }

    private void loadLangPack() throws Exception {
        String string;
        Object object;
        List<String> list = this.getAvailableLangPacks();
        int n = list.size();
        if (n == 0) {
            throw new Exception("no language pack available");
        }
        JFrame jFrame = new JFrame();
        jFrame.setIconImage(new ImageIcon(this.getClass().getResource("/img/JFrameIcon.png")).getImage());
        Dimension dimension = jFrame.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2 - 10);
        if (n != 1) {
            object = new LanguageDialog(jFrame, list.toArray());
            ((LanguageDialog)object).setSelection(Locale.getDefault().getISO3Language().toLowerCase());
            ((Dialog)object).setModal(true);
            ((Window)object).toFront();
            jFrame.setVisible(false);
            ((Dialog)object).setVisible(true);
            string = (String)((LanguageDialog)object).getSelection();
            if (string == null) {
                throw new Exception("installation canceled");
            }
        } else {
            string = list.get(0);
        }
        this.installdata.xmlData.setAttribute("langpack", string);
        this.installdata.localeISO3 = string;
        this.installdata.setVariable("ISO3_LANG", this.installdata.localeISO3);
        object = this.getClass().getResourceAsStream("/langpacks/" + string + ".xml");
        this.installdata.langpack = new LocaleDatabase((InputStream)object);
    }

    protected void loadLookAndFeel() throws Exception {
        Map<String, String> map;
        String string = "unix";
        if (OsVersion.IS_WINDOWS) {
            string = "windows";
        } else if (OsVersion.IS_OSX) {
            string = "mac";
        }
        String string2 = null;
        if (this.installdata.guiPrefs.lookAndFeelMapping.containsKey(string)) {
            string2 = this.installdata.guiPrefs.lookAndFeelMapping.get(string);
        }
        boolean bl = true;
        if (this.installdata.guiPrefs.modifier.containsKey("useButtonIcons") && "no".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("useButtonIcons"))) {
            bl = false;
        }
        ButtonFactory.useButtonIcons(bl);
        boolean bl2 = true;
        if (this.installdata.guiPrefs.modifier.containsKey("useLabelIcons") && "no".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("useLabelIcons"))) {
            bl2 = false;
        }
        LabelFactory.setUseLabelIcons(bl2);
        if (this.installdata.guiPrefs.modifier.containsKey("labelFontSize")) {
            map = this.installdata.guiPrefs.modifier.get("labelFontSize");
            try {
                LabelFactory.setLabelFontSize(Float.parseFloat((String)((Object)map)));
            }
            catch (NumberFormatException numberFormatException) {
                Debug.log("Error parsing guiprefs 'labelFontSize' value (" + (String)((Object)map) + ')');
            }
        }
        if (string2 == null) {
            if (!"mac".equals(string)) {
                if ("unix".equals(string)) {
                    Locale.setDefault(Locale.ENGLISH);
                }
                map = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel((String)((Object)map));
                if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                    ButtonFactory.useButtonIcons(bl);
                }
            }
            this.lnf = "swing";
            return;
        }
        if ("kunststoff".equals(string2)) {
            ButtonFactory.useHighlightButtons();
            ButtonFactory.useButtonIcons(bl);
            this.installdata.buttonsHColor = new Color(255, 255, 255);
            map = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            Class<?> clazz = Class.forName("javax.swing.plaf.metal.MetalTheme");
            Class[] classArray = new Class[]{clazz};
            Class<?> clazz2 = Class.forName("com.izforge.izpack.gui.IzPackKMetalTheme");
            Method method = ((Class)((Object)map)).getMethod("setCurrentTheme", classArray);
            LookAndFeel lookAndFeel = (LookAndFeel)((Class)((Object)map)).newInstance();
            MetalTheme metalTheme = (MetalTheme)clazz2.newInstance();
            Object[] objectArray = new Object[]{metalTheme};
            UIManager.setLookAndFeel(lookAndFeel);
            method.invoke((Object)lookAndFeel, objectArray);
            this.lnf = "kunststoff";
            return;
        }
        if ("liquid".equals(string2)) {
            String string3;
            UIManager.setLookAndFeel("com.birosoft.liquid.LiquidLookAndFeel");
            this.lnf = "liquid";
            map = this.installdata.guiPrefs.lookAndFeelParams.get(string2);
            if (map.containsKey("decorate.frames") && "yes".equals(string3 = map.get("decorate.frames"))) {
                JFrame.setDefaultLookAndFeelDecorated(true);
            }
            if (map.containsKey("decorate.dialogs") && "yes".equals(string3 = map.get("decorate.dialogs"))) {
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            return;
        }
        if ("metouia".equals(string2)) {
            UIManager.setLookAndFeel("net.sourceforge.mlf.metouia.MetouiaLookAndFeel");
            this.lnf = "metouia";
            return;
        }
        if ("nimbus".equals(string2)) {
            UIManager.setLookAndFeel("org.jdesktop.swingx.plaf.nimbus.NimbusLookAndFeel");
            return;
        }
        if ("looks".equals(string2)) {
            String string4;
            map = new TreeMap<String, String>();
            map.put("windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
            map.put("plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            map.put("plastic3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            map.put("plasticXP", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            String string5 = map.get("plasticXP");
            Map<String, String> map2 = this.installdata.guiPrefs.lookAndFeelParams.get(string2);
            if (map2.containsKey("variant") && map.containsKey(string4 = map2.get("variant"))) {
                string5 = map.get(string4);
            }
            UIManager.setLookAndFeel(string5);
            return;
        }
        if ("substance".equals(string2)) {
            String string6;
            map = new TreeMap<String, String>();
            map.put("default", "org.jvnet.substance.SubstanceLookAndFeel");
            map.put("business", "org.jvnet.substance.skin.SubstanceBusinessLookAndFeel");
            map.put("business-blue", "org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel");
            map.put("business-black", "org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel");
            map.put("creme", "org.jvnet.substance.skin.SubstanceCremeLookAndFeel");
            map.put("sahara", "org.jvnet.substance.skin.SubstanceSaharaLookAndFeel");
            map.put("moderate", "org.jvnet.substance.skin.SubstanceModerateLookAndFeel");
            map.put("officesilver", "org.jvnet.substance.skin.SubstanceOfficeSilver2007LookAndFeel");
            String string7 = map.get("default");
            Map<String, String> map3 = this.installdata.guiPrefs.lookAndFeelParams.get(string2);
            if (map3.containsKey("variant") && map.containsKey(string6 = map3.get("variant"))) {
                string7 = map.get(string6);
            }
            UIManager.setLookAndFeel(string7);
        }
    }

    private void loadGUI() throws Exception {
        String string;
        UIManager.put("OptionPane.yesButtonText", this.installdata.langpack.getString("installer.yes"));
        UIManager.put("OptionPane.noButtonText", this.installdata.langpack.getString("installer.no"));
        UIManager.put("OptionPane.cancelButtonText", this.installdata.langpack.getString("installer.cancel"));
        String string2 = this.installdata.langpack.getString("installer.reversetitle");
        if (string2.indexOf("installer.reversetitle") > -1) {
            string = this.installdata.langpack.getString("installer.title") + this.installdata.info.getAppName();
        } else {
            VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.installdata.getVariables());
            string = variableSubstitutor.substitute(string2, null);
        }
        new InstallerFrame(string, this.installdata, this);
    }

    protected boolean useFlags() {
        return !this.installdata.guiPrefs.modifier.containsKey("useFlags") || !"no".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("useFlags"));
    }

    protected String getLangType() {
        if (this.installdata.guiPrefs.modifier.containsKey("langDisplayType")) {
            String string = this.installdata.guiPrefs.modifier.get("langDisplayType");
            string = string.toLowerCase();
            for (String string2 : LANGUAGE_DISPLAY_TYPES) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return string;
            }
            Debug.trace("Value for language display type not valid; value: " + string);
        }
        return LANGUAGE_DISPLAY_TYPES[0];
    }

    private static class FlagRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 3832899961942782769L;
        private TreeMap<String, ImageIcon> icons = new TreeMap();
        private TreeMap<String, ImageIcon> grayIcons = new TreeMap();

        public FlagRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = (String)object;
            this.setText(string);
            if (isoTable != null) {
                string = (String)isoTable.get(string);
            }
            if (bl) {
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            }
            if (!this.icons.containsKey(string)) {
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/res/flag." + string));
                this.icons.put(string, imageIcon);
                imageIcon = new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage()));
                this.grayIcons.put(string, imageIcon);
            }
            if (bl || n == -1) {
                this.setIcon(this.icons.get(string));
            } else {
                this.setIcon(this.grayIcons.get(string));
            }
            return this;
        }
    }

    private final class LanguageDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 3256443616359887667L;
        private JComboBox comboBox;
        private HashMap<String, String> iso3Toiso2;
        private boolean isoMapExpanded;

        public LanguageDialog(JFrame jFrame, Object[] objectArray) {
            super(jFrame);
            this.iso3Toiso2 = null;
            this.isoMapExpanded = false;
            try {
                GUIInstaller.this.loadLookAndFeel();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.addWindowListener(new WindowHandler());
            JPanel jPanel = (JPanel)this.getContentPane();
            this.setTitle("Language Selection");
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 6;
            ImageIcon imageIcon = this.getImage();
            JLabel jLabel = new JLabel(imageIcon);
            gridBagConstraints.gridy = 0;
            jPanel.add(jLabel);
            String string = "Please select your language";
            if (GUIInstaller.this.getLangType().equals(LANGUAGE_DISPLAY_TYPES[0])) {
                string = "Please select your language below";
            }
            JLabel jLabel2 = new JLabel(string, 10);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(15, 5, 5, 5);
            gridBagLayout.addLayoutComponent(jLabel2, gridBagConstraints);
            jPanel.add(jLabel2);
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            objectArray = this.reviseItems(objectArray);
            this.comboBox = new JComboBox<Object>(objectArray);
            if (GUIInstaller.this.useFlags()) {
                this.comboBox.setRenderer(new FlagRenderer());
            }
            gridBagConstraints.gridy = 3;
            gridBagLayout.addLayoutComponent(this.comboBox, gridBagConstraints);
            jPanel.add(this.comboBox);
            gridBagConstraints.insets = new Insets(15, 5, 15, 5);
            JButton jButton = new JButton("OK");
            jButton.addActionListener(this);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = 10;
            gridBagLayout.addLayoutComponent(jButton, gridBagConstraints);
            jPanel.add(jButton);
            this.getRootPane().setDefaultButton(jButton);
            if (System.getProperty("mrj.version") == null) {
                this.pack();
            }
            this.setSize(this.getPreferredSize());
            Dimension dimension = this.getSize();
            Point point = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            this.setLocation(point.x - dimension.width / 2, point.y - dimension.height / 2 - 10);
            this.setResizable(true);
        }

        private Object[] reviseItems(Object[] objectArray) {
            String string = GUIInstaller.this.getLangType();
            if (string.equals(LANGUAGE_DISPLAY_TYPES[0])) {
                return objectArray;
            }
            if (string.equals(LANGUAGE_DISPLAY_TYPES[1])) {
                return this.expandItems(objectArray, new JComboBox().getFont());
            }
            if (string.equals(LANGUAGE_DISPLAY_TYPES[2])) {
                return this.expandItems(objectArray, null);
            }
            return objectArray;
        }

        private Object[] expandItems(Object[] objectArray, Font font) {
            int n;
            if (this.iso3Toiso2 == null) {
                this.iso3Toiso2 = new HashMap(32);
                isoTable = new HashMap();
                for (n = 0; n < LANG_CODES.length; ++n) {
                    this.iso3Toiso2.put(LANG_CODES[n][0], LANG_CODES[n][1]);
                }
            }
            for (n = 0; n < objectArray.length; ++n) {
                Object object = this.expandItem(objectArray[n], font);
                isoTable.put(object, objectArray[n]);
                objectArray[n] = object;
            }
            return objectArray;
        }

        private Object expandItem(Object object, Font font) {
            Object object2;
            String string = this.iso3Toiso2.get(object);
            if (string == null && !this.isoMapExpanded) {
                this.isoMapExpanded = true;
                object2 = Locale.getAvailableLocales();
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    this.iso3Toiso2.put(((Locale)object2[i]).getISO3Language(), ((Locale)object2[i]).getLanguage());
                }
                string = this.iso3Toiso2.get(object);
            }
            if (string == null) {
                return object;
            }
            object2 = new Locale(string);
            if (font == null) {
                return ((Locale)object2).getDisplayLanguage();
            }
            String string2 = ((Locale)object2).getDisplayLanguage((Locale)object2);
            int n = font.canDisplayUpTo(string2);
            if (n > -1) {
                string2 = ((Locale)object2).getDisplayLanguage();
            }
            return string2;
        }

        public ImageIcon getImage() {
            ImageIcon imageIcon;
            try {
                imageIcon = new ImageIcon(LanguageDialog.class.getResource("/res/installer.langsel.img"));
            }
            catch (NullPointerException nullPointerException) {
                imageIcon = null;
            }
            return imageIcon;
        }

        public Object getSelection() {
            Object object = null;
            if (isoTable != null) {
                object = isoTable.get(this.comboBox.getSelectedItem());
            }
            return object != null ? object : this.comboBox.getSelectedItem();
        }

        public void setSelection(Object object) {
            Object object2 = null;
            if (isoTable != null) {
                for (Object k : isoTable.keySet()) {
                    if (!isoTable.get(k).equals(object)) continue;
                    object2 = k;
                    break;
                }
            }
            if (object2 == null) {
                object2 = object;
            }
            this.comboBox.setSelectedItem(object2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dispose();
        }

        private class WindowHandler
        extends WindowAdapter {
            private WindowHandler() {
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        }
    }
}

