/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.gui.SelectionChangeEvent;
import org.lobobrowser.html.gui.SelectionChangeListener;
import org.lobobrowser.html.test.NodeTreeModel;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.lobobrowser.html.test.SimpleUserAgentContext;

public class TestFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(TestFrame.class.getName());
    private final SimpleHtmlRendererContext rcontext;
    private final JTree tree;
    private final HtmlPanel htmlPanel;
    private final JTextArea textArea;
    private final JTextField addressField;

    public TestFrame() throws HeadlessException {
        this("");
    }

    public TestFrame(String string) throws HeadlessException {
        super(string);
        JTextArea jTextArea;
        JTextField jTextField;
        this.setDefaultCloseOperation(3);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.addressField = jTextField = new JTextField();
        JButton jButton = new JButton("Parse & Render");
        final JTabbedPane jTabbedPane = new JTabbedPane();
        final JTree jTree = new JTree();
        final JScrollPane jScrollPane = new JScrollPane(jTree);
        this.tree = jTree;
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "Center");
        jPanel.add((Component)new JLabel("URL: "), "West");
        jPanel.add((Component)jTextField, "Center");
        jPanel.add((Component)jButton, "East");
        jPanel2.add((Component)jTabbedPane, "Center");
        final HtmlPanel htmlPanel = new HtmlPanel();
        htmlPanel.addSelectionChangeListener(new SelectionChangeListener(){

            public void selectionChanged(SelectionChangeEvent selectionChangeEvent) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("selectionChanged(): selection node: " + htmlPanel.getSelectionNode());
                }
            }
        });
        this.htmlPanel = htmlPanel;
        SimpleUserAgentContext simpleUserAgentContext = new SimpleUserAgentContext();
        this.rcontext = new LocalHtmlRendererContext(htmlPanel, simpleUserAgentContext);
        this.textArea = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        final JScrollPane jScrollPane2 = new JScrollPane(jTextArea);
        jTabbedPane.addTab("HTML", htmlPanel);
        jTabbedPane.addTab("Tree", jScrollPane);
        jTabbedPane.addTab("Source", jScrollPane2);
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = jTabbedPane.getSelectedComponent();
                if (component == jScrollPane) {
                    jTree.setModel(new NodeTreeModel(htmlPanel.getRootNode()));
                } else if (component == jScrollPane2) {
                    jTextArea.setText(TestFrame.this.rcontext.getSourceCode());
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestFrame.this.process(jTextField.getText());
            }
        });
    }

    public HtmlRendererContext getHtmlRendererContext() {
        return this.rcontext;
    }

    public void navigate(String string) {
        this.addressField.setText(string);
        this.process(string);
    }

    private void process(String string) {
        try {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                int n = string.indexOf(58);
                if (n == -1 || n == 1) {
                    uRL = new URL("file:" + string);
                }
                throw malformedURLException;
            }
            this.rcontext.navigate(uRL, null);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Error trying to load URI=[" + string + "].", exception);
        }
    }

    private class LocalHtmlRendererContext
    extends SimpleHtmlRendererContext {
        public LocalHtmlRendererContext(HtmlPanel htmlPanel, UserAgentContext userAgentContext) {
            super(htmlPanel, userAgentContext);
        }

        public HtmlRendererContext open(URL uRL, String string, String string2, boolean bl) {
            TestFrame testFrame = new TestFrame("Cobra Test Tool");
            testFrame.setSize(600, 400);
            testFrame.setExtendedState(0);
            testFrame.setVisible(true);
            HtmlRendererContext htmlRendererContext = testFrame.getHtmlRendererContext();
            htmlRendererContext.setOpener(this);
            testFrame.navigate(uRL.toExternalForm());
            return htmlRendererContext;
        }
    }
}

