/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.FrameNode;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.test.SimpleBrowserFrame;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.io.BufferExceededException;
import org.lobobrowser.util.io.RecordedInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLLinkElement;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleHtmlRendererContext
implements HtmlRendererContext {
    private static final Logger logger = Logger.getLogger(SimpleHtmlRendererContext.class.getName());
    private final HtmlPanel htmlPanel;
    private final HtmlRendererContext parentRcontext;
    private volatile String sourceCode;
    protected URLConnection currentConnection;
    private volatile HtmlRendererContext opener;
    private UserAgentContext bcontext = null;

    public SimpleHtmlRendererContext(HtmlPanel htmlPanel) {
        this(htmlPanel, (UserAgentContext)null);
    }

    public SimpleHtmlRendererContext(HtmlPanel htmlPanel, UserAgentContext userAgentContext) {
        this.htmlPanel = htmlPanel;
        this.parentRcontext = null;
        this.bcontext = userAgentContext;
    }

    public SimpleHtmlRendererContext(HtmlPanel htmlPanel, HtmlRendererContext htmlRendererContext) {
        this.htmlPanel = htmlPanel;
        this.parentRcontext = htmlRendererContext;
        this.bcontext = htmlRendererContext == null ? null : htmlRendererContext.getUserAgentContext();
    }

    public HtmlPanel getHtmlPanel() {
        return this.htmlPanel;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public HTMLCollection getFrames() {
        NodeImpl nodeImpl = this.htmlPanel.getRootNode();
        if (nodeImpl instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)nodeImpl).getFrames();
        }
        return null;
    }

    public void reload() {
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.htmlPanel.getRootNode();
        if (hTMLDocumentImpl != null) {
            try {
                URL uRL = new URL(hTMLDocumentImpl.getDocumentURI());
                this.navigate(uRL, null);
            }
            catch (MalformedURLException malformedURLException) {
                this.warn("reload(): Malformed URL", malformedURLException);
            }
        }
    }

    public void linkClicked(HTMLElement hTMLElement, URL uRL, String string) {
        this.navigate(uRL, string);
    }

    protected Proxy getProxy() {
        UserAgentContext userAgentContext = this.getUserAgentContext();
        if (userAgentContext instanceof SimpleUserAgentContext) {
            return ((SimpleUserAgentContext)userAgentContext).getProxy();
        }
        return Proxy.NO_PROXY;
    }

    public void navigate(URL uRL, String string) {
        this.submitForm("GET", uRL, string, null, null);
    }

    public void navigate(String string) throws MalformedURLException {
        URL uRL = Urls.createURL(null, string);
        this.navigate(uRL, "_this");
    }

    public void submitForm(final String string, final URL uRL, final String string2, final String string3, final FormInput[] formInputArray) {
        if (string2 != null) {
            Object object;
            Object object2;
            HtmlRendererContext htmlRendererContext = this.getTop();
            HTMLCollection hTMLCollection = htmlRendererContext.getFrames();
            if (hTMLCollection != null) {
                object2 = hTMLCollection.namedItem(string2);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("submitForm(): Frame matching target=" + string2 + " is " + object2);
                }
                if (object2 instanceof FrameNode) {
                    object = ((FrameNode)object2).getBrowserFrame();
                    if (object == null) {
                        throw new IllegalStateException("Frame node without a BrowserFrame instance: " + object2);
                    }
                    if (object.getHtmlRendererContext() != this) {
                        object.loadURL(uRL);
                        return;
                    }
                }
            }
            if ("_top".equals(object2 = string2.trim().toLowerCase())) {
                this.getTop().navigate(uRL, null);
                return;
            }
            if ("_parent".equals(object2)) {
                object = this.getParent();
                if (object != null) {
                    object.navigate(uRL, null);
                    return;
                }
            } else {
                if ("_blank".equals(object2)) {
                    this.open(uRL, "cobra.blank", "", false);
                    return;
                }
                if (!"_this".equals(object2)) {
                    logger.warning("submitForm(): Link target unrecognized: " + (String)object2);
                }
            }
        }
        if (this.isNavigationAsynchronous()) {
            new Thread(){

                public void run() {
                    try {
                        SimpleHtmlRendererContext.this.submitFormSync(string, uRL, string2, string3, formInputArray);
                    }
                    catch (Exception exception) {
                        SimpleHtmlRendererContext.this.error("navigate(): Error loading or parsing request.", exception);
                    }
                }
            }.start();
        } else {
            try {
                this.submitFormSync(string, uRL, string2, string3, formInputArray);
            }
            catch (Exception exception) {
                this.error("navigate(): Error loading or parsing request.", exception);
            }
        }
    }

    protected boolean isNavigationAsynchronous() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitFormSync(String string, URL uRL, String string2, String string3, FormInput[] formInputArray) throws IOException, SAXException {
        URL uRL2;
        URL uRL3;
        Object object;
        Object object2;
        Object object3;
        CharSequence charSequence;
        Object object4;
        String string4 = string.toUpperCase();
        if ("GET".equals(string4) && formInputArray != null) {
            boolean bl = true;
            object4 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile());
            charSequence = new StringBuffer(((URL)object4).toExternalForm());
            if (uRL.getQuery() == null) {
                ((StringBuffer)charSequence).append("?");
            } else {
                ((StringBuffer)charSequence).append("&");
            }
            for (int i = 0; i < formInputArray.length; ++i) {
                FormInput formInput = formInputArray[i];
                object3 = formInput.getName();
                object2 = URLEncoder.encode((String)object3, "UTF-8");
                if (formInput.isText()) {
                    if (bl) {
                        bl = false;
                    } else {
                        ((StringBuffer)charSequence).append("&");
                    }
                    String string5 = formInput.getTextValue();
                    object = URLEncoder.encode(string5, "UTF-8");
                    ((StringBuffer)charSequence).append((String)object2);
                    ((StringBuffer)charSequence).append("=");
                    ((StringBuffer)charSequence).append((String)object);
                    continue;
                }
                logger.warning("postData(): Ignoring non-textual parameter " + (String)object3 + " for GET.");
            }
            uRL3 = new URL(((StringBuffer)charSequence).toString());
        } else {
            uRL3 = uRL;
        }
        if (uRL3.getProtocol().equalsIgnoreCase("file")) {
            try {
                object4 = uRL.getRef();
                charSequence = object4 == null || ((String)object4).length() == 0 ? "" : "#" + (String)object4;
                uRL2 = new URL(uRL3.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getPath() + (String)charSequence);
            }
            catch (MalformedURLException malformedURLException) {
                this.warn("malformed", malformedURLException);
                uRL2 = uRL;
            }
        } else {
            uRL2 = uRL3;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("process(): Loading URI=[" + uRL2 + "].");
        }
        long l = System.currentTimeMillis();
        Proxy proxy = this.getProxy();
        boolean bl = "POST".equals(string4);
        object3 = proxy == null || proxy == Proxy.NO_PROXY ? uRL2.openConnection() : uRL2.openConnection(proxy);
        this.currentConnection = object3;
        try {
            Object object5;
            Object object6;
            String string6;
            Object object7;
            Object object8;
            ((URLConnection)object3).setRequestProperty("User-Agent", this.getUserAgentContext().getUserAgent());
            ((URLConnection)object3).setRequestProperty("Cookie", "");
            if (object3 instanceof HttpURLConnection) {
                object2 = (HttpURLConnection)object3;
                ((HttpURLConnection)object2).setRequestMethod(string4);
                ((HttpURLConnection)object2).setInstanceFollowRedirects(false);
            }
            if (bl) {
                ((URLConnection)object3).setDoOutput(true);
                object2 = new ByteArrayOutputStream();
                boolean bl2 = true;
                if (formInputArray != null) {
                    for (int i = 0; i < formInputArray.length; ++i) {
                        object8 = formInputArray[i];
                        object7 = ((FormInput)object8).getName();
                        string6 = URLEncoder.encode((String)object7, "UTF-8");
                        if (((FormInput)object8).isText()) {
                            if (bl2) {
                                bl2 = false;
                            } else {
                                ((ByteArrayOutputStream)object2).write(38);
                            }
                            object6 = ((FormInput)object8).getTextValue();
                            object5 = URLEncoder.encode((String)object6, "UTF-8");
                            ((OutputStream)object2).write(string6.getBytes("UTF-8"));
                            ((ByteArrayOutputStream)object2).write(61);
                            ((OutputStream)object2).write(((String)object5).getBytes("UTF-8"));
                            continue;
                        }
                        logger.warning("postData(): Ignoring non-textual parameter " + (String)object7 + " for POST.");
                    }
                }
                object = ((ByteArrayOutputStream)object2).toByteArray();
                if (object3 instanceof HttpURLConnection) {
                    ((HttpURLConnection)object3).setFixedLengthStreamingMode(((Object)object).length);
                }
                ((URLConnection)object3).setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                object8 = ((URLConnection)object3).getOutputStream();
                ((OutputStream)object8).write((byte[])object);
                ((OutputStream)object8).flush();
            }
            if (object3 instanceof HttpURLConnection) {
                object2 = (HttpURLConnection)object3;
                int n = ((HttpURLConnection)object2).getResponseCode();
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("process(): HTTP response code: " + n);
                }
                if (n == 301 || n == 302 || n == 303) {
                    object = ((URLConnection)object2).getHeaderField("Location");
                    if (object == null) {
                        logger.warning("No Location header in redirect from " + uRL + ".");
                    } else {
                        object8 = Urls.createURL(uRL, (String)object);
                        this.navigate((URL)object8, string2);
                    }
                    return;
                }
            }
            object2 = ((URLConnection)object3).getInputStream();
            try {
                String string7;
                this.sourceCode = null;
                long l2 = System.currentTimeMillis();
                object8 = new RecordedInputStream((InputStream)object2, 1000000);
                object7 = new BufferedInputStream((InputStream)object8, 8192);
                string6 = uRL2.toExternalForm();
                object6 = this.createDocument(new InputSourceImpl((InputStream)object7, string6, this.getDocumentCharset((URLConnection)object3)));
                object5 = this.htmlPanel;
                ((HtmlPanel)object5).setDocument((Document)object6, this);
                ((HTMLDocumentImpl)object6).load();
                long l3 = System.currentTimeMillis();
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Parsed URI=[" + uRL2 + "]: Parse elapsed: " + (l3 - l2) + " ms. Connection elapsed: " + (l2 - l) + " ms.");
                }
                if ((string7 = uRL2.getRef()) != null && string7.length() != 0) {
                    ((HtmlPanel)object5).scrollToElement(string7);
                }
                try {
                    this.sourceCode = ((RecordedInputStream)object8).getString("ISO-8859-1");
                }
                catch (BufferExceededException bufferExceededException) {
                    this.sourceCode = "[TOO BIG]";
                }
            }
            finally {
                ((InputStream)object2).close();
            }
        }
        finally {
            this.currentConnection = null;
        }
    }

    protected HTMLDocumentImpl createDocument(InputSource inputSource) throws IOException, SAXException {
        DocumentBuilderImpl documentBuilderImpl = new DocumentBuilderImpl(this.getUserAgentContext(), this);
        return (HTMLDocumentImpl)documentBuilderImpl.createDocument(inputSource);
    }

    protected String getDocumentCharset(URLConnection uRLConnection) {
        String string = Urls.getCharset(uRLConnection);
        return string == null ? "ISO-8859-1" : string;
    }

    public void alert(String string) {
        JOptionPane.showMessageDialog(this.htmlPanel, string);
    }

    public void blur() {
        this.warn("back(): Not overridden");
    }

    public void close() {
        this.warn("close(): Not overridden");
    }

    public boolean confirm(String string) {
        int n = JOptionPane.showConfirmDialog(this.htmlPanel, string, "Confirm", 0);
        return n == 0;
    }

    public void focus() {
        this.warn("focus(): Not overridden");
    }

    public final HtmlRendererContext open(String string, String string2, String string3, boolean bl) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Malformed URL: " + string);
        }
        return this.open(uRL, string2, string3, bl);
    }

    public HtmlRendererContext open(URL uRL, String string, String string2, boolean bl) {
        this.warn("open(): Not overridden");
        return null;
    }

    public String prompt(String string, String string2) {
        return JOptionPane.showInputDialog(this.htmlPanel, (Object)string);
    }

    public void scroll(int n, int n2) {
        this.htmlPanel.scroll(n, n2);
    }

    public void scrollBy(int n, int n2) {
        this.htmlPanel.scrollBy(n, n2);
    }

    public boolean isClosed() {
        this.warn("isClosed(): Not overridden");
        return false;
    }

    public String getDefaultStatus() {
        this.warn("getDefaultStatus(): Not overridden");
        return "";
    }

    public String getName() {
        this.warn("getName(): Not overridden");
        return "";
    }

    public HtmlRendererContext getParent() {
        return this.parentRcontext;
    }

    public HtmlRendererContext getOpener() {
        return this.opener;
    }

    public void setOpener(HtmlRendererContext htmlRendererContext) {
        this.opener = htmlRendererContext;
    }

    public String getStatus() {
        this.warn("getStatus(): Not overridden");
        return "";
    }

    public void setStatus(String string) {
        this.warn("setStatus(): Not overridden");
    }

    public HtmlRendererContext getTop() {
        HtmlRendererContext htmlRendererContext = this.parentRcontext;
        if (htmlRendererContext == null) {
            return this;
        }
        return htmlRendererContext.getTop();
    }

    public BrowserFrame createBrowserFrame() {
        return new SimpleBrowserFrame(this);
    }

    public void warn(String string, Throwable throwable) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, string, throwable);
        }
    }

    public void error(String string, Throwable throwable) {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, string, throwable);
        }
    }

    public void warn(String string) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, string);
        }
    }

    public void error(String string) {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, string);
        }
    }

    public HtmlObject getHtmlObject(HTMLElement hTMLElement) {
        return null;
    }

    public void setDefaultStatus(String string) {
        this.warn("setDefaultStatus(): Not overridden.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAgentContext getUserAgentContext() {
        SimpleHtmlRendererContext simpleHtmlRendererContext = this;
        synchronized (simpleHtmlRendererContext) {
            if (this.bcontext == null) {
                this.warn("getUserAgentContext(): UserAgentContext not provided in constructor. Creating a simple one.");
                this.bcontext = new SimpleUserAgentContext();
            }
            return this.bcontext;
        }
    }

    public boolean isVisitedLink(HTMLLinkElement hTMLLinkElement) {
        return false;
    }

    public boolean onContextMenu(HTMLElement hTMLElement, MouseEvent mouseEvent) {
        return true;
    }

    public void onMouseOut(HTMLElement hTMLElement, MouseEvent mouseEvent) {
    }

    public void onMouseOver(HTMLElement hTMLElement, MouseEvent mouseEvent) {
    }

    public boolean isImageLoadingEnabled() {
        return true;
    }

    public boolean onDoubleClick(HTMLElement hTMLElement, MouseEvent mouseEvent) {
        return true;
    }

    public boolean onMouseClick(HTMLElement hTMLElement, MouseEvent mouseEvent) {
        return true;
    }

    private static Window getWindow(Component component) {
        Component component2;
        for (component2 = component; component2 != null && !(component2 instanceof Window); component2 = component2.getParent()) {
        }
        return (Window)component2;
    }

    public void resizeBy(int n, int n2) {
        Window window = SimpleHtmlRendererContext.getWindow(this.htmlPanel);
        if (window != null) {
            window.setSize(window.getWidth() + n, window.getHeight() + n2);
        }
    }

    public void resizeTo(int n, int n2) {
        Window window = SimpleHtmlRendererContext.getWindow(this.htmlPanel);
        if (window != null) {
            window.setSize(n, n2);
        }
    }

    public void back() {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "back() does nothing, unless overridden.");
        }
    }

    public void forward() {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "forward() does nothing, unless overridden.");
        }
    }

    public String getCurrentURL() {
        NodeImpl nodeImpl = this.htmlPanel.getRootNode();
        if (nodeImpl instanceof HTMLDocumentImpl) {
            HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)nodeImpl;
            return hTMLDocumentImpl.getDocumentURI();
        }
        return null;
    }

    public int getHistoryLength() {
        return 0;
    }

    public String getNextURL() {
        return null;
    }

    public String getPreviousURL() {
        return null;
    }

    public void goToHistoryURL(String string) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "goToHistoryURL() does nothing, unless overridden.");
        }
    }

    public void moveInHistory(int n) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "moveInHistory() does nothing, unless overridden.");
        }
    }
}

