/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.BorderInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.RenderThreadState;
import org.lobobrowser.html.style.WordInfo;
import org.lobobrowser.util.gui.ColorFactory;
import org.lobobrowser.util.gui.FontFactory;

public class StyleSheetRenderState
implements RenderState {
    private static final FontFactory FONT_FACTORY = FontFactory.getInstance();
    private static final String DEFAULT_FONT_FAMILY = "SansSerif";
    private static final Font DEFAULT_FONT = FONT_FACTORY.getFont("SansSerif", null, null, null, 14.0f, null, null);
    protected static final HtmlInsets INVALID_INSETS = new HtmlInsets();
    protected static final BackgroundInfo INVALID_BACKGROUND_INFO = new BackgroundInfo();
    protected static final BorderInfo INVALID_BORDER_INFO = new BorderInfo();
    protected static final Color INVALID_COLOR = new Color(100, 0, 100);
    protected final HTMLElementImpl element;
    protected final HTMLDocumentImpl document;
    protected final RenderState prevRenderState;
    private Font iFont;
    private FontMetrics iFontMetrics;
    private Color iColor;
    private Color iBackgroundColor = INVALID_COLOR;
    private Color iTextBackgroundColor = INVALID_COLOR;
    private Color iOverlayColor = INVALID_COLOR;
    private int iTextDecoration = -1;
    private int iTextTransform = -1;
    private int iBlankWidth = -1;
    private boolean iHighlight;
    protected BackgroundInfo iBackgroundInfo = INVALID_BACKGROUND_INFO;
    private Integer iDisplay;
    Map iWordInfoMap = null;
    private int alignXPercent = -1;
    private Map counters = null;
    private String iTextIndentText = null;
    protected Integer iWhiteSpace;
    protected HtmlInsets marginInsets = INVALID_INSETS;
    protected HtmlInsets paddingInsets = INVALID_INSETS;
    private Integer cachedVisibility;
    private Integer cachedPosition;
    private Integer cachedFloat;
    protected int overflowX = -1;
    protected int overflowY = -1;
    protected BorderInfo borderInfo = INVALID_BORDER_INFO;

    public StyleSheetRenderState(RenderState renderState, HTMLElementImpl hTMLElementImpl) {
        this.prevRenderState = renderState;
        this.element = hTMLElementImpl;
        this.document = (HTMLDocumentImpl)hTMLElementImpl.getOwnerDocument();
    }

    public StyleSheetRenderState(HTMLDocumentImpl hTMLDocumentImpl) {
        this.prevRenderState = null;
        this.element = null;
        this.document = hTMLDocumentImpl;
    }

    protected int getDefaultDisplay() {
        return 1;
    }

    public int getDisplay() {
        String string;
        String string2;
        Integer n = this.iDisplay;
        if (n != null) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        String string3 = string2 = abstractCSS2Properties == null ? null : abstractCSS2Properties.getDisplay();
        int n2 = string2 != null ? ("block".equals(string = string2.toLowerCase()) ? 2 : ("inline".equals(string) ? 1 : ("none".equals(string) ? 0 : ("list-item".equals(string) ? 3 : ("table".equals(string) ? 6 : ("table-cell".equals(string) ? 5 : ("table-row".equals(string) ? 4 : this.getDefaultDisplay()))))))) : this.getDefaultDisplay();
        this.iDisplay = n = new Integer(n2);
        return n2;
    }

    public RenderState getPreviousRenderState() {
        return this.prevRenderState;
    }

    public int getFontBase() {
        RenderState renderState = this.prevRenderState;
        return renderState == null ? 3 : renderState.getFontBase();
    }

    public void repaint() {
    }

    protected final AbstractCSS2Properties getCssProperties() {
        HTMLElementImpl hTMLElementImpl = this.element;
        return hTMLElementImpl == null ? null : hTMLElementImpl.getCurrentStyle();
    }

    public void invalidate() {
        Map map = this.iWordInfoMap;
        if (map != null) {
            map.clear();
        }
        this.iFont = null;
        this.iFontMetrics = null;
        this.iColor = null;
        this.iTextDecoration = -1;
        this.iBlankWidth = -1;
        this.alignXPercent = -1;
        this.iBackgroundColor = INVALID_COLOR;
        this.iTextBackgroundColor = INVALID_COLOR;
        this.iOverlayColor = INVALID_COLOR;
        this.iBackgroundInfo = INVALID_BACKGROUND_INFO;
        this.iDisplay = null;
        this.iTextIndentText = null;
        this.iWhiteSpace = null;
        this.marginInsets = INVALID_INSETS;
        this.paddingInsets = INVALID_INSETS;
        this.overflowX = -1;
        this.overflowY = -1;
        this.borderInfo = INVALID_BORDER_INFO;
    }

    public Font getFont() {
        int n;
        int n2;
        boolean bl;
        Font font = this.iFont;
        if (font != null) {
            return font;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        RenderState renderState = this.prevRenderState;
        if (abstractCSS2Properties == null) {
            if (renderState != null) {
                this.iFont = font = renderState.getFont();
                return font;
            }
            this.iFont = font = DEFAULT_FONT;
            return font;
        }
        Float f = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = abstractCSS2Properties == null ? null : abstractCSS2Properties.getFontSize();
        String string6 = abstractCSS2Properties == null ? null : abstractCSS2Properties.getFontFamily();
        String string7 = abstractCSS2Properties == null ? null : abstractCSS2Properties.getFontStyle();
        String string8 = abstractCSS2Properties == null ? null : abstractCSS2Properties.getFontVariant();
        String string9 = abstractCSS2Properties == null ? null : abstractCSS2Properties.getFontWeight();
        String string10 = abstractCSS2Properties == null ? null : abstractCSS2Properties.getVerticalAlign();
        boolean bl2 = string10 != null && string10.equalsIgnoreCase("super");
        boolean bl3 = bl = string10 != null && string10.equalsIgnoreCase("sub");
        if (string5 == null && string9 == null && string7 == null && string6 == null && string8 == null && !bl2 && !bl) {
            if (renderState != null) {
                this.iFont = font = renderState.getFont();
                return font;
            }
            this.iFont = font = DEFAULT_FONT;
            return font;
        }
        if (string5 != null) {
            try {
                f = new Float(HtmlValues.getFontSize(string5, renderState));
            }
            catch (Exception exception) {
                f = HtmlValues.DEFAULT_FONT_SIZE_BOX;
            }
        } else if (f == null) {
            f = renderState != null ? new Float(renderState.getFont().getSize()) : HtmlValues.DEFAULT_FONT_SIZE_BOX;
        }
        if (string6 != null) {
            string4 = string6;
        } else if (string4 == null && renderState != null) {
            string4 = renderState.getFont().getFamily();
        }
        if (string4 == null) {
            string4 = DEFAULT_FONT_FAMILY;
        }
        if (string7 != null) {
            string = string7;
        } else if (string == null && renderState != null && ((n2 = renderState.getFont().getStyle()) & 2) != 0) {
            string = "italic";
        }
        if (string8 != null) {
            string2 = string8;
        } else if (renderState != null) {
            // empty if block
        }
        if (string9 != null) {
            string3 = string9;
        } else if (string3 == null && renderState != null && ((n = renderState.getFont().getStyle()) & 1) != 0) {
            string3 = "bold";
        }
        HTMLDocumentImpl hTMLDocumentImpl = this.document;
        Set set = hTMLDocumentImpl == null ? null : hTMLDocumentImpl.getLocales();
        Integer n3 = null;
        if (bl2) {
            n3 = new Integer(1);
        } else if (bl) {
            n3 = new Integer(-1);
        }
        if (n3 == null && renderState != null) {
            n3 = (Integer)renderState.getFont().getAttributes().get(TextAttribute.SUPERSCRIPT);
        }
        this.iFont = font = FONT_FACTORY.getFont(string4, string, string2, string3, f.floatValue(), set, n3);
        return font;
    }

    public Color getColor() {
        String string;
        Color color = this.iColor;
        if (color != null) {
            return color;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        String string2 = string = abstractCSS2Properties == null ? null : abstractCSS2Properties.getColor();
        if (string == null || "".equals(string)) {
            RenderState renderState = this.prevRenderState;
            if (renderState != null) {
                this.iColor = color = renderState.getColor();
                return color;
            }
            string = "black";
        }
        this.iColor = color = ColorFactory.getInstance().getColor(string);
        return color;
    }

    public Color getBackgroundColor() {
        Color color;
        RenderState renderState;
        Color color2;
        Color color3 = this.iBackgroundColor;
        if (color3 != INVALID_COLOR) {
            return color3;
        }
        BackgroundInfo backgroundInfo = this.getBackgroundInfo();
        Color color4 = color2 = backgroundInfo == null ? null : backgroundInfo.backgroundColor;
        if (color2 == null && this.getDisplay() == 1 && (renderState = this.prevRenderState) != null && (color = renderState.getBackgroundColor()) != null) {
            this.iBackgroundColor = color;
            return color;
        }
        this.iBackgroundColor = color2;
        return color2;
    }

    public Color getTextBackgroundColor() {
        Color color;
        Color color2 = this.iTextBackgroundColor;
        if (color2 != INVALID_COLOR) {
            return color2;
        }
        if (this.getDisplay() != 1) {
            color = null;
        } else {
            Color color3;
            RenderState renderState;
            BackgroundInfo backgroundInfo = this.getBackgroundInfo();
            Color color4 = color = backgroundInfo == null ? null : backgroundInfo.backgroundColor;
            if (color == null && (renderState = this.prevRenderState) != null && (color3 = renderState.getTextBackgroundColor()) != null) {
                this.iTextBackgroundColor = color3;
                return color3;
            }
        }
        this.iTextBackgroundColor = color;
        return color;
    }

    public Color getOverlayColor() {
        String string;
        Color color = this.iOverlayColor;
        if (color != INVALID_COLOR) {
            return color;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        String string2 = string = abstractCSS2Properties == null ? null : abstractCSS2Properties.getOverlayColor();
        if (string == null || string.length() == 0) {
            RenderState renderState = this.prevRenderState;
            if (renderState != null) {
                this.iOverlayColor = color = renderState.getOverlayColor();
                return color;
            }
            string = null;
        }
        this.iOverlayColor = color = string == null ? null : ColorFactory.getInstance().getColor(string);
        return color;
    }

    public int getTextDecorationMask() {
        Object object;
        String string;
        int n = this.iTextDecoration;
        if (n != -1) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        String string2 = string = abstractCSS2Properties == null ? null : abstractCSS2Properties.getTextDecoration();
        if (string == null && (object = this.prevRenderState) != null) {
            this.iTextDecoration = n = object.getTextDecorationMask();
            return n;
        }
        n = 0;
        if (string != null) {
            object = new StringTokenizer(string.toLowerCase(), ", \t\n\r");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                if ("none".equals(string3)) continue;
                if ("underline".equals(string3)) {
                    n |= 1;
                    continue;
                }
                if ("line-through".equals(string3)) {
                    n |= 4;
                    continue;
                }
                if ("blink".equals(string3)) {
                    n |= 8;
                    continue;
                }
                if (!"overline".equals(string3)) continue;
                n |= 2;
            }
        }
        this.iTextDecoration = n;
        return n;
    }

    public int getTextTransform() {
        RenderState renderState;
        String string;
        int n = this.iTextTransform;
        if (n != -1) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        String string2 = string = abstractCSS2Properties == null ? null : abstractCSS2Properties.getTextTransform();
        if (string == null && (renderState = this.prevRenderState) != null) {
            this.iTextTransform = n = renderState.getTextTransform();
            return n;
        }
        n = 0;
        if (string != null && !"none".equals(string)) {
            if ("capitalize".equals(string)) {
                n = 1;
            } else if ("uppercase".equals(string)) {
                n = 2;
            } else if ("lowercase".equals(string)) {
                n = 4;
            }
        }
        this.iTextTransform = n;
        return n;
    }

    public final FontMetrics getFontMetrics() {
        FontMetrics fontMetrics = this.iFontMetrics;
        if (fontMetrics == null) {
            this.iFontMetrics = fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        }
        return fontMetrics;
    }

    public int getBlankWidth() {
        int n = this.iBlankWidth;
        if (n == -1) {
            this.iBlankWidth = n = this.getFontMetrics().charWidth(' ');
        }
        return n;
    }

    public boolean isHighlight() {
        return this.iHighlight;
    }

    public void setHighlight(boolean bl) {
        this.iHighlight = bl;
    }

    public final WordInfo getWordInfo(String string) {
        FontMetrics fontMetrics;
        WordInfo wordInfo;
        HashMap<String, WordInfo> hashMap = this.iWordInfoMap;
        if (hashMap == null) {
            this.iWordInfoMap = hashMap = new HashMap<String, WordInfo>(1);
        }
        if ((wordInfo = (WordInfo)hashMap.get(string)) != null) {
            return wordInfo;
        }
        wordInfo = new WordInfo();
        wordInfo.fontMetrics = fontMetrics = this.getFontMetrics();
        wordInfo.ascentPlusLeading = fontMetrics.getAscent() + fontMetrics.getLeading();
        wordInfo.descent = fontMetrics.getDescent();
        wordInfo.height = fontMetrics.getHeight();
        wordInfo.width = fontMetrics.stringWidth(string);
        hashMap.put(string, wordInfo);
        return wordInfo;
    }

    public int getAlignXPercent() {
        HTMLElementImpl hTMLElementImpl;
        String string;
        int n = this.alignXPercent;
        if (n != -1) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        String string2 = string = abstractCSS2Properties == null ? null : abstractCSS2Properties.getTextAlign();
        if (!(string != null && string.length() != 0 || (hTMLElementImpl = this.element) == null || (string = hTMLElementImpl.getAttribute("align")) != null && string.length() != 0)) {
            RenderState renderState = this.prevRenderState;
            if (renderState != null) {
                return renderState.getAlignXPercent();
            }
            string = null;
        }
        n = string == null ? 0 : ("center".equalsIgnoreCase(string) ? 50 : ("right".equalsIgnoreCase(string) ? 100 : 0));
        this.alignXPercent = n;
        return n;
    }

    public int getAlignYPercent() {
        return 0;
    }

    public int getCount(String string, int n) {
        RenderState renderState = this.prevRenderState;
        if (renderState != null) {
            return renderState.getCount(string, n);
        }
        Map map = this.counters;
        if (map == null) {
            return 0;
        }
        ArrayList arrayList = (ArrayList)map.get(string);
        if (n < 0 || n >= arrayList.size()) {
            return 0;
        }
        Integer n2 = (Integer)arrayList.get(n);
        return n2 == null ? 0 : n2;
    }

    public void resetCount(String string, int n, int n2) {
        RenderState renderState = this.prevRenderState;
        if (renderState != null) {
            renderState.resetCount(string, n, n2);
        } else {
            HashMap hashMap = this.counters;
            if (hashMap == null) {
                this.counters = hashMap = new HashMap(2);
                hashMap.put(string, new ArrayList(0));
            }
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            while (arrayList.size() <= n) {
                arrayList.add(null);
            }
            arrayList.set(n, new Integer(n2));
        }
    }

    public int incrementCount(String string, int n) {
        RenderState renderState = this.prevRenderState;
        if (renderState != null) {
            return renderState.incrementCount(string, n);
        }
        HashMap hashMap = this.counters;
        if (hashMap == null) {
            this.counters = hashMap = new HashMap(2);
            hashMap.put(string, new ArrayList(0));
        }
        ArrayList arrayList = (ArrayList)hashMap.get(string);
        while (arrayList.size() <= n) {
            arrayList.add(null);
        }
        Integer n2 = (Integer)arrayList.get(n);
        int n3 = n2 == null ? 0 : n2;
        arrayList.set(n, new Integer(n3 + 1));
        return n3;
    }

    public BackgroundInfo getBackgroundInfo() {
        BackgroundInfo backgroundInfo = this.iBackgroundInfo;
        if (backgroundInfo != INVALID_BACKGROUND_INFO) {
            return backgroundInfo;
        }
        backgroundInfo = null;
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        if (abstractCSS2Properties != null) {
            String string;
            Object object;
            String string2;
            String string3 = abstractCSS2Properties.getBackgroundColor();
            if (string3 != null) {
                if (backgroundInfo == null) {
                    backgroundInfo = new BackgroundInfo();
                }
                backgroundInfo.backgroundColor = ColorFactory.getInstance().getColor(string3);
            }
            if ((string2 = abstractCSS2Properties.getBackgroundImage()) != null && string2.length() > 0 && (object = HtmlValues.getURIFromStyleValue(string2)) != null) {
                if (backgroundInfo == null) {
                    backgroundInfo = new BackgroundInfo();
                }
                backgroundInfo.backgroundImage = object;
            }
            if ((object = abstractCSS2Properties.getBackgroundRepeat()) != null) {
                if (backgroundInfo == null) {
                    backgroundInfo = new BackgroundInfo();
                }
                this.applyBackgroundRepeat(backgroundInfo, (String)object);
            }
            if ((string = abstractCSS2Properties.getBackgroundPosition()) != null) {
                if (backgroundInfo == null) {
                    backgroundInfo = new BackgroundInfo();
                }
                this.applyBackgroundPosition(backgroundInfo, string);
            }
        }
        this.iBackgroundInfo = backgroundInfo;
        return backgroundInfo;
    }

    public String getTextIndentText() {
        String string = this.iTextIndentText;
        if (string != null) {
            return string;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        String string2 = string = abstractCSS2Properties == null ? null : abstractCSS2Properties.getTextIndent();
        if (string == null) {
            RenderState renderState = this.prevRenderState;
            if (renderState != null) {
                String string3;
                this.iTextIndentText = string3 = renderState.getTextIndentText();
                return string3;
            }
            string = "";
        }
        return string;
    }

    public int getTextIndent(int n) {
        String string = this.getTextIndentText();
        if (string.length() == 0) {
            return 0;
        }
        return HtmlValues.getPixelSize(string, this, 0, n);
    }

    public int getWhiteSpace() {
        String string;
        RenderState renderState;
        String string2;
        if (RenderThreadState.getState().overrideNoWrap) {
            return 2;
        }
        Integer n = this.iWhiteSpace;
        if (n != null) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        String string3 = string2 = abstractCSS2Properties == null ? null : abstractCSS2Properties.getWhiteSpace();
        int n2 = string2 == null ? ((renderState = this.prevRenderState) != null ? renderState.getWhiteSpace() : 0) : ("nowrap".equals(string = string2.toLowerCase()) ? 2 : ("pre".equals(string) ? 1 : 0));
        this.iWhiteSpace = new Integer(n2);
        return n2;
    }

    public HtmlInsets getMarginInsets() {
        HtmlInsets htmlInsets = this.marginInsets;
        if (htmlInsets != INVALID_INSETS) {
            return htmlInsets;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        htmlInsets = abstractCSS2Properties == null ? null : HtmlValues.getMarginInsets(abstractCSS2Properties, this);
        this.marginInsets = htmlInsets;
        return htmlInsets;
    }

    public HtmlInsets getPaddingInsets() {
        HtmlInsets htmlInsets = this.paddingInsets;
        if (htmlInsets != INVALID_INSETS) {
            return htmlInsets;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        if (abstractCSS2Properties == null) {
            htmlInsets = null;
        } else {
            this.paddingInsets = htmlInsets = HtmlValues.getPaddingInsets(abstractCSS2Properties, this);
        }
        return htmlInsets;
    }

    private void applyBackgroundHorizontalPositon(BackgroundInfo backgroundInfo, String string) {
        if (string.endsWith("%")) {
            backgroundInfo.backgroundXPositionAbsolute = false;
            try {
                backgroundInfo.backgroundXPosition = (int)Double.parseDouble(string.substring(0, string.length() - 1).trim());
            }
            catch (NumberFormatException numberFormatException) {
                backgroundInfo.backgroundXPosition = 0;
            }
        } else if ("center".equalsIgnoreCase(string)) {
            backgroundInfo.backgroundXPositionAbsolute = false;
            backgroundInfo.backgroundXPosition = 50;
        } else if ("right".equalsIgnoreCase(string)) {
            backgroundInfo.backgroundXPositionAbsolute = false;
            backgroundInfo.backgroundXPosition = 100;
        } else if ("left".equalsIgnoreCase(string)) {
            backgroundInfo.backgroundXPositionAbsolute = false;
            backgroundInfo.backgroundXPosition = 0;
        } else if ("bottom".equalsIgnoreCase(string)) {
            backgroundInfo.backgroundYPositionAbsolute = false;
            backgroundInfo.backgroundYPosition = 100;
        } else if ("top".equalsIgnoreCase(string)) {
            backgroundInfo.backgroundYPositionAbsolute = false;
            backgroundInfo.backgroundYPosition = 0;
        } else {
            backgroundInfo.backgroundXPositionAbsolute = true;
            backgroundInfo.backgroundXPosition = HtmlValues.getPixelSize(string, this, 0);
        }
    }

    private void applyBackgroundVerticalPosition(BackgroundInfo backgroundInfo, String string) {
        if (string.endsWith("%")) {
            backgroundInfo.backgroundYPositionAbsolute = false;
            try {
                backgroundInfo.backgroundYPosition = (int)Double.parseDouble(string.substring(0, string.length() - 1).trim());
            }
            catch (NumberFormatException numberFormatException) {
                backgroundInfo.backgroundYPosition = 0;
            }
        } else if ("center".equalsIgnoreCase(string)) {
            backgroundInfo.backgroundYPositionAbsolute = false;
            backgroundInfo.backgroundYPosition = 50;
        } else if ("bottom".equalsIgnoreCase(string)) {
            backgroundInfo.backgroundYPositionAbsolute = false;
            backgroundInfo.backgroundYPosition = 100;
        } else if ("top".equalsIgnoreCase(string)) {
            backgroundInfo.backgroundYPositionAbsolute = false;
            backgroundInfo.backgroundYPosition = 0;
        } else if ("right".equalsIgnoreCase(string)) {
            backgroundInfo.backgroundXPositionAbsolute = false;
            backgroundInfo.backgroundXPosition = 100;
        } else if ("left".equalsIgnoreCase(string)) {
            backgroundInfo.backgroundXPositionAbsolute = false;
            backgroundInfo.backgroundXPosition = 0;
        } else {
            backgroundInfo.backgroundYPositionAbsolute = true;
            backgroundInfo.backgroundYPosition = HtmlValues.getPixelSize(string, this, 0);
        }
    }

    private void applyBackgroundPosition(BackgroundInfo backgroundInfo, String string) {
        backgroundInfo.backgroundXPositionAbsolute = false;
        backgroundInfo.backgroundYPositionAbsolute = false;
        backgroundInfo.backgroundXPosition = 50;
        backgroundInfo.backgroundYPosition = 50;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.applyBackgroundHorizontalPositon(backgroundInfo, string2);
            if (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                this.applyBackgroundVerticalPosition(backgroundInfo, string3);
            }
        }
    }

    private void applyBackgroundRepeat(BackgroundInfo backgroundInfo, String string) {
        String string2 = string.toLowerCase();
        if ("repeat".equals(string2)) {
            backgroundInfo.backgroundRepeat = 0;
        } else if ("repeat-x".equals(string2)) {
            backgroundInfo.backgroundRepeat = 2;
        } else if ("repeat-y".equals(string2)) {
            backgroundInfo.backgroundRepeat = 3;
        } else if ("no-repeat".equals(string2)) {
            backgroundInfo.backgroundRepeat = 1;
        }
    }

    public int getVisibility() {
        String string;
        String string2;
        Integer n = this.cachedVisibility;
        if (n != null) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        int n2 = abstractCSS2Properties == null ? 0 : ((string2 = abstractCSS2Properties.getVisibility()) == null || string2.length() == 0 ? 0 : ((string = string2.toLowerCase()).equals("hidden") ? 1 : (string.equals("visible") ? 0 : (string.equals("collapse") ? 2 : 0))));
        this.cachedVisibility = new Integer(n2);
        return n2;
    }

    public int getPosition() {
        String string;
        String string2;
        Integer n = this.cachedPosition;
        if (n != null) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        int n2 = abstractCSS2Properties == null ? 0 : ((string2 = abstractCSS2Properties.getPosition()) == null || string2.length() == 0 ? 0 : ((string = string2.toLowerCase()).equals("absolute") ? 1 : (string.equals("static") ? 0 : (string.equals("relative") ? 2 : (string.equals("fixed") ? 3 : 0)))));
        this.cachedPosition = new Integer(n2);
        return n2;
    }

    public int getFloat() {
        String string;
        String string2;
        Integer n = this.cachedFloat;
        if (n != null) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        int n2 = abstractCSS2Properties == null ? 0 : ((string2 = abstractCSS2Properties.getFloat()) == null || string2.length() == 0 ? 0 : ((string = string2.toLowerCase()).equals("left") ? 1 : (string.equals("right") ? 2 : 0)));
        this.cachedFloat = new Integer(n2);
        return n2;
    }

    public String toString() {
        return "StyleSheetRenderState[font=" + this.getFont() + ",textDecoration=" + this.getTextDecorationMask() + "]";
    }

    public int getOverflowX() {
        int n = this.overflowX;
        if (n != -1) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        if (abstractCSS2Properties == null) {
            n = 0;
        } else {
            String string;
            String string2 = abstractCSS2Properties.getPropertyValue("overflow-x");
            if (string2 == null) {
                string2 = abstractCSS2Properties.getOverflow();
            }
            n = string2 == null ? 0 : ("scroll".equals(string = string2.toLowerCase()) ? 1 : ("auto".equals(string) ? 2 : ("hidden".equals(string) ? 3 : ("visible".equals(string) ? 4 : 0))));
        }
        this.overflowX = n;
        return n;
    }

    public int getOverflowY() {
        int n = this.overflowY;
        if (n != -1) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        if (abstractCSS2Properties == null) {
            n = 0;
        } else {
            String string;
            String string2 = abstractCSS2Properties.getPropertyValue("overflow-y");
            if (string2 == null) {
                string2 = abstractCSS2Properties.getOverflow();
            }
            n = string2 == null ? 0 : ("scroll".equals(string = string2.toLowerCase()) ? 1 : ("auto".equals(string) ? 2 : ("hidden".equals(string) ? 3 : ("visible".equals(string) ? 4 : 0))));
        }
        this.overflowY = n;
        return n;
    }

    public BorderInfo getBorderInfo() {
        BorderInfo borderInfo = this.borderInfo;
        if (borderInfo != INVALID_BORDER_INFO) {
            return borderInfo;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        borderInfo = abstractCSS2Properties != null ? HtmlValues.getBorderInfo(abstractCSS2Properties, this) : null;
        this.borderInfo = borderInfo;
        return borderInfo;
    }
}

