/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.RenderStateDelegator;
import org.lobobrowser.html.style.WordInfo;
import org.lobobrowser.util.gui.FontFactory;

public class FontStyleRenderState
extends RenderStateDelegator {
    private final int style;
    private final Integer superscript;
    private Font iFont;
    private FontMetrics iFontMetrics;
    Map iWordInfoMap = null;

    public FontStyleRenderState(RenderState renderState, int n) {
        this(renderState, n, null);
    }

    FontStyleRenderState(RenderState renderState, int n, Integer n2) {
        super(renderState);
        this.style = n;
        this.superscript = n2;
    }

    public static FontStyleRenderState createSuperscriptFontStyleRenderState(RenderState renderState, Integer n) {
        return new FontStyleRenderState(renderState, renderState.getFont().getStyle(), n);
    }

    public Font getFont() {
        Font font = this.iFont;
        if (font != null) {
            return font;
        }
        Font font2 = this.delegate.getFont();
        font = font2.getStyle() != this.style ? font2.deriveFont(this.style | font2.getStyle()) : font2;
        this.iFont = font = FontFactory.superscriptFont(font, this.superscript);
        return font;
    }

    public FontMetrics getFontMetrics() {
        FontMetrics fontMetrics = this.iFontMetrics;
        if (fontMetrics == null) {
            this.iFontMetrics = fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        }
        return fontMetrics;
    }

    public void invalidate() {
        this.delegate.invalidate();
        this.iFont = null;
        this.iFontMetrics = null;
        Map map = this.iWordInfoMap;
        if (map != null) {
            map.clear();
        }
    }

    public final WordInfo getWordInfo(String string) {
        FontMetrics fontMetrics;
        WordInfo wordInfo;
        HashMap<String, WordInfo> hashMap = this.iWordInfoMap;
        if (hashMap == null) {
            this.iWordInfoMap = hashMap = new HashMap<String, WordInfo>(1);
        }
        if ((wordInfo = (WordInfo)hashMap.get(string)) != null) {
            return wordInfo;
        }
        wordInfo = new WordInfo();
        wordInfo.fontMetrics = fontMetrics = this.getFontMetrics();
        wordInfo.ascentPlusLeading = fontMetrics.getAscent() + fontMetrics.getLeading();
        wordInfo.descent = fontMetrics.getDescent();
        wordInfo.height = fontMetrics.getHeight();
        wordInfo.width = fontMetrics.stringWidth(string);
        hashMap.put(string, wordInfo);
        return wordInfo;
    }
}

