/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.RenderStateDelegator;
import org.lobobrowser.html.style.WordInfo;

public class FontNameRenderState
extends RenderStateDelegator {
    private final String fontName;
    private Font iFont;
    private FontMetrics iFontMetrics;
    Map iWordInfoMap = null;

    public FontNameRenderState(RenderState renderState, String string) {
        super(renderState);
        this.fontName = string;
    }

    public Font getFont() {
        Font font = this.iFont;
        if (font != null) {
            return font;
        }
        Font font2 = this.delegate.getFont();
        this.iFont = font = new Font(this.fontName, font2.getStyle(), font2.getSize());
        return font;
    }

    public FontMetrics getFontMetrics() {
        FontMetrics fontMetrics = this.iFontMetrics;
        if (fontMetrics == null) {
            this.iFontMetrics = fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        }
        return fontMetrics;
    }

    public void invalidate() {
        super.invalidate();
        this.iFont = null;
        this.iFontMetrics = null;
        Map map = this.iWordInfoMap;
        if (map != null) {
            map.clear();
        }
    }

    public final WordInfo getWordInfo(String string) {
        FontMetrics fontMetrics;
        WordInfo wordInfo;
        HashMap<String, WordInfo> hashMap = this.iWordInfoMap;
        if (hashMap == null) {
            this.iWordInfoMap = hashMap = new HashMap<String, WordInfo>(1);
        }
        if ((wordInfo = (WordInfo)hashMap.get(string)) != null) {
            return wordInfo;
        }
        wordInfo = new WordInfo();
        wordInfo.fontMetrics = fontMetrics = this.getFontMetrics();
        wordInfo.ascentPlusLeading = fontMetrics.getAscent() + fontMetrics.getLeading();
        wordInfo.descent = fontMetrics.getDescent();
        wordInfo.height = fontMetrics.getHeight();
        wordInfo.width = fontMetrics.stringWidth(string);
        hashMap.put(string, wordInfo);
        return wordInfo;
    }
}

