/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.RenderState;

final class RWord
extends BaseBoundableRenderable {
    final String shownWord;
    public final FontMetrics fontMetrics;
    public final int descent;
    public final int ascentPlusLeading;

    public RWord(ModelNode modelNode, String string, RenderableContainer renderableContainer, FontMetrics fontMetrics, int n, int n2, int n3, int n4) {
        super(renderableContainer, modelNode);
        String string2;
        this.shownWord = string2 = n4 == 0 ? string : this.transformText(string, n4);
        this.fontMetrics = fontMetrics;
        this.descent = n;
        this.ascentPlusLeading = n2;
        this.height = n3;
        this.width = fontMetrics.stringWidth(string2);
    }

    private String transformText(String string, int n) {
        String string2;
        switch (n) {
            case 1: {
                string2 = Character.toTitleCase(string.charAt(0)) + string.substring(1).toLowerCase();
                break;
            }
            case 4: {
                string2 = string.toLowerCase();
                break;
            }
            case 2: {
                string2 = string.toUpperCase();
                break;
            }
            default: {
                string2 = string;
            }
        }
        return string2;
    }

    protected void invalidateLayoutLocal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Color color;
        RenderState renderState = this.modelNode.getRenderState();
        String string = this.shownWord;
        int n = this.width;
        int n2 = this.ascentPlusLeading;
        int n3 = this.height;
        int n4 = renderState.getTextDecorationMask();
        Color color2 = renderState.getTextBackgroundColor();
        if (color2 != null) {
            Color color3 = graphics.getColor();
            try {
                graphics.setColor(color2);
                graphics.fillRect(0, 0, n, n3);
            }
            finally {
                graphics.setColor(color3);
            }
        }
        graphics.drawString(string, 0, n2);
        int n5 = n4;
        if (n5 != 0) {
            int n6;
            if ((n5 & 1) != 0) {
                int n7 = n2 + 2;
                graphics.drawLine(0, n7, n, n7);
            }
            if ((n5 & 4) != 0) {
                FontMetrics fontMetrics = this.fontMetrics;
                n6 = fontMetrics.getLeading() + (fontMetrics.getAscent() + fontMetrics.getDescent()) / 2;
                graphics.drawLine(0, n6, n, n6);
            }
            if ((n5 & 2) != 0) {
                FontMetrics fontMetrics = this.fontMetrics;
                n6 = fontMetrics.getLeading();
                graphics.drawLine(0, n6, n, n6);
            }
            if ((n5 & 8) != 0) {
                // empty if block
            }
        }
        if ((color = renderState.getOverlayColor()) != null) {
            Color color4 = graphics.getColor();
            try {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n, n3);
            }
            finally {
                graphics.setColor(color4);
            }
        }
    }

    public boolean paintSelection(Graphics graphics, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        int n;
        int n2;
        FontMetrics fontMetrics;
        int n3;
        int n4 = -1;
        int n5 = -1;
        if (this == renderableSpot.renderable) {
            n4 = renderableSpot.x;
        }
        if (this == renderableSpot2.renderable) {
            n5 = renderableSpot2.x;
        }
        if (!bl && n4 == -1 && n5 == -1) {
            return false;
        }
        if (n4 != -1 && n5 != -1) {
            if (n5 < n4) {
                n3 = n4;
                n4 = n5;
                n5 = n3;
            }
        } else if (n4 != -1 && n5 == -1 && bl) {
            n5 = n4;
            n4 = -1;
        } else if (n4 == -1 && n5 != -1 && !bl) {
            n4 = n5;
            n5 = -1;
        }
        n3 = -1;
        int n6 = -1;
        char[] cArray = this.shownWord.toCharArray();
        if (n4 != -1) {
            n3 = 0;
            fontMetrics = this.fontMetrics;
            for (n2 = 0; n2 < cArray.length && (n = fontMetrics.charsWidth(cArray, 0, n2)) <= n4; ++n2) {
                n3 = n;
            }
        }
        if (n5 != -1) {
            n6 = 0;
            fontMetrics = this.fontMetrics;
            for (n2 = 0; n2 < cArray.length && (n = fontMetrics.charsWidth(cArray, 0, n2)) <= n5; ++n2) {
                n6 = n;
            }
        }
        if (n3 != -1 || n6 != -1) {
            int n7 = n3 == -1 ? 0 : n3;
            n2 = n6 == -1 ? this.width : n6;
            graphics.setColor(SELECTION_COLOR);
            graphics.setXORMode(SELECTION_XOR);
            graphics.fillRect(n7, 0, n2 - n7, this.height);
            graphics.setPaintMode();
            return n6 == -1;
        }
        if (bl) {
            graphics.setColor(SELECTION_COLOR);
            graphics.setXORMode(SELECTION_XOR);
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setPaintMode();
        }
        return bl;
    }

    public boolean extractSelectionText(StringBuffer stringBuffer, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        int n;
        int n2;
        FontMetrics fontMetrics;
        int n3;
        int n4 = -1;
        int n5 = -1;
        if (this == renderableSpot.renderable) {
            n4 = renderableSpot.x;
        }
        if (this == renderableSpot2.renderable) {
            n5 = renderableSpot2.x;
        }
        if (!bl && n4 == -1 && n5 == -1) {
            return false;
        }
        if (n4 != -1 && n5 != -1) {
            if (n5 < n4) {
                n3 = n4;
                n4 = n5;
                n5 = n3;
            }
        } else if (n4 != -1 && n5 == -1 && bl) {
            n5 = n4;
            n4 = -1;
        } else if (n4 == -1 && n5 != -1 && !bl) {
            n4 = n5;
            n5 = -1;
        }
        n3 = -1;
        int n6 = -1;
        char[] cArray = this.shownWord.toCharArray();
        if (n4 != -1) {
            n3 = 0;
            fontMetrics = this.fontMetrics;
            n2 = 0;
            while (n2 < cArray.length && (n = fontMetrics.charsWidth(cArray, 0, n2)) <= n4) {
                n3 = n2++;
            }
        }
        if (n5 != -1) {
            n6 = 0;
            fontMetrics = this.fontMetrics;
            n2 = 0;
            while (n2 < cArray.length && (n = fontMetrics.charsWidth(cArray, 0, n2)) <= n5) {
                n6 = n2++;
            }
        }
        if (n3 != -1 || n6 != -1) {
            int n7 = n3 == -1 ? 0 : n3;
            n2 = n6 == -1 ? cArray.length : n6;
            stringBuffer.append(cArray, n7, n2 - n7);
        } else if (bl) {
            stringBuffer.append(cArray);
            return true;
        }
        if (n3 != -1 && n6 != -1) {
            return false;
        }
        return !bl;
    }

    public boolean onMouseClick(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseClick(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onDoubleClick(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onDoubleClick(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseDown(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseUp(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onMouseDisarmed(MouseEvent mouseEvent) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseDisarmed(modelNode, mouseEvent);
        }
        return true;
    }

    public RenderableSpot getLowestRenderableSpot(int n, int n2) {
        return new RenderableSpot(this, n, n2);
    }

    public boolean isContainedByNode() {
        return true;
    }

    public boolean onRightClick(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onContextMenu(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public String toString() {
        return "RWord[word=" + this.shownWord + "]";
    }
}

