/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.UIControl;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.Objects;

class RUIControl
extends BaseElementRenderable
implements RElement {
    private static final int MAX_CACHE_SIZE = 10;
    public final UIControl widget;
    protected final ModelNode modelNode;
    private final FrameContext frameContext;
    private int declaredWidth = -1;
    private int declaredHeight = -1;
    private LayoutKey lastLayoutKey = null;
    private LayoutValue lastLayoutValue = null;
    private final Map cachedLayout = new HashMap(5);

    public RUIControl(ModelNode modelNode, UIControl uIControl, RenderableContainer renderableContainer, FrameContext frameContext, UserAgentContext userAgentContext) {
        super(renderableContainer, modelNode, userAgentContext);
        this.modelNode = modelNode;
        this.widget = uIControl;
        this.frameContext = frameContext;
        uIControl.setRUIControl(this);
    }

    public void focus() {
        super.focus();
        Component component = this.widget.getComponent();
        component.requestFocus();
    }

    public final void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.widget.invalidate();
        this.cachedLayout.clear();
        this.lastLayoutKey = null;
        this.lastLayoutValue = null;
    }

    public int getVAlign() {
        return this.widget.getVAlign();
    }

    public boolean hasBackground() {
        return this.backgroundColor != null || this.backgroundImage != null || this.lastBackgroundImageUri != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics graphics) {
        RenderState renderState = this.modelNode.getRenderState();
        if (renderState != null && renderState.getVisibility() != 0) {
            return;
        }
        this.prePaint(graphics);
        Insets insets = this.getInsets(false, false);
        graphics.translate(insets.left, insets.top);
        try {
            this.widget.paint(graphics);
        }
        finally {
            graphics.translate(-insets.left, -insets.top);
        }
    }

    public boolean onMouseClick(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseClick(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onDoubleClick(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onDoubleClick(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseDown(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseUp(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onMouseDisarmed(MouseEvent mouseEvent) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseDisarmed(modelNode, mouseEvent);
        }
        return true;
    }

    public void invalidateRenderStyle() {
    }

    public void repaint(ModelNode modelNode) {
        UIControl uIControl = this.widget;
        if (uIControl instanceof UINode) {
            ((UINode)((Object)uIControl)).repaint(modelNode);
        } else {
            this.repaint();
        }
    }

    public void updateWidgetBounds(int n, int n2) {
        super.updateWidgetBounds(n, n2);
        Insets insets = this.getInsets(false, false);
        this.widget.setBounds(n + insets.left, n2 + insets.top, this.width - insets.left - insets.right, this.height - insets.top - insets.bottom);
    }

    public Color getBlockBackgroundColor() {
        return this.widget.getBackgroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintSelection(Graphics graphics, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        Color color;
        if ((bl = super.paintSelection(graphics, bl, renderableSpot, renderableSpot2)) && (color = new Color(0, 0, 255, 50)) != null) {
            Color color2 = graphics.getColor();
            try {
                graphics.setColor(color);
                graphics.fillRect(0, 0, this.width, this.height);
            }
            finally {
                graphics.setColor(color2);
            }
        }
        return bl;
    }

    public boolean extractSelectionText(StringBuffer stringBuffer, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        return bl;
    }

    public RenderableSpot getLowestRenderableSpot(int n, int n2) {
        return new RenderableSpot(this, n, n2);
    }

    public void doLayout(int n, int n2, boolean bl) {
        Map map = this.cachedLayout;
        RenderState renderState = this.modelNode.getRenderState();
        int n3 = renderState == null ? 0 : renderState.getWhiteSpace();
        Font font = renderState == null ? null : renderState.getFont();
        LayoutKey layoutKey = new LayoutKey(n, n2, n3, font);
        LayoutValue layoutValue = bl ? (LayoutValue)map.get(layoutKey) : (Objects.equals(this.lastLayoutKey, layoutKey) ? this.lastLayoutValue : null);
        if (layoutValue == null) {
            int n4;
            Insets insets;
            Insets insets2;
            this.applyStyle(n, n2);
            RenderState renderState2 = this.modelNode.getRenderState();
            Insets insets3 = this.paddingInsets;
            if (insets3 == null) {
                insets3 = RBlockViewport.ZERO_INSETS;
            }
            if ((insets2 = this.borderInsets) == null) {
                insets2 = RBlockViewport.ZERO_INSETS;
            }
            if ((insets = this.marginInsets) == null) {
                insets = RBlockViewport.ZERO_INSETS;
            }
            int n5 = n - insets3.left - insets3.right - insets2.left - insets2.right - insets.left - insets.right;
            int n6 = n2 - insets3.top - insets3.bottom - insets2.top - insets2.bottom - insets.top - insets.bottom;
            Integer n7 = this.getDeclaredWidth(renderState2, n5);
            Integer n8 = this.getDeclaredHeight(renderState2, n6);
            int n9 = n7 == null ? -1 : n7;
            int n10 = n8 == null ? -1 : n8;
            this.declaredWidth = n9;
            this.declaredHeight = n10;
            UIControl uIControl = this.widget;
            uIControl.reset(n, n2);
            Insets insets4 = this.getInsets(false, false);
            int n11 = n9 == -1 ? -1 : n9 - insets4.left - insets4.right;
            int n12 = n4 = n10 == -1 ? -1 : n10 - insets4.top - insets4.bottom;
            if (n11 == -1 || n4 == -1) {
                Dimension dimension = uIControl.getPreferredSize();
                if (n11 == -1) {
                    n11 = dimension.width + insets4.left + insets4.right;
                }
                if (n4 == -1) {
                    n4 = dimension.height + insets4.top + insets4.bottom;
                }
            }
            layoutValue = new LayoutValue(n11, n4);
            if (bl) {
                if (map.size() > 10) {
                    map.clear();
                }
                map.put(layoutKey, layoutValue);
                this.lastLayoutKey = null;
                this.lastLayoutValue = null;
            } else {
                this.lastLayoutKey = layoutKey;
                this.lastLayoutValue = layoutValue;
            }
        }
        this.width = layoutValue.width;
        this.height = layoutValue.height;
    }

    public final void preferredSizeInvalidated() {
        int n = this.declaredWidth;
        int n2 = this.declaredHeight;
        if (n == -1 || n2 == -1) {
            this.frameContext.delayedRelayout((NodeImpl)this.modelNode);
        } else {
            this.repaint();
        }
    }

    public Iterator getRenderables() {
        return null;
    }

    public Color getPaintedBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    public Color getForegroundColor() {
        RenderState renderState = this.modelNode.getRenderState();
        return renderState == null ? null : renderState.getColor();
    }

    private static class LayoutValue {
        public final int width;
        public final int height;

        public LayoutValue(int n, int n2) {
            this.width = n;
            this.height = n2;
        }
    }

    private static class LayoutKey {
        public final int availWidth;
        public final int availHeight;
        public final int whitespace;
        public final Font font;

        public LayoutKey(int n, int n2, int n3, Font font) {
            this.availWidth = n;
            this.availHeight = n2;
            this.whitespace = n3;
            this.font = font;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LayoutKey)) {
                return false;
            }
            LayoutKey layoutKey = (LayoutKey)object;
            return layoutKey.availWidth == this.availWidth && layoutKey.availHeight == this.availHeight && layoutKey.whitespace == this.whitespace && Objects.equals(layoutKey.font, this.font);
        }

        public int hashCode() {
            Font font = this.font;
            return this.availWidth * 1000 + this.availHeight ^ (font == null ? 0 : font.hashCode());
        }
    }
}

