/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLInputElementImpl;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.util.gui.WrapperLayout;

class InputButtonControl
extends BaseInputControl {
    private final JButton widget;

    public InputButtonControl(HTMLBaseInputElement hTMLBaseInputElement) {
        super(hTMLBaseInputElement);
        this.setLayout(WrapperLayout.getInstance());
        JButton jButton = new JButton();
        jButton.setContentAreaFilled(false);
        this.widget = jButton;
        this.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HtmlController.getInstance().onPressed(InputButtonControl.this.controlElement, null, 0, 0);
            }
        });
    }

    public void reset(int n, int n2) {
        HTMLInputElementImpl hTMLInputElementImpl;
        String string;
        super.reset(n, n2);
        RUIControl rUIControl = this.ruicontrol;
        JButton jButton = this.widget;
        jButton.setContentAreaFilled(!rUIControl.hasBackground());
        Color color = rUIControl.getForegroundColor();
        if (color != null) {
            jButton.setForeground(color);
        }
        if ((string = (hTMLInputElementImpl = (HTMLInputElementImpl)this.controlElement).getAttribute("value")) == null || string.length() == 0) {
            String string2 = hTMLInputElementImpl.getType();
            string = "submit".equalsIgnoreCase(string2) ? "Submit Query" : ("reset".equalsIgnoreCase(string2) ? "Reset" : "");
        }
        jButton.setText(string);
    }

    public void click() {
        this.widget.doClick();
    }

    public String getValue() {
        return this.widget.getText();
    }

    public void setDisabled(boolean bl) {
        super.setDisabled(bl);
        this.widget.setEnabled(!bl);
    }

    public void setValue(String string) {
        this.widget.setText(string);
    }

    public void resetInput() {
    }
}

