/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.util.Objects;

class FloatingViewportBounds
implements FloatingBounds {
    private final FloatingBounds prevBounds;
    private final boolean leftFloat;
    private final int y;
    private final int offsetFromBorder;
    private final int height;

    public FloatingViewportBounds(FloatingBounds floatingBounds, boolean bl, int n, int n2, int n3) {
        this.prevBounds = floatingBounds;
        this.leftFloat = bl;
        this.y = n;
        this.offsetFromBorder = n2;
        this.height = n3;
    }

    public int getLeft(int n) {
        int n2;
        FloatingBounds floatingBounds;
        int n3 = 0;
        if (this.leftFloat && n >= this.y && n < this.y + this.height) {
            n3 = this.offsetFromBorder;
        }
        if ((floatingBounds = this.prevBounds) != null && (n2 = floatingBounds.getLeft(n)) > n3) {
            n3 = n2;
        }
        return n3;
    }

    public int getRight(int n) {
        int n2;
        FloatingBounds floatingBounds;
        int n3 = 0;
        if (!this.leftFloat && n >= this.y && n < this.y + this.height) {
            n3 = this.offsetFromBorder;
        }
        if ((floatingBounds = this.prevBounds) != null && (n2 = floatingBounds.getRight(n)) > n3) {
            n3 = n2;
        }
        return n3;
    }

    public int getClearY(int n) {
        int n2;
        int n3 = Math.max(n, this.y + this.height);
        FloatingBounds floatingBounds = this.prevBounds;
        if (floatingBounds != null && (n2 = floatingBounds.getClearY(n)) > n3) {
            n3 = n2;
        }
        return n3;
    }

    public int getFirstClearY(int n) {
        int n2;
        int n3 = n;
        FloatingBounds floatingBounds = this.prevBounds;
        if (floatingBounds != null && (n2 = floatingBounds.getFirstClearY(n)) != n) {
            n3 = n2;
        }
        if (n3 == n && n >= this.y && n < this.y + this.height) {
            n3 = this.y + this.height;
        }
        return n3;
    }

    public int getLeftClearY(int n) {
        int n2;
        int n3 = this.leftFloat ? Math.max(n, this.y + this.height) : n;
        FloatingBounds floatingBounds = this.prevBounds;
        if (floatingBounds != null && (n2 = floatingBounds.getLeftClearY(n)) > n3) {
            n3 = n2;
        }
        return n3;
    }

    public int getRightClearY(int n) {
        int n2;
        int n3 = !this.leftFloat ? Math.max(n, this.y + this.height) : n;
        FloatingBounds floatingBounds = this.prevBounds;
        if (floatingBounds != null && (n2 = floatingBounds.getLeftClearY(n)) > n3) {
            n3 = n2;
        }
        return n3;
    }

    public int getMaxY() {
        int n;
        int n2 = this.y + this.height;
        FloatingBounds floatingBounds = this.prevBounds;
        if (floatingBounds != null && (n = floatingBounds.getMaxY()) > n2) {
            n2 = n;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FloatingViewportBounds)) {
            return false;
        }
        FloatingViewportBounds floatingViewportBounds = (FloatingViewportBounds)object;
        return floatingViewportBounds.leftFloat == this.leftFloat && floatingViewportBounds.y == this.y && floatingViewportBounds.height == this.height && floatingViewportBounds.offsetFromBorder == this.offsetFromBorder && Objects.equals(floatingViewportBounds.prevBounds, this.prevBounds);
    }

    public int hashCode() {
        return (this.leftFloat ? 1 : 0) ^ this.y ^ this.height ^ this.offsetFromBorder;
    }
}

