/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.util.gui.WrapperLayout;

abstract class BaseInputTextControl
extends BaseInputControl {
    private static final float DEFAULT_FONT_SIZE = 14.0f;
    protected final JTextComponent widget;
    private int maxLength = -1;

    public BaseInputTextControl(HTMLBaseInputElement hTMLBaseInputElement) {
        super(hTMLBaseInputElement);
        this.setLayout(WrapperLayout.getInstance());
        JTextComponent jTextComponent = this.createTextField();
        Font font = jTextComponent.getFont();
        jTextComponent.setFont(font.deriveFont(14.0f));
        jTextComponent.setDocument(new LimitedDocument());
        HTMLElementImpl hTMLElementImpl = this.controlElement;
        String string = hTMLElementImpl.getAttribute("value");
        jTextComponent.setText(string);
        this.widget = jTextComponent;
        this.add(jTextComponent);
    }

    public void reset(int n, int n2) {
        super.reset(n, n2);
        String string = this.controlElement.getAttribute("maxlength");
        if (string != null) {
            try {
                this.maxLength = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected abstract JTextComponent createTextField();

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean getReadOnly() {
        return !this.widget.isEditable();
    }

    public String getValue() {
        return this.widget.getText();
    }

    public void select() {
        this.widget.selectAll();
    }

    public void setDisabled(boolean bl) {
        super.setDisabled(bl);
        this.widget.setEnabled(!bl);
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public void setReadOnly(boolean bl) {
        this.widget.setEditable(!bl);
    }

    public void setValue(String string) {
        this.widget.setText(string);
    }

    public Dimension getPreferredSize() {
        int n = this.size;
        JTextComponent jTextComponent = this.widget;
        FontMetrics fontMetrics = jTextComponent.getFontMetrics(jTextComponent.getFont());
        Insets insets = jTextComponent.getInsets();
        int n2 = n == -1 ? 100 : insets.left + insets.right + fontMetrics.charWidth('0') * n;
        int n3 = fontMetrics.getHeight() + insets.top + insets.bottom;
        return new Dimension(n2, n3);
    }

    public void resetInput() {
        this.widget.setText("");
    }

    private class LimitedDocument
    extends PlainDocument {
        private LimitedDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2 = BaseInputTextControl.this.maxLength;
            if (n2 != -1) {
                int n3 = this.getLength();
                if (n3 >= n2) {
                    return;
                }
                int n4 = string.length();
                if (n3 + n4 > n2) {
                    String string2 = string.substring(0, n2 - n3);
                    super.insertString(n, string2, attributeSet);
                } else {
                    super.insertString(n, string, attributeSet);
                }
            } else {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

