/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.BorderInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.gui.GUITasks;

abstract class BaseElementRenderable
extends BaseRCollection
implements RElement,
RenderableContainer,
ImageObserver {
    protected static final Integer INVALID_SIZE = new Integer(Integer.MIN_VALUE);
    private Collection guiComponents = null;
    protected Collection delayedPairs = null;
    protected Color backgroundColor;
    protected volatile Image backgroundImage;
    protected int zIndex;
    protected Color borderTopColor;
    protected Color borderLeftColor;
    protected Color borderBottomColor;
    protected Color borderRightColor;
    protected Insets borderInsets;
    protected Insets marginInsets;
    protected Insets paddingInsets;
    protected BorderInfo borderInfo;
    protected URL lastBackgroundImageUri;
    protected Insets defaultMarginInsets = null;
    protected Insets defaultPaddingInsets = null;
    protected int overflowX;
    protected int overflowY;
    protected final UserAgentContext userAgentContext;
    protected boolean layoutDeepCanBeInvalidated = false;
    private Integer declaredWidth = INVALID_SIZE;
    private Integer declaredHeight = INVALID_SIZE;
    private int lastAvailWidthForDeclared = -1;
    private int lastAvailHeightForDeclared = -1;
    protected static final int SCROLL_BAR_THICKNESS = 16;

    public BaseElementRenderable(RenderableContainer renderableContainer, ModelNode modelNode, UserAgentContext userAgentContext) {
        super(renderableContainer, modelNode);
        this.userAgentContext = userAgentContext;
    }

    public void setDefaultPaddingInsets(Insets insets) {
        this.defaultPaddingInsets = insets;
    }

    public void setDefaultMarginInsets(Insets insets) {
        this.defaultMarginInsets = insets;
    }

    public float getAlignmentX() {
        return 0.0f;
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    public final void invalidateLayoutDeep() {
        if (this.layoutDeepCanBeInvalidated) {
            this.layoutDeepCanBeInvalidated = false;
            this.invalidateLayoutLocal();
            Iterator iterator = this.getRenderables();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof RCollection)) continue;
                    ((RCollection)e).invalidateLayoutDeep();
                }
            }
        }
    }

    protected void invalidateLayoutLocal() {
        RenderState renderState = this.modelNode.getRenderState();
        if (renderState != null) {
            renderState.invalidate();
        }
        this.overflowX = 0;
        this.overflowY = 0;
        this.declaredWidth = INVALID_SIZE;
        this.declaredHeight = INVALID_SIZE;
        this.lastAvailHeightForDeclared = -1;
        this.lastAvailWidthForDeclared = -1;
    }

    protected Integer getDeclaredWidth(RenderState renderState, int n) {
        Integer n2 = this.declaredWidth;
        if (n2 == INVALID_SIZE || n != this.lastAvailWidthForDeclared) {
            this.lastAvailWidthForDeclared = n;
            int n3 = this.getDeclaredWidthImpl(renderState, n);
            this.declaredWidth = n2 = n3 == -1 ? null : new Integer(n3);
        }
        return n2;
    }

    public final boolean hasDeclaredWidth() {
        Integer n = this.declaredWidth;
        if (n == INVALID_SIZE) {
            ModelNode modelNode = this.modelNode;
            if (modelNode instanceof HTMLElementImpl) {
                HTMLElementImpl hTMLElementImpl = (HTMLElementImpl)modelNode;
                AbstractCSS2Properties abstractCSS2Properties = hTMLElementImpl.getCurrentStyle();
                if (abstractCSS2Properties == null) {
                    return false;
                }
                return !Strings.isBlank(abstractCSS2Properties.getWidth());
            }
            return false;
        }
        return n != null;
    }

    private final int getDeclaredWidthImpl(RenderState renderState, int n) {
        ModelNode modelNode = this.modelNode;
        if (modelNode instanceof HTMLElementImpl) {
            HTMLElementImpl hTMLElementImpl = (HTMLElementImpl)modelNode;
            AbstractCSS2Properties abstractCSS2Properties = hTMLElementImpl.getCurrentStyle();
            if (abstractCSS2Properties == null) {
                return -1;
            }
            String string = abstractCSS2Properties.getWidth();
            if (string == null || "".equals(string)) {
                return -1;
            }
            return HtmlValues.getPixelSize(string, renderState, -1, n);
        }
        return -1;
    }

    protected Integer getDeclaredHeight(RenderState renderState, int n) {
        Integer n2 = this.declaredHeight;
        if (n2 == INVALID_SIZE || n != this.lastAvailHeightForDeclared) {
            this.lastAvailHeightForDeclared = n;
            int n3 = this.getDeclaredHeightImpl(renderState, n);
            this.declaredHeight = n2 = n3 == -1 ? null : new Integer(n3);
        }
        return n2;
    }

    protected int getDeclaredHeightImpl(RenderState renderState, int n) {
        ModelNode modelNode = this.modelNode;
        if (modelNode instanceof HTMLElementImpl) {
            HTMLElementImpl hTMLElementImpl = (HTMLElementImpl)modelNode;
            AbstractCSS2Properties abstractCSS2Properties = hTMLElementImpl.getCurrentStyle();
            if (abstractCSS2Properties == null) {
                return -1;
            }
            String string = abstractCSS2Properties.getHeight();
            if (string == null || "".equals(string)) {
                return -1;
            }
            return HtmlValues.getPixelSize(string, renderState, -1, n);
        }
        return -1;
    }

    public void paint(Graphics graphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void layout(int n, int n2, boolean bl) {
        try {
            this.doLayout(n, n2, bl);
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
        }
    }

    protected abstract void doLayout(int var1, int var2, boolean var3);

    protected final void sendGUIComponentsToParent() {
        Collection collection = this.guiComponents;
        int n = 0;
        if (collection != null) {
            RenderableContainer renderableContainer = this.container;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ++n;
                renderableContainer.addComponent((Component)iterator.next());
            }
        }
    }

    protected final void clearGUIComponents() {
        Collection collection = this.guiComponents;
        if (collection != null) {
            collection.clear();
        }
    }

    public Component addComponent(Component component) {
        HashSet<Component> hashSet = this.guiComponents;
        if (hashSet == null) {
            this.guiComponents = hashSet = new HashSet<Component>(1);
        }
        hashSet.add(component);
        return component;
    }

    public void updateAllWidgetBounds() {
        this.container.updateAllWidgetBounds();
    }

    public void updateWidgetBounds() {
        Point point = this.getGUIPoint(0, 0);
        this.updateWidgetBounds(point.x, point.y);
    }

    public Rectangle getBoundsRelativeToBlock() {
        RCollection rCollection = this;
        int n = 0;
        int n2 = 0;
        while (rCollection != null) {
            n += rCollection.getX();
            n2 += rCollection.getY();
            if (!((rCollection = rCollection.getParent()) instanceof RElement)) continue;
        }
        return new Rectangle(n, n2, this.getWidth(), this.getHeight());
    }

    protected void clearStyle(boolean bl) {
        this.borderInfo = null;
        this.borderInsets = null;
        this.borderTopColor = null;
        this.borderLeftColor = null;
        this.borderBottomColor = null;
        this.borderRightColor = null;
        this.zIndex = 0;
        this.backgroundColor = null;
        this.backgroundImage = null;
        this.lastBackgroundImageUri = null;
        this.overflowX = 4;
        this.overflowY = 4;
        if (bl) {
            Insets insets;
            Insets insets2 = this.defaultMarginInsets;
            Insets insets3 = this.defaultPaddingInsets;
            Insets insets4 = insets = insets2 == null ? null : new Insets(insets2.top, insets2.left, insets2.bottom, insets2.right);
            if (insets3 != null) {
                if (insets == null) {
                    insets = new Insets(insets3.top, insets3.left, insets3.bottom, insets3.right);
                } else {
                    insets.top += insets3.top;
                    insets.bottom += insets3.bottom;
                    insets.left += insets3.left;
                    insets.right += insets3.right;
                }
            }
            this.marginInsets = null;
            this.paddingInsets = insets;
        } else {
            this.marginInsets = this.defaultMarginInsets;
            this.paddingInsets = this.defaultPaddingInsets;
        }
    }

    protected void applyStyle(int n, int n2) {
        URL uRL;
        HTMLElementImpl hTMLElementImpl;
        Object object;
        boolean bl;
        ModelNode modelNode = this.modelNode;
        if (modelNode instanceof HTMLDocumentImpl) {
            bl = true;
            object = (HTMLDocumentImpl)modelNode;
            hTMLElementImpl = (HTMLElementImpl)((HTMLDocumentImpl)object).getBody();
        } else {
            bl = false;
            hTMLElementImpl = (HTMLElementImpl)modelNode;
        }
        if (hTMLElementImpl == null) {
            this.clearStyle(bl);
            return;
        }
        object = hTMLElementImpl.getRenderState();
        if (object == null) {
            throw new IllegalStateException("Element without render state: " + hTMLElementImpl + "; parent=" + hTMLElementImpl.getParentNode());
        }
        BackgroundInfo backgroundInfo = object.getBackgroundInfo();
        this.backgroundColor = backgroundInfo == null ? null : backgroundInfo.backgroundColor;
        URL uRL2 = uRL = backgroundInfo == null ? null : backgroundInfo.backgroundImage;
        if (uRL == null) {
            this.backgroundImage = null;
            this.lastBackgroundImageUri = null;
        } else if (!uRL.equals(this.lastBackgroundImageUri)) {
            this.lastBackgroundImageUri = uRL;
            this.loadBackgroundImage(uRL);
        }
        AbstractCSS2Properties abstractCSS2Properties = hTMLElementImpl.getCurrentStyle();
        if (abstractCSS2Properties == null) {
            this.clearStyle(bl);
        } else {
            Object object2;
            Insets insets;
            Insets insets2;
            Insets insets3;
            BorderInfo borderInfo;
            this.borderInfo = borderInfo = object.getBorderInfo();
            HtmlInsets htmlInsets = borderInfo == null ? null : borderInfo.insets;
            HtmlInsets htmlInsets2 = object.getMarginInsets();
            HtmlInsets htmlInsets3 = object.getPaddingInsets();
            Insets insets4 = this.defaultMarginInsets;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (insets4 != null) {
                n3 = insets4.left;
                n4 = insets4.right;
                n5 = insets4.top;
                n6 = insets4.bottom;
            }
            Insets insets5 = this.defaultPaddingInsets;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            if (insets5 != null) {
                n7 = insets5.left;
                n8 = insets5.right;
                n9 = insets5.top;
                n10 = insets5.bottom;
            }
            Insets insets6 = insets3 = htmlInsets == null ? null : htmlInsets.getAWTInsets(0, 0, 0, 0, n, n2, 0, 0);
            if (insets3 == null) {
                insets3 = RBlockViewport.ZERO_INSETS;
            }
            Insets insets7 = insets2 = htmlInsets3 == null ? insets5 : htmlInsets3.getAWTInsets(n9, n7, n10, n8, n, n2, 0, 0);
            if (insets2 == null) {
                insets2 = RBlockViewport.ZERO_INSETS;
            }
            Insets insets8 = insets = htmlInsets2 == null ? insets4 : htmlInsets2.getAWTInsets(n5, n3, n6, n4, n, n2, 0, 0);
            if (insets == null) {
                insets = RBlockViewport.ZERO_INSETS;
            }
            int n11 = n - insets2.left - insets2.right - insets3.left - insets3.right - insets.left - insets.right;
            int n12 = n2 - insets2.top - insets2.bottom - insets3.top - insets3.bottom - insets.top - insets.bottom;
            Integer n13 = this.getDeclaredWidth((RenderState)object, n11);
            Integer n14 = this.getDeclaredHeight((RenderState)object, n12);
            int n15 = 0;
            int n16 = 0;
            if (n13 != null) {
                n15 = (n - n13 - (insets3 == null ? 0 : insets3.left - insets3.right) - (insets2 == null ? 0 : insets2.left - insets2.right)) / 2;
            }
            if (n14 != null) {
                n16 = (n2 - n14 - (insets3 == null ? 0 : insets3.top - insets3.bottom) - (insets2 == null ? 0 : insets2.top - insets2.bottom)) / 2;
            }
            this.borderInsets = insets3;
            if (bl) {
                Object object3 = n15 == 0 && n16 == 0 ? insets : (object2 = htmlInsets2 == null ? insets4 : htmlInsets2.getAWTInsets(n5, n3, n6, n4, n, n2, n15, n16));
                if (insets2 == null) {
                    insets2 = RBlockViewport.ZERO_INSETS;
                }
                if (object2 == null) {
                    object2 = RBlockViewport.ZERO_INSETS;
                }
                this.marginInsets = null;
                this.paddingInsets = new Insets(insets2.top + ((Insets)object2).top, insets2.left + ((Insets)object2).left, insets2.bottom + ((Insets)object2).bottom, insets2.right + ((Insets)object2).right);
            } else {
                this.paddingInsets = insets2;
                Insets insets9 = n15 == 0 && n16 == 0 ? insets : (this.marginInsets = htmlInsets2 == null ? insets4 : htmlInsets2.getAWTInsets(n5, n3, n6, n4, n, n2, n15, n16));
            }
            if (borderInfo != null) {
                this.borderTopColor = borderInfo.topColor;
                this.borderLeftColor = borderInfo.leftColor;
                this.borderBottomColor = borderInfo.bottomColor;
                this.borderRightColor = borderInfo.rightColor;
            } else {
                this.borderTopColor = null;
                this.borderLeftColor = null;
                this.borderBottomColor = null;
                this.borderRightColor = null;
            }
            object2 = abstractCSS2Properties.getZIndex();
            if (object2 != null) {
                try {
                    this.zIndex = Integer.parseInt((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.log(Level.WARNING, "Unable to parse z-index [" + (String)object2 + "] in element " + this.modelNode + ".", numberFormatException);
                    this.zIndex = 0;
                }
            } else {
                this.zIndex = 0;
            }
            this.overflowX = object.getOverflowX();
            this.overflowY = object.getOverflowY();
        }
    }

    protected void loadBackgroundImage(final URL uRL) {
        ModelNode modelNode = this.modelNode;
        UserAgentContext userAgentContext = this.userAgentContext;
        if (userAgentContext != null) {
            final HttpRequest httpRequest = userAgentContext.createHttpRequest();
            httpRequest.addReadyStateChangeListener(new ReadyStateChangeListener(){

                public void readyStateChanged() {
                    int n;
                    int n2 = httpRequest.getReadyState();
                    if (n2 == 4 && ((n = httpRequest.getStatus()) == 200 || n == 0)) {
                        Image image;
                        BaseElementRenderable.this.backgroundImage = image = httpRequest.getResponseImage();
                        int n3 = image.getWidth(BaseElementRenderable.this);
                        int n4 = image.getHeight(BaseElementRenderable.this);
                        if (n3 != -1 && n4 != -1) {
                            BaseElementRenderable.this.repaint();
                        }
                    }
                }
            });
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                try {
                    httpRequest.open("GET", uRL);
                    httpRequest.send(null);
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "loadBackgroundImage()", iOException);
                }
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            httpRequest.open("GET", uRL);
                            httpRequest.send(null);
                        }
                        catch (IOException iOException) {
                            BaseBoundableRenderable.logger.log(Level.WARNING, "loadBackgroundImage()", iOException);
                        }
                        return null;
                    }
                });
            }
        }
    }

    public int getZIndex() {
        return this.zIndex;
    }

    private Color getBorderTopColor() {
        Color color = this.borderTopColor;
        return color == null ? Color.black : color;
    }

    private Color getBorderLeftColor() {
        Color color = this.borderLeftColor;
        return color == null ? Color.black : color;
    }

    private Color getBorderBottomColor() {
        Color color = this.borderBottomColor;
        return color == null ? Color.black : color;
    }

    private Color getBorderRightColor() {
        Color color = this.borderRightColor;
        return color == null ? Color.black : color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void prePaint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Insets insets;
        int n6 = this.width;
        int n7 = this.height;
        int n8 = n6;
        int n9 = n7;
        int n10 = 0;
        int n11 = 0;
        ModelNode modelNode = this.modelNode;
        RenderState renderState = modelNode.getRenderState();
        Insets insets2 = this.marginInsets;
        if (insets2 != null) {
            n8 -= insets2.left + insets2.right;
            n9 -= insets2.top + insets2.bottom;
            n10 += insets2.left;
            n11 += insets2.top;
        }
        if ((insets = this.borderInsets) != null) {
            int n12 = insets.left;
            n5 = n10 + n12;
            int n13 = insets.top;
            n4 = n11 + n13;
            int n14 = insets.right;
            int n15 = n8 - (n12 + n14);
            int n16 = insets.bottom;
            n3 = n9 - (n13 + n16);
            Rectangle rectangle = new Rectangle(n5, n4, n15, n3);
            Rectangle rectangle2 = graphics.getClipBounds();
            if (!rectangle.contains(rectangle2)) {
                int n17;
                int n18;
                int n19;
                BorderInfo borderInfo = this.borderInfo;
                if (n13 > 0) {
                    graphics.setColor(this.getBorderTopColor());
                    n2 = borderInfo == null ? 4 : borderInfo.topStyle;
                    for (n = 0; n < n13; ++n) {
                        n19 = n * n12 / n13;
                        n18 = n * n14 / n13;
                        if (n2 == 3) {
                            GUITasks.drawDashed(graphics, n10 + n19, n11 + n, n10 + n8 - n18 - 1, n11 + n, 10 + n13, 6);
                            continue;
                        }
                        graphics.drawLine(n10 + n19, n11 + n, n10 + n8 - n18 - 1, n11 + n);
                    }
                }
                if (n14 > 0) {
                    n2 = borderInfo == null ? 4 : borderInfo.rightStyle;
                    graphics.setColor(this.getBorderRightColor());
                    n = n10 + n8 - 1;
                    for (n19 = 0; n19 < n14; ++n19) {
                        n18 = n19 * n13 / n14;
                        n17 = n19 * n16 / n14;
                        if (n2 == 3) {
                            GUITasks.drawDashed(graphics, n - n19, n11 + n18, n - n19, n11 + n9 - n17 - 1, 10 + n14, 6);
                            continue;
                        }
                        graphics.drawLine(n - n19, n11 + n18, n - n19, n11 + n9 - n17 - 1);
                    }
                }
                if (n16 > 0) {
                    n2 = borderInfo == null ? 4 : borderInfo.bottomStyle;
                    graphics.setColor(this.getBorderBottomColor());
                    n = n11 + n9 - 1;
                    for (n19 = 0; n19 < n16; ++n19) {
                        n18 = n19 * n12 / n16;
                        n17 = n19 * n14 / n16;
                        if (n2 == 3) {
                            GUITasks.drawDashed(graphics, n10 + n18, n - n19, n10 + n8 - n17 - 1, n - n19, 10 + n16, 6);
                            continue;
                        }
                        graphics.drawLine(n10 + n18, n - n19, n10 + n8 - n17 - 1, n - n19);
                    }
                }
                if (n12 > 0) {
                    n2 = borderInfo == null ? 4 : borderInfo.leftStyle;
                    graphics.setColor(this.getBorderLeftColor());
                    for (n = 0; n < n12; ++n) {
                        n19 = n * n13 / n12;
                        n18 = n * n16 / n12;
                        if (n2 == 3) {
                            GUITasks.drawDashed(graphics, n10 + n, n11 + n19, n10 + n, n11 + n9 - n18 - 1, 10 + n12, 6);
                            continue;
                        }
                        graphics.drawLine(n10 + n, n11 + n19, n10 + n, n11 + n9 - n18 - 1);
                    }
                }
            }
            n8 = n15;
            n9 = n3;
            n10 = n5;
            n11 = n4;
        }
        Graphics graphics2 = graphics.create(n10, n11, n8, n9);
        try {
            Rectangle rectangle = null;
            if (modelNode == null) return;
            Color color = this.backgroundColor;
            if (color != null && color.getAlpha() > 0) {
                graphics2.setColor(color);
                rectangle = graphics2.getClipBounds();
                graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            BackgroundInfo backgroundInfo = renderState == null ? null : renderState.getBackgroundInfo();
            Image image = this.backgroundImage;
            if (image == null) return;
            if (rectangle == null) {
                rectangle = graphics2.getClipBounds();
            }
            n3 = image.getWidth(this);
            n5 = image.getHeight(this);
            if (n3 == -1 || n5 == -1) return;
            switch (backgroundInfo == null ? 0 : backgroundInfo.backgroundRepeat) {
                case 1: {
                    n4 = backgroundInfo.backgroundXPositionAbsolute ? backgroundInfo.backgroundXPosition : backgroundInfo.backgroundXPosition * (n8 - n3) / 100;
                    int n20 = backgroundInfo.backgroundYPositionAbsolute ? backgroundInfo.backgroundYPosition : backgroundInfo.backgroundYPosition * (n9 - n5) / 100;
                    graphics2.drawImage(image, n4, n20, n3, n5, this);
                    return;
                }
                case 2: {
                    n4 = backgroundInfo.backgroundYPositionAbsolute ? backgroundInfo.backgroundYPosition : backgroundInfo.backgroundYPosition * (n9 - n5) / 100;
                    int n21 = rectangle.x + rectangle.width;
                    for (int i = rectangle.x / n3 * n3; i < n21; i += n3) {
                        graphics2.drawImage(image, i, n4, n3, n5, this);
                    }
                    return;
                }
                case 3: {
                    n4 = backgroundInfo.backgroundXPositionAbsolute ? backgroundInfo.backgroundXPosition : backgroundInfo.backgroundXPosition * (n8 - n3) / 100;
                    int n22 = rectangle.y + rectangle.height;
                    for (int i = rectangle.y / n5 * n5; i < n22; i += n5) {
                        graphics2.drawImage(image, n4, i, n3, n5, this);
                    }
                    return;
                }
                default: {
                    n4 = rectangle.x / n3 * n3;
                    int n23 = rectangle.y / n5 * n5;
                    int n24 = rectangle.x + rectangle.width;
                    int n25 = rectangle.y + rectangle.height;
                    for (n2 = n4; n2 < n24; n2 += n3) {
                        for (n = n23; n < n25; n += n5) {
                            graphics2.drawImage(image, n2, n, n3, n5, this);
                        }
                    }
                    return;
                }
            }
        }
        finally {
            graphics2.dispose();
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0 || (n & 0x10) != 0) {
            this.repaint();
        }
        return true;
    }

    public Insets getInsets(boolean bl, boolean bl2) {
        RenderState renderState = this.modelNode.getRenderState();
        Insets insets = this.marginInsets;
        Insets insets2 = this.borderInsets;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (insets != null) {
            n += insets.top;
            n3 += insets.left;
            n2 += insets.bottom;
            n4 += insets.right;
        }
        if (insets2 != null) {
            n += insets2.top;
            n3 += insets2.left;
            n2 += insets2.bottom;
            n4 += insets2.right;
        }
        if (bl) {
            n2 += 16;
        }
        if (bl2) {
            n4 += 16;
        }
        return new Insets(n, n3, n2, n4);
    }

    protected final void sendDelayedPairsToParent() {
        Collection collection = this.delayedPairs;
        if (collection != null) {
            RenderableContainer renderableContainer = this.container;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DelayedPair delayedPair = (DelayedPair)iterator.next();
                if (delayedPair.targetParent == this) continue;
                renderableContainer.addDelayedPair(delayedPair);
            }
        }
    }

    public final void clearDelayedPairs() {
        Collection collection = this.delayedPairs;
        if (collection != null) {
            collection.clear();
        }
    }

    public final Collection getDelayedPairs() {
        return this.delayedPairs;
    }

    public void addDelayedPair(DelayedPair delayedPair) {
        LinkedList<DelayedPair> linkedList = this.delayedPairs;
        if (linkedList == null) {
            this.delayedPairs = linkedList = new LinkedList<DelayedPair>();
        }
        linkedList.add(delayedPair);
    }

    public RenderableContainer getParentContainer() {
        return this.container;
    }

    public boolean isContainedByNode() {
        return true;
    }

    public int getCollapsibleMarginBottom() {
        FontMetrics fontMetrics;
        int n;
        Object object;
        Insets insets = this.paddingInsets;
        int n2 = insets != null && insets.bottom > 0 ? 0 : ((object = this.borderInsets) != null && ((Insets)object).bottom > 0 ? 0 : this.getMarginBottom());
        if (this.isMarginBoundary() && (object = this.modelNode.getRenderState()) != null && (n = (fontMetrics = object.getFontMetrics()).getHeight()) > n2) {
            n2 = n;
        }
        return n2;
    }

    protected boolean isMarginBoundary() {
        return this.overflowY != 4 && this.overflowX != 0 || this.modelNode instanceof HTMLDocumentImpl;
    }

    public int getCollapsibleMarginTop() {
        FontMetrics fontMetrics;
        int n;
        Object object;
        Insets insets = this.paddingInsets;
        int n2 = insets != null && insets.top > 0 ? 0 : ((object = this.borderInsets) != null && ((Insets)object).top > 0 ? 0 : this.getMarginTop());
        if (this.isMarginBoundary() && (object = this.modelNode.getRenderState()) != null && (n = (fontMetrics = object.getFontMetrics()).getHeight()) > n2) {
            n2 = n;
        }
        return n2;
    }

    public int getMarginBottom() {
        Insets insets = this.marginInsets;
        return insets == null ? 0 : insets.bottom;
    }

    public int getMarginLeft() {
        Insets insets = this.marginInsets;
        return insets == null ? 0 : insets.left;
    }

    public int getMarginRight() {
        Insets insets = this.marginInsets;
        return insets == null ? 0 : insets.right;
    }

    public int getMarginTop() {
        Insets insets = this.marginInsets;
        return insets == null ? 0 : insets.top;
    }
}

