/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RenderableContainer;

abstract class BaseBoundableRenderable
extends BaseRenderable
implements BoundableRenderable {
    protected static final Logger logger = Logger.getLogger(BaseBoundableRenderable.class.getName());
    protected static final Color SELECTION_COLOR = Color.BLUE;
    protected static final Color SELECTION_XOR = Color.LIGHT_GRAY;
    protected final RenderableContainer container;
    protected final ModelNode modelNode;
    public int x;
    public int y;
    public int width;
    public int height;
    protected boolean layoutUpTreeCanBeInvalidated = true;
    protected RCollection parent;
    protected RCollection originalParent;

    public void markLayoutValid() {
        this.layoutUpTreeCanBeInvalidated = true;
    }

    public BaseBoundableRenderable(RenderableContainer renderableContainer, ModelNode modelNode) {
        this.container = renderableContainer;
        this.modelNode = modelNode;
    }

    public Point getGUIPoint(int n, int n2) {
        RCollection rCollection = this.getParent();
        if (rCollection instanceof BoundableRenderable) {
            return ((BoundableRenderable)rCollection).getGUIPoint(n + this.x, n2 + this.y);
        }
        if (rCollection == null) {
            return this.container.getGUIPoint(n + this.x, n2 + this.y);
        }
        throw new IllegalStateException("parent=" + rCollection);
    }

    public Point getRenderablePoint(int n, int n2) {
        RCollection rCollection = this.getParent();
        if (rCollection instanceof BoundableRenderable) {
            return ((BoundableRenderable)rCollection).getRenderablePoint(n - this.x, n2 - this.y);
        }
        if (rCollection == null) {
            return new Point(n - this.x, n2 - this.y);
        }
        throw new IllegalStateException("parent=" + rCollection);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean contains(int n, int n2) {
        return n >= this.x && n2 >= this.y && n < this.x + this.width && n2 < this.y + this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public ModelNode getModelNode() {
        return this.modelNode;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setOrigin(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    protected abstract void invalidateLayoutLocal();

    public final void invalidateLayoutUpTree() {
        if (this.layoutUpTreeCanBeInvalidated) {
            this.layoutUpTreeCanBeInvalidated = false;
            this.invalidateLayoutLocal();
            RCollection rCollection = this.originalParent;
            if (rCollection == null) {
                rCollection = this.parent;
                if (rCollection == null) {
                    RenderableContainer renderableContainer = this.container;
                    if (renderableContainer != null) {
                        renderableContainer.invalidateLayoutUpTree();
                    }
                } else {
                    rCollection.invalidateLayoutUpTree();
                }
            } else {
                rCollection.invalidateLayoutUpTree();
            }
        }
    }

    protected boolean isValid() {
        return this.layoutUpTreeCanBeInvalidated;
    }

    private final void relayoutImpl(boolean bl, boolean bl2) {
        RCollection rCollection;
        if (bl2 && !this.layoutUpTreeCanBeInvalidated) {
            return;
        }
        if (bl) {
            this.invalidateLayoutUpTree();
        }
        if ((rCollection = this.parent) instanceof BaseBoundableRenderable) {
            ((BaseBoundableRenderable)((Object)rCollection)).relayoutImpl(false, false);
        } else if (rCollection == null) {
            this.container.relayout();
        } else if (logger.isLoggable(Level.INFO)) {
            logger.warning("relayout(): Don't know how to relayout " + this + ", parent being " + rCollection);
        }
    }

    public void relayout() {
        if (EventQueue.isDispatchThread()) {
            this.relayoutImpl(true, false);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BaseBoundableRenderable.this.relayoutImpl(true, false);
                }
            });
        }
    }

    public void relayoutIfValid() {
        if (EventQueue.isDispatchThread()) {
            this.relayoutImpl(true, true);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BaseBoundableRenderable.this.relayoutImpl(true, true);
                }
            });
        }
    }

    public void setParent(RCollection rCollection) {
        this.parent = rCollection;
    }

    public RCollection getParent() {
        return this.parent;
    }

    public void setOriginalParent(RCollection rCollection) {
        this.originalParent = rCollection;
    }

    public RCollection getOriginalParent() {
        return this.originalParent;
    }

    public RCollection getOriginalOrCurrentParent() {
        RCollection rCollection = this.originalParent;
        if (rCollection == null) {
            return this.parent;
        }
        return rCollection;
    }

    public void repaint(int n, int n2, int n3, int n4) {
        RCollection rCollection = this.parent;
        if (rCollection instanceof BoundableRenderable) {
            ((BoundableRenderable)rCollection).repaint(n + this.x, n2 + this.y, n3, n4);
        } else if (rCollection == null) {
            this.container.repaint(n, n2, n3, n4);
        } else if (logger.isLoggable(Level.INFO)) {
            logger.warning("repaint(): Don't know how to repaint " + this + ", parent being " + rCollection);
        }
    }

    public void repaint() {
        this.repaint(0, 0, this.width, this.height);
    }

    public Color getBlockBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintTranslated(Graphics graphics) {
        int n = this.x;
        int n2 = this.y;
        graphics.translate(n, n2);
        try {
            this.paint(graphics);
        }
        finally {
            graphics.translate(-n, -n2);
        }
    }

    protected final Point translateDescendentPoint(BoundableRenderable boundableRenderable, int n, int n2) {
        while (boundableRenderable != this) {
            if (boundableRenderable == null) {
                throw new IllegalStateException("Not descendent");
            }
            n += boundableRenderable.getX();
            n2 += boundableRenderable.getY();
            boundableRenderable = boundableRenderable.getParent();
        }
        return new Point(n, n2);
    }

    public void onMouseOut(MouseEvent mouseEvent, int n, int n2, ModelNode modelNode) {
        if (this.isContainedByNode()) {
            HtmlController.getInstance().onMouseOut(this.modelNode, mouseEvent, n, n2, modelNode);
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent, int n, int n2, boolean bl, ModelNode modelNode) {
        if (bl && this.isContainedByNode()) {
            HtmlController.getInstance().onMouseOver(this.modelNode, mouseEvent, n, n2, modelNode);
        }
    }

    public Point getOrigin() {
        return new Point(this.x, this.y);
    }

    public Point getOriginRelativeTo(RCollection rCollection) {
        int n = this.x;
        int n2 = this.y;
        RCollection rCollection2 = this.parent;
        while (true) {
            if (rCollection2 == null) {
                throw new IllegalArgumentException("Not an ancestor: " + rCollection);
            }
            if (rCollection2 == rCollection) {
                return new Point(n, n2);
            }
            n += rCollection2.getX();
            n2 += rCollection2.getY();
            rCollection2 = rCollection2.getParent();
        }
    }
}

