/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.js.Window;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.w3c.dom.Document;

public class Location
extends AbstractScriptableDelegate {
    private static final Logger logger = Logger.getLogger(Location.class.getName());
    private final Window window;
    private String target;

    Location(Window window) {
        this.window = window;
    }

    private URL getURL() {
        URL uRL;
        try {
            Document document = this.window.getDocumentNode();
            uRL = document == null ? null : new URL(document.getDocumentURI());
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    public String getHash() {
        URL uRL = this.getURL();
        return uRL == null ? null : uRL.getRef();
    }

    public String getHost() {
        URL uRL = this.getURL();
        if (uRL == null) {
            return null;
        }
        return uRL.getHost() + (uRL.getPort() == -1 ? "" : ":" + uRL.getPort());
    }

    public String getHostname() {
        URL uRL = this.getURL();
        if (uRL == null) {
            return null;
        }
        return uRL.getHost();
    }

    public String getPathname() {
        URL uRL = this.getURL();
        return uRL == null ? null : uRL.getPath();
    }

    public String getPort() {
        URL uRL = this.getURL();
        if (uRL == null) {
            return null;
        }
        int n = uRL.getPort();
        return n == -1 ? null : String.valueOf(n);
    }

    public String getProtocol() {
        URL uRL = this.getURL();
        if (uRL == null) {
            return null;
        }
        return uRL.getProtocol() + ":";
    }

    public String getSearch() {
        URL uRL = this.getURL();
        String string = uRL == null ? null : uRL.getQuery();
        return string == null ? "" : "?" + string;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getHref() {
        Document document = this.window.getDocumentNode();
        return document == null ? null : document.getDocumentURI();
    }

    public void setHref(String string) {
        HtmlRendererContext htmlRendererContext = this.window.getHtmlRendererContext();
        if (htmlRendererContext != null) {
            try {
                URL uRL;
                Document document = this.window.getDocumentNode();
                if (document instanceof HTMLDocumentImpl) {
                    HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)document;
                    uRL = hTMLDocumentImpl.getFullURL(string);
                } else {
                    uRL = new URL(string);
                }
                htmlRendererContext.navigate(uRL, this.target);
            }
            catch (MalformedURLException malformedURLException) {
                logger.log(Level.WARNING, "setHref(): Malformed location: [" + string + "].", malformedURLException);
            }
        }
    }

    public void reload() {
        Document document = this.window.getDocumentNode();
        if (document instanceof HTMLDocumentImpl) {
            HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)document;
            HtmlRendererContext htmlRendererContext = hTMLDocumentImpl.getHtmlRendererContext();
            if (htmlRendererContext != null) {
                htmlRendererContext.reload();
            } else {
                hTMLDocumentImpl.warn("reload(): No renderer context in Location's document.");
            }
        }
    }

    public void replace(String string) {
        this.setHref(string);
    }

    public String toString() {
        return this.getHref();
    }
}

