/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.io;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;

public class WritableLineReader
extends LineNumberReader {
    private final Reader delegate;
    private StringBuffer writeBuffer = null;

    public WritableLineReader(Reader reader, int n) {
        super(reader, n);
        this.delegate = reader;
    }

    public WritableLineReader(Reader reader) {
        super(reader);
        this.delegate = reader;
    }

    public int read() throws IOException {
        StringBuffer stringBuffer = this.writeBuffer;
        if (stringBuffer != null && stringBuffer.length() > 0) {
            char c = stringBuffer.charAt(0);
            stringBuffer.deleteCharAt(0);
            if (stringBuffer.length() == 0) {
                this.writeBuffer = null;
            }
            return c;
        }
        return super.read();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        StringBuffer stringBuffer = this.writeBuffer;
        if (stringBuffer != null && stringBuffer.length() > 0) {
            int n3 = Math.min(stringBuffer.length(), n2);
            stringBuffer.getChars(0, n3, cArray, n);
            stringBuffer.delete(0, n3);
            if (stringBuffer.length() == 0) {
                this.writeBuffer = null;
            }
            return n3;
        }
        return super.read(cArray, n, n2);
    }

    public boolean ready() throws IOException {
        StringBuffer stringBuffer = this.writeBuffer;
        if (stringBuffer != null && stringBuffer.length() > 0) {
            return true;
        }
        return super.ready();
    }

    public void close() throws IOException {
        this.writeBuffer = null;
        super.close();
    }

    public void write(String string) throws IOException {
        StringBuffer stringBuffer = this.writeBuffer;
        if (stringBuffer == null) {
            this.writeBuffer = stringBuffer = new StringBuffer();
        }
        stringBuffer.append(string);
    }
}

