/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.DocumentNotificationListener;
import org.lobobrowser.html.domimpl.ElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.gui.DocumentNotification;
import org.lobobrowser.html.gui.FrameSetPanel;
import org.lobobrowser.html.gui.HtmlBlockPanel;
import org.lobobrowser.html.gui.SelectionChangeEvent;
import org.lobobrowser.html.gui.SelectionChangeListener;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.NodeRenderer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.util.EventDispatch2;
import org.lobobrowser.util.gui.WrapperLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html2.HTMLFrameSetElement;
import org.xml.sax.SAXException;

public class HtmlPanel
extends JComponent
implements FrameContext {
    private final EventDispatch2 selectionDispatch = new SelectionDispatch();
    private final Timer notificationTimer;
    private final DocumentNotificationListener notificationListener;
    private final Runnable notificationImmediateAction;
    private static final int NOTIF_TIMER_DELAY = 300;
    private volatile boolean isFrameSet = false;
    private volatile NodeRenderer nodeRenderer = null;
    private volatile NodeImpl rootNode;
    private volatile int preferredWidth = -1;
    private volatile Insets defaultMarginInsets = new Insets(8, 8, 8, 8);
    private volatile int defaultOverflowX = 2;
    private volatile int defaultOverflowY = 1;
    protected volatile HtmlBlockPanel htmlBlockPanel;
    protected volatile FrameSetPanel frameSetPanel;
    private ArrayList notifications = new ArrayList(1);

    public HtmlPanel() {
        this.setLayout(WrapperLayout.getInstance());
        this.setOpaque(false);
        this.notificationTimer = new Timer(300, new NotificationTimerAction());
        this.notificationTimer.setRepeats(false);
        this.notificationListener = new LocalDocumentNotificationListener();
        this.notificationImmediateAction = new Runnable(){

            public void run() {
                HtmlPanel.this.processNotifications();
            }
        };
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel != null) {
            htmlBlockPanel.setPreferredWidth(n);
        }
    }

    public void scrollTo(Rectangle rectangle, boolean bl, boolean bl2) {
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel != null) {
            htmlBlockPanel.scrollTo(rectangle, bl, bl2);
        }
    }

    public void scrollTo(Node node) {
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel != null) {
            htmlBlockPanel.scrollTo(node);
        }
    }

    public BoundableRenderable getBlockRenderable() {
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        return htmlBlockPanel == null ? null : htmlBlockPanel.getRootRenderable();
    }

    public FrameSetPanel getFrameSetPanel() {
        int n = this.getComponentCount();
        if (n == 0) {
            return null;
        }
        Component component = this.getComponent(0);
        if (component instanceof FrameSetPanel) {
            return (FrameSetPanel)component;
        }
        return null;
    }

    private void setUpAsBlock(UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext) {
        HtmlBlockPanel htmlBlockPanel = this.createHtmlBlockPanel(userAgentContext, htmlRendererContext);
        htmlBlockPanel.setPreferredWidth(this.preferredWidth);
        htmlBlockPanel.setDefaultMarginInsets(this.defaultMarginInsets);
        htmlBlockPanel.setDefaultOverflowX(this.defaultOverflowX);
        htmlBlockPanel.setDefaultOverflowY(this.defaultOverflowY);
        this.htmlBlockPanel = htmlBlockPanel;
        this.frameSetPanel = null;
        this.removeAll();
        this.add(htmlBlockPanel);
        this.nodeRenderer = htmlBlockPanel;
    }

    private void setUpFrameSet(NodeImpl nodeImpl) {
        FrameSetPanel frameSetPanel;
        this.isFrameSet = true;
        this.htmlBlockPanel = null;
        this.frameSetPanel = frameSetPanel = this.createFrameSetPanel();
        this.nodeRenderer = frameSetPanel;
        this.removeAll();
        this.add(frameSetPanel);
        frameSetPanel.setRootNode(nodeImpl);
    }

    protected HtmlBlockPanel createHtmlBlockPanel(UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext) {
        return new HtmlBlockPanel(Color.WHITE, true, userAgentContext, htmlRendererContext, this);
    }

    protected FrameSetPanel createFrameSetPanel() {
        return new FrameSetPanel();
    }

    public void scroll(final int n, final int n2) {
        if (EventQueue.isDispatchThread()) {
            this.scrollImpl(n, n2);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    HtmlPanel.this.scrollImpl(n, n2);
                }
            });
        }
    }

    public void scrollBy(final int n, final int n2) {
        if (EventQueue.isDispatchThread()) {
            this.scrollByImpl(n, n2);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    HtmlPanel.this.scrollByImpl(n, n2);
                }
            });
        }
    }

    private void scrollImpl(int n, int n2) {
        this.scrollTo(new Rectangle(n, n2, 16, 16), false, false);
    }

    private void scrollByImpl(int n, int n2) {
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel != null) {
            htmlBlockPanel.scrollBy(n, n2);
        }
    }

    public void clearDocument() {
        if (EventQueue.isDispatchThread()) {
            this.clearDocumentImpl();
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    HtmlPanel.this.clearDocumentImpl();
                }
            });
        }
    }

    private void clearDocumentImpl() {
        NodeRenderer nodeRenderer;
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.rootNode;
        if (hTMLDocumentImpl != null) {
            hTMLDocumentImpl.removeDocumentNotificationListener(this.notificationListener);
        }
        if ((nodeRenderer = this.nodeRenderer) != null) {
            nodeRenderer.setRootNode(null);
        }
        this.rootNode = null;
        this.htmlBlockPanel = null;
        this.nodeRenderer = null;
        this.isFrameSet = false;
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    public void setDocument(final Document document, final HtmlRendererContext htmlRendererContext) {
        if (EventQueue.isDispatchThread()) {
            this.setDocumentImpl(document, htmlRendererContext);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    HtmlPanel.this.setDocumentImpl(document, htmlRendererContext);
                }
            });
        }
    }

    public void scrollToElement(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.scrollToElementImpl(string);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    HtmlPanel.this.scrollToElementImpl(string);
                }
            });
        }
    }

    private void scrollToElementImpl(String string) {
        HTMLDocumentImpl hTMLDocumentImpl;
        Element element;
        NodeImpl nodeImpl = this.rootNode;
        if (nodeImpl instanceof HTMLDocumentImpl && (element = (hTMLDocumentImpl = (HTMLDocumentImpl)nodeImpl).getElementById(string)) != null) {
            this.scrollTo(element);
        }
    }

    private void setDocumentImpl(Document document, HtmlRendererContext htmlRendererContext) {
        NodeRenderer nodeRenderer;
        boolean bl;
        if (!(document instanceof HTMLDocumentImpl)) {
            throw new IllegalArgumentException("Only nodes of type HTMLDocumentImpl are currently supported. Use DocumentBuilderImpl.");
        }
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.rootNode;
        if (hTMLDocumentImpl != null) {
            hTMLDocumentImpl.removeDocumentNotificationListener(this.notificationListener);
        }
        HTMLDocumentImpl hTMLDocumentImpl2 = (HTMLDocumentImpl)document;
        hTMLDocumentImpl2.addDocumentNotificationListener(this.notificationListener);
        this.rootNode = hTMLDocumentImpl2;
        NodeImpl nodeImpl = this.getFrameSetRootNode(hTMLDocumentImpl2);
        boolean bl2 = bl = nodeImpl != null;
        if (bl != this.isFrameSet || this.getComponentCount() == 0) {
            this.isFrameSet = bl;
            if (bl) {
                this.setUpFrameSet(nodeImpl);
            } else {
                this.setUpAsBlock(htmlRendererContext.getUserAgentContext(), htmlRendererContext);
            }
        }
        if ((nodeRenderer = this.nodeRenderer) != null) {
            if (bl) {
                nodeRenderer.setRootNode(nodeImpl);
            } else {
                nodeRenderer.setRootNode(hTMLDocumentImpl2);
            }
        } else {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHtml(String string, String string2, HtmlRendererContext htmlRendererContext) {
        try {
            DocumentBuilderImpl documentBuilderImpl = new DocumentBuilderImpl(htmlRendererContext.getUserAgentContext(), htmlRendererContext);
            StringReader stringReader = new StringReader(string);
            try {
                InputSourceImpl inputSourceImpl = new InputSourceImpl(stringReader, string2);
                Document document = documentBuilderImpl.parse(inputSourceImpl);
                this.setDocument(document, htmlRendererContext);
            }
            finally {
                ((Reader)stringReader).close();
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unexpected condition.", iOException);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException("Unexpected condition.", sAXException);
        }
    }

    public NodeImpl getRootNode() {
        return this.rootNode;
    }

    private boolean resetIfFrameSet() {
        boolean bl;
        NodeImpl nodeImpl = this.rootNode;
        NodeImpl nodeImpl2 = this.getFrameSetRootNode(nodeImpl);
        boolean bl2 = bl = nodeImpl2 != null;
        if (bl != this.isFrameSet || this.getComponentCount() == 0) {
            this.isFrameSet = bl;
            if (bl) {
                this.setUpFrameSet(nodeImpl2);
                NodeRenderer nodeRenderer = this.nodeRenderer;
                nodeRenderer.setRootNode(nodeImpl2);
                this.validate();
                this.repaint();
                return true;
            }
        }
        return false;
    }

    private NodeImpl getFrameSetRootNode(NodeImpl nodeImpl) {
        if (nodeImpl instanceof Document) {
            ElementImpl elementImpl = (ElementImpl)((Document)((Object)nodeImpl)).getDocumentElement();
            if (elementImpl != null && "HTML".equalsIgnoreCase(elementImpl.getTagName())) {
                return this.getFrameSet(elementImpl);
            }
            return this.getFrameSet(nodeImpl);
        }
        return null;
    }

    private NodeImpl getFrameSet(NodeImpl nodeImpl) {
        NodeImpl[] nodeImplArray = nodeImpl.getChildrenArray();
        if (nodeImplArray == null) {
            return null;
        }
        int n = nodeImplArray.length;
        NodeImpl nodeImpl2 = null;
        for (int i = 0; i < n; ++i) {
            String string;
            NodeImpl nodeImpl3 = nodeImplArray[i];
            if (nodeImpl3 instanceof Text || !(nodeImpl3 instanceof ElementImpl) || "HEAD".equalsIgnoreCase(string = nodeImpl3.getNodeName()) || "NOFRAMES".equalsIgnoreCase(string) || "TITLE".equalsIgnoreCase(string) || "META".equalsIgnoreCase(string) || "SCRIPT".equalsIgnoreCase(string) || "NOSCRIPT".equalsIgnoreCase(string)) continue;
            if ("FRAMESET".equalsIgnoreCase(string)) {
                nodeImpl2 = nodeImpl3;
                break;
            }
            if (!this.hasSomeHtml((ElementImpl)nodeImpl3)) continue;
            return null;
        }
        return nodeImpl2;
    }

    private boolean hasSomeHtml(ElementImpl elementImpl) {
        String string = elementImpl.getTagName();
        if ("HEAD".equalsIgnoreCase(string) || "TITLE".equalsIgnoreCase(string) || "META".equalsIgnoreCase(string)) {
            return false;
        }
        NodeImpl[] nodeImplArray = elementImpl.getChildrenArray();
        if (nodeImplArray != null) {
            int n = nodeImplArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                NodeImpl nodeImpl = nodeImplArray[i];
                if (!(nodeImpl instanceof Text ? (string2 = ((Text)((Object)nodeImpl)).getTextContent()) != null && !"".equals(string2.trim()) : nodeImpl instanceof ElementImpl && this.hasSomeHtml((ElementImpl)nodeImpl))) continue;
                return false;
            }
        }
        return true;
    }

    public void expandSelection(RenderableSpot renderableSpot) {
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel != null) {
            htmlBlockPanel.setSelectionEnd(renderableSpot);
            htmlBlockPanel.repaint();
            this.selectionDispatch.fireEvent(new SelectionChangeEvent(this, htmlBlockPanel.isSelectionAvailable()));
        }
    }

    public void resetSelection(RenderableSpot renderableSpot) {
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel != null) {
            htmlBlockPanel.setSelectionStart(renderableSpot);
            htmlBlockPanel.setSelectionEnd(renderableSpot);
            htmlBlockPanel.repaint();
        }
        this.selectionDispatch.fireEvent(new SelectionChangeEvent(this, false));
    }

    public String getSelectionText() {
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel == null) {
            return null;
        }
        return htmlBlockPanel.getSelectionText();
    }

    public Node getSelectionNode() {
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel == null) {
            return null;
        }
        return htmlBlockPanel.getSelectionNode();
    }

    public boolean hasSelection() {
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel == null) {
            return false;
        }
        return htmlBlockPanel.hasSelection();
    }

    public boolean copy() {
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel != null) {
            return htmlBlockPanel.copy();
        }
        return false;
    }

    public void addSelectionChangeListener(SelectionChangeListener selectionChangeListener) {
        this.selectionDispatch.addListener(selectionChangeListener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener selectionChangeListener) {
        this.selectionDispatch.removeListener(selectionChangeListener);
    }

    public void setDefaultMarginInsets(Insets insets) {
        this.defaultMarginInsets = insets;
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel != null) {
            htmlBlockPanel.setDefaultMarginInsets(insets);
        }
    }

    public void setDefaultOverflowX(int n) {
        this.defaultOverflowX = n;
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel != null) {
            htmlBlockPanel.setDefaultOverflowX(n);
        }
    }

    public void setDefaultOverflowY(int n) {
        this.defaultOverflowY = n;
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel != null) {
            htmlBlockPanel.setDefaultOverflowY(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotification(DocumentNotification documentNotification) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.notifications;
        synchronized (arrayList2) {
            arrayList.add(documentNotification);
        }
        if (EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(this.notificationImmediateAction);
        } else {
            this.notificationTimer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayedRelayout(NodeImpl nodeImpl) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.notifications;
        synchronized (arrayList2) {
            arrayList.add(new DocumentNotification(2, nodeImpl));
        }
        this.notificationTimer.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotifications() {
        Object object;
        DocumentNotification[] documentNotificationArray;
        int n;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.notifications;
        synchronized (arrayList2) {
            n = arrayList.size();
            if (n == 0) {
                return;
            }
            documentNotificationArray = new DocumentNotification[n];
            documentNotificationArray = arrayList.toArray(documentNotificationArray);
            arrayList.clear();
        }
        int n2 = documentNotificationArray.length;
        for (n = 0; n < n2; ++n) {
            object = documentNotificationArray[n];
            if (!(((DocumentNotification)object).node instanceof HTMLFrameSetElement) || this.htmlBlockPanel == null || !this.resetIfFrameSet()) continue;
            return;
        }
        HtmlBlockPanel htmlBlockPanel = this.htmlBlockPanel;
        if (htmlBlockPanel != null) {
            htmlBlockPanel.processDocumentNotifications(documentNotificationArray);
        }
        if ((object = this.frameSetPanel) != null) {
            ((FrameSetPanel)object).processDocumentNotifications(documentNotificationArray);
        }
    }

    private class NotificationTimerAction
    implements ActionListener {
        private NotificationTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HtmlPanel.this.processNotifications();
        }
    }

    private class LocalDocumentNotificationListener
    implements DocumentNotificationListener {
        private LocalDocumentNotificationListener() {
        }

        public void allInvalidated() {
            HtmlPanel.this.addNotification(new DocumentNotification(3, null));
        }

        public void invalidated(NodeImpl nodeImpl) {
            HtmlPanel.this.addNotification(new DocumentNotification(3, nodeImpl));
        }

        public void lookInvalidated(NodeImpl nodeImpl) {
            HtmlPanel.this.addNotification(new DocumentNotification(0, nodeImpl));
        }

        public void positionInvalidated(NodeImpl nodeImpl) {
            HtmlPanel.this.addNotification(new DocumentNotification(1, nodeImpl));
        }

        public void sizeInvalidated(NodeImpl nodeImpl) {
            HtmlPanel.this.addNotification(new DocumentNotification(2, nodeImpl));
        }

        public void externalScriptLoading(NodeImpl nodeImpl) {
        }

        public void nodeLoaded(NodeImpl nodeImpl) {
            HtmlPanel.this.addNotification(new DocumentNotification(3, nodeImpl));
        }

        public void structureInvalidated(NodeImpl nodeImpl) {
            HtmlPanel.this.addNotification(new DocumentNotification(3, nodeImpl));
        }
    }

    private class SelectionDispatch
    extends EventDispatch2 {
        private SelectionDispatch() {
        }

        protected void dispatchEvent(EventListener eventListener, EventObject eventObject) {
            ((SelectionChangeListener)eventListener).selectionChanged((SelectionChangeEvent)eventObject);
        }
    }
}

