/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.gui.DocumentNotification;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.NodeRenderer;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.util.Nodes;
import org.lobobrowser.util.Objects;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HtmlBlockPanel
extends JComponent
implements NodeRenderer,
RenderableContainer,
ClipboardOwner {
    private static final Logger logger = Logger.getLogger(HtmlBlockPanel.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    protected final FrameContext frameContext;
    protected final UserAgentContext ucontext;
    protected final HtmlRendererContext rcontext;
    protected RenderableSpot startSelection;
    protected RenderableSpot endSelection;
    protected RBlock rblock;
    protected int preferredWidth = -1;
    protected Insets defaultMarginInsets = null;
    protected int defaultOverflowX = 2;
    protected int defaultOverflowY = 1;
    private BoundableRenderable mousePressTarget;
    private boolean processingDocumentNotification = false;
    private Set components;

    public HtmlBlockPanel(UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext, FrameContext frameContext) {
        this(ColorFactory.TRANSPARENT, false, userAgentContext, htmlRendererContext, frameContext);
    }

    public HtmlBlockPanel(Color color, boolean bl, UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext, FrameContext frameContext) {
        this.setLayout(null);
        this.setAutoscrolls(true);
        this.frameContext = frameContext;
        this.ucontext = userAgentContext;
        this.rcontext = htmlRendererContext;
        this.setOpaque(bl);
        this.setBackground(color);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("copy".equals(string)) {
                    HtmlBlockPanel.this.copy();
                }
            }
        };
        if (!GraphicsEnvironment.isHeadless()) {
            this.registerKeyboardAction(actionListener, "copy", KeyStroke.getKeyStroke(65485, 0), 0);
            this.registerKeyboardAction(actionListener, "copy", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 0);
        }
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HtmlBlockPanel.this.onMouseClick(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
                HtmlBlockPanel.this.onMouseExited(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                HtmlBlockPanel.this.onMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                HtmlBlockPanel.this.onMouseReleased(mouseEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                HtmlBlockPanel.this.onMouseDragged(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                HtmlBlockPanel.this.onMouseMoved(mouseEvent);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                HtmlBlockPanel.this.onMouseWheelMoved(mouseWheelEvent);
            }
        });
    }

    public void scrollTo(Rectangle rectangle, boolean bl, boolean bl2) {
        RBlock rBlock = this.rblock;
        if (rBlock != null) {
            rBlock.scrollTo(rectangle, bl, bl2);
        }
    }

    public void scrollBy(int n, int n2) {
        RBlock rBlock = this.rblock;
        if (rBlock != null) {
            if (n != 0) {
                rBlock.scrollBy(0, n);
            }
            if (n2 != 0) {
                rBlock.scrollBy(1, n2);
            }
        }
    }

    public void scrollTo(Node node) {
        Rectangle rectangle = this.getNodeBounds(node, true);
        if (rectangle == null) {
            return;
        }
        this.scrollTo(rectangle, true, false);
    }

    public Rectangle getNodeBounds(Node node, boolean bl) {
        Object object;
        Node node2;
        RBlock rBlock = this.rblock;
        if (rBlock == null) {
            return null;
        }
        UINode uINode = null;
        for (node2 = node; !(node2 == null || node2 instanceof HTMLElementImpl && (uINode = ((NodeImpl)(object = (HTMLElementImpl)node2)).getUINode()) != null); node2 = node2.getParentNode()) {
        }
        if (uINode == null) {
            return null;
        }
        Object object2 = object = bl ? rBlock.getRBlockViewport() : rBlock;
        if (node == node2) {
            BoundableRenderable boundableRenderable = (BoundableRenderable)((Object)uINode);
            Point point = boundableRenderable.getOriginRelativeTo((RCollection)object);
            Dimension dimension = boundableRenderable.getSize();
            return new Rectangle(point, dimension);
        }
        return this.scanNodeBounds((RCollection)((Object)uINode), node, (RCollection)object);
    }

    private Rectangle scanNodeBounds(RCollection rCollection, Node node, RCollection rCollection2) {
        Iterator iterator = rCollection.getRenderables();
        Rectangle rectangle = null;
        BoundableRenderable boundableRenderable = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Point point;
                Renderable renderable = (Renderable)iterator.next();
                Rectangle rectangle2 = null;
                if (renderable instanceof RCollection) {
                    RCollection rCollection3 = (RCollection)renderable;
                    boundableRenderable = rCollection3;
                    rectangle2 = this.scanNodeBounds(rCollection3, node, rCollection2);
                } else if (renderable instanceof BoundableRenderable) {
                    BoundableRenderable boundableRenderable2;
                    boundableRenderable = boundableRenderable2 = (BoundableRenderable)renderable;
                    if (Nodes.isSameOrAncestorOf(node, (Node)((Object)renderable.getModelNode()))) {
                        point = boundableRenderable2.getOriginRelativeTo(rCollection2);
                        Dimension dimension = boundableRenderable2.getSize();
                        rectangle2 = new Rectangle(point, dimension);
                    }
                } else if (Nodes.isSameOrAncestorOf(node, (Node)((Object)renderable.getModelNode()))) {
                    int n = boundableRenderable == null ? 0 : boundableRenderable.getX() + boundableRenderable.getWidth();
                    point = rCollection.getOriginRelativeTo(rCollection2);
                    rectangle2 = new Rectangle(point.x + n, point.y, 0, rCollection.getHeight());
                }
                if (rectangle2 == null) continue;
                if (rectangle == null) {
                    rectangle = rectangle2;
                    continue;
                }
                rectangle = rectangle2.union(rectangle);
            }
        }
        return rectangle;
    }

    public BoundableRenderable getRootRenderable() {
        return this.rblock;
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    public Dimension getPreferredSize() {
        RBlock rBlock;
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        final int n = this.preferredWidth;
        if (n != -1 && (rBlock = this.rblock) != null) {
            if (EventQueue.isDispatchThread()) {
                rBlock.layout(n, 0, false, false, 4, 4, true);
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            rBlock.layout(n, 0, false, false, 4, 4, true);
                        }
                    });
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Unable to do preferred size layout.", exception);
                }
            }
            int n2 = Math.max(rBlock.width + rBlock.getVScrollBarWidth(), n);
            return new Dimension(n2, rBlock.height);
        }
        return new Dimension(600, 400);
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public boolean copy() {
        String string = this.getSelectionText();
        if (string != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(string), this);
            return true;
        }
        return false;
    }

    public int getFirstLineHeight() {
        RBlock rBlock = this.rblock;
        return rBlock == null ? 0 : rBlock.getFirstLineHeight();
    }

    public void setSelectionEnd(RenderableSpot renderableSpot) {
        this.endSelection = renderableSpot;
    }

    public void setSelectionStart(RenderableSpot renderableSpot) {
        this.startSelection = renderableSpot;
    }

    public boolean isSelectionAvailable() {
        RenderableSpot renderableSpot = this.startSelection;
        RenderableSpot renderableSpot2 = this.endSelection;
        return renderableSpot != null && renderableSpot2 != null && !renderableSpot.equals(renderableSpot2);
    }

    public Node getSelectionNode() {
        RenderableSpot renderableSpot = this.startSelection;
        RenderableSpot renderableSpot2 = this.endSelection;
        if (renderableSpot != null && renderableSpot2 != null) {
            return Nodes.getCommonAncestor((Node)((Object)renderableSpot.renderable.getModelNode()), (Node)((Object)renderableSpot2.renderable.getModelNode()));
        }
        return null;
    }

    public void setRootNode(NodeImpl nodeImpl) {
        if (nodeImpl != null) {
            RBlock rBlock = new RBlock(nodeImpl, 0, this.ucontext, this.rcontext, this.frameContext, this);
            rBlock.setDefaultMarginInsets(this.defaultMarginInsets);
            rBlock.setDefaultOverflowX(this.defaultOverflowX);
            rBlock.setDefaultOverflowY(this.defaultOverflowY);
            nodeImpl.setUINode(rBlock);
            this.rblock = rBlock;
        } else {
            this.rblock = null;
        }
        this.invalidate();
        this.validateAll();
        this.repaint();
    }

    protected void validateAll() {
        Container container;
        Container container2 = this;
        while ((container = container2.getParent()) != null && !container.isValid()) {
            container2 = container;
        }
        ((Component)container2).validate();
    }

    protected void revalidatePanel() {
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public NodeImpl getRootNode() {
        RBlock rBlock = this.rblock;
        return rBlock == null ? null : (NodeImpl)rBlock.getModelNode();
    }

    private void onMouseClick(MouseEvent mouseEvent) {
        RBlock rBlock = this.rblock;
        if (rBlock != null) {
            int n = mouseEvent.getButton();
            int n2 = mouseEvent.getClickCount();
            if (n == 1 && n2 > 1) {
                Point point = mouseEvent.getPoint();
                rBlock.onDoubleClick(mouseEvent, point.x, point.y);
            } else if (n == 3 && n2 == 1) {
                rBlock.onRightClick(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private void onMousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        RBlock rBlock = this.rblock;
        if (rBlock != null) {
            Point point = mouseEvent.getPoint();
            this.mousePressTarget = rBlock;
            int n = point.x;
            int n2 = point.y;
            rBlock.onMousePressed(mouseEvent, point.x, point.y);
            RenderableSpot renderableSpot = rBlock.getLowestRenderableSpot(n, n2);
            if (renderableSpot != null) {
                this.frameContext.resetSelection(renderableSpot);
            } else {
                this.frameContext.resetSelection(null);
            }
        }
    }

    private void onMouseReleased(MouseEvent mouseEvent) {
        RBlock rBlock = this.rblock;
        if (rBlock != null) {
            Point point = mouseEvent.getPoint();
            int n = point.x;
            int n2 = point.y;
            if (mouseEvent.getButton() == 1) {
                rBlock.onMouseClick(mouseEvent, n, n2);
            }
            rBlock.onMouseReleased(mouseEvent, n, n2);
            BoundableRenderable boundableRenderable = this.mousePressTarget;
            if (boundableRenderable != null) {
                this.mousePressTarget = null;
                if (boundableRenderable != rBlock) {
                    boundableRenderable.onMouseDisarmed(mouseEvent);
                }
            }
        } else {
            this.mousePressTarget = null;
        }
    }

    private void onMouseExited(MouseEvent mouseEvent) {
        BoundableRenderable boundableRenderable = this.mousePressTarget;
        if (boundableRenderable != null) {
            this.mousePressTarget = null;
            boundableRenderable.onMouseDisarmed(mouseEvent);
        }
    }

    private void onMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        RBlock rBlock = this.rblock;
        if (rBlock != null) {
            switch (mouseWheelEvent.getScrollType()) {
                case 0: {
                    int n = mouseWheelEvent.getWheelRotation() * mouseWheelEvent.getScrollAmount();
                    rBlock.scrollByUnits(1, n);
                }
            }
        }
    }

    private void onMouseDragged(MouseEvent mouseEvent) {
        RBlock rBlock = this.rblock;
        if (rBlock != null) {
            Point point = mouseEvent.getPoint();
            RenderableSpot renderableSpot = rBlock.getLowestRenderableSpot(point.x, point.y);
            if (renderableSpot != null) {
                this.frameContext.expandSelection(renderableSpot);
            }
            rBlock.ensureVisible(point);
        }
    }

    private void onMouseMoved(MouseEvent mouseEvent) {
        RBlock rBlock = this.rblock;
        if (rBlock != null) {
            Point point = mouseEvent.getPoint();
            rBlock.onMouseMoved(mouseEvent, point.x, point.y, false, null);
        }
    }

    public void paint(Graphics graphics) {
        Object object;
        if (this.isOpaque()) {
            object = graphics.getClipBounds();
            graphics.setColor(this.getBackground());
            graphics.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
        if (graphics instanceof Graphics2D) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if ((object = this.rblock) != null) {
            boolean bl = loggableInfo;
            long l = bl ? System.currentTimeMillis() : 0L;
            ((RBlock)object).paint(graphics);
            if (bl) {
                long l2 = System.currentTimeMillis();
                NodeImpl nodeImpl = this.getRootNode();
                String string = nodeImpl instanceof Document ? ((Document)((Object)nodeImpl)).getDocumentURI() : "";
                logger.info("paintComponent(): URI=[" + string + "]. Block paint elapsed: " + (l2 - l) + " ms.");
            }
            RenderableSpot renderableSpot = this.startSelection;
            RenderableSpot renderableSpot2 = this.endSelection;
            if (renderableSpot != null && renderableSpot2 != null && !renderableSpot.equals(renderableSpot2)) {
                ((RBlock)object).paintSelection(graphics, false, renderableSpot, renderableSpot2);
            }
        }
    }

    public void doLayout() {
        try {
            Dimension dimension = this.getSize();
            boolean bl = loggableInfo;
            long l = 0L;
            if (bl) {
                l = System.currentTimeMillis();
            }
            this.clearComponents();
            RBlock rBlock = this.rblock;
            if (rBlock != null) {
                ModelNode modelNode = rBlock.getModelNode();
                rBlock.layout(dimension.width, dimension.height, true, true, null, false);
                rBlock.setOrigin(0, 0);
                rBlock.updateWidgetBounds(0, 0);
                this.updateGUIComponents();
                if (bl) {
                    long l2 = System.currentTimeMillis();
                    String string = modelNode instanceof Document ? ((Document)((Object)modelNode)).getDocumentURI() : "";
                    logger.info("doLayout(): URI=[" + string + "]. Block layout elapsed: " + (l2 - l) + " ms. Component count: " + this.getComponentCount() + ".");
                }
            } else if (this.getComponentCount() > 0) {
                this.removeAll();
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Unexpected error in layout engine. Document is " + this.getRootNode(), throwable);
        }
    }

    public void repaint(ModelNode modelNode) {
        this.repaint();
    }

    public String getSelectionText() {
        RenderableSpot renderableSpot = this.startSelection;
        RenderableSpot renderableSpot2 = this.endSelection;
        if (renderableSpot != null && renderableSpot2 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.rblock.extractSelectionText(stringBuffer, false, renderableSpot, renderableSpot2);
            return stringBuffer.toString();
        }
        return null;
    }

    public boolean hasSelection() {
        RenderableSpot renderableSpot = this.startSelection;
        RenderableSpot renderableSpot2 = this.endSelection;
        return renderableSpot != null && renderableSpot2 != null && !renderableSpot.equals(renderableSpot2);
    }

    protected void paintChildren(Graphics graphics) {
    }

    public Color getPaintedBackgroundColor() {
        return this.isOpaque() ? this.getBackground() : null;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void relayout() {
        this.revalidatePanel();
    }

    public void invalidateLayoutUpTree() {
    }

    public void updateAllWidgetBounds() {
        this.rblock.updateWidgetBounds(0, 0);
    }

    public Point getGUIPoint(int n, int n2) {
        return new Point(n, n2);
    }

    public void focus() {
        this.grabFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDocumentNotifications(DocumentNotification[] documentNotificationArray) {
        if (this.processingDocumentNotification) {
            throw new IllegalStateException("Recursive");
        }
        this.processingDocumentNotification = true;
        try {
            Object object;
            boolean bl = false;
            ArrayList<UINode> arrayList = null;
            int n = documentNotificationArray.length;
            block8: for (int i = 0; i < n; ++i) {
                object = documentNotificationArray[i];
                int n2 = ((DocumentNotification)object).type;
                switch (n2) {
                    case 2: 
                    case 3: {
                        UINode uINode;
                        Object object2;
                        NodeImpl nodeImpl = ((DocumentNotification)object).node;
                        if (nodeImpl == null) {
                            if (loggableInfo) {
                                logger.info("processDocumentNotifications(): Calling invalidateLayoutDeep().");
                            }
                            this.rblock.invalidateLayoutDeep();
                        } else {
                            object2 = nodeImpl.findUINode();
                            if (object2 != null) {
                                uINode = (RElement)object2;
                                uINode.invalidateLayoutUpTree();
                            } else if (loggableInfo) {
                                logger.info("processDocumentNotifications(): Unable to find UINode for " + nodeImpl);
                            }
                        }
                        bl = true;
                        continue block8;
                    }
                    case 1: {
                        UINode uINode;
                        NodeImpl nodeImpl = ((DocumentNotification)object).node;
                        Object object2 = (NodeImpl)nodeImpl.getParentNode();
                        if (object2 != null && (uINode = ((NodeImpl)object2).findUINode()) != null) {
                            RElement rElement = (RElement)uINode;
                            rElement.invalidateLayoutUpTree();
                        }
                        bl = true;
                        continue block8;
                    }
                    case 0: {
                        NodeImpl nodeImpl = ((DocumentNotification)object).node;
                        Object object2 = nodeImpl.findUINode();
                        if (object2 == null) continue block8;
                        if (arrayList == null) {
                            arrayList = new ArrayList<UINode>(1);
                        }
                        UINode uINode = (RElement)object2;
                        arrayList.add(uINode);
                        continue block8;
                    }
                }
            }
            if (bl) {
                this.revalidatePanel();
            } else if (arrayList != null) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object = (RElement)iterator.next();
                    object.repaint();
                }
            }
        }
        finally {
            this.processingDocumentNotification = false;
        }
    }

    public void addDelayedPair(DelayedPair delayedPair) {
    }

    public RenderableContainer getParentContainer() {
        return null;
    }

    public Collection getDelayedPairs() {
        return null;
    }

    public void clearDelayedPairs() {
    }

    private void clearComponents() {
        Set set = this.components;
        if (set != null) {
            set.clear();
        }
    }

    public Component addComponent(Component component) {
        HashSet<Component> hashSet = this.components;
        if (hashSet == null) {
            this.components = hashSet = new HashSet<Component>();
        }
        if (hashSet.add(component)) {
            return component;
        }
        return null;
    }

    private void updateGUIComponents() {
        Set set = this.components;
        if (set == null) {
            if (this.getComponentCount() != 0) {
                this.removeAll();
            }
        } else {
            Component component;
            HashSet hashSet = new HashSet();
            hashSet.addAll(set);
            int n = this.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                component = this.getComponent(n2);
                if (!set.contains(component)) {
                    this.remove(n2);
                    n = this.getComponentCount();
                    continue;
                }
                ++n2;
                hashSet.remove(component);
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                component = (Component)iterator.next();
                this.add(component);
            }
        }
    }

    public Insets getDefaultMarginInsets() {
        return this.defaultMarginInsets;
    }

    public void setDefaultMarginInsets(Insets insets) {
        if (!Objects.equals(this.defaultMarginInsets, insets)) {
            this.defaultMarginInsets = insets;
            RBlock rBlock = this.rblock;
            if (rBlock != null) {
                rBlock.setDefaultMarginInsets(insets);
                rBlock.relayoutIfValid();
            }
        }
    }

    public int getDefaultOverflowX() {
        return this.defaultOverflowX;
    }

    public void setDefaultOverflowX(int n) {
        if (n != this.defaultOverflowX) {
            this.defaultOverflowX = n;
            RBlock rBlock = this.rblock;
            if (rBlock != null) {
                rBlock.setDefaultOverflowX(n);
                rBlock.relayoutIfValid();
            }
        }
    }

    public int getDefaultOverflowY() {
        return this.defaultOverflowY;
    }

    public void setDefaultOverflowY(int n) {
        if (this.defaultOverflowY != n) {
            this.defaultOverflowY = n;
            RBlock rBlock = this.rblock;
            if (rBlock != null) {
                rBlock.setDefaultOverflowY(n);
                rBlock.relayoutIfValid();
            }
        }
    }
}

