/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.CharacterDataImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.util.Strings;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements Text {
    public TextImpl() {
        this("");
    }

    public TextImpl(String string) {
        this.text = string;
    }

    public boolean isElementContentWhitespace() {
        String string = this.text;
        return string == null || string.trim().equals("");
    }

    public Text replaceWholeText(String string) throws DOMException {
        NodeImpl nodeImpl = (NodeImpl)this.getParentNode();
        if (nodeImpl == null) {
            throw new DOMException(3, "Text node has no parent");
        }
        return nodeImpl.replaceAdjacentTextNodes(this, string);
    }

    public Text splitText(int n) throws DOMException {
        NodeImpl nodeImpl = (NodeImpl)this.getParentNode();
        if (nodeImpl == null) {
            throw new DOMException(3, "Text node has no parent");
        }
        String string = this.text;
        if (n < 0 || n > string.length()) {
            throw new DOMException(1, "Bad offset: " + n);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        this.text = string2;
        TextImpl textImpl = new TextImpl(string3);
        textImpl.setOwnerDocument(this.document);
        return (Text)nodeImpl.insertAfter(textImpl, this);
    }

    public String getWholeText() {
        NodeImpl nodeImpl = (NodeImpl)this.getParentNode();
        if (nodeImpl == null) {
            throw new DOMException(3, "Text node has no parent");
        }
        return nodeImpl.getTextContent();
    }

    public String getLocalName() {
        return null;
    }

    public String getNodeName() {
        return "#text";
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeValue() throws DOMException {
        return this.text;
    }

    public void setNodeValue(String string) throws DOMException {
        this.text = string;
    }

    public void setTextContent(String string) throws DOMException {
        this.text = string;
    }

    protected Node createSimilarNode() {
        return new TextImpl(this.text);
    }

    public String toString() {
        String string = this.text;
        int n = string == null ? 0 : string.length();
        return "#text[length=" + n + ",value=\"" + Strings.truncate(string, 64) + "\",renderState=" + this.getRenderState() + "]";
    }
}

