/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import org.lobobrowser.html.domimpl.DescendentHTMLCollection;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.NodeVisitor;
import org.lobobrowser.html.domimpl.StopVisitorException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLTableCellElement;
import org.w3c.dom.html2.HTMLTableRowElement;

public class HTMLTableRowElementImpl
extends HTMLElementImpl
implements HTMLTableRowElement {
    public HTMLTableRowElementImpl(String string) {
        super(string, true);
    }

    public HTMLTableRowElementImpl() {
        super("TR", true);
    }

    public int getRowIndex() {
        NodeImpl nodeImpl = (NodeImpl)this.getParentNode();
        if (nodeImpl == null) {
            return -1;
        }
        try {
            nodeImpl.visit(new NodeVisitor(){
                private int count = 0;

                public void visit(Node node) {
                    if (node instanceof HTMLTableRowElementImpl) {
                        if (HTMLTableRowElementImpl.this == node) {
                            throw new StopVisitorException(new Integer(this.count));
                        }
                        ++this.count;
                    }
                }
            });
        }
        catch (StopVisitorException stopVisitorException) {
            return (Integer)stopVisitorException.getTag();
        }
        return -1;
    }

    public int getSectionRowIndex() {
        return 0;
    }

    public HTMLCollection getCells() {
        NodeFilter nodeFilter = new NodeFilter(){

            public boolean accept(Node node) {
                return node instanceof HTMLTableCellElementImpl;
            }
        };
        return new DescendentHTMLCollection(this, nodeFilter, this.treeLock, false);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String string) {
        this.setAttribute("align", string);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String string) {
        this.setAttribute("bgcolor", string);
    }

    public String getCh() {
        return this.getAttribute("ch");
    }

    public void setCh(String string) {
        this.setAttribute("ch", string);
    }

    public String getChOff() {
        return this.getAttribute("choff");
    }

    public void setChOff(String string) {
        this.setAttribute("choff", string);
    }

    public String getVAlign() {
        return this.getAttribute("valign");
    }

    public void setVAlign(String string) {
        this.setAttribute("valign", string);
    }

    public HTMLElement insertHeader(int n) throws DOMException {
        return this.insertCell(n, "TH");
    }

    public HTMLElement insertCell(int n) throws DOMException {
        return this.insertCell(n, "TD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTMLElement insertCell(int n, String string) throws DOMException {
        Document document = this.document;
        if (document == null) {
            throw new DOMException(4, "Orphan element");
        }
        HTMLElement hTMLElement = (HTMLElement)document.createElement(string);
        Object object = this.treeLock;
        synchronized (object) {
            if (n == -1) {
                this.appendChild(hTMLElement);
                return hTMLElement;
            }
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                int n2 = arrayList.size();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    Node node = (Node)arrayList.get(i);
                    if (!(node instanceof HTMLTableCellElement)) continue;
                    if (n3 == n) {
                        this.insertAt(hTMLElement, i);
                        return hTMLElement;
                    }
                    ++n3;
                }
            } else {
                this.appendChild(hTMLElement);
                return hTMLElement;
            }
        }
        throw new DOMException(1, "Index out of range");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCell(int n) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                int n2 = arrayList.size();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    Node node = (Node)arrayList.get(i);
                    if (!(node instanceof HTMLTableCellElement)) continue;
                    if (n3 == n) {
                        this.removeChildAt(n);
                    }
                    ++n3;
                }
            }
        }
        throw new DOMException(1, "Index out of range");
    }
}

