/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.style.CSSUtilities;
import org.lobobrowser.html.style.ColorRenderState;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.TextDecorationRenderState;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.html2.HTMLBodyElement;
import org.w3c.dom.html2.HTMLDocument;
import org.w3c.dom.html2.HTMLLinkElement;

public class HTMLLinkElementImpl
extends HTMLAbstractUIElement
implements HTMLLinkElement {
    private static final Logger logger = Logger.getLogger(HTMLLinkElementImpl.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    private CSSStyleSheet styleSheet;
    private boolean disabled;

    public HTMLLinkElementImpl(String string) {
        super(string);
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
        CSSStyleSheet cSSStyleSheet = this.styleSheet;
        if (cSSStyleSheet != null) {
            cSSStyleSheet.setDisabled(bl);
        }
    }

    public String getHref() {
        String string = this.getAttribute("href");
        return string == null ? "" : string;
    }

    public void setHref(String string) {
        this.setAttribute("href", string);
    }

    public String getHreflang() {
        return this.getAttribute("hreflang");
    }

    public void setHreflang(String string) {
        this.setAttribute("hreflang", string);
    }

    public String getMedia() {
        return this.getAttribute("media");
    }

    public void setMedia(String string) {
        this.setAttribute("media", string);
    }

    public String getRel() {
        return this.getAttribute("rel");
    }

    public void setRel(String string) {
        this.setAttribute("rel", string);
    }

    public String getRev() {
        return this.getAttribute("rev");
    }

    public void setRev(String string) {
        this.setAttribute("rev", string);
    }

    public String getTarget() {
        String string = this.getAttribute("target");
        if (string != null) {
            return string;
        }
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        return hTMLDocumentImpl == null ? null : hTMLDocumentImpl.getDefaultTarget();
    }

    public void setTarget(String string) {
        this.setAttribute("target", string);
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setType(String string) {
        this.setAttribute("type", string);
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        if ("cobra.suspend".equals(string) && object != Boolean.TRUE) {
            this.processLink();
        } else if ("styleSheet.disabled.changed".equals(string)) {
            this.informDocumentInvalid();
        }
        return super.setUserData(string, object, userDataHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLink() {
        this.styleSheet = null;
        String string = this.getAttribute("rel");
        if (string != null) {
            String string2;
            UserAgentContext userAgentContext;
            String string3 = string.trim().toLowerCase();
            boolean bl = string3.equals("stylesheet");
            boolean bl2 = string3.equals("alternate stylesheet");
            if ((bl || bl2) && (userAgentContext = this.getUserAgentContext()).isExternalCSSEnabled() && CSSUtilities.matchesMedia(string2 = this.getMedia(), userAgentContext)) {
                HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.getOwnerDocument();
                try {
                    boolean bl3 = loggableInfo;
                    long l = bl3 ? System.currentTimeMillis() : 0L;
                    try {
                        CSSStyleSheet cSSStyleSheet = CSSUtilities.parse(this, this.getHref(), hTMLDocumentImpl, hTMLDocumentImpl.getBaseURI(), false);
                        if (cSSStyleSheet != null) {
                            this.styleSheet = cSSStyleSheet;
                            if (cSSStyleSheet instanceof CSSStyleSheetImpl) {
                                CSSStyleSheetImpl cSSStyleSheetImpl = (CSSStyleSheetImpl)cSSStyleSheet;
                                if (bl2) {
                                    cSSStyleSheetImpl.setDisabledOnly(true);
                                } else {
                                    cSSStyleSheetImpl.setDisabledOnly(this.disabled);
                                }
                            } else if (bl2) {
                                cSSStyleSheet.setDisabled(true);
                            } else {
                                cSSStyleSheet.setDisabled(this.disabled);
                            }
                            hTMLDocumentImpl.addStyleSheet(cSSStyleSheet);
                        }
                    }
                    finally {
                        if (bl3) {
                            long l2 = System.currentTimeMillis();
                            logger.info("processLink(): Loaded and parsed CSS (or attempted to) at URI=[" + this.getHref() + "] in " + (l2 - l) + " ms.");
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    this.warn("Will not parse CSS. URI=[" + this.getHref() + "] with BaseURI=[" + hTMLDocumentImpl.getBaseURI() + "] does not appear to be a valid URI.");
                }
                catch (Throwable throwable) {
                    this.warn("Unable to parse CSS. URI=[" + this.getHref() + "].", throwable);
                }
            }
        }
    }

    public String getAbsoluteHref() {
        String string;
        HtmlRendererContext htmlRendererContext = this.getHtmlRendererContext();
        if (htmlRendererContext != null && (string = this.getHref()) != null && string.length() > 0) {
            String string2 = this.getTarget();
            try {
                URL uRL = this.getFullURL(string);
                return uRL == null ? null : uRL.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                this.warn("Malformed URI: [" + string + "].", malformedURLException);
            }
        }
        return null;
    }

    public void navigate() {
        String string;
        if (this.disabled) {
            return;
        }
        HtmlRendererContext htmlRendererContext = this.getHtmlRendererContext();
        if (htmlRendererContext != null && (string = this.getHref()) != null && string.length() > 0) {
            String string2 = this.getTarget();
            try {
                URL uRL = this.getFullURL(string);
                if (uRL == null) {
                    this.warn("Unable to resolve URI: [" + string + "].");
                } else {
                    htmlRendererContext.linkClicked(this, uRL, string2);
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.warn("Malformed URI: [" + string + "].", malformedURLException);
            }
        }
    }

    private Color getLinkColor() {
        HTMLBodyElement hTMLBodyElement;
        HTMLDocument hTMLDocument = (HTMLDocument)this.document;
        if (hTMLDocument != null && (hTMLBodyElement = (HTMLBodyElement)hTMLDocument.getBody()) != null) {
            HtmlRendererContext htmlRendererContext;
            String string = hTMLBodyElement.getVLink();
            String string2 = hTMLBodyElement.getLink();
            if ((string != null || string2 != null) && (htmlRendererContext = this.getHtmlRendererContext()) != null) {
                String string3;
                boolean bl = htmlRendererContext.isVisitedLink(this);
                String string4 = string3 = bl ? string : string2;
                if (string3 != null) {
                    return ColorFactory.getInstance().getColor(string3);
                }
            }
        }
        return Color.BLUE;
    }

    protected RenderState createRenderState(RenderState renderState) {
        if (this.hasAttribute("href")) {
            renderState = new TextDecorationRenderState(renderState, 1);
            renderState = new ColorRenderState(renderState, this.getLinkColor());
        }
        return super.createRenderState(renderState);
    }

    public String toString() {
        return this.getHref();
    }
}

