/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Image;
import java.util.ArrayList;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.ImageEvent;
import org.lobobrowser.html.domimpl.ImageListener;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.style.ImageRenderState;
import org.lobobrowser.html.style.RenderState;
import org.mozilla.javascript.Function;
import org.w3c.dom.html2.HTMLImageElement;

public class HTMLImageElementImpl
extends HTMLAbstractUIElement
implements HTMLImageElement {
    private Function onload;
    private Image image = null;
    private String imageSrc;
    private final ArrayList listeners = new ArrayList(1);

    public HTMLImageElementImpl() {
        super("IMG");
    }

    public HTMLImageElementImpl(String string) {
        super(string);
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public void setName(String string) {
        this.setAttribute("name", string);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String string) {
        this.setAttribute("align", string);
    }

    public String getAlt() {
        return this.getAttribute("alt");
    }

    public void setAlt(String string) {
        this.setAttribute("alt", string);
    }

    public String getBorder() {
        return this.getAttribute("border");
    }

    public void setBorder(String string) {
        this.setAttribute("border", string);
    }

    public int getHeight() {
        UINode uINode = this.uiNode;
        return uINode == null ? 0 : uINode.getBounds().height;
    }

    public void setHeight(int n) {
        this.setAttribute("height", String.valueOf(n));
    }

    public int getHspace() {
        return this.getAttributeAsInt("hspace", 0);
    }

    public void setHspace(int n) {
        this.setAttribute("hspace", String.valueOf("hspace"));
    }

    public boolean getIsMap() {
        return this.getAttributeAsBoolean("isMap");
    }

    public void setIsMap(boolean bl) {
        this.setAttribute("isMap", bl ? "isMap" : null);
    }

    public String getLongDesc() {
        return this.getAttribute("longDesc");
    }

    public void setLongDesc(String string) {
        this.setAttribute("longDesc", string);
    }

    public String getSrc() {
        return this.getAttribute("src");
    }

    public void setSrc(String string) {
        this.setAttribute("src", string);
    }

    public String getUseMap() {
        return this.getAttribute("useMap");
    }

    public void setUseMap(String string) {
        this.setAttribute("useMap", string);
    }

    public int getVspace() {
        return this.getAttributeAsInt("vspace", 0);
    }

    public void setVspace(int n) {
        this.setAttribute("vspace", String.valueOf(n));
    }

    public int getWidth() {
        UINode uINode = this.uiNode;
        return uINode == null ? 0 : uINode.getBounds().width;
    }

    public void setWidth(int n) {
        this.setAttribute("width", String.valueOf(n));
    }

    protected void assignAttributeField(String string, String string2) {
        super.assignAttributeField(string, string2);
        if ("src".equals(string)) {
            this.loadImage(string2);
        }
    }

    public Function getOnload() {
        return this.getEventFunction(this.onload, "onload");
    }

    public void setOnload(Function function) {
        this.onload = function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage(String string) {
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.imageSrc = string;
                this.image = null;
            }
            if (string != null) {
                hTMLDocumentImpl.loadImage(string, new LocalImageListener(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Image getImage() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageListener(ImageListener imageListener) {
        Image image;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.listeners;
        synchronized (arrayList2) {
            image = this.image;
            arrayList.add(imageListener);
        }
        if (image != null) {
            imageListener.imageLoaded(new ImageEvent(this, image));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageListener(ImageListener imageListener) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.listeners;
        synchronized (arrayList2) {
            arrayList.remove(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(String string, ImageEvent imageEvent) {
        ImageListener[] imageListenerArray;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.listeners;
        synchronized (arrayList2) {
            if (!string.equals(this.imageSrc)) {
                return;
            }
            this.image = imageEvent.image;
            imageListenerArray = arrayList.toArray(ImageListener.EMPTY_ARRAY);
        }
        int n = imageListenerArray.length;
        for (int i = 0; i < n; ++i) {
            imageListenerArray[i].imageLoaded(imageEvent);
        }
        Function function = this.getOnload();
        if (function != null) {
            Executor.executeFunction(this, function, null);
        }
    }

    protected RenderState createRenderState(RenderState renderState) {
        return new ImageRenderState(renderState, this);
    }

    private class LocalImageListener
    implements ImageListener {
        private final String expectedImgSrc;

        public LocalImageListener(String string) {
            this.expectedImgSrc = string;
        }

        public void imageLoaded(ImageEvent imageEvent) {
            HTMLImageElementImpl.this.dispatchEvent(this.expectedImgSrc, imageEvent);
        }
    }
}

