/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.ComputedCSS2Properties;
import org.lobobrowser.html.style.HeadingRenderState;
import org.lobobrowser.html.style.RenderState;
import org.w3c.dom.html2.HTMLHeadingElement;

public class HTMLHeadingElementImpl
extends HTMLAbstractUIElement
implements HTMLHeadingElement {
    public HTMLHeadingElementImpl(String string) {
        super(string);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String string) {
        this.setAttribute("align", string);
    }

    private final float getHeadingFontSize() {
        String string = this.getTagName();
        try {
            int n = string.charAt(1) - 48;
            switch (n) {
                case 1: {
                    return 24.0f;
                }
                case 2: {
                    return 18.0f;
                }
                case 3: {
                    return 15.0f;
                }
                case 4: {
                    return 12.0f;
                }
                case 5: {
                    return 10.0f;
                }
                case 6: {
                    return 8.0f;
                }
            }
        }
        catch (Exception exception) {
            this.warn("getHeadingFontSize(): Bad heading tag: " + this.getTagName(), exception);
        }
        return 14.0f;
    }

    private final String getHeadingFontSizeText() {
        String string = this.getTagName();
        try {
            int n = string.charAt(1) - 48;
            switch (n) {
                case 1: {
                    return "24pt";
                }
                case 2: {
                    return "18pt";
                }
                case 3: {
                    return "13.55pt";
                }
                case 4: {
                    return "12pt";
                }
                case 5: {
                    return "10pt";
                }
                case 6: {
                    return "7.55pt";
                }
            }
        }
        catch (Exception exception) {
            this.warn("getHeadingFontSizeText(): Bad heading tag: " + this.getTagName(), exception);
        }
        return "14px";
    }

    protected RenderState createRenderState(RenderState renderState) {
        float f = this.getHeadingFontSize();
        return new HeadingRenderState(renderState, this);
    }

    protected void appendInnerTextImpl(StringBuffer stringBuffer) {
        int n;
        int n2;
        int n3 = stringBuffer.length();
        if (n3 == 0) {
            n2 = 2;
        } else {
            n = n3 - 4;
            if (n < 0) {
                n = 0;
            }
            n2 = 0;
            for (int i = n; i < n3; ++i) {
                char c = stringBuffer.charAt(i);
                if (c != '\n') continue;
                ++n2;
            }
        }
        for (n = 0; n < 2 - n2; ++n) {
            stringBuffer.append("\r\n");
        }
        super.appendInnerTextImpl(stringBuffer);
        stringBuffer.append("\r\n\r\n");
    }

    protected AbstractCSS2Properties createDefaultStyleSheet() {
        ComputedCSS2Properties computedCSS2Properties = new ComputedCSS2Properties(this);
        computedCSS2Properties.internalSetLC("font-size", this.getHeadingFontSizeText());
        computedCSS2Properties.internalSetLC("font-weight", "bolder");
        return computedCSS2Properties;
    }
}

