/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Image;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.AttrImpl;
import org.lobobrowser.html.domimpl.CDataSectionImpl;
import org.lobobrowser.html.domimpl.CommentImpl;
import org.lobobrowser.html.domimpl.DOMConfigurationImpl;
import org.lobobrowser.html.domimpl.DOMImplementationImpl;
import org.lobobrowser.html.domimpl.DescendentHTMLCollection;
import org.lobobrowser.html.domimpl.DocumentFragmentImpl;
import org.lobobrowser.html.domimpl.DocumentNotificationListener;
import org.lobobrowser.html.domimpl.ElementFactory;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLProcessingInstruction;
import org.lobobrowser.html.domimpl.ImageEvent;
import org.lobobrowser.html.domimpl.ImageListener;
import org.lobobrowser.html.domimpl.LocalErrorHandler;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.NodeVisitor;
import org.lobobrowser.html.domimpl.TextImpl;
import org.lobobrowser.html.io.WritableLineReader;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.js.Location;
import org.lobobrowser.html.js.Window;
import org.lobobrowser.html.parser.HtmlParser;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.StyleSheetAggregator;
import org.lobobrowser.html.style.StyleSheetRenderState;
import org.lobobrowser.util.Domains;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.WeakValueHashMap;
import org.lobobrowser.util.io.EmptyReader;
import org.mozilla.javascript.Function;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLDocument;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLFrameElement;
import org.w3c.dom.html2.HTMLIFrameElement;
import org.w3c.dom.html2.HTMLLinkElement;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class HTMLDocumentImpl
extends NodeImpl
implements HTMLDocument,
DocumentView {
    private static final Logger logger = Logger.getLogger(HTMLDocumentImpl.class.getName());
    private final ElementFactory factory;
    private final HtmlRendererContext rcontext;
    private final UserAgentContext ucontext;
    private final Window window;
    private final Map elementsById = new WeakValueHashMap();
    private String documentURI;
    private URL documentURL;
    private WritableLineReader reader;
    private Set locales;
    private volatile String baseURI;
    private String defaultTarget;
    private String title;
    private String referrer;
    private String domain;
    private HTMLCollection images;
    private HTMLCollection applets;
    private HTMLCollection links;
    private HTMLCollection forms;
    private HTMLCollection anchors;
    private HTMLCollection frames;
    private DocumentType doctype;
    private final Map elementsByName = new HashMap(0);
    private String inputEncoding;
    private String xmlEncoding;
    private boolean xmlStandalone;
    private String xmlVersion = null;
    private boolean strictErrorChecking = true;
    private DOMConfiguration domConfig;
    private DOMImplementation domImplementation;
    private HTMLElement body;
    private final Collection styleSheets = new CSSStyleSheetList();
    private StyleSheetAggregator styleSheetAggregator = null;
    private final ArrayList documentNotificationListeners = new ArrayList(1);
    private final Map imageInfos = new HashMap(4);
    private final ImageEvent BLANK_IMAGE_EVENT = new ImageEvent(this, null);
    private Function onloadHandler;

    public HTMLDocumentImpl(HtmlRendererContext htmlRendererContext) {
        this(htmlRendererContext.getUserAgentContext(), htmlRendererContext, null, null);
    }

    public HTMLDocumentImpl(UserAgentContext userAgentContext) {
        this(userAgentContext, null, null, null);
    }

    public HTMLDocumentImpl(UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext, WritableLineReader writableLineReader, String string) {
        Object object;
        this.factory = ElementFactory.getInstance();
        this.rcontext = htmlRendererContext;
        this.ucontext = userAgentContext;
        this.reader = writableLineReader;
        this.documentURI = string;
        try {
            object = new URL(string);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new SocketPermission(((URL)object).getHost(), "connect"));
            }
            this.documentURL = object;
            this.domain = ((URL)object).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            logger.warning("HTMLDocumentImpl(): Document URI [" + string + "] is malformed.");
        }
        this.document = this;
        object = htmlRendererContext != null ? Window.getWindow(htmlRendererContext) : new Window(null, userAgentContext);
        this.window = object;
        ((Window)object).setDocument(this);
        this.setUserData("cobra.js.scope", ((Window)object).getWindowScope(), null);
    }

    public Set getLocales() {
        return this.locales;
    }

    public void setLocales(Set set) {
        this.locales = set;
    }

    String getDocumentHost() {
        URL uRL = this.documentURL;
        return uRL == null ? null : uRL.getHost();
    }

    public URL getDocumentURL() {
        return this.documentURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setElementById(String string, Element element) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsById.put(string, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeElementById(String string) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsById.remove(string);
        }
    }

    public String getBaseURI() {
        String string = this.baseURI;
        return string == null ? this.documentURI : string;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(String string) {
        this.defaultTarget = string;
    }

    public AbstractView getDefaultView() {
        return this.window;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public void setTextContent(String string) throws DOMException {
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String string) {
        this.referrer = string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        String string2 = this.domain;
        if (string2 == null || !Domains.isValidCookieDomain(string, string2)) {
            throw new SecurityException("Cannot set domain to '" + string + "' when current domain is '" + string2 + "'");
        }
        this.domain = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLElement getBody() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            return this.body;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getImages() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.images == null) {
                this.images = new DescendentHTMLCollection(this, new ImageFilter(), this.treeLock);
            }
            return this.images;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getApplets() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.applets == null) {
                this.applets = new DescendentHTMLCollection(this, new AppletFilter(), this.treeLock);
            }
            return this.applets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getLinks() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.links == null) {
                this.links = new DescendentHTMLCollection(this, new LinkFilter(), this.treeLock);
            }
            return this.links;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getForms() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.forms == null) {
                this.forms = new DescendentHTMLCollection(this, new FormFilter(), this.treeLock);
            }
            return this.forms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getFrames() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.frames == null) {
                this.frames = new DescendentHTMLCollection(this, new FrameFilter(), this.treeLock);
            }
            return this.frames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getAnchors() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.anchors == null) {
                this.anchors = new DescendentHTMLCollection(this, new AnchorFilter(), this.treeLock);
            }
            return this.anchors;
        }
    }

    public String getCookie() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return HTMLDocumentImpl.this.ucontext.getCookie(HTMLDocumentImpl.this.documentURL);
                }
            });
        }
        return this.ucontext.getCookie(this.documentURL);
    }

    public void setCookie(final String string) throws DOMException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    HTMLDocumentImpl.this.ucontext.setCookie(HTMLDocumentImpl.this.documentURL, string);
                    return null;
                }
            });
        } else {
            this.ucontext.setCookie(this.documentURL, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.reader != null) {
                if (this.reader instanceof LocalWritableLineReader) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.reader = null;
                } else {
                    return;
                }
            }
            this.removeAllChildrenImpl();
            this.reader = new LocalWritableLineReader(new EmptyReader());
        }
    }

    public void load() throws IOException, SAXException, UnsupportedEncodingException {
        this.load(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(boolean bl) throws IOException, SAXException, UnsupportedEncodingException {
        WritableLineReader writableLineReader;
        Object object = this.treeLock;
        synchronized (object) {
            this.removeAllChildrenImpl();
            this.setTitle(null);
            this.setBaseURI(null);
            this.setDefaultTarget(null);
            this.styleSheets.clear();
            this.styleSheetAggregator = null;
            writableLineReader = this.reader;
        }
        if (writableLineReader != null) {
            try {
                String string;
                object = new LocalErrorHandler();
                String string2 = string = this.documentURI;
                HtmlParser htmlParser = new HtmlParser(this.ucontext, this, (ErrorHandler)object, string2, string);
                htmlParser.parse(writableLineReader);
            }
            finally {
                if (bl) {
                    try {
                        writableLineReader.close();
                    }
                    catch (Exception exception) {
                        logger.log(Level.WARNING, "load(): Unable to close stream", exception);
                    }
                    object = this.treeLock;
                    synchronized (object) {
                        this.reader = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.reader instanceof LocalWritableLineReader) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.reader = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string) {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.reader != null) {
                try {
                    this.reader.write(string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(String string) {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.reader != null) {
                try {
                    this.reader.write(string + "\r\n");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void openBufferChanged(String string) {
        String string2;
        LocalErrorHandler localErrorHandler = new LocalErrorHandler();
        String string3 = string2 = this.documentURI;
        HtmlParser htmlParser = new HtmlParser(this.ucontext, this, localErrorHandler, string3, string2);
        StringReader stringReader = new StringReader(string);
        try {
            htmlParser.parse(stringReader);
        }
        catch (Exception exception) {
            this.warn("Unable to parse written HTML text. BaseURI=[" + this.getBaseURI() + "].", exception);
        }
    }

    public NodeList getElementsByName(String string) {
        return this.getNodeList(new ElementNameFilter(string));
    }

    public DocumentType getDoctype() {
        return this.doctype;
    }

    public void setDoctype(DocumentType documentType) {
        this.doctype = documentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getDocumentElement() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Element)) continue;
                    return (Element)e;
                }
            }
            return null;
        }
    }

    public Element createElement(String string) throws DOMException {
        return this.factory.createElement(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        DocumentFragmentImpl documentFragmentImpl = new DocumentFragmentImpl();
        documentFragmentImpl.setOwnerDocument(this);
        return documentFragmentImpl;
    }

    public Text createTextNode(String string) {
        TextImpl textImpl = new TextImpl(string);
        textImpl.setOwnerDocument(this);
        return textImpl;
    }

    public Comment createComment(String string) {
        CommentImpl commentImpl = new CommentImpl(string);
        commentImpl.setOwnerDocument(this);
        return commentImpl;
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        CDataSectionImpl cDataSectionImpl = new CDataSectionImpl(string);
        cDataSectionImpl.setOwnerDocument(this);
        return cDataSectionImpl;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        HTMLProcessingInstruction hTMLProcessingInstruction = new HTMLProcessingInstruction(string, string2);
        hTMLProcessingInstruction.setOwnerDocument(this);
        return hTMLProcessingInstruction;
    }

    public Attr createAttribute(String string) throws DOMException {
        return new AttrImpl(string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        throw new DOMException(9, "HTML document");
    }

    public NodeList getElementsByTagName(String string) {
        if ("*".equals(string)) {
            return this.getNodeList(new ElementFilter());
        }
        return this.getNodeList(new TagNameFilter(string));
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        throw new DOMException(9, "Not implemented");
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        throw new DOMException(9, "HTML document");
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        throw new DOMException(9, "HTML document");
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        throw new DOMException(9, "HTML document");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElementById(String string) {
        Element element;
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            element = (Element)this.elementsById.get(string);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element namedItem(String string) {
        Element element;
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            element = (Element)this.elementsByName.get(string);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNamedItem(String string, Element element) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsByName.put(string, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNamedItem(String string) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsByName.remove(string);
        }
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    public void setXmlStandalone(boolean bl) throws DOMException {
        this.xmlStandalone = bl;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String string) throws DOMException {
        this.xmlVersion = string;
    }

    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    public void setStrictErrorChecking(boolean bl) {
        this.strictErrorChecking = bl;
    }

    public String getDocumentURI() {
        return this.documentURI;
    }

    public void setDocumentURI(String string) {
        this.documentURI = string;
    }

    public Node adoptNode(Node node) throws DOMException {
        if (node instanceof NodeImpl) {
            NodeImpl nodeImpl = (NodeImpl)node;
            nodeImpl.setOwnerDocument(this, true);
            return nodeImpl;
        }
        throw new DOMException(9, "Invalid Node implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMConfiguration getDomConfig() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.domConfig == null) {
                this.domConfig = new DOMConfigurationImpl();
            }
            return this.domConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalizeDocument() {
        Object object = this.treeLock;
        synchronized (object) {
            this.visitImpl(new NodeVisitor(){

                public void visit(Node node) {
                    node.normalize();
                }
            });
        }
    }

    public Node renameNode(Node node, String string, String string2) throws DOMException {
        throw new DOMException(9, "No renaming");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMImplementation getImplementation() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.domImplementation == null) {
                this.domImplementation = new DOMImplementationImpl(this.ucontext);
            }
            return this.domImplementation;
        }
    }

    public String getLocalName() {
        return null;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMException(13, "Cannot set node value of document");
    }

    public final HtmlRendererContext getHtmlRendererContext() {
        return this.rcontext;
    }

    public UserAgentContext getUserAgentContext() {
        return this.ucontext;
    }

    public final URL getFullURL(String string) {
        try {
            String string2 = this.getBaseURI();
            URL uRL = string2 == null ? null : new URL(string2);
            return Urls.createURL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException2) {
                logger.log(Level.WARNING, "Unable to create URL for URI=[" + string + "], with base=[" + this.getBaseURI() + "].", malformedURLException);
                return null;
            }
        }
    }

    public final Location getLocation() {
        return this.window.getLocation();
    }

    public void setLocation(String string) {
        this.getLocation().setHref(string);
    }

    public String getURL() {
        return this.documentURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBody(HTMLElement hTMLElement) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.body = hTMLElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addStyleSheet(CSSStyleSheet cSSStyleSheet) {
        Object object = this.treeLock;
        synchronized (object) {
            this.styleSheets.add(cSSStyleSheet);
            this.styleSheetAggregator = null;
            this.forgetRenderState();
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof HTMLElementImpl)) continue;
                    ((HTMLElementImpl)e).forgetStyle(true);
                }
            }
        }
        this.allInvalidated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allInvalidated(boolean bl) {
        if (bl) {
            Object object = this.treeLock;
            synchronized (object) {
                this.styleSheetAggregator = null;
                this.forgetRenderState();
                ArrayList arrayList = this.nodeList;
                if (arrayList != null) {
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof HTMLElementImpl)) continue;
                        ((HTMLElementImpl)e).forgetStyle(true);
                    }
                }
            }
        }
        this.allInvalidated();
    }

    public Collection getStyleSheets() {
        return this.styleSheets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final StyleSheetAggregator getStyleSheetAggregator() {
        Object object = this.treeLock;
        synchronized (object) {
            StyleSheetAggregator styleSheetAggregator = this.styleSheetAggregator;
            if (styleSheetAggregator == null) {
                styleSheetAggregator = new StyleSheetAggregator(this);
                try {
                    styleSheetAggregator.addStyleSheets(this.styleSheets);
                }
                catch (MalformedURLException malformedURLException) {
                    logger.log(Level.WARNING, "getStyleSheetAggregator()", malformedURLException);
                }
                this.styleSheetAggregator = styleSheetAggregator;
            }
            return styleSheetAggregator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentNotificationListener(DocumentNotificationListener documentNotificationListener) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.documentNotificationListeners;
        synchronized (arrayList2) {
            arrayList.add(documentNotificationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentNotificationListener(DocumentNotificationListener documentNotificationListener) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.documentNotificationListeners;
        synchronized (arrayList2) {
            arrayList.remove(documentNotificationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sizeInvalidated(NodeImpl nodeImpl) {
        int n;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.documentNotificationListeners;
        synchronized (arrayList2) {
            n = arrayList.size();
        }
        for (int i = 0; i < n; ++i) {
            try {
                DocumentNotificationListener documentNotificationListener = (DocumentNotificationListener)arrayList.get(i);
                documentNotificationListener.sizeInvalidated(nodeImpl);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookInvalidated(NodeImpl nodeImpl) {
        int n;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.documentNotificationListeners;
        synchronized (arrayList2) {
            n = arrayList.size();
        }
        for (int i = 0; i < n; ++i) {
            try {
                DocumentNotificationListener documentNotificationListener = (DocumentNotificationListener)arrayList.get(i);
                documentNotificationListener.lookInvalidated(nodeImpl);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionInParentInvalidated(NodeImpl nodeImpl) {
        int n;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.documentNotificationListeners;
        synchronized (arrayList2) {
            n = arrayList.size();
        }
        for (int i = 0; i < n; ++i) {
            try {
                DocumentNotificationListener documentNotificationListener = (DocumentNotificationListener)arrayList.get(i);
                documentNotificationListener.positionInvalidated(nodeImpl);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidated(NodeImpl nodeImpl) {
        int n;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.documentNotificationListeners;
        synchronized (arrayList2) {
            n = arrayList.size();
        }
        for (int i = 0; i < n; ++i) {
            try {
                DocumentNotificationListener documentNotificationListener = (DocumentNotificationListener)arrayList.get(i);
                documentNotificationListener.invalidated(nodeImpl);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void structureInvalidated(NodeImpl nodeImpl) {
        int n;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.documentNotificationListeners;
        synchronized (arrayList2) {
            n = arrayList.size();
        }
        for (int i = 0; i < n; ++i) {
            try {
                DocumentNotificationListener documentNotificationListener = (DocumentNotificationListener)arrayList.get(i);
                documentNotificationListener.structureInvalidated(nodeImpl);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeLoaded(NodeImpl nodeImpl) {
        int n;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.documentNotificationListeners;
        synchronized (arrayList2) {
            n = arrayList.size();
        }
        for (int i = 0; i < n; ++i) {
            try {
                DocumentNotificationListener documentNotificationListener = (DocumentNotificationListener)arrayList.get(i);
                documentNotificationListener.nodeLoaded(nodeImpl);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void externalScriptLoading(NodeImpl nodeImpl) {
        int n;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.documentNotificationListeners;
        synchronized (arrayList2) {
            n = arrayList.size();
        }
        for (int i = 0; i < n; ++i) {
            try {
                DocumentNotificationListener documentNotificationListener = (DocumentNotificationListener)arrayList.get(i);
                documentNotificationListener.externalScriptLoading(nodeImpl);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allInvalidated() {
        int n;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.documentNotificationListeners;
        synchronized (arrayList2) {
            n = arrayList.size();
        }
        for (int i = 0; i < n; ++i) {
            try {
                DocumentNotificationListener documentNotificationListener = (DocumentNotificationListener)arrayList.get(i);
                documentNotificationListener.allInvalidated();
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    protected RenderState createRenderState(RenderState renderState) {
        return new StyleSheetRenderState(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadImage(String string, ImageListener imageListener) {
        HtmlRendererContext htmlRendererContext = this.getHtmlRendererContext();
        if (htmlRendererContext == null || !htmlRendererContext.isImageLoadingEnabled()) {
            imageListener.imageLoaded(this.BLANK_IMAGE_EVENT);
            return;
        }
        final URL uRL = this.getFullURL(string);
        if (uRL == null) {
            imageListener.imageLoaded(this.BLANK_IMAGE_EVENT);
            return;
        }
        final String string2 = uRL.toExternalForm();
        final Map map = this.imageInfos;
        ImageEvent imageEvent = null;
        Map map2 = map;
        synchronized (map2) {
            ImageInfo imageInfo = (ImageInfo)map.get(string2);
            if (imageInfo != null) {
                if (imageInfo.loaded) {
                    imageEvent = imageInfo.imageEvent;
                } else {
                    imageInfo.addListener(imageListener);
                }
            } else {
                UserAgentContext userAgentContext = htmlRendererContext.getUserAgentContext();
                final HttpRequest httpRequest = userAgentContext.createHttpRequest();
                final ImageInfo imageInfo2 = new ImageInfo();
                map.put(string2, imageInfo2);
                imageInfo2.addListener(imageListener);
                httpRequest.addReadyStateChangeListener(new ReadyStateChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void readyStateChanged() {
                        if (httpRequest.getReadyState() == 4) {
                            ImageListener[] imageListenerArray;
                            Image image = httpRequest.getResponseImage();
                            ImageEvent imageEvent = image == null ? null : new ImageEvent(HTMLDocumentImpl.this, image);
                            Map map2 = map;
                            synchronized (map2) {
                                imageInfo2.imageEvent = imageEvent;
                                imageInfo2.loaded = true;
                                imageListenerArray = imageEvent == null ? null : imageInfo2.getListeners();
                                map.remove(string2);
                            }
                            if (imageListenerArray != null) {
                                int n = imageListenerArray.length;
                                for (int i = 0; i < n; ++i) {
                                    imageListenerArray[i].imageLoaded(imageEvent);
                                }
                            }
                        }
                    }
                });
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager == null) {
                    try {
                        httpRequest.open("GET", uRL, true);
                        httpRequest.send(null);
                    }
                    catch (IOException iOException) {
                        logger.log(Level.WARNING, "loadImage()", iOException);
                    }
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                httpRequest.open("GET", uRL, true);
                                httpRequest.send(null);
                            }
                            catch (IOException iOException) {
                                logger.log(Level.WARNING, "loadImage()", iOException);
                            }
                            return null;
                        }
                    });
                }
            }
        }
        if (imageEvent != null) {
            imageListener.imageLoaded(imageEvent);
        }
    }

    public Function getOnloadHandler() {
        return this.onloadHandler;
    }

    public void setOnloadHandler(Function function) {
        this.onloadHandler = function;
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        Function function = this.onloadHandler;
        if (function != null && "cobra.suspend".equals(string) && object == Boolean.FALSE) {
            Executor.executeFunction(this, function, null);
        }
        return super.setUserData(string, object, userDataHandler);
    }

    protected Node createSimilarNode() {
        return new HTMLDocumentImpl(this.ucontext, this.rcontext, this.reader, this.documentURI);
    }

    private class LocalWritableLineReader
    extends WritableLineReader {
        public LocalWritableLineReader(LineNumberReader lineNumberReader) {
            super(lineNumberReader);
        }

        public LocalWritableLineReader(Reader reader) {
            super(reader);
        }

        public void write(String string) throws IOException {
            super.write(string);
            if ("".equals(string)) {
                HTMLDocumentImpl.this.openBufferChanged(string);
            }
        }
    }

    private class TagNameFilter
    implements NodeFilter {
        private final String name;

        public TagNameFilter(String string) {
            this.name = string;
        }

        public boolean accept(Node node) {
            if (!(node instanceof Element)) {
                return false;
            }
            String string = this.name;
            return string.equalsIgnoreCase(((Element)node).getTagName());
        }
    }

    private class ElementFilter
    implements NodeFilter {
        public boolean accept(Node node) {
            return node instanceof Element;
        }
    }

    private class ElementNameFilter
    implements NodeFilter {
        private final String name;

        public ElementNameFilter(String string) {
            this.name = string;
        }

        public boolean accept(Node node) {
            return node instanceof Element && this.name.equals(((Element)node).getAttribute("name"));
        }
    }

    private class FrameFilter
    implements NodeFilter {
        private FrameFilter() {
        }

        public boolean accept(Node node) {
            return node instanceof HTMLFrameElement || node instanceof HTMLIFrameElement;
        }
    }

    private class FormFilter
    implements NodeFilter {
        private FormFilter() {
        }

        public boolean accept(Node node) {
            String string = node.getNodeName();
            return "FORM".equalsIgnoreCase(string);
        }
    }

    private class AnchorFilter
    implements NodeFilter {
        private AnchorFilter() {
        }

        public boolean accept(Node node) {
            String string = node.getNodeName();
            return "A".equalsIgnoreCase(string) || "ANCHOR".equalsIgnoreCase(string);
        }
    }

    private class LinkFilter
    implements NodeFilter {
        private LinkFilter() {
        }

        public boolean accept(Node node) {
            return node instanceof HTMLLinkElement;
        }
    }

    private class AppletFilter
    implements NodeFilter {
        private AppletFilter() {
        }

        public boolean accept(Node node) {
            return "APPLET".equalsIgnoreCase(node.getNodeName());
        }
    }

    private class ImageFilter
    implements NodeFilter {
        private ImageFilter() {
        }

        public boolean accept(Node node) {
            return "IMG".equalsIgnoreCase(node.getNodeName());
        }
    }

    private static class ImageInfo {
        public ImageEvent imageEvent;
        public boolean loaded;
        private ArrayList listeners = new ArrayList(1);

        private ImageInfo() {
        }

        void addListener(ImageListener imageListener) {
            this.listeners.add(imageListener);
        }

        ImageListener[] getListeners() {
            return this.listeners.toArray(ImageListener.EMPTY_ARRAY);
        }
    }

    public class CSSStyleSheetList
    extends ArrayList {
        public int getLength() {
            return this.size();
        }

        public CSSStyleSheet item(int n) {
            return (CSSStyleSheet)this.get(n);
        }
    }
}

