/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.BaseFontRenderState;
import org.lobobrowser.html.style.ComputedCSS2Properties;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.w3c.dom.html2.HTMLBaseFontElement;

public class HTMLBaseFontElementImpl
extends HTMLAbstractUIElement
implements HTMLBaseFontElement {
    public HTMLBaseFontElementImpl(String string) {
        super(string);
    }

    public String getColor() {
        return this.getAttribute("color");
    }

    public String getFace() {
        return this.getAttribute("face");
    }

    public void setColor(String string) {
        this.setAttribute("color", string);
    }

    public void setFace(String string) {
        this.setAttribute("face", string);
    }

    public int getSize() {
        try {
            return Integer.parseInt(this.getAttribute("size"));
        }
        catch (Exception exception) {
            this.warn("getSize(): Unable to parse size attribute in " + this + ".", exception);
            return 0;
        }
    }

    public void setSize(int n) {
        this.setAttribute("size", String.valueOf(n));
    }

    protected RenderState createRenderState(RenderState renderState) {
        String string = this.getAttribute("size");
        if (string != null) {
            int n = HtmlValues.getFontNumberOldStyle(string, renderState);
            float f = HtmlValues.getFontSize(n);
            renderState = new BaseFontRenderState(renderState, n);
        }
        return super.createRenderState(renderState);
    }

    protected AbstractCSS2Properties createDefaultStyleSheet() {
        String string = this.getAttribute("face");
        String string2 = this.getAttribute("color");
        String string3 = this.getAttribute("size");
        ModelNode modelNode = this.getParentModelNode();
        RenderState renderState = modelNode == null ? null : modelNode.getRenderState();
        String string4 = null;
        if (renderState != null) {
            int n = HtmlValues.getFontNumberOldStyle(string3, renderState);
            string4 = HtmlValues.getFontSizeSpec(n);
        }
        ComputedCSS2Properties computedCSS2Properties = new ComputedCSS2Properties(this);
        if (string4 != null) {
            computedCSS2Properties.internalSetLC("font-size", string4);
        }
        if (string != null) {
            computedCSS2Properties.internalSetLC("font-family", string);
        }
        if (string2 != null) {
            computedCSS2Properties.internalSetLC("color", string2);
        }
        return computedCSS2Properties;
    }
}

