/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lobobrowser.html.domimpl.DocumentNotificationAdapter;
import org.lobobrowser.html.domimpl.ElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.util.Nodes;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;

public class DescendentHTMLCollection
extends AbstractScriptableDelegate
implements HTMLCollection {
    private final NodeImpl rootNode;
    private final NodeFilter nodeFilter;
    private final Object treeLock;
    private final boolean nestIntoMatchingNodes;
    private Map itemsByName = null;
    private List itemsByIndex = null;

    public DescendentHTMLCollection(NodeImpl nodeImpl, NodeFilter nodeFilter, Object object) {
        this(nodeImpl, nodeFilter, object, true);
    }

    public DescendentHTMLCollection(NodeImpl nodeImpl, NodeFilter nodeFilter, Object object, boolean bl) {
        this.rootNode = nodeImpl;
        this.nodeFilter = nodeFilter;
        this.treeLock = object;
        this.nestIntoMatchingNodes = bl;
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)nodeImpl.getOwnerDocument();
        hTMLDocumentImpl.addDocumentNotificationListener(new LocalNotificationListener(hTMLDocumentImpl, this));
    }

    private void ensurePopulatedImpl() {
        if (this.itemsByName == null) {
            HashMap<String, ElementImpl> hashMap;
            ArrayList arrayList = this.rootNode.getDescendents(this.nodeFilter, this.nestIntoMatchingNodes);
            this.itemsByIndex = arrayList == null ? Collections.EMPTY_LIST : arrayList;
            int n = arrayList == null ? 0 : arrayList.size();
            this.itemsByName = hashMap = new HashMap<String, ElementImpl>(n * 3 / 2);
            for (int i = 0; i < n; ++i) {
                String string;
                Object e = arrayList.get(i);
                if (!(e instanceof ElementImpl)) continue;
                ElementImpl elementImpl = (ElementImpl)e;
                String string2 = elementImpl.getId();
                if (string2 != null && string2.length() != 0) {
                    hashMap.put(string2, elementImpl);
                }
                if ((string = elementImpl.getAttribute("name")) == null || string.length() == 0 || string.equals(string2)) continue;
                hashMap.put(string, elementImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        Object object = this.treeLock;
        synchronized (object) {
            this.itemsByName = null;
            this.itemsByIndex = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.itemsByName != null && this.itemsByIndex != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            return this.itemsByIndex.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node item(int n) {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            try {
                return (Node)this.itemsByIndex.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node namedItem(String string) {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            return (Node)this.itemsByName.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Node node) {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            return this.itemsByIndex.indexOf(node);
        }
    }

    private static class LocalNotificationListener
    extends DocumentNotificationAdapter {
        private final HTMLDocumentImpl document;
        private final WeakReference collectionRef;

        public LocalNotificationListener(HTMLDocumentImpl hTMLDocumentImpl, DescendentHTMLCollection descendentHTMLCollection) {
            this.document = hTMLDocumentImpl;
            this.collectionRef = new WeakReference<DescendentHTMLCollection>(descendentHTMLCollection);
        }

        public void structureInvalidated(NodeImpl nodeImpl) {
            DescendentHTMLCollection descendentHTMLCollection = (DescendentHTMLCollection)this.collectionRef.get();
            if (descendentHTMLCollection == null) {
                this.document.removeDocumentNotificationListener(this);
                return;
            }
            if (descendentHTMLCollection.isValid() && Nodes.isSameOrAncestorOf(descendentHTMLCollection.rootNode, nodeImpl)) {
                descendentHTMLCollection.invalidate();
            }
        }

        public void nodeLoaded(NodeImpl nodeImpl) {
            this.structureInvalidated(nodeImpl);
        }
    }
}

