/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;

public class ChildHTMLCollection
extends AbstractScriptableDelegate
implements HTMLCollection {
    private final NodeImpl rootNode;

    public ChildHTMLCollection(NodeImpl nodeImpl) {
        this.rootNode = nodeImpl;
    }

    public int getLength() {
        return this.rootNode.getChildCount();
    }

    public Node item(int n) {
        return this.rootNode.getChildAtIndex(n);
    }

    public Node namedItem(String string) {
        Document document = this.rootNode.getOwnerDocument();
        if (document == null) {
            return null;
        }
        Element element = document.getElementById(string);
        if (element != null && element.getParentNode() == this.rootNode) {
            return element;
        }
        return null;
    }

    public int indexOf(Node node) {
        return this.rootNode.getChildIndex(node);
    }
}

