/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import com.steadystate.css.parser.ASCII_CharStream;
import com.steadystate.css.parser.CharStream;
import com.steadystate.css.parser.LexicalUnitImpl;
import com.steadystate.css.parser.ParseException;
import com.steadystate.css.parser.SACMediaListImpl;
import com.steadystate.css.parser.SACParserConstants;
import com.steadystate.css.parser.SACParserTokenManager;
import com.steadystate.css.parser.SelectorListImpl;
import com.steadystate.css.parser.Token;
import com.steadystate.css.parser.selectors.ConditionFactoryImpl;
import com.steadystate.css.parser.selectors.SelectorFactoryImpl;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;

public class SACParser
implements Parser,
SACParserConstants {
    private static final Logger logger = Logger.getLogger(SACParser.class.getName());
    private InputSource _source = null;
    private Locale _locale = null;
    private DocumentHandler _docHandler = null;
    private ErrorHandler _errHandler = null;
    private SelectorFactory _selectorFactory = new SelectorFactoryImpl();
    private ConditionFactory _conditionFactory = new ConditionFactoryImpl();
    private boolean _quiet = true;
    public SACParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[108];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public SACParser() {
        this((CharStream)null);
    }

    public void setLocale(Locale locale) throws CSSException {
        this._locale = locale;
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this._docHandler = documentHandler;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        this._selectorFactory = selectorFactory;
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        this._conditionFactory = conditionFactory;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errHandler = errorHandler;
    }

    public void parseStyleSheet(InputSource inputSource) throws CSSException, IOException {
        this._source = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        try {
            this.styleSheet();
        }
        catch (ParseException parseException) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, parseException.getMessage(), parseException);
        }
    }

    public void parseStyleSheet(String string) throws CSSException, IOException {
        this.parseStyleSheet(new InputSource(string));
    }

    public void parseStyleDeclaration(InputSource inputSource) throws CSSException, IOException {
        this._source = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        try {
            this.styleDeclaration();
        }
        catch (ParseException parseException) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, parseException.getMessage(), parseException);
        }
    }

    public void parseRule(InputSource inputSource) throws CSSException, IOException {
        this._source = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        try {
            this.styleSheetRuleSingle();
        }
        catch (ParseException parseException) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, parseException.getMessage(), parseException);
        }
    }

    public String getParserVersion() {
        return "http://www.w3.org/TR/REC-CSS2";
    }

    public SelectorList parseSelectors(InputSource inputSource) throws CSSException, IOException {
        this._source = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        SelectorList selectorList = null;
        try {
            selectorList = this.selectorList();
        }
        catch (ParseException parseException) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, parseException.getMessage(), parseException);
        }
        return selectorList;
    }

    public LexicalUnit parsePropertyValue(InputSource inputSource) throws CSSException, IOException {
        this._source = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        LexicalUnit lexicalUnit = null;
        try {
            lexicalUnit = this.expr();
        }
        catch (ParseException parseException) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, parseException.getMessage(), parseException);
        }
        return lexicalUnit;
    }

    public boolean parsePriority(InputSource inputSource) throws CSSException, IOException {
        this._source = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        boolean bl = false;
        try {
            bl = this.prio();
        }
        catch (ParseException parseException) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, parseException.getMessage(), parseException);
        }
        return bl;
    }

    private CharStream getCharStream(InputSource inputSource) throws CSSException, IOException {
        if (inputSource.getCharacterStream() != null) {
            return new ASCII_CharStream(inputSource.getCharacterStream(), 1, 1);
        }
        return null;
    }

    private Locator getLocator() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void styleSheet() throws ParseException {
        try {
            this._docHandler.startDocument(this._source);
            this.styleSheetRuleList();
            try {
                this.jj_consume_token(0);
            }
            catch (ParseException parseException) {
                logger.log(Level.WARNING, "styleSheet(): " + this._source.getURI() + ": Skipping last part of style sheet: " + parseException.getMessage());
            }
        }
        finally {
            this._docHandler.endDocument(this._source);
        }
    }

    public final void styleSheetRuleList() throws ParseException {
        block47: {
            block46: {
                block45: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 36: {
                            this.charsetRule();
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                        }
                    }
                    block40: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 28: 
                            case 29: {
                                break;
                            }
                            default: {
                                this.jj_la1[1] = this.jj_gen;
                                break block45;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                continue block40;
                            }
                            case 28: {
                                this.jj_consume_token(28);
                                continue block40;
                            }
                            case 29: {
                                this.jj_consume_token(29);
                                continue block40;
                            }
                        }
                        break;
                    }
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                block41: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 32: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block46;
                        }
                    }
                    this.importRule();
                    block42: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 28: 
                            case 29: {
                                break;
                            }
                            default: {
                                this.jj_la1[4] = this.jj_gen;
                                continue block41;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                continue block42;
                            }
                            case 28: {
                                this.jj_consume_token(28);
                                continue block42;
                            }
                            case 29: {
                                this.jj_consume_token(29);
                                continue block42;
                            }
                        }
                        break;
                    }
                    break;
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block43: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 11: 
                    case 12: 
                    case 18: 
                    case 23: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 37: 
                    case 55: 
                    case 60: {
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        break block47;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 11: 
                    case 12: 
                    case 18: 
                    case 23: 
                    case 55: 
                    case 60: {
                        this.styleRule();
                        break;
                    }
                    case 34: {
                        this.mediaRule();
                        break;
                    }
                    case 33: {
                        this.pageRule();
                        break;
                    }
                    case 35: {
                        this.fontFaceRule();
                        break;
                    }
                    case 37: {
                        this.unknownRule();
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block44: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 28: 
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            continue block43;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            this.jj_consume_token(1);
                            continue block44;
                        }
                        case 28: {
                            this.jj_consume_token(28);
                            continue block44;
                        }
                        case 29: {
                            this.jj_consume_token(29);
                            continue block44;
                        }
                    }
                    break;
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void styleSheetRuleSingle() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.charsetRule();
                break;
            }
            case 32: {
                this.importRule();
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 18: 
            case 23: 
            case 55: 
            case 60: {
                this.styleRule();
                break;
            }
            case 34: {
                this.mediaRule();
                break;
            }
            case 33: {
                this.pageRule();
                break;
            }
            case 35: {
                this.fontFaceRule();
                break;
            }
            case 37: {
                this.unknownRule();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void charsetRule() throws ParseException {
        this.jj_consume_token(36);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(1);
        }
        Token token = this.jj_consume_token(24);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(1);
        }
        this.jj_consume_token(10);
    }

    public final void unknownRule() throws ParseException {
        Token token = this.jj_consume_token(37);
        String string = this.skip();
        this._docHandler.ignorableAtRule(string);
    }

    public final void importRule() throws ParseException {
        Token token;
        SACMediaListImpl sACMediaListImpl = new SACMediaListImpl();
        this.jj_consume_token(32);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(1);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                token = this.jj_consume_token(24);
                break;
            }
            case 27: {
                token = this.jj_consume_token(27);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(1);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.mediaList(sACMediaListImpl);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        this.jj_consume_token(10);
        this._docHandler.importStyle(this.unescape(token.image), sACMediaListImpl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mediaRule() throws ParseException {
        boolean bl = false;
        SACMediaListImpl sACMediaListImpl = new SACMediaListImpl();
        try {
            this.jj_consume_token(34);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(1);
            }
            this.mediaQuery(sACMediaListImpl);
            bl = true;
            this._docHandler.startMedia(sACMediaListImpl);
            this.jj_consume_token(5);
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        break block13;
                    }
                }
                this.jj_consume_token(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 11: 
                case 12: 
                case 18: 
                case 23: 
                case 33: 
                case 37: 
                case 55: 
                case 60: {
                    this.mediaRuleList();
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                }
            }
            this.jj_consume_token(6);
        }
        finally {
            if (bl) {
                this._docHandler.endMedia(sACMediaListImpl);
            }
        }
    }

    public final void mediaQuery(SACMediaListImpl sACMediaListImpl) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: 
            case 21: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        this.jj_consume_token(21);
                        break block0;
                    }
                    case 20: {
                        this.jj_consume_token(20);
                        break block0;
                    }
                }
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        String string = this.medium();
        sACMediaListImpl.add(string);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 22: {
                this.mediaListOrExpression(sACMediaListImpl);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
    }

    public final void mediaListOrExpression(SACMediaListImpl sACMediaListImpl) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                block16: while (true) {
                    this.jj_consume_token(8);
                    block17: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[23] = this.jj_gen;
                                break block17;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                    String string = this.medium();
                    sACMediaListImpl.add(string);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            continue block16;
                        }
                    }
                    break;
                }
                this.jj_la1[24] = this.jj_gen;
                break;
            }
            case 22: {
                block18: while (true) {
                    this.jj_consume_token(22);
                    block19: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[25] = this.jj_gen;
                                break block19;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                    this.mediaExpression(sACMediaListImpl);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 22: {
                            continue block18;
                        }
                    }
                    break;
                }
                this.jj_la1[26] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void mediaExpression(SACMediaListImpl sACMediaListImpl) throws ParseException {
        this.jj_consume_token(7);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(1);
        }
        this.mediaFeature(sACMediaListImpl);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[29] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(1);
                }
                this.expr();
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
        this.jj_consume_token(25);
    }

    public final void mediaFeature(SACMediaListImpl sACMediaListImpl) throws ParseException {
        Token token = this.jj_consume_token(60);
    }

    public final void mediaList(SACMediaListImpl sACMediaListImpl) throws ParseException {
        String string = this.medium();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(8);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(1);
            }
            sACMediaListImpl.add(string);
            string = this.medium();
        }
        sACMediaListImpl.add(string);
    }

    public final void mediaRuleList() throws ParseException {
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 11: 
                case 12: 
                case 18: 
                case 23: 
                case 55: 
                case 60: {
                    this.styleRule();
                    break;
                }
                case 33: {
                    this.pageRule();
                    break;
                }
                case 37: {
                    this.unknownRule();
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 11: 
                case 12: 
                case 18: 
                case 23: 
                case 33: 
                case 37: 
                case 55: 
                case 60: {
                    continue block11;
                }
            }
            break;
        }
        this.jj_la1[35] = this.jj_gen;
    }

    public final void mediaRuleSingle() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 11: 
            case 12: 
            case 18: 
            case 23: 
            case 55: 
            case 60: {
                this.styleRule();
                break;
            }
            case 33: {
                this.pageRule();
                break;
            }
            case 37: {
                this.unknownRule();
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String medium() throws ParseException {
        Token token = this.jj_consume_token(60);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(1);
        }
        return token.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pageRule() throws ParseException {
        block45: {
            Token token = null;
            String string = null;
            boolean bl = false;
            try {
                this.jj_consume_token(33);
                block36: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[38] = this.jj_gen;
                            break block36;
                        }
                    }
                    this.jj_consume_token(1);
                }
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: 
                    case 60: {
                        if (this.jj_2_1(2)) {
                            token = this.jj_consume_token(60);
                            while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 1: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[39] = this.jj_gen;
                                        break block4;
                                    }
                                }
                                this.jj_consume_token(1);
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 60: {
                                token = this.jj_consume_token(60);
                                string = this.pseudoPage();
                                while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 1: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[40] = this.jj_gen;
                                            break block4;
                                        }
                                    }
                                    this.jj_consume_token(1);
                                }
                            }
                            case 11: {
                                string = this.pseudoPage();
                                while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 1: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[41] = this.jj_gen;
                                            break block4;
                                        }
                                    }
                                    this.jj_consume_token(1);
                                }
                            }
                        }
                        this.jj_la1[42] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                    }
                }
                this.jj_consume_token(5);
                block40: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[44] = this.jj_gen;
                            break block40;
                        }
                    }
                    this.jj_consume_token(1);
                }
                bl = true;
                this._docHandler.startPage(token != null ? this.unescape(token.image) : null, string);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 60: {
                        this.declaration();
                        break;
                    }
                    default: {
                        this.jj_la1[45] = this.jj_gen;
                    }
                }
                block41: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 10: {
                            break;
                        }
                        default: {
                            this.jj_la1[46] = this.jj_gen;
                            break block41;
                        }
                    }
                    this.jj_consume_token(10);
                    block42: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[47] = this.jj_gen;
                                break block42;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 60: {
                            this.declaration();
                            continue block41;
                        }
                    }
                    this.jj_la1[48] = this.jj_gen;
                }
                this.jj_consume_token(6);
                if (!bl) break block45;
                this._docHandler.endPage(token != null ? this.unescape(token.image) : null, string);
            }
            catch (Throwable throwable) {
                if (bl) {
                    this._docHandler.endPage(token != null ? this.unescape(token.image) : null, string);
                }
                throw throwable;
            }
        }
    }

    public final String pseudoPage() throws ParseException {
        this.jj_consume_token(11);
        Token token = this.jj_consume_token(60);
        return token.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fontFaceRule() throws ParseException {
        boolean bl = false;
        try {
            this.jj_consume_token(35);
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[49] = this.jj_gen;
                        break block21;
                    }
                }
                this.jj_consume_token(1);
            }
            this.jj_consume_token(5);
            block22: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                        break block22;
                    }
                }
                this.jj_consume_token(1);
            }
            bl = true;
            this._docHandler.startFontFace();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 60: {
                    this.declaration();
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                }
            }
            block23: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        break block23;
                    }
                }
                this.jj_consume_token(10);
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[53] = this.jj_gen;
                            break block24;
                        }
                    }
                    this.jj_consume_token(1);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 60: {
                        this.declaration();
                        continue block23;
                    }
                }
                this.jj_la1[54] = this.jj_gen;
            }
            this.jj_consume_token(6);
        }
        finally {
            if (bl) {
                this._docHandler.endFontFace();
            }
        }
    }

    public final LexicalUnit operator(LexicalUnit lexicalUnit) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                Token token = this.jj_consume_token(13);
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[55] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.jj_consume_token(1);
                }
                return new LexicalUnitImpl(lexicalUnit, 4);
            }
            case 8: {
                Token token = this.jj_consume_token(8);
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[56] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(1);
                }
                return new LexicalUnitImpl(lexicalUnit, 0);
            }
            case 16: {
                Token token = this.jj_consume_token(16);
                block16: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[57] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.jj_consume_token(1);
                }
                return new LexicalUnitImpl(lexicalUnit, 43);
            }
        }
        this.jj_la1[58] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final char combinator() throws ParseException {
        int n = 32;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                n = 43;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[59] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(1);
                }
            }
            case 17: {
                this.jj_consume_token(17);
                n = 62;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[60] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(1);
                }
            }
            case 1: {
                this.jj_consume_token(1);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 17: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 14: {
                                this.jj_consume_token(14);
                                n = 43;
                                break;
                            }
                            case 17: {
                                this.jj_consume_token(17);
                                n = 62;
                                break;
                            }
                            default: {
                                this.jj_la1[61] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 1: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[62] = this.jj_gen;
                                    break block0;
                                }
                            }
                            this.jj_consume_token(1);
                        }
                    }
                }
                this.jj_la1[63] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return (char)n;
    }

    public final char unaryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                return '-';
            }
            case 14: {
                this.jj_consume_token(14);
                return '+';
            }
        }
        this.jj_la1[65] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String property() throws ParseException {
        Token token = this.jj_consume_token(60);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(1);
        }
        return this.unescape(token.image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void styleRule() throws ParseException {
        SelectorList selectorList = null;
        boolean bl = false;
        boolean bl2 = true;
        try {
            selectorList = this.selectorList();
            this.jj_consume_token(5);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[67] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(1);
            }
            bl = true;
            this._docHandler.startSelector(selectorList);
            this.styleRuleDeclarations();
        }
        catch (ParseException parseException) {
            logger.log(Level.WARNING, "styleRule(): " + this._source.getURI() + ": Skipping block: " + parseException.getMessage() + ".");
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "styleRule()", parseException);
            }
            bl2 = false;
            this.error_skipblock();
        }
        finally {
            if (bl) {
                this._docHandler.endSelector(selectorList);
            }
        }
    }

    public final void styleRuleDeclarations() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.declaration();
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
            }
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[69] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(10);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[70] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 60: {
                    this.declaration();
                    continue block14;
                }
            }
            this.jj_la1[71] = this.jj_gen;
        }
        try {
            this.jj_consume_token(6);
        }
        catch (ParseException parseException) {
            logger.log(Level.WARNING, "styleRule(): " + this._source.getURI() + ": Skipping declaration: " + parseException.getMessage() + ".");
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "styleRule()", parseException);
            }
            this.error_skipdecl();
            this.styleRuleDeclarations();
        }
    }

    public final SelectorList selectorList() throws ParseException {
        SelectorListImpl selectorListImpl = new SelectorListImpl();
        Selector selector = this.selector();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(8);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[73] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(1);
            }
            selectorListImpl.add(selector);
            selector = this.selector();
        }
        selectorListImpl.add(selector);
        return selectorListImpl;
    }

    public final Selector selector() throws ParseException {
        Selector selector = this.simpleSelector(null, ' ');
        while (this.jj_2_2(2)) {
            char c = this.combinator();
            selector = this.simpleSelector(selector, c);
        }
        block4: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[74] = this.jj_gen;
                    break block4;
                }
            }
            this.jj_consume_token(1);
        }
        return selector;
    }

    public final Selector simpleSelector(Selector selector, char c) throws ParseException {
        SimpleSelector simpleSelector = null;
        Condition condition = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 60: {
                simpleSelector = this.elementName();
                block27: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: 
                        case 11: 
                        case 18: 
                        case 23: 
                        case 55: {
                            break;
                        }
                        default: {
                            this.jj_la1[75] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 23: {
                            condition = this.hash(condition);
                            continue block27;
                        }
                        case 9: 
                        case 55: {
                            condition = this._class(condition);
                            continue block27;
                        }
                        case 18: {
                            condition = this.attrib(condition);
                            continue block27;
                        }
                        case 11: {
                            condition = this.pseudo(condition);
                            continue block27;
                        }
                    }
                    break;
                }
                this.jj_la1[76] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 9: 
            case 11: 
            case 18: 
            case 23: 
            case 55: {
                simpleSelector = this._selectorFactory.createElementSelector(null, null);
                block28: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 23: {
                            condition = this.hash(condition);
                            break;
                        }
                        case 9: 
                        case 55: {
                            condition = this._class(condition);
                            break;
                        }
                        case 18: {
                            condition = this.attrib(condition);
                            break;
                        }
                        case 11: {
                            condition = this.pseudo(condition);
                            break;
                        }
                        default: {
                            this.jj_la1[77] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: 
                        case 11: 
                        case 18: 
                        case 23: 
                        case 55: {
                            continue block28;
                        }
                    }
                    break;
                }
                this.jj_la1[78] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (condition != null) {
            simpleSelector = this._selectorFactory.createConditionalSelector(simpleSelector, condition);
        }
        if (selector != null) {
            switch (c) {
                case ' ': {
                    selector = this._selectorFactory.createDescendantSelector(selector, simpleSelector);
                    break;
                }
                case '+': {
                    selector = this._selectorFactory.createDirectAdjacentSelector(selector.getSelectorType(), selector, simpleSelector);
                    break;
                }
                case '>': {
                    selector = this._selectorFactory.createChildSelector(selector, simpleSelector);
                }
            }
        } else {
            selector = simpleSelector;
        }
        return selector;
    }

    public final Condition _class(Condition condition) throws ParseException {
        String string;
        Object object;
        Token token;
        boolean bl = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                token = this.jj_consume_token(60);
                break;
            }
            case 55: {
                token = this.jj_consume_token(55);
                bl = true;
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (bl) {
            object = token.image;
            if (!((String)object).startsWith(".")) {
                return null;
            }
            string = ((String)object).substring(1);
        } else {
            string = token.image;
        }
        object = this._conditionFactory.createClassCondition(null, string);
        return condition == null ? object : this._conditionFactory.createAndCondition(condition, (Condition)object);
    }

    public final SimpleSelector elementName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                Token token = this.jj_consume_token(60);
                return this._selectorFactory.createElementSelector(null, this.unescape(token.image));
            }
            case 12: {
                this.jj_consume_token(12);
                return this._selectorFactory.createElementSelector(null, null);
            }
        }
        this.jj_la1[81] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Condition attrib(Condition condition) throws ParseException {
        String string = null;
        String string2 = null;
        int n = 0;
        this.jj_consume_token(18);
        block30: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                    break block30;
                }
            }
            this.jj_consume_token(1);
        }
        Token token = this.jj_consume_token(60);
        string = this.unescape(token.image);
        block31: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                    break block31;
                }
            }
            this.jj_consume_token(1);
        }
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: 
            case 30: 
            case 31: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        n = 1;
                        break;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        n = 2;
                        break;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        n = 3;
                        break;
                    }
                    default: {
                        this.jj_la1[84] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block32: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[85] = this.jj_gen;
                            break block32;
                        }
                    }
                    this.jj_consume_token(1);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 60: {
                        token = this.jj_consume_token(60);
                        string2 = token.image;
                        break;
                    }
                    case 24: {
                        token = this.jj_consume_token(24);
                        string2 = this.unescape(token.image);
                        break;
                    }
                    default: {
                        this.jj_la1[86] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[87] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(1);
                }
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
            }
        }
        this.jj_consume_token(19);
        Condition condition2 = null;
        switch (n) {
            case 0: {
                condition2 = this._conditionFactory.createAttributeCondition(string, null, false, null);
                break;
            }
            case 1: {
                condition2 = this._conditionFactory.createAttributeCondition(string, null, false, string2);
                break;
            }
            case 2: {
                condition2 = this._conditionFactory.createOneOfAttributeCondition(string, null, false, string2);
                break;
            }
            case 3: {
                condition2 = this._conditionFactory.createBeginHyphenAttributeCondition(string, null, false, string2);
            }
        }
        return condition == null ? condition2 : this._conditionFactory.createAndCondition(condition, condition2);
    }

    public final Condition pseudo(Condition condition) throws ParseException {
        this.jj_consume_token(11);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                Token token = this.jj_consume_token(60);
                String string = this.unescape(token.image);
                AttributeCondition attributeCondition = this._conditionFactory.createPseudoClassCondition(null, string);
                return condition == null ? attributeCondition : this._conditionFactory.createAndCondition(condition, attributeCondition);
            }
            case 59: {
                Token token = this.jj_consume_token(59);
                String string = this.unescape(token.image);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[89] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(1);
                }
                token = this.jj_consume_token(60);
                String string2 = this.unescape(token.image);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[90] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(1);
                }
                this.jj_consume_token(25);
                if (string.equalsIgnoreCase("lang(")) {
                    LangCondition langCondition = this._conditionFactory.createLangCondition(this.unescape(string2));
                    return condition == null ? langCondition : this._conditionFactory.createAndCondition(condition, langCondition);
                }
                throw new CSSParseException("Invalid pseudo function name " + string, this.getLocator());
            }
        }
        this.jj_la1[91] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Condition hash(Condition condition) throws ParseException {
        Token token = this.jj_consume_token(23);
        AttributeCondition attributeCondition = this._conditionFactory.createIdCondition(token.image.substring(1));
        return condition == null ? attributeCondition : this._conditionFactory.createAndCondition(condition, attributeCondition);
    }

    public final void styleDeclaration() throws ParseException {
        this.jj_consume_token(5);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[92] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(1);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.declaration();
                break;
            }
            default: {
                this.jj_la1[93] = this.jj_gen;
            }
        }
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                    break block16;
                }
            }
            this.jj_consume_token(10);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[95] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 60: {
                    this.declaration();
                    continue block16;
                }
            }
            this.jj_la1[96] = this.jj_gen;
        }
        this.jj_consume_token(6);
    }

    public final void declaration() throws ParseException {
        boolean bl = false;
        boolean bl2 = true;
        try {
            String string = this.property();
            this.jj_consume_token(11);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[97] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(1);
            }
            LexicalUnit lexicalUnit = this.expr();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 38: {
                    bl = this.prio();
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                }
            }
            this._docHandler.property(string, lexicalUnit, bl);
        }
        catch (ParseException parseException) {
            logger.log(Level.WARNING, "declaration(): " + this._source.getURI() + ": Skipping declaration due to: " + parseException.getMessage() + ".");
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "declaration()", parseException);
            }
            bl2 = false;
            this.error_skipdecl();
        }
    }

    public final boolean prio() throws ParseException {
        this.jj_consume_token(38);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[99] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(1);
        }
        return true;
    }

    public final LexicalUnit expr() throws ParseException {
        LexicalUnit lexicalUnit;
        LexicalUnit lexicalUnit2 = lexicalUnit = this.term(null);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 23: 
                case 24: 
                case 27: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 63: {
                    break;
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 13: 
                case 16: {
                    lexicalUnit2 = this.operator(lexicalUnit2);
                    break;
                }
                default: {
                    this.jj_la1[101] = this.jj_gen;
                }
            }
            lexicalUnit2 = this.term(lexicalUnit2);
        }
        return lexicalUnit;
    }

    public final LexicalUnit term(LexicalUnit lexicalUnit) throws ParseException {
        char c = ' ';
        LexicalUnit lexicalUnit2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: {
                c = this.unaryOperator();
                break;
            }
            default: {
                this.jj_la1[102] = this.jj_gen;
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 59: {
                Token token;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 57: {
                        token = this.jj_consume_token(57);
                        lexicalUnit2 = LexicalUnitImpl.createNumber(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 56: {
                        token = this.jj_consume_token(56);
                        lexicalUnit2 = LexicalUnitImpl.createPercentage(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 42: {
                        token = this.jj_consume_token(42);
                        lexicalUnit2 = LexicalUnitImpl.createPixel(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 43: {
                        token = this.jj_consume_token(43);
                        lexicalUnit2 = LexicalUnitImpl.createCentimeter(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 44: {
                        token = this.jj_consume_token(44);
                        lexicalUnit2 = LexicalUnitImpl.createMillimeter(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 45: {
                        token = this.jj_consume_token(45);
                        lexicalUnit2 = LexicalUnitImpl.createInch(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 46: {
                        token = this.jj_consume_token(46);
                        lexicalUnit2 = LexicalUnitImpl.createPoint(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 47: {
                        token = this.jj_consume_token(47);
                        lexicalUnit2 = LexicalUnitImpl.createPica(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 40: {
                        token = this.jj_consume_token(40);
                        lexicalUnit2 = LexicalUnitImpl.createEm(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 41: {
                        token = this.jj_consume_token(41);
                        lexicalUnit2 = LexicalUnitImpl.createEx(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 48: {
                        token = this.jj_consume_token(48);
                        lexicalUnit2 = LexicalUnitImpl.createDegree(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 49: {
                        token = this.jj_consume_token(49);
                        lexicalUnit2 = LexicalUnitImpl.createRadian(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 50: {
                        token = this.jj_consume_token(50);
                        lexicalUnit2 = LexicalUnitImpl.createGradian(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 51: {
                        token = this.jj_consume_token(51);
                        lexicalUnit2 = LexicalUnitImpl.createMillisecond(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 52: {
                        token = this.jj_consume_token(52);
                        lexicalUnit2 = LexicalUnitImpl.createSecond(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 53: {
                        token = this.jj_consume_token(53);
                        lexicalUnit2 = LexicalUnitImpl.createHertz(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 54: {
                        token = this.jj_consume_token(54);
                        lexicalUnit2 = LexicalUnitImpl.createKiloHertz(lexicalUnit, this.value(c, token.image));
                        break block3;
                    }
                    case 59: {
                        lexicalUnit2 = this.function(lexicalUnit);
                        break block3;
                    }
                }
                this.jj_la1[103] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 24: {
                Token token = this.jj_consume_token(24);
                lexicalUnit2 = new LexicalUnitImpl(lexicalUnit, 36, token.image);
                break;
            }
            case 60: {
                Token token = this.jj_consume_token(60);
                lexicalUnit2 = new LexicalUnitImpl(lexicalUnit, 35, token.image);
                break;
            }
            case 27: {
                Token token = this.jj_consume_token(27);
                lexicalUnit2 = new LexicalUnitImpl(lexicalUnit, 24, token.image);
                break;
            }
            case 63: {
                Token token = this.jj_consume_token(63);
                lexicalUnit2 = new LexicalUnitImpl(lexicalUnit, 39, token.image);
                break;
            }
            case 58: {
                lexicalUnit2 = this.rgb(lexicalUnit);
                break;
            }
            case 23: {
                lexicalUnit2 = this.hexcolor(lexicalUnit);
                break;
            }
            case 55: {
                Token token = this.jj_consume_token(55);
                int n = this.getLastNumPos(token.image);
                lexicalUnit2 = LexicalUnitImpl.createDimension(lexicalUnit, this.value(c, token.image.substring(0, n + 1)), token.image.substring(n + 1));
                break;
            }
            case 39: {
                Token token = this.jj_consume_token(39);
                lexicalUnit2 = new LexicalUnitImpl(lexicalUnit, 12, token.image);
                break;
            }
            default: {
                this.jj_la1[104] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block37: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[105] = this.jj_gen;
                    break block37;
                }
            }
            this.jj_consume_token(1);
        }
        return lexicalUnit2;
    }

    public final LexicalUnit function(LexicalUnit lexicalUnit) throws ParseException {
        Token token = this.jj_consume_token(59);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[106] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(1);
        }
        LexicalUnit lexicalUnit2 = this.expr();
        this.jj_consume_token(25);
        if (token.image.equalsIgnoreCase("counter(")) {
            return LexicalUnitImpl.createCounter(lexicalUnit, lexicalUnit2);
        }
        if (token.image.equalsIgnoreCase("counters(")) {
            return LexicalUnitImpl.createCounters(lexicalUnit, lexicalUnit2);
        }
        if (token.image.equalsIgnoreCase("attr(")) {
            return LexicalUnitImpl.createAttr(lexicalUnit, lexicalUnit2);
        }
        if (token.image.equalsIgnoreCase("rect(")) {
            return LexicalUnitImpl.createRect(lexicalUnit, lexicalUnit2);
        }
        if (token.image.equalsIgnoreCase("alpha(")) {
            return LexicalUnitImpl.createAlpha(lexicalUnit, lexicalUnit2);
        }
        return LexicalUnitImpl.createFunction(lexicalUnit, token.image.substring(0, token.image.length() - 1), lexicalUnit2);
    }

    public final LexicalUnit rgb(LexicalUnit lexicalUnit) throws ParseException {
        Token token = this.jj_consume_token(58);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[107] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(1);
        }
        LexicalUnit lexicalUnit2 = this.expr();
        this.jj_consume_token(25);
        return LexicalUnitImpl.createRgbColor(lexicalUnit, lexicalUnit2);
    }

    public final LexicalUnit hexcolor(LexicalUnit lexicalUnit) throws ParseException {
        Token token = this.jj_consume_token(23);
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = token.image.length() - 1;
        try {
            if (n5 == 3) {
                n2 = Integer.parseInt(token.image.substring(n + 0, n + 1), 16);
                n3 = Integer.parseInt(token.image.substring(n + 1, n + 2), 16);
                n4 = Integer.parseInt(token.image.substring(n + 2, n + 3), 16);
                n2 = n2 << 4 | n2;
                n3 = n3 << 4 | n3;
                n4 = n4 << 4 | n4;
            } else if (n5 == 6) {
                n2 = Integer.parseInt(token.image.substring(n + 0, n + 2), 16);
                n3 = Integer.parseInt(token.image.substring(n + 2, n + 4), 16);
                n4 = Integer.parseInt(token.image.substring(n + 4, n + 6), 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("hexcolor(): Unable to parse color: " + token.image);
        }
        LexicalUnit lexicalUnit2 = LexicalUnitImpl.createNumber(null, n2);
        LexicalUnit lexicalUnit3 = LexicalUnitImpl.createComma(lexicalUnit2);
        LexicalUnit lexicalUnit4 = LexicalUnitImpl.createNumber(lexicalUnit3, n3);
        LexicalUnit lexicalUnit5 = LexicalUnitImpl.createComma(lexicalUnit4);
        LexicalUnit lexicalUnit6 = LexicalUnitImpl.createNumber(lexicalUnit5, n4);
        return LexicalUnitImpl.createRgbColor(lexicalUnit, lexicalUnit2);
    }

    float value(char c, String string) throws ParseException {
        return (float)(c == '-' ? -1 : 1) * Float.parseFloat(string);
    }

    int getLastNumPos(String string) throws ParseException {
        int n;
        for (n = 0; n < string.length() && !Character.isLetter(string.charAt(n)); ++n) {
        }
        return n - 1;
    }

    String unescape(String string) throws ParseException {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (++i < n) {
                    c = string.charAt(i);
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            int n2 = Character.digit(c, 16);
                            int n3 = 0;
                            int n4 = 16;
                            while (i + 1 < n && n3 < 6) {
                                c = string.charAt(i + 1);
                                if (Character.digit(c, 16) != -1) {
                                    n2 = n2 * 16 + Character.digit(c, 16);
                                    n4 *= 16;
                                    ++i;
                                    continue;
                                }
                                if (c != ' ') break;
                                ++i;
                                break;
                            }
                            stringBuffer.append((char)n2);
                            break;
                        }
                        case '\n': 
                        case '\f': {
                            break;
                        }
                        case '\r': {
                            if (i + 1 >= n || string.charAt(i + 1) != '\n') continue block5;
                            ++i;
                            break;
                        }
                        default: {
                            stringBuffer.append(c);
                            break;
                        }
                    }
                    continue;
                }
                throw new CSSParseException("invalid string " + string, this.getLocator());
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    void skipSelector() throws ParseException {
        Token token = this.getToken(1);
        while (token.kind != 8 && token.kind != 10 && token.kind != 5 && token.kind != 0) {
            this.getNextToken();
            token = this.getToken(1);
        }
    }

    String skip() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Token token = this.getToken(0);
        if (token.image != null) {
            stringBuffer.append(token.image);
        }
        do {
            token = this.getNextToken();
            if (token.kind == 0) break;
            stringBuffer.append(token.image);
            if (token.kind == 5) {
                ++n;
                continue;
            }
            if (token.kind == 6) {
                --n;
                continue;
            }
            if (token.kind == 10 && n <= 0) break;
        } while (token.kind != 6 || n > 0);
        return stringBuffer.toString();
    }

    void error_skipblock() throws ParseException {
        Object object;
        if (!this._quiet) {
            object = this.generateParseException();
            System.err.println("** error_skipblock **\n" + ((Throwable)object).toString());
        }
        int n = 0;
        do {
            object = this.getNextToken();
            if (((Token)object).kind == 5) {
                ++n;
                continue;
            }
            if (((Token)object).kind == 6) {
                --n;
                continue;
            }
            if (((Token)object).kind == 0) break;
        } while (((Token)object).kind != 6 || n > 0);
    }

    void error_skipdecl() throws ParseException {
        Object object;
        if (!this._quiet) {
            object = this.generateParseException();
            System.err.println("** error_skipdecl **\n" + ((Throwable)object).toString());
        }
        object = this.getToken(1);
        while (((Token)object).kind != 10 && ((Token)object).kind != 6 && ((Token)object).kind != 0) {
            this.getNextToken();
            object = this.getToken(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    private final boolean jj_3R_71() {
        Token token;
        if (this.jj_3R_74()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_74());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_87() {
        return this.jj_scan_token(9);
    }

    private final boolean jj_3R_85() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_84() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_87()) {
            this.jj_scanpos = token;
            if (this.jj_3R_88()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_72()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        Token token;
        if (this.jj_scan_token(17)) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_67() {
        Token token;
        if (this.jj_scan_token(14)) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_83() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_65() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = token;
            if (this.jj_3R_68()) {
                this.jj_scanpos = token;
                if (this.jj_3R_69()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_70() {
        return this.jj_3R_73();
    }

    private final boolean jj_3R_66() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_70()) {
            this.jj_scanpos = token;
            if (this.jj_3R_71()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_78() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_76() {
        return this.jj_scan_token(17);
    }

    private final boolean jj_3R_73() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_77()) {
            this.jj_scanpos = token;
            if (this.jj_3R_78()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_77() {
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_88() {
        return this.jj_scan_token(55);
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_65()) {
            return true;
        }
        return this.jj_3R_66();
    }

    private final boolean jj_3R_82() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_81() {
        return this.jj_3R_85();
    }

    private final boolean jj_3_1() {
        Token token;
        if (this.jj_scan_token(60)) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_80() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_74() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_79()) {
            this.jj_scanpos = token;
            if (this.jj_3R_80()) {
                this.jj_scanpos = token;
                if (this.jj_3R_81()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_82()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_79() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_75() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_86() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_72() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_75()) {
            this.jj_scanpos = token;
            if (this.jj_3R_76()) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, 0x30000002, 0x30000002, 0, 0x30000002, 0x30000002, 8657408, 8657408, 0x30000002, 0x30000002, 8657408, 2, 2, 2, 0x9000000, 2, 0, 2, 2, 8657408, 0x300000, 0x300000, 0x400100, 2, 256, 2, 0x400000, 0x400100, 2, 2, 2048, 256, 2, 8657408, 2, 8657408, 8657408, 2, 2, 2, 2, 2, 2048, 2048, 2, 0, 1024, 2, 0, 2, 2, 0, 1024, 2, 0, 2, 2, 2, 73984, 2, 2, 147456, 2, 147456, 147458, 49152, 2, 2, 0, 1024, 2, 0, 256, 2, 2, 8653312, 8653312, 8653312, 8653312, 8657408, 512, 4096, 2, 2, -1073676288, 2, 0x1000000, 2, -1073676288, 2, 2, 0, 2, 0, 1024, 2, 0, 2, 0, 2, 159506688, 73984, 49152, 0, 0x9800000, 2, 2, 2};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{16, 0, 0, 1, 0, 0, 276824110, 276824110, 0, 0, 276824127, 0, 0, 0, 0, 0, 0x10000000, 0, 0, 276824098, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 276824098, 0, 276824098, 276824098, 0, 0, 0, 0, 0, 0x10000000, 0x10000000, 0, 0x10000000, 0, 0, 0x10000000, 0, 0, 0x10000000, 0, 0, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0, 0x10000000, 0, 0, 0, 0x800000, 0x800000, 0x800000, 0x800000, 0x10800000, 0x800000, 0x10000000, 0, 0, 0, 0, 0x10000000, 0, 0, 0, 0, 0x18000000, 0, 0x10000000, 0, 0, 0x10000000, 0, 64, 0, -1610612864, 0, 0, 192937728, -1610612864, 0, 0, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SACParser(CharStream charStream) {
        int n;
        this.token_source = new SACParserTokenManager(charStream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 108; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(CharStream charStream) {
        int n;
        this.token_source.ReInit(charStream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 108; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public SACParser(SACParserTokenManager sACParserTokenManager) {
        int n;
        this.token_source = sACParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 108; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(SACParserTokenManager sACParserTokenManager) {
        int n;
        this.token_source = sACParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 108; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[83];
        for (n2 = 0; n2 < 83; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 108; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 83; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        SACParser.jj_la1_0();
        SACParser.jj_la1_1();
        SACParser.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

