/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import com.steadystate.css.dom.CSSFontFaceRuleImpl;
import com.steadystate.css.dom.CSSImportRuleImpl;
import com.steadystate.css.dom.CSSMediaRuleImpl;
import com.steadystate.css.dom.CSSPageRuleImpl;
import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.CSSUnknownRuleImpl;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.dom.MediaListImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.HandlerBase;
import com.steadystate.css.parser.SACParser;
import java.io.IOException;
import java.util.Properties;
import java.util.Stack;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

public class CSSOMParser {
    private static final String PARSER = "com.steadystate.css.parser.SACParser";
    private Parser _parser = null;
    private CSSStyleSheetImpl _parentStyleSheet = null;

    public CSSOMParser() {
        try {
            this._parser = new SACParser();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public CSSStyleSheet parseStyleSheet(InputSource inputSource) throws IOException {
        CSSOMHandler cSSOMHandler = new CSSOMHandler();
        this._parser.setDocumentHandler(cSSOMHandler);
        this._parser.parseStyleSheet(inputSource);
        return (CSSStyleSheet)cSSOMHandler.getRoot();
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputSource inputSource) throws IOException {
        CSSStyleDeclarationImpl cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl(null);
        this.parseStyleDeclaration(cSSStyleDeclarationImpl, inputSource);
        return cSSStyleDeclarationImpl;
    }

    public void parseStyleDeclaration(CSSStyleDeclaration cSSStyleDeclaration, InputSource inputSource) throws IOException {
        Stack<CSSStyleDeclaration> stack = new Stack<CSSStyleDeclaration>();
        stack.push(cSSStyleDeclaration);
        CSSOMHandler cSSOMHandler = new CSSOMHandler(stack);
        this._parser.setDocumentHandler(cSSOMHandler);
        this._parser.parseStyleDeclaration(inputSource);
    }

    public CSSValue parsePropertyValue(InputSource inputSource) throws IOException {
        CSSOMHandler cSSOMHandler = new CSSOMHandler();
        this._parser.setDocumentHandler(cSSOMHandler);
        return new CSSValueImpl(this._parser.parsePropertyValue(inputSource));
    }

    public CSSRule parseRule(InputSource inputSource) throws IOException {
        CSSOMHandler cSSOMHandler = new CSSOMHandler();
        this._parser.setDocumentHandler(cSSOMHandler);
        this._parser.parseRule(inputSource);
        return (CSSRule)cSSOMHandler.getRoot();
    }

    public SelectorList parseSelectors(InputSource inputSource) throws IOException {
        HandlerBase handlerBase = new HandlerBase();
        this._parser.setDocumentHandler(handlerBase);
        return this._parser.parseSelectors(inputSource);
    }

    public void setParentStyleSheet(CSSStyleSheetImpl cSSStyleSheetImpl) {
        this._parentStyleSheet = cSSStyleSheetImpl;
    }

    public static void setProperty(String string, String string2) {
        Properties properties = System.getProperties();
        properties.put(string, string2);
        System.setProperties(properties);
    }

    class CSSOMHandler
    implements DocumentHandler {
        private Stack _nodeStack;
        private Object _root = null;

        public CSSOMHandler(Stack stack) {
            this._nodeStack = stack;
        }

        public CSSOMHandler() {
            this._nodeStack = new Stack();
        }

        public Object getRoot() {
            return this._root;
        }

        public void startDocument(InputSource inputSource) throws CSSException {
            if (this._nodeStack.empty()) {
                CSSStyleSheetImpl cSSStyleSheetImpl = new CSSStyleSheetImpl();
                CSSOMParser.this._parentStyleSheet = cSSStyleSheetImpl;
                CSSRuleListImpl cSSRuleListImpl = new CSSRuleListImpl();
                cSSStyleSheetImpl.setRuleList(cSSRuleListImpl);
                this._nodeStack.push(cSSStyleSheetImpl);
                this._nodeStack.push(cSSRuleListImpl);
            }
        }

        public void endDocument(InputSource inputSource) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void comment(String string) throws CSSException {
        }

        public void ignorableAtRule(String string) throws CSSException {
            CSSUnknownRuleImpl cSSUnknownRuleImpl = new CSSUnknownRuleImpl(CSSOMParser.this._parentStyleSheet, null, string);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(cSSUnknownRuleImpl);
            } else {
                this._root = cSSUnknownRuleImpl;
            }
        }

        public void namespaceDeclaration(String string, String string2) throws CSSException {
        }

        public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
            CSSImportRuleImpl cSSImportRuleImpl = new CSSImportRuleImpl(CSSOMParser.this._parentStyleSheet, null, string, new MediaListImpl(sACMediaList));
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(cSSImportRuleImpl);
            } else {
                this._root = cSSImportRuleImpl;
            }
        }

        public void startMedia(SACMediaList sACMediaList) throws CSSException {
            CSSMediaRuleImpl cSSMediaRuleImpl = new CSSMediaRuleImpl(CSSOMParser.this._parentStyleSheet, null, new MediaListImpl(sACMediaList));
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(cSSMediaRuleImpl);
            }
            CSSRuleListImpl cSSRuleListImpl = new CSSRuleListImpl();
            cSSMediaRuleImpl.setRuleList(cSSRuleListImpl);
            this._nodeStack.push(cSSMediaRuleImpl);
            this._nodeStack.push(cSSRuleListImpl);
        }

        public void endMedia(SACMediaList sACMediaList) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void startPage(String string, String string2) throws CSSException {
            CSSPageRuleImpl cSSPageRuleImpl = new CSSPageRuleImpl(CSSOMParser.this._parentStyleSheet, null, string, string2);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(cSSPageRuleImpl);
            }
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl(cSSPageRuleImpl);
            cSSPageRuleImpl.setStyle(cSSStyleDeclarationImpl);
            this._nodeStack.push(cSSPageRuleImpl);
            this._nodeStack.push(cSSStyleDeclarationImpl);
        }

        public void endPage(String string, String string2) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void startFontFace() throws CSSException {
            CSSFontFaceRuleImpl cSSFontFaceRuleImpl = new CSSFontFaceRuleImpl(CSSOMParser.this._parentStyleSheet, null);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(cSSFontFaceRuleImpl);
            }
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl(cSSFontFaceRuleImpl);
            cSSFontFaceRuleImpl.setStyle(cSSStyleDeclarationImpl);
            this._nodeStack.push(cSSFontFaceRuleImpl);
            this._nodeStack.push(cSSStyleDeclarationImpl);
        }

        public void endFontFace() throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void startSelector(SelectorList selectorList) throws CSSException {
            CSSStyleRuleImpl cSSStyleRuleImpl = new CSSStyleRuleImpl(CSSOMParser.this._parentStyleSheet, null, selectorList);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(cSSStyleRuleImpl);
            }
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl(cSSStyleRuleImpl);
            cSSStyleRuleImpl.setStyle(cSSStyleDeclarationImpl);
            this._nodeStack.push(cSSStyleRuleImpl);
            this._nodeStack.push(cSSStyleDeclarationImpl);
        }

        public void endSelector(SelectorList selectorList) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = (CSSStyleDeclarationImpl)this._nodeStack.peek();
            cSSStyleDeclarationImpl.addProperty(new Property(string, new CSSValueImpl(lexicalUnit), bl));
        }
    }
}

