/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.MonitorInfo;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import sun.management.LazyCompositeData;
import sun.management.LockDataConverter;
import sun.management.MappedMXBeanType;
import sun.management.StackTraceElementCompositeData;
import sun.management.Util;

public class MonitorInfoCompositeData
extends LazyCompositeData {
    private final MonitorInfo lock;
    private static final CompositeType monitorInfoCompositeType;
    private static final String[] monitorInfoItemNames;
    private static final String CLASS_NAME = "className";
    private static final String IDENTITY_HASH_CODE = "identityHashCode";
    private static final String LOCKED_STACK_FRAME = "lockedStackFrame";
    private static final String LOCKED_STACK_DEPTH = "lockedStackDepth";

    private MonitorInfoCompositeData(MonitorInfo monitorInfo) {
        this.lock = monitorInfo;
    }

    public MonitorInfo getMonitorInfo() {
        return this.lock;
    }

    public static CompositeData toCompositeData(MonitorInfo monitorInfo) {
        MonitorInfoCompositeData monitorInfoCompositeData = new MonitorInfoCompositeData(monitorInfo);
        return monitorInfoCompositeData.getCompositeData();
    }

    protected CompositeData getCompositeData() {
        int n = monitorInfoItemNames.length;
        Object[] objectArray = new Object[n];
        CompositeData compositeData = LockDataConverter.toLockInfoCompositeData(this.lock);
        for (int i = 0; i < n; ++i) {
            StackTraceElement stackTraceElement;
            String string = monitorInfoItemNames[i];
            objectArray[i] = string.equals(LOCKED_STACK_FRAME) ? ((stackTraceElement = this.lock.getLockedStackFrame()) != null ? StackTraceElementCompositeData.toCompositeData(stackTraceElement) : null) : (string.equals(LOCKED_STACK_DEPTH) ? new Integer(this.lock.getLockedStackDepth()) : compositeData.get(string));
        }
        try {
            return new CompositeDataSupport(monitorInfoCompositeType, monitorInfoItemNames, objectArray);
        }
        catch (OpenDataException openDataException) {
            throw Util.newInternalError(openDataException);
        }
    }

    static CompositeType getMonitorInfoCompositeType() {
        return monitorInfoCompositeType;
    }

    public static String getClassName(CompositeData compositeData) {
        return MonitorInfoCompositeData.getString(compositeData, CLASS_NAME);
    }

    public static int getIdentityHashCode(CompositeData compositeData) {
        return MonitorInfoCompositeData.getInt(compositeData, IDENTITY_HASH_CODE);
    }

    public static StackTraceElement getLockedStackFrame(CompositeData compositeData) {
        CompositeData compositeData2 = (CompositeData)compositeData.get(LOCKED_STACK_FRAME);
        if (compositeData2 != null) {
            return StackTraceElementCompositeData.from(compositeData2);
        }
        return null;
    }

    public static int getLockedStackDepth(CompositeData compositeData) {
        return MonitorInfoCompositeData.getInt(compositeData, LOCKED_STACK_DEPTH);
    }

    public static void validateCompositeData(CompositeData compositeData) {
        if (compositeData == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!MonitorInfoCompositeData.isTypeMatched(monitorInfoCompositeType, compositeData.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for MonitorInfo");
        }
    }

    static {
        try {
            monitorInfoCompositeType = (CompositeType)MappedMXBeanType.toOpenType(MonitorInfo.class);
            Set<String> set = monitorInfoCompositeType.keySet();
            monitorInfoItemNames = set.toArray(new String[0]);
        }
        catch (OpenDataException openDataException) {
            throw Util.newInternalError(openDataException);
        }
    }
}

