/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class StringBuilder
extends AbstractStringBuilder
implements Serializable,
CharSequence {
    static final long serialVersionUID = 4383685877147921099L;

    public StringBuilder() {
        super(16);
    }

    public StringBuilder(int n) {
        super(n);
    }

    public StringBuilder(String string) {
        super(string.length() + 16);
        this.append(string);
    }

    public StringBuilder(CharSequence charSequence) {
        this(charSequence.length() + 16);
        this.append(charSequence);
    }

    public StringBuilder append(Object object) {
        return this.append(String.valueOf(object));
    }

    public StringBuilder append(String string) {
        super.append(string);
        return this;
    }

    private StringBuilder append(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return this.append("null");
        }
        int n = stringBuilder.length();
        int n2 = this.count + n;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        stringBuilder.getChars(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public StringBuilder append(StringBuffer stringBuffer) {
        super.append(stringBuffer);
        return this;
    }

    public StringBuilder append(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (charSequence instanceof String) {
            return this.append((String)charSequence);
        }
        if (charSequence instanceof StringBuffer) {
            return this.append((StringBuffer)charSequence);
        }
        if (charSequence instanceof StringBuilder) {
            return this.append((StringBuilder)charSequence);
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    public StringBuilder append(CharSequence charSequence, int n, int n2) {
        super.append(charSequence, n, n2);
        return this;
    }

    public StringBuilder append(char[] cArray) {
        super.append(cArray);
        return this;
    }

    public StringBuilder append(char[] cArray, int n, int n2) {
        super.append(cArray, n, n2);
        return this;
    }

    public StringBuilder append(boolean bl) {
        super.append(bl);
        return this;
    }

    public StringBuilder append(char c) {
        super.append(c);
        return this;
    }

    public StringBuilder append(int n) {
        super.append(n);
        return this;
    }

    public StringBuilder append(long l) {
        super.append(l);
        return this;
    }

    public StringBuilder append(float f) {
        super.append(f);
        return this;
    }

    public StringBuilder append(double d) {
        super.append(d);
        return this;
    }

    public StringBuilder appendCodePoint(int n) {
        super.appendCodePoint(n);
        return this;
    }

    public StringBuilder delete(int n, int n2) {
        super.delete(n, n2);
        return this;
    }

    public StringBuilder deleteCharAt(int n) {
        super.deleteCharAt(n);
        return this;
    }

    public StringBuilder replace(int n, int n2, String string) {
        super.replace(n, n2, string);
        return this;
    }

    public StringBuilder insert(int n, char[] cArray, int n2, int n3) {
        super.insert(n, cArray, n2, n3);
        return this;
    }

    public StringBuilder insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public StringBuilder insert(int n, String string) {
        super.insert(n, string);
        return this;
    }

    public StringBuilder insert(int n, char[] cArray) {
        super.insert(n, cArray);
        return this;
    }

    public StringBuilder insert(int n, CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (charSequence instanceof String) {
            return this.insert(n, (String)charSequence);
        }
        return this.insert(n, charSequence, 0, charSequence.length());
    }

    public StringBuilder insert(int n, CharSequence charSequence, int n2, int n3) {
        super.insert(n, charSequence, n2, n3);
        return this;
    }

    public StringBuilder insert(int n, boolean bl) {
        super.insert(n, bl);
        return this;
    }

    public StringBuilder insert(int n, char c) {
        super.insert(n, c);
        return this;
    }

    public StringBuilder insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuilder insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public StringBuilder insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StringBuilder insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        return String.indexOf(this.value, 0, this.count, string.toCharArray(), 0, string.length(), n);
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        return String.lastIndexOf(this.value, 0, this.count, string.toCharArray(), 0, string.length(), n);
    }

    public StringBuilder reverse() {
        super.reverse();
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.count);
        objectOutputStream.writeObject(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.count = objectInputStream.readInt();
        this.value = (char[])objectInputStream.readObject();
    }
}

