/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.sei;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.sei.DispatchException;
import com.sun.xml.internal.ws.server.sei.EndpointMethodDispatcher;
import com.sun.xml.internal.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.internal.ws.server.sei.SEIInvokerTube;
import com.sun.xml.internal.ws.util.QNameMap;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

final class PayloadQNameBasedDispatcher
implements EndpointMethodDispatcher {
    private static final Logger LOGGER = Logger.getLogger(PayloadQNameBasedDispatcher.class.getName());
    private static final String EMPTY_PAYLOAD_LOCAL = "";
    private static final String EMPTY_PAYLOAD_NSURI = "";
    private static final QName EMPTY_PAYLOAD = new QName("", "");
    private final QNameMap<EndpointMethodHandler> methodHandlers = new QNameMap();
    private final QNameMap<List<String>> unique = new QNameMap();
    private final WSBinding binding;

    public PayloadQNameBasedDispatcher(AbstractSEIModelImpl abstractSEIModelImpl, WSBinding wSBinding, SEIInvokerTube sEIInvokerTube) {
        QName qName;
        this.binding = wSBinding;
        for (JavaMethodImpl object : abstractSEIModelImpl.getJavaMethods()) {
            List<String> list;
            qName = object.getRequestPayloadName();
            if (qName == null) {
                qName = EMPTY_PAYLOAD;
            }
            if ((list = this.unique.get(qName)) == null) {
                list = new ArrayList<String>();
                this.unique.put(qName, list);
            }
            list.add(object.getMethod().getName());
        }
        for (QNameMap.Entry entry : this.unique.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            LOGGER.warning(ServerMessages.NON_UNIQUE_DISPATCH_QNAME(entry.getValue(), entry.createQName()));
        }
        for (JavaMethodImpl javaMethodImpl : abstractSEIModelImpl.getJavaMethods()) {
            qName = javaMethodImpl.getRequestPayloadName();
            if (qName == null) {
                qName = EMPTY_PAYLOAD;
            }
            if (this.unique.get(qName).size() != 1) continue;
            this.methodHandlers.put(qName, new EndpointMethodHandler(sEIInvokerTube, javaMethodImpl, wSBinding));
        }
    }

    @Nullable
    public EndpointMethodHandler getEndpointMethodHandler(Packet packet) throws DispatchException {
        String string;
        Message message = packet.getMessage();
        String string2 = message.getPayloadLocalPart();
        if (string2 == null) {
            string2 = "";
            string = "";
        } else {
            string = message.getPayloadNamespaceURI();
            if (string == null) {
                string = "";
            }
        }
        EndpointMethodHandler endpointMethodHandler = this.methodHandlers.get(string, string2);
        if (endpointMethodHandler == null && !this.unique.containsKey(string, string2)) {
            String string3 = "{" + string + "}" + string2;
            String string4 = ServerMessages.DISPATCH_CANNOT_FIND_METHOD(string3);
            throw new DispatchException(SOAPFaultBuilder.createSOAPFaultMessage(this.binding.getSOAPVersion(), string4, this.binding.getSOAPVersion().faultCodeClient));
        }
        return endpointMethodHandler;
    }
}

