/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.common.ExtBasicArrowButtonHandler;
import com.jgoodies.looks.plastic.PlasticArrowButton;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticSpinnerUI;
import com.jgoodies.looks.plastic.PlasticXPUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class PlasticXPSpinnerUI
extends PlasticSpinnerUI {
    private static final ExtBasicArrowButtonHandler NEXT_BUTTON_HANDLER = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler PREVIOUS_BUTTON_HANDLER = new ExtBasicArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticXPSpinnerUI();
    }

    protected Component createPreviousButton() {
        return new SpinnerXPArrowButton(5, PREVIOUS_BUTTON_HANDLER);
    }

    protected Component createNextButton() {
        return new SpinnerXPArrowButton(1, NEXT_BUTTON_HANDLER);
    }

    private static final class SpinnerXPArrowButton
    extends PlasticArrowButton {
        SpinnerXPArrowButton(int n, ExtBasicArrowButtonHandler extBasicArrowButtonHandler) {
            super(n, UIManager.getInt("ScrollBar.width") - 1, false);
            this.addActionListener(extBasicArrowButtonHandler);
            this.addMouseListener(extBasicArrowButtonHandler);
        }

        protected int calculateArrowHeight(int n, int n2) {
            int n3 = Math.min((n - 4) / 3, (n2 - 4) / 3);
            return Math.max(n3, 3);
        }

        protected boolean isPaintingNorthBottom() {
            return true;
        }

        protected int calculateArrowOffset() {
            return 1;
        }

        protected void paintNorth(Graphics graphics, boolean bl, boolean bl2, Color color, boolean bl3, int n, int n2, int n3, int n4, int n5, int n6, boolean bl4) {
            if (!this.isFreeStanding) {
                ++n2;
                graphics.translate(0, -1);
                if (!bl) {
                    ++n;
                    graphics.translate(-1, 0);
                } else {
                    n += 2;
                }
            }
            graphics.setColor(color);
            int n7 = 1 + (n4 + 1 - n5) / 2;
            int n8 = n3 / 2;
            for (int i = 0; i < n5; ++i) {
                graphics.fillRect(n8 - i - n6, n7 + i, 2 * (i + 1), 1);
            }
            this.paintNorthBorder(graphics, bl2, n, n2, bl4);
            if (!this.isFreeStanding) {
                --n2;
                graphics.translate(0, 1);
                if (!bl) {
                    --n;
                    graphics.translate(1, 0);
                } else {
                    n -= 2;
                }
            }
        }

        private void paintNorthBorder(Graphics graphics, boolean bl, int n, int n2, boolean bl2) {
            if (bl) {
                boolean bl3;
                boolean bl4 = bl3 = this.model.isPressed() && this.model.isArmed();
                if (bl3) {
                    PlasticXPUtils.drawPressedButtonBorder(graphics, 0, 1, n - 2, n2);
                } else {
                    PlasticXPUtils.drawPlainButtonBorder(graphics, 0, 1, n - 2, n2);
                }
            } else {
                PlasticXPUtils.drawDisabledButtonBorder(graphics, 0, 1, n - 2, n2 + 1);
            }
            graphics.setColor(bl ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            graphics.fillRect(0, 1, 1, 1);
            if (bl2) {
                graphics.fillRect(0, n2 - 1, n - 1, 1);
            }
        }

        protected void paintSouth(Graphics graphics, boolean bl, boolean bl2, Color color, boolean bl3, int n, int n2, int n3, int n4, int n5, int n6) {
            if (!this.isFreeStanding) {
                ++n2;
                if (!bl) {
                    ++n;
                    graphics.translate(-1, 0);
                } else {
                    n += 2;
                }
            }
            graphics.setColor(color);
            int n7 = (n4 + 0 - n5) / 2 + n5 - 2;
            int n8 = n3 / 2;
            for (int i = 0; i < n5; ++i) {
                graphics.fillRect(n8 - i - n6, n7 - i, 2 * (i + 1), 1);
            }
            this.paintSouthBorder(graphics, bl2, n, n2);
            if (!this.isFreeStanding) {
                --n2;
                if (!bl) {
                    --n;
                    graphics.translate(1, 0);
                } else {
                    n -= 2;
                }
            }
        }

        private void paintSouthBorder(Graphics graphics, boolean bl, int n, int n2) {
            if (bl) {
                boolean bl2;
                boolean bl3 = bl2 = this.model.isPressed() && this.model.isArmed();
                if (bl2) {
                    PlasticXPUtils.drawPressedButtonBorder(graphics, 0, -2, n - 2, n2 + 1);
                } else {
                    PlasticXPUtils.drawPlainButtonBorder(graphics, 0, -2, n - 2, n2 + 1);
                }
            } else {
                PlasticXPUtils.drawDisabledButtonBorder(graphics, 0, -2, n - 2, n2 + 1);
            }
            graphics.setColor(bl ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            graphics.fillRect(0, n2 - 2, 1, 1);
        }
    }
}

