/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

final class PlasticFieldCaret
extends DefaultCaret
implements UIResource {
    private boolean isKeyboardFocusEvent = true;

    PlasticFieldCaret() {
    }

    public void focusGained(FocusEvent focusEvent) {
        JTextComponent jTextComponent;
        if (this.getComponent().isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if ((jTextComponent = this.getComponent()).isEnabled() && this.isKeyboardFocusEvent) {
            if (jTextComponent instanceof JFormattedTextField) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        PlasticFieldCaret.super.setDot(0);
                        PlasticFieldCaret.super.moveDot(jTextComponent.getDocument().getLength());
                    }
                });
            } else {
                super.setDot(0);
                super.moveDot(jTextComponent.getDocument().getLength());
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        if (!focusEvent.isTemporary()) {
            this.isKeyboardFocusEvent = true;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
        }
        super.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }
}

